from threading import Thread
from .__version__ import __version__, __minor__, __date__
import os
import time

os.environ['FALCON_SETTING_MODULE'] = 'api_dnl.settings'

from .up_rec import up_rec

from . import settings

# +++ sentry integration
try:
    if settings.SENTRY_URL:
        import raven
        import logging

        sentry = raven.Client(settings.SENTRY_URL)
        from raven.handlers.logging import SentryHandler

        # Manually specify a client
        handler = SentryHandler(sentry)
        handler.setLevel(logging.ERROR)
        from raven.conf import setup_logging

        setup_logging(handler)
except Exception as e:
    pass


from falcon_rest.logger import log


def clean_old_logs(log_file, max_age_seconds):
    current_time = time.time()
    lines_without_time = []  # In case if there are too long lines that do not contain time
    with open(log_file, 'r') as f:
        lines = f.readlines()
    with open(log_file, 'w') as f:
        for line in lines:
            try:
                try:
                    log_timestamp = time.mktime(time.strptime(line, '%Y-%m-%d %H:%M:%S,%f'))
                except:
                    lines_without_time.append(line)
                    continue
                if current_time - log_timestamp <= max_age_seconds:
                    if lines_without_time:
                        f.writelines(lines_without_time)
                        lines_without_time = []
                    f.write(line)
            except Exception as e:
                log.debug(f"Error parsing log line: {line} Error: {e}")


def schedule_cleaning(log_file, max_age_seconds):
    while True:
        clean_old_logs(log_file, max_age_seconds)
        log.debug("CLEANED OLD LOGS")
        time.sleep(3600)  # delay between cleaning logs


# log_file_path = 'dnl.log'
# max_age_seconds = 7 * 24 * 60 * 60  # logs lifetime

# cleaning_thread = Thread(target=schedule_cleaning, args=(log_file_path, max_age_seconds))
# cleaning_thread.daemon = True
# cleaning_thread.start()

# --- sentry integration

def retoken(token):
    import jwt
    from pytz import UTC
    from datetime import datetime, timedelta
    token_data = jwt.decode(token, settings.JWT_SIGNATURE, verify=False)
    print('old expired',str(datetime.utcfromtimestamp(int(token_data['expired']))))
    valid_till = datetime.now(UTC) + timedelta(hours=24*7)
    token_data['expired'] = int(valid_till.timestamp())
    token_data['user_id']=token_data['user_id']
    if 'ip' in token_data:
        del token_data['ip']
    print(token_data)
    token = jwt.encode(token_data, settings.JWT_SIGNATURE, algorithm='HS256')
    return token.decode('utf-8')

def token(user_id):
    import jwt
    from pytz import UTC
    from datetime import datetime, timedelta
    token_data = {}
    print(token_data)
    valid_till = datetime.now(UTC) + timedelta(hours=24*7)
    token_data['expired'] = int(valid_till.timestamp())
    token_data['user_id']=user_id
    token = jwt.encode(token_data, settings.JWT_SIGNATURE, algorithm='HS256')
    return token.decode('utf-8')



def curl(txt):
    import re
    token=re.match('.*X-Auth-Token: ([\w\.\-]*).*',txt).group(1)
    new_token=retoken(token)
    return txt.replace(token,new_token)


def create_app():
    from datetime import datetime
    from pytz import UTC
    from falcon_rest.app import create
    from .swagger import init_swagger,init_swagger_client
    from .routes import ROUTES
    from .actions import user
    from falcon_rest.contrib.auth import auth
    from .model import CodeDeck, DailyCdrField, Product, Role, SystemFunction, User, MailTemplate, SendRateTemplate, \
        VersionInformation, RateTable, RouteStrategy, Route, SystemParameter, StorageConfig, CodeCountry
    from inspect import isclass
    from falcon_rest.logger import log
    from time import sleep
    from random import randint

    try:
        from .tasks import init_version_task
        # init_version_task.delay()
        init_version_task()
    except Exception as e:
        log.debug('init_version_task cannot start {}'.format(e))
        pass
    # if True:  # not len(SystemFunction.query().all()):
    #     SystemParameter.init()
    #     SystemFunction.init(ROUTES)
    # if not len(SystemFunction.query().all()):
    #     SystemFunction.init(ROUTES)
    app = create(ROUTES, init_swagger(), name='dnl_api')
    log.debug(f"CREATED APP WITH ROUTES: {ROUTES}")
    if settings.UI_BASE_DIR !='False':
        app.add_static_route('/', settings.UI_BASE_DIR )
    #client swagger
    client_swagger = init_swagger_client()
    log.debug("ADDING ROUTES")
    app.add_route('{}/client_swagger.json'.format(settings.API_BASE_PATH), client_swagger.endpoints)
    log.debug("ROUTES ADDED")

    try:
        if settings.SENTRY_URL:
            sentry.captureMessage('start api-dnl on {}'.format(settings.API_HOST))
    except Exception as e:
        log.error('sentry connecton error {}'.format(str(e)))
    # app.celery = celery
    from falcon_rest import conf
    conf.settings.entities = [{'name': k, 'model': v} for k, v in model.__dict__.items() if
                              isclass(v) and issubclass(v, model.DnlApiBaseModel)]

    # sc=StorageConfig.get('pcap')
    # if sc:
    #     sc.update_settings()

    for tag_name, tag in ROUTES.items():
        routes_list = tag['routes'] if isinstance(tag, dict) else tag
        for route in routes_list:
            route['resource'].__class__.api_module = tag_name

    log.info('App starting')
    log.info('upload_to dir {}'.format(settings.FILES['upload_to']))
    return app
