"""[CLAS6-28801] Re-work system limits

Revision ID: 4613fb5b57e8
Revises: 8e612290be3a
Create Date: 2025-06-02 17:49:12.129815

"""

from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp, os


# revision identifiers, used by Alembic.
revision = "4613fb5b57e8"
down_revision = "8e612290be3a"
branch_labels = None
depends_on = None


def upgrade():
    upgrade_sql = """
BEGIN;

-- Drop system_configure
DROP TABLE IF EXISTS system_configure_record;
DROP TABLE IF EXISTS system_configure;

-- Update voip_gateway
ALTER TABLE voip_gateway DROP COLUMN IF EXISTS cps;
ALTER TABLE voip_gateway DROP COLUMN IF EXISTS cap;

-- Create voip_gateway_record
CREATE TABLE voip_gateway_record (LIKE voip_gateway, "time" integer, flag character(1), record_id SERIAL PRIMARY KEY);
CREATE INDEX IF NOT EXISTS voip_gateway_record_time_idx ON voip_gateway_record USING btree ("time");
ALTER TABLE voip_gateway_record OWNER TO class4_user;
ALTER INDEX voip_gateway_record_time_idx OWNER TO class4_user;
CREATE FUNCTION class4_trigfun_record_voip_gateway() RETURNS trigger
LANGUAGE plpgsql
AS $$
BEGIN
    IF (TG_OP = 'INSERT') THEN
        INSERT INTO voip_gateway_record SELECT NEW.*, EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
    ELSEIF (TG_OP = 'DELETE') THEN
        INSERT INTO voip_gateway_record SELECT OLD.*, EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
    ELSEIF (TG_OP = 'UPDATE') THEN
        INSERT INTO voip_gateway_record SELECT OLD.*, EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
        INSERT INTO voip_gateway_record SELECT NEW.*, EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
    END IF;
    return null;
END;
$$;
ALTER FUNCTION class4_trigfun_record_voip_gateway() OWNER TO class4_user;
CREATE TRIGGER class4_trig_record_voip_gateway
    AFTER INSERT OR DELETE OR UPDATE ON voip_gateway
    FOR EACH ROW EXECUTE PROCEDURE class4_trigfun_record_voip_gateway();

/* Version 7.4.8 */
UPDATE c4db_version SET version_num = 'd9028048546496e30a10378e36d0657a', tag = '7.4.8';

END;
"""
    connection = op.get_bind()
    connection.execute(upgrade_sql)
    up_rec("voip_gateway")


def downgrade():
    # Arch users don't downgrade
    pass


"""
ADDONS
"""


def up_rec(table):
    """
    Update {table}_record schema
    """

    up_rec_sql = """
DO $do$
DECLARE
    rec_id INT := 1;
BEGIN
    -- Check if table exists
    IF NOT EXISTS (SELECT 0 FROM pg_tables WHERE tablename = '{table}') THEN
        RAISE WARNING 'Table {table} does not exist';
    ELSE
        -- Get last record_id
        SELECT record_id FROM {table}_record ORDER BY record_id DESC LIMIT 1
        INTO rec_id;
        -- Delete existing table
        DROP TRIGGER IF EXISTS class4_trig_record_{table} ON {table};
        DROP FUNCTION IF EXISTS class4_trigfun_record_{table};
        DROP TABLE IF EXISTS {table}_record;
        DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
    END IF;

    -- Create new table
    CREATE TABLE {table}_record (LIKE {table},
    "time" integer, flag character(1), record_id SERIAL PRIMARY KEY);
    ALTER TABLE {table}_record OWNER TO class4_user;
    CREATE INDEX IF NOT EXISTS {table}_record_time_idx
    ON {table}_record USING btree ("time");
    EXECUTE format(E'SELECT setval(\\'{table}_record_record_id_seq\\', %%L)',
    rec_id);

    -- Trigger
    CREATE FUNCTION class4_trigfun_record_{table}() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.{table}_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.{table}_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.{table}_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.{table}_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;
    ALTER FUNCTION class4_trigfun_record_{table}() OWNER TO class4_user;
    CREATE TRIGGER class4_trig_record_{table} AFTER INSERT OR DELETE OR UPDATE
    ON {table} FOR EACH ROW EXECUTE PROCEDURE class4_trigfun_record_{table}();
END $do$;
"""
    connection = op.get_bind()
    connection.execute(up_rec_sql.format_map(dict(table=table)))
