"""sms_rate_table

Revision ID: 8de1954ace8d
Revises: 424e4916ce6d
Create Date: 2021-04-05 16:05:32.541089

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):



# revision identifiers, used by Alembic.
revision = '8de1954ace8d'
down_revision = '424e4916ce6d'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('sms_rate_table',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.Column('created_on', sa.DateTime(timezone=True), nullable=True),
    sa.Column('created_by', sa.String(), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name')
    )
    op.create_table('sms_rate',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('sms_rate_table_id', sa.Integer(), nullable=True),
    sa.Column('code', api_dnl.migration_types.PrefixRange(), server_default=sa.text("''::prefix_range"), nullable=True),
    sa.Column('country', sa.String(length=1000), nullable=True),
    sa.Column('effective_date', sa.DateTime(timezone=True), nullable=True),
    sa.Column('end_date', sa.DateTime(timezone=True), nullable=True),
    sa.ForeignKeyConstraint(['sms_rate_table_id'], ['sms_rate_table.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_sms_rate_code'), 'sms_rate', ['code'], unique=False)
    op.create_index(op.f('ix_sms_rate_country'), 'sms_rate', ['country'], unique=False)
    op.create_index(op.f('ix_sms_rate_effective_date'), 'sms_rate', ['effective_date'], unique=False)
    op.create_index(op.f('ix_sms_rate_end_date'), 'sms_rate', ['end_date'], unique=False)
    op.create_index(op.f('ix_sms_rate_sms_rate_table_id'), 'sms_rate', ['sms_rate_table_id'], unique=False)
    op.add_column('client_did_product', sa.Column('rate_table_id', sa.Integer(), nullable=True))
    op.drop_constraint('client_did_product_sms_rate_table_id_fkey', 'client_did_product', type_='foreignkey')
    op.create_foreign_key(None, 'client_did_product', 'sms_rate_table', ['rate_table_id'], ['id'], ondelete='CASCADE')
    op.drop_column('client_did_product', 'sms_rate_table_id')
    #op.add_column('monitored_rule', sa.Column('action_type', api_dnl.migration_types.ChoiceType(), nullable=True))
    #op.add_column('signup', sa.Column('client_type', api_dnl.migration_types.ChoiceType(), server_default='1', nullable=True))
    #op.drop_column('signup', 'cllient_type')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('signup', sa.Column('cllient_type', sa.SMALLINT(), server_default=sa.text("'1'::smallint"), autoincrement=False, nullable=True))
    op.drop_column('signup', 'client_type')
    op.drop_column('monitored_rule', 'action_type')
    op.add_column('client_did_product', sa.Column('sms_rate_table_id', sa.INTEGER(), autoincrement=False, nullable=True))
    op.drop_constraint(None, 'client_did_product', type_='foreignkey')
    op.create_foreign_key('client_did_product_sms_rate_table_id_fkey', 'client_did_product', 'rate_table', ['sms_rate_table_id'], ['rate_table_id'], ondelete='CASCADE')
    op.drop_column('client_did_product', 'rate_table_id')
    op.drop_index(op.f('ix_sms_rate_sms_rate_table_id'), table_name='sms_rate')
    op.drop_index(op.f('ix_sms_rate_end_date'), table_name='sms_rate')
    op.drop_index(op.f('ix_sms_rate_effective_date'), table_name='sms_rate')
    op.drop_index(op.f('ix_sms_rate_country'), table_name='sms_rate')
    op.drop_index(op.f('ix_sms_rate_code'), table_name='sms_rate')
    op.drop_table('sms_rate')
    op.drop_table('sms_rate_table')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))
