"""dnl_invoice_history

Revision ID: 9150d549cea3
Revises: 7e3959fcd0e2
Create Date: 2019-09-06 22:11:34.014252

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = '9150d549cea3'
down_revision = '7e3959fcd0e2'
branch_labels = None
depends_on = None


def upgrade():
    connection = op.get_bind()
    connection.execute('drop table if exists dnl_invoice_history')
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('dnl_invoice_history',
    sa.Column('id', sa.Integer(), nullable=False),#, server_default=sa.text("nextval('dnl_invoice_history_id_seq'::regclass)")
    sa.Column('client_id', sa.Integer(), nullable=False),
    sa.Column('invoice_number', sa.Integer(), nullable=True),
    sa.Column('invoice_generation_time', sa.DateTime(), nullable=True),
    sa.Column('invoice_start_time', sa.DateTime(), nullable=True),
    sa.Column('invoice_end_time', sa.DateTime(), nullable=True),
    sa.Column('status', sa.SmallInteger(), server_default=sa.text('0'), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_dnl_invoice_history_client_id'), 'dnl_invoice_history', ['client_id'], unique=False)
    op.add_column('rate_import_task', sa.Column('redup_in_rate_rable_action', sa.SmallInteger(), nullable=True))
    op.alter_column('rate_import_task', 'redup_in_file_action',
               existing_type=sa.SMALLINT(),
               nullable=False,
               existing_server_default=sa.text("'0'::smallint"))
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('rate_import_task', 'redup_in_file_action',
               existing_type=sa.SMALLINT(),
               nullable=True,
               existing_server_default=sa.text("'0'::smallint"))
    op.drop_column('rate_import_task', 'redup_in_rate_rable_action')
    op.drop_index(op.f('ix_dnl_invoice_history_client_id'), table_name='dnl_invoice_history')
    op.drop_table('dnl_invoice_history')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger class4_trig_record_{table} on {table};
drop table {table}_record;
DROP FUNCTION class4_trigfun_record_{table}();
DROP SEQUENCE {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))