"""qos_client did_port_usage_info client did_billing_by

Revision ID: c5e8539359dc
Revises: 50da2c915ca6
Create Date: 2020-01-24 21:29:57.677185

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):



# revision identifiers, used by Alembic.
revision = 'c5e8539359dc'
down_revision = '50da2c915ca6'
branch_labels = None
depends_on = None


def upgrade():
    connection = op.get_bind()
    # ### commands auto generated by Alembic - please adjust! ###
    row = connection.execute("select * from pg_tables where tablename='did_port_usage_info'")
    if not row or len(row.fetchall()) == 0:
        op.create_table('did_port_usage_info',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('invoice_number', sa.Integer(), nullable=True),
        sa.Column('client_id', sa.Integer(), nullable=False),
        sa.Column('port_limit_per_did', sa.Integer(), nullable=True),
        sa.Column('total_port_limit', sa.Integer(), nullable=True),
        sa.Column('port_usage', sa.Integer(), nullable=True),
        sa.Column('did_count', sa.Integer(), server_default=sa.text('0'), nullable=False),
        sa.Column('fee_per_port', api_dnl.migration_types.Numeric(length=32, collation=6), server_default=sa.text('0.00'), nullable=False),
        sa.Column('total_fee', api_dnl.migration_types.Numeric(length=32, collation=6), server_default=sa.text('0.00'), nullable=False),
        sa.Column('start_date', sa.Date(), nullable=True),
        sa.Column('end_date', sa.Date(), nullable=True),
        sa.PrimaryKeyConstraint('id')
        )
        op.create_index(op.f('ix_did_port_usage_info_client_id'), 'did_port_usage_info', ['client_id'], unique=False)
        op.create_index(op.f('ix_did_port_usage_info_invoice_number'), 'did_port_usage_info', ['invoice_number'], unique=False)
    row = connection.execute("select * from pg_tables where tablename='qos_client'")
    if not row or len(row.fetchall()) == 0:
        op.create_table('qos_client',
        sa.Column('report_time', sa.DateTime(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), nullable=False),
        sa.Column('client_id', sa.Integer(), nullable=True),
        sa.Column('call', sa.Integer(), nullable=True),
        sa.Column('inbound_cps', sa.Integer(), nullable=True),
        sa.Column('inbound_chan', sa.Integer(), nullable=True),
        sa.Column('outbound_cps', sa.Integer(), nullable=True),
        sa.Column('outbound_chan', sa.Integer(), nullable=True),
        sa.Column('server_ip', sa.String(length=50), nullable=True),
        sa.Column('server_port', sa.Integer(), nullable=True)
        )
    row = connection.execute(
        "select * from pg_attribute where attrelid ='client'::regclass and attname='did_billing_by';")
    if not row or len(row.fetchall()) == 0:
        op.add_column('client', sa.Column('did_billing_by', sa.SmallInteger(), server_default='0', nullable=True))
    row = connection.execute(
        "select * from pg_attribute where attrelid ='client'::regclass and attname='fee_per_port';")
    if not row or len(row.fetchall()) == 0:
        op.add_column('client', sa.Column('fee_per_port', api_dnl.migration_types.Numeric(length=30, collation=10), nullable=True))
    # ### end Alembic commands ###
    up_rec('client')


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('client', 'fee_per_port')
    op.drop_column('client', 'did_billing_by')
    op.drop_table('qos_client')
    op.drop_index(op.f('ix_did_port_usage_info_invoice_number'), table_name='did_port_usage_info')
    op.drop_index(op.f('ix_did_port_usage_info_client_id'), table_name='did_port_usage_info')
    op.drop_table('did_port_usage_info')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))