import sys
from falcon_rest.swagger import init
from falcon_rest.conf import settings
from falcon_rest.schemes.schemes import ObjectCreatedUuidAsPk, ObjectCreatedCompositeOrStrPk
from api_dnl.routes import ROUTES,CLIENT_ROUTES
from falcon_rest.db import initialize_db
from api_dnl.base_model import DnlApiBaseModel
from api_dnl import scheme
from falcon_rest import schemes


def init_swagger():
    for name, cls in scheme.__dict__.items():
        if isinstance(cls,schemes.BaseModelScheme):
            for name,field in cls._declared_fields:
                if hasattr(field,'attribute'):
                    name=field.attribute
                field._add_to_schema(name,cls)
    swagger = init(
        ROUTES, [
        #'api_dnl.entities', 
        'api_dnl.scheme','api_dnl.schemes','api_dnl.schemes.cdr','api_dnl.dbconfig','api_dnl.views.rt_proxy',
        'falcon_rest.contrib.objects_history.object_revision'],
        [ObjectCreatedCompositeOrStrPk,ObjectCreatedUuidAsPk]
    )

    swagger.add_oauth2_security_definition(
        'api_auth', '{}{}{}{}'.format(
            settings.API_SCHEME, settings.API_HOST, settings.API_BASE_PATH, settings.AUTH_END_POINT
        )
    )
    swagger.add_api_key_security_definition('auth_token')

    return swagger

def init_swagger_client():

    swagger = init(
        CLIENT_ROUTES, [
        #'api_dnl.entities',
        'api_dnl.scheme','api_dnl.schemes','api_dnl.dbconfig'],
        [ObjectCreatedCompositeOrStrPk,ObjectCreatedUuidAsPk]
    )

    swagger.add_oauth2_security_definition(
        'api_auth', '{}{}{}{}'.format(
            settings.API_SCHEME, settings.API_HOST, settings.API_BASE_PATH, settings.AUTH_END_POINT
        )
    )
    swagger.add_api_key_security_definition('auth_token')

    return swagger


def main(args):
    initialize_db(settings.DB_CONN_STRING, DnlApiBaseModel)

    if len(args) > 1 and args[1] == 'yaml':
        return init_swagger().get_yaml()
    else:
        return init_swagger().get_json()


if __name__ == '__main__':
    print(main(sys.argv))
