from time import sleep
import traceback
import celery
from api_dnl import settings
from datetime import date,datetime,timedelta
from dateutil.relativedelta import relativedelta
from dateutil.parser import parse as parse_datetime
from pytz import UTC
from time import mktime,gmtime,strftime,strptime,localtime
import calendar
import random
import requests
import io,csv,gzip,zipfile
import os,shutil
import xlwt
import json
from celery import Celery
from celery.app.log import get_logger
from celery.schedules import crontab
from falcon_rest.db import initialize_db
from sqlalchemy import (
    Integer, SmallInteger, Float, Text, String, DateTime, Date, Time, Boolean, ForeignKey, BigInteger,
    Table
)
from sqlalchemy import (Column, desc, and_,or_,not_, text as text_, PrimaryKeyConstraint, inspect, Index, UniqueConstraint)
from sqlalchemy.sql import func, select,alias,case
from api_dnl.base_model import DnlApiBaseModel
from api_dnl.model import SchedulerLog,ScheduledReportLog,Client,InvoiceHistory,PaymentTerm,Invoice,\
    DidBillingPlan,DidBillingRel,Client,Resource,ResourceIp,JurisdictionPrefix,Code,ImportExportLogs,\
    ResourcePrefix,Rate,RateTable,RateSendLog,Route,RouteStrategy,C4ClientBalance,Product,ProductItems,ProductItemsResource,\
    RateSendLogDetail,CrdReportDetailTable,MailSender,FraudDetection,FraudDetectionLog,FraudDetectionLogDetail,\
    ResourceBlock,IngressTrunk,SystemParameter,AlertRule,AlertRuleLog,AlertRulesLogDetail,CdrReportDetail,client_cdr,\
    VoipGateway
from api_dnl.model import PrimaryKeyConstraint,func,query_to_sting,cast,generate_uuid_str,aliased,get_db
from api_dnl.tasks import app,log,db,SqlAlchemyTask
from api_dnl import model
from api_dnl.utils.statisticapi2 import StatisticAPI
from api_dnl.utils.dnl_switch import DnlSwitchSession
from api_dnl.scheme import RateScheme

def ip():

    l=[]
    while True:
        for i in range(0,4):
            l.append(str(random.randint(0,255)))
        ip='.'.join(l)
        return ip

def dig(l=12):
    letters=[chr(i) for i in range(48,58)]
    ret=''
    for c in range(0,l):
        ret=ret+random.choice(letters)
    return ret

def do_lcr_test():
    pass

def create_rates(self,obj, **kwargs):
    rate_per_min=0.0
    if obj.rate_per_min and obj.rate_table:
        rate_per_min=obj.rate_per_min

    for c in [chr(a) for a in range(ord('0'), ord('9')+1)]+\
             [chr(a) for a in range(ord('A'), ord('Z')+1)]+\
             [chr(a) for a in range(ord('a'), ord('z')+1)]:
        #q=model.Rate.filter(model.Rate.rate_table_id=)
        obj.rate_table.rates.append( model.Rate(code=c,rate=rate_per_min,
                                                    min_time = 1,interval = 1,
                                                    setup_fee = obj.setup_fee) )
class LcrTest():
    def __init__(self,name,switch_id,egress_id):
        RATE=1.0
        NOW=datetime.now(UTC)
        #self.egress = Resource.filter(Resource.alias=='aaa').first()
        self.egress = Resource.get(egress_id)
        jur_type =  self.egress.rate_table.jur_type
        ####1. rate_table
        RateTable.filter(RateTable.name==name).delete()
        self.rate_table = RateTable(name=name, jur_type=jur_type)
        for c in [chr(a) for a in range(ord('1'), ord('9') + 1)]:
            self.rate_table.rates.append(Rate(code=c, rate=RATE, effective_date=datetime(NOW.year,1,1),
                                                   min_time=6, interval=6
                                                   ))
        ####2. product (static_route)
        Product.filter(Product.name==name).delete()
        self.static_route = Product(name=name)
        #id=self.static_route.save()
        self.product_item = ProductItems() #product_id=id)
        self.product_item.product = self.static_route
        self.product_item_resource = ProductItemsResource()
        self.product_item_resource.product = self.product_item
        self.product_item_resource.resource = self.egress
        self.product_item_resource.resource
        self.product_item_resource.save()
        #self.egress.product_items.append(self.product_item)

        ####3.route
        RouteStrategy.filter(RouteStrategy.name==name).delete()
        self.route_strategy = RouteStrategy(name=name)
        self.route= Route(route_type=2)
        self.route.route_strategy = self.route_strategy
        self.route.static_route = self.static_route

        ####4. ingress resource
        Resource.filter(Resource.alias == name).delete()
        Client.filter(Client.name == name).delete()
        self.client=Carrier(name=name,enough_balance=True,mode='postpay',
                            #unlimited_credit=True,
                            allowed_credit = -1000,
                            cps_limit=10,update_by='system')

        self.trunk=Resource(alias=name,ingress=True,egress=False,enough_balance=True,res_strategy=1,max_duration=3600,rpid=1)

        self.client.resource=self.trunk
        ####5. resource ip
        self.ip=ResourceIp(ip=ip(),port=3090)
        self.trunk.ip.append(self.ip)

        ####6. resource prefix
        self.prefix0 = ResourcePrefix()
        self.prefix0.rate_table = self.rate_table
        self.prefix0.route_strategy = self.route_strategy
        self.trunk.prefixes.append(self.prefix0)

        self.prefix=ResourcePrefix(tech_prefix='9999')
        self.prefix.rate_table=self.rate_table
        self.prefix.route_strategy = self.route_strategy
        self.trunk.prefixes.append(self.prefix)

        self.client.resources.append(self.trunk)

        self.client.session().add(self.product_item_resource)
        self.client.session().add(self.route)
        self.client.save()

        self.switch = VoipGateway.get(switch_id)
        self.sess = None

    def __del__(self):
        self.product_item_resource.delete()
        self.route.delete()
        self.route_strategy.delete()
        self.static_route.delete()
        self.rate_table.delete()
        self.trunk.delete()
        self.client.delete()

    def login(self):
        self.sess = DnlSwitchSession(self.switch.lan_ip, self.switch.lan_port)
        self.sess.login()

    def logout(self):
        self.sess.logout()
        self.sess = None

    def test_code(self,code):
        logged_in = False
        if not self.sess:
            self.login()
            logged_in = True

        ret = self.sess.call_simulation(caller_ip=self.ip.ip,caller_port=self.ip.port,ani='9999'+dig(7),dnis=code,include_blocked_route=False)

        if logged_in:
            self.logout()

        return ret

if __name__ == '__main__':
    #obj=LcrTest('#dummy',1,'A-Z')
    obj=LcrTest('Dummy','A-Z',247,2666)
    sleep(10)
    obj.test_code('123456')