from datetime import date, datetime, timedelta, timezone
from time import mktime
import jwt
from api_dnl import settings
from datetime import datetime,timedelta
from pytz import UTC
UTC = timezone.utc

from sqlalchemy.exc import OperationalError
from falcon_rest.contrib.auth import auth, auth_endpoints, auth_schemes
from falcon_rest.contrib.auth.auth_signals import auth_success, auth_failed
from falcon_rest.resources import BaseResource, resources
from falcon_rest import schemes, responses
from falcon_rest.swagger import specify
from falcon_rest.conf import settings
from falcon_rest.logger import log
from falcon_rest.helpers import get_request_ip
#from .utils.statisticapi import StatisticAPI
from api_dnl import model
#from api_dnl.resources import OperationalErrorResponse
from sqlalchemy import and_

def OperationalErrorResponse(e):
    from api_dnl import settings
    log.debug("AUTH ERROR")
    msg = 'Connect to database {} \n'.format(settings.DB_CONN_STRING.split('@')[1].split('/')[0])
    msg = msg + '\n'.join(str(e).split('\n')[0:2])
    return responses.UnauthenticatedErrorResponse(data=responses.errors.Error(401, msg, e.__class__.__name__))

def get_token(user, ttl=None,ip=None):
    import jwt
    token_data = user.get_token_data()
    if not ttl:
        sp = model.SystemParameter.get(1)
        if sp:
            ttl = sp.inactivity_timeout
        if not sp or not ttl:
            ttl = 5
    valid_till = datetime.now(UTC) + timedelta(minutes=ttl)
    #token_data['exp'] = int(valid_till.timestamp())
    token_data['expired'] = int(valid_till.timestamp())
    if ip:
        token_data['ip']=ip
    token = jwt.encode(token_data, settings.JWT_SIGNATURE, algorithm='HS256')
    if hasattr(user, 'on_token_created'):
        user.on_token_created(token_data.get('jti'), token, valid_till)
    auth_token = model.AuthToken()
    auth_token.token = str(token)[2:-1]
    auth_token.start_time = datetime.now(UTC)
    auth_token.expired_on = str(valid_till)
    auth_token.user_name = user.name
    auth_token.save()
    return token

def retoken(token):

    data = jwt.decode(token, settings.JWT_SIGNATURE, verify=False)
    data['expired'] = int((datetime.now(UTC) + timedelta(days=60)).timestamp())
    auth_token = model.AuthToken()
    auth_token.token = token
    auth_token.start_time = datetime.now(UTC)
    auth_token.expired_on = str((datetime.now(UTC) + timedelta(days=60)))
    auth_token.user_name = model.User.filter(model.User.user_id == data['user_id']).first().user_name
    auth_token.save()
    return jwt.encode(data, settings.JWT_SIGNATURE, algorithm='HS256').decode('utf-8')



class AuthTokenSchemeInner(schemes.Schema):
    token = schemes.fields.String(dump_only=True)
    expired = schemes.fields.String(dump_only=True)

class AuthTokenScheme(schemes.SuccessScheme):
    payload = schemes.fields.Nested(AuthTokenSchemeInner())

class AuthCredentialsScheme(schemes.Schema):
    email_or_name = schemes.fields.String(required=True)
    password = schemes.fields.String(required=True)
    expire_after_minutes = schemes.fields.Int()

class Auth(auth_endpoints.Auth):
    def __init__(self, **kwargs):
        super(Auth, self).__init__()
        self.credentials_scheme_class = AuthCredentialsScheme

    def on_post(self, req, resp, **kwargs):
        credentials_scheme = self.credentials_scheme_class()
        try:
            if self.check_request_data(req, resp, credentials_scheme):
                credentials = self.get_loaded_data(credentials_scheme)
                user = settings.get_auth_user_model(req=req).get_user_from_credentials(credentials)
                if user and auth.check_password(credentials['password'], user.password):
                    if not hasattr(user, 'can_login') or user.can_login(req, resp):
                        ip = None
                        if user.user_type == 'admin':
                            ip = get_request_ip(req)
                        ttl = req.data.pop('expire_after_minutes', None)
                        token = get_token(user, ttl=ttl, ip=ip)
                        data = jwt.decode(token, settings.JWT_SIGNATURE, verify=False)

                        if user.user_type == "client" and user.client:
                            if user.client.enable_sign_in_notification:
                                obj = model.Client.filter(model.Client.client_id == user.client.client_id).first()
                                obj.apply_mail('sign_on_notification')
                            if not user.client.enable_client_portal:
                                auth_failed.send(self, req=req, resp=resp, data=credentials, user=user)
                                return self.set_response(resp, responses.UnAuthorizedErrorResponse())
                        self.set_response(
                            resp, responses.SuccessResponse(
                                scheme=AuthTokenScheme, data={'token': token,
                                                              'expired': str(int(data['expired'])),
                                                              'user': user
                                                              }
                            )
                        )
                        auth_success.send(self, req=req, resp=resp, user=user)
                else:
                    auth_failed.send(self, req=req, resp=resp, data=credentials, user=user)
                    if hasattr(user, 'can_login') and not user.can_login(req, resp):
                        pass
                    else:
                        from falcon_rest.responses import errors
                        if False and model.Signup.filter(model.Signup.username == credentials['email_or_name']).first():
                            self.set_response(resp, responses.UnAuthorizedErrorResponse(
                                data=errors.Error(101, 'You are not approved'))
                            )
                        else:
                            self.set_response(resp, responses.UnAuthorizedErrorResponse())
        except OperationalError as e:
            self.set_response(resp, OperationalErrorResponse(e))
        except Exception as e:
            log.critical('cannot auth:{}'.format(e))
            self.set_response(resp, OperationalErrorResponse(e))

class AuthAsClientScheme(schemes.Schema):
    client_id = schemes.fields.Int(required=True)


class AuthAsClient(BaseResource):
    credentials_scheme_class = AuthAsClientScheme
    allow_methods = ['put']
    security = (['auth_token'])
    restrict = ()

    def on_post(self, req, resp, **kwargs):
        try:
            admin = req.context['user']
            credentials_scheme = self.credentials_scheme_class()
            if self.check_request_data(req, resp, credentials_scheme):
                credentials = self.get_loaded_data(credentials_scheme)
                client = model.Client.get(credentials['client_id'])
                if not client:
                    self.set_response(resp, responses.ObjectNotFoundErrorResponse())
                    return
                credentials['email_or_name'] = admin.name + ' as client_id {}'.format(client.client_id)
                credentials['password'] = '***'
                user_id = client.create_user()
                user = model.User.get(user_id) if user_id else None
                if user and admin.user_type == 'admin':
                    if not hasattr(user, 'can_login') or user.can_login(req, resp):
                        #     pass
                        self.set_response(
                            resp, responses.SuccessResponse(
                                scheme=AuthTokenScheme, data={'token': get_token(user),
                                                              'user': user
                                                              }
                            )
                        )
                        auth_success.send(self, req=req, resp=resp, user=user)
                else:
                    auth_failed.send(self, req=req, resp=resp, data=credentials, user=user)
                    if hasattr(user, 'can_login') and not user.can_login(req, resp):
                        pass
                    else:
                        self.set_response(resp, responses.UnAuthorizedErrorResponse())
        except OperationalError as e:
            self.set_response(resp, OperationalErrorResponse(e))
        except Exception as e:
            log.critical('cannot client auth:{}'.format(e))
            self.set_response(resp, OperationalErrorResponse(e))

    def get_spec(self):
        return specify.get_spec(
            method='post', description='Authenticate as client',
            body_parameters=('Client reference id', self.credentials_scheme_class),
            responses=(
                responses.SuccessResponse(scheme=AuthTokenScheme),
                responses.ValidationErrorResponse(),
                responses.UnAuthorizedErrorResponse(),
                responses.ObjectNotFoundErrorResponse()
            ),
            security=self.security
        )


class AuthAsAgentScheme(schemes.Schema):
    agent_id = schemes.fields.Int(required=True)


class AuthAsAgent(BaseResource):
    credentials_scheme_class = AuthAsAgentScheme
    allow_methods = ['put']
    security = (['auth_token'])
    restrict = ()

    def on_post(self, req, resp, **kwargs):
        admin = req.context['user']
        try:
            credentials_scheme = self.credentials_scheme_class()
            if self.check_request_data(req, resp, credentials_scheme):
                credentials = self.get_loaded_data(credentials_scheme)
                agent = model.Agent.get(credentials['agent_id'])
                if not agent:
                    self.set_response(resp, responses.ObjectNotFoundErrorResponse())
                    return
                credentials['email_or_name'] = admin.name + ' as agent_id {}'.format(agent.agent_id)
                credentials['password'] = '***'
                user_id = agent.create_user()
                user = model.User.get(user_id)
                if user and admin.user_type == 'admin':
                    if not hasattr(user, 'can_login') or user.can_login(req, resp):
                        self.set_response(
                            resp, responses.SuccessResponse(
                                scheme=AuthTokenScheme, data={'token': get_token(user),
                                                              'user': user
                                                              }
                            )
                        )
                        auth_success.send(self, req=req, resp=resp, user=user)
                else:
                    auth_failed.send(self, req=req, resp=resp, data=credentials, user=user)
                    if hasattr(user, 'can_login') and not user.can_login(req, resp):
                        pass
                    else:
                        self.set_response(resp, responses.UnAuthorizedErrorResponse())
        except OperationalError as e:
            self.set_response(resp, OperationalErrorResponse(e))
        except Exception as e:
            log.critical('cannot agent auth:{}'.format(e))
            self.set_response(resp, OperationalErrorResponse(e))

    def get_spec(self):
        return specify.get_spec(
            method='post', description='Authenticate as agent',
            body_parameters=('Agent reference id', self.credentials_scheme_class),
            responses=(
                responses.SuccessResponse(scheme=AuthTokenScheme),
                responses.ValidationErrorResponse(),
                responses.UnAuthorizedErrorResponse(),
                responses.ObjectNotFoundErrorResponse()
            ),
            security=self.security
        )


class TokenCheck(BaseResource):
    allow_methods = ['post']

    def __init__(self, **kwargs):
        super(TokenCheck, self).__init__()
        self.security = kwargs.get('security', resources.DEFAULT_SECURITY)

    def on_post(self, req, resp, **kwargs):
        try:
            token = req.headers.get('X-AUTH-TOKEN')
            token_data = jwt.decode(token, settings.JWT_SIGNATURE, verify=False)
            sp = model.SystemParameter.get(1)
            if sp:
                ttl = sp.inactivity_timeout
            else:
                return None
            valid_till = datetime.now(UTC) - timedelta(minutes=30+ttl*2)
            exp1 = int(valid_till.timestamp())
            if token_data['expired'] < exp1:
                self.set_response(resp, responses.UnAuthorizedErrorResponse())
                return
            self.init_req(req)
            user = self.get_user(req)
            if not user:
                self.set_response(resp, responses.UnAuthorizedErrorResponse())
                return False
            ip = None
            if user.user_type == 'admin':
                ip = get_request_ip(req)
            token = get_token(user, ip=ip)
            data = jwt.decode(token, settings.JWT_SIGNATURE, verify=False)
            self.set_response(
                resp, responses.SuccessResponse(
                    scheme=AuthTokenScheme, data={'token': token,
                                                  'expired': str(int(data['expired']))

                                                  }
                )
            )
        except OperationalError as e:
            self.set_response(resp, OperationalErrorResponse(e))
        except Exception as e:
            self.set_response(resp, OperationalErrorResponse(e))

    def get_spec(self):
        return specify.get_spec(
            method='post', description='Checks and refreshes token',
            responses=(
                responses.SuccessResponse(scheme=AuthTokenScheme),
                responses.ValidationErrorResponse(),
                responses.OperationErrorResponse('Incorrect token')
            ),
            security=self.security
        )

class AdminTokenCheck(BaseResource):
    allow_methods = ['get']
    no_auth_needed = True
    def __init__(self, **kwargs):
        super(AdminTokenCheck, self).__init__()
        self.security = kwargs.get('security', resources.DEFAULT_SECURITY)

    def on_get(self, req, resp, **kwargs):
        from urllib.parse import parse_qsl, urlencode, quote
        try:
            #token = req.headers.get('X-AUTH-TOKEN')
            log.debug('auth params {}'.format(req.params))
            log.debug('auth headers {}'.format(req.headers))
            token = req.params.get('auth_token',None)
            if not token:
                token = req.headers.get('X-AUTH-TOKEN')
                token=token.replace('/sngrep?','').replace('/sngrep/ws?','').replace('auth_token=','')
            log.debug('auth token {}'.format(token))
            token_data = jwt.decode(token, settings.JWT_SIGNATURE, verify=False)
            ip = get_request_ip(req)
            if token_data['ip']!=ip:
                self.set_response(resp, responses.UnAuthorizedErrorResponse())
                log.debug('ip does not match {} {}'.format(token_data['ip'],ip))
                return
            sp = model.SystemParameter.get(1)
            if sp:
                ttl = sp.inactivity_timeout
            else:
                return None
            valid_till = datetime.now(UTC) - timedelta(minutes=30+ttl*2)
            exp1 = int(valid_till.timestamp())
            if token_data['expired'] < exp1:
                self.set_response(resp, responses.UnAuthorizedErrorResponse())
                return
            self.init_req(req)
            user = model.User.get(token_data['user_id'])
            if not user.user_type == 'admin':
                self.set_response(resp, responses.UnAuthorizedErrorResponse())
                return False
            ip = None
            if user.user_type == 'admin':
                ip = get_request_ip(req)
            token = get_token(user, ip=ip)
            data = jwt.decode(token, settings.JWT_SIGNATURE, verify=False)



            self.set_response(
                resp, responses.SuccessResponse(
                    scheme=AuthTokenScheme, data={'token': token,
                                                  'expired': str(int(data['expired']))
                                                  }
                )
            )
        except OperationalError as e:
            self.set_response(resp, responses.UnAuthorizedErrorResponse())
            return False
        except Exception as e:
            self.set_response(resp, responses.UnAuthorizedErrorResponse())
            return False

    def get_spec(self):
        return specify.get_spec(
            method='get', description='Checks and refreshes admin token',
            responses=(
                responses.SuccessResponse(scheme=AuthTokenScheme),
                responses.ValidationErrorResponse(),
                responses.OperationErrorResponse('Incorrect token'),
                responses.UnAuthorizedErrorResponse()
            ),
            security=self.security
        )
