"""invoice_summary foreign

Revision ID: 0f14f277046e
Revises: 81edc88402f0
Create Date: 2019-10-29 23:26:21.026758

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):



# revision identifiers, used by Alembic.
revision = '0f14f277046e'
down_revision = '81edc88402f0'
branch_labels = None
depends_on = None


def upgrade():
    connection = op.get_bind()
    connection.execute("delete from manual_invoice_task where (not invoice_number is null) and (invoice_number not in (select invoice_number from invoice_summary) )")
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('ix_did_invoice_number_fee_detail_invoice_number', table_name='did_invoice_number_fee_detail')
    op.create_foreign_key(None, 'did_invoice_number_fee_detail', 'invoice_summary', ['invoice_number'], ['invoice_number'], ondelete='CASCADE')
    op.drop_index('ix_did_setup_fee_invoice_number', table_name='did_setup_fee')
    op.create_foreign_key(None, 'did_setup_fee', 'invoice_summary', ['invoice_number'], ['invoice_number'], ondelete='CASCADE')
    op.create_foreign_key(None, 'dnl_invoice_history', 'invoice_summary', ['invoice_number'], ['invoice_number'], ondelete='CASCADE')
    op.drop_index('ix_invoice_code_name_detail_invoice_number', table_name='invoice_code_name_detail')
    op.create_foreign_key(None, 'invoice_code_name_detail', 'invoice_summary', ['invoice_number'], ['invoice_number'], ondelete='CASCADE')
    op.drop_index('ix_invoice_country_detail_invoice_number', table_name='invoice_country_detail')
    op.create_foreign_key(None, 'invoice_country_detail', 'invoice_summary', ['invoice_number'], ['invoice_number'], ondelete='CASCADE')
    op.drop_index('ix_invoice_daily_detail_invoice_number', table_name='invoice_daily_detail')
    op.create_foreign_key(None, 'invoice_daily_detail', 'invoice_summary', ['invoice_number'], ['invoice_number'], ondelete='CASCADE')
    op.drop_index('ix_invoice_trunk_detail_invoice_number', table_name='invoice_trunk_detail')
    op.create_foreign_key(None, 'invoice_trunk_detail', 'invoice_summary', ['invoice_number'], ['invoice_number'], ondelete='CASCADE')
    op.drop_index('ix_invoice_trunk_prefix_detail_invoice_number', table_name='invoice_trunk_prefix_detail')
    op.create_foreign_key(None, 'invoice_trunk_prefix_detail', 'invoice_summary', ['invoice_number'], ['invoice_number'], ondelete='CASCADE')
    op.create_foreign_key(None, 'manual_invoice_task', 'invoice_summary', ['invoice_number'], ['invoice_number'], ondelete='SET NULL')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, 'manual_invoice_task', type_='foreignkey')
    op.drop_constraint(None, 'invoice_trunk_prefix_detail', type_='foreignkey')
    op.create_index('ix_invoice_trunk_prefix_detail_invoice_number', 'invoice_trunk_prefix_detail', ['invoice_number'], unique=False)
    op.drop_constraint(None, 'invoice_trunk_detail', type_='foreignkey')
    op.create_index('ix_invoice_trunk_detail_invoice_number', 'invoice_trunk_detail', ['invoice_number'], unique=False)
    op.drop_constraint(None, 'invoice_daily_detail', type_='foreignkey')
    op.create_index('ix_invoice_daily_detail_invoice_number', 'invoice_daily_detail', ['invoice_number'], unique=False)
    op.drop_constraint(None, 'invoice_country_detail', type_='foreignkey')
    op.create_index('ix_invoice_country_detail_invoice_number', 'invoice_country_detail', ['invoice_number'], unique=False)
    op.drop_constraint(None, 'invoice_code_name_detail', type_='foreignkey')
    op.create_index('ix_invoice_code_name_detail_invoice_number', 'invoice_code_name_detail', ['invoice_number'], unique=False)
    op.drop_constraint(None, 'dnl_invoice_history', type_='foreignkey')
    op.drop_constraint(None, 'did_setup_fee', type_='foreignkey')
    op.create_index('ix_did_setup_fee_invoice_number', 'did_setup_fee', ['invoice_number'], unique=False)
    op.drop_constraint(None, 'did_invoice_number_fee_detail', type_='foreignkey')
    op.create_index('ix_did_invoice_number_fee_detail_invoice_number', 'did_invoice_number_fee_detail', ['invoice_number'], unique=False)
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))