"""did_charge_detail

Revision ID: 71d01210f6bc
Revises: d36c341d144c
Create Date: 2020-04-06 23:40:57.881585

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):



# revision identifiers, used by Alembic.
revision = '71d01210f6bc'
down_revision = 'd36c341d144c'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('did_charge_detail',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('params', sa.String(length=4096), nullable=True),
    sa.Column('did_number', sa.String(length=64), nullable=False),
    sa.Column('client_billing_plan_id', sa.Integer(), nullable=True),
    sa.Column('client_trunk_id', sa.Integer(), nullable=True),
    sa.Column('nrc', api_dnl.migration_types.Numeric(length=32, collation=6), server_default=sa.text('0.00'), nullable=False),
    sa.Column('mrc', api_dnl.migration_types.Numeric(length=32, collation=6), server_default=sa.text('0.00'), nullable=False),
    sa.Column('minutes', sa.Integer(), server_default='0', nullable=True),
    sa.Column('attempts', sa.Integer(), server_default='0', nullable=True),
    sa.Column('call_charge', api_dnl.migration_types.Numeric(length=32, collation=6), server_default=sa.text('0.00'), nullable=False),
    sa.Column('start_date', sa.Date(), nullable=True),
    sa.Column('end_date', sa.Date(), nullable=True),
    sa.Column('mrc_number', sa.Integer(), server_default='0', nullable=True),
    sa.Column('pay_type', sa.Integer(), server_default='0', nullable=True),
    sa.Column('created_on', sa.DateTime(True), server_default=sa.func.now()),
    sa.ForeignKeyConstraint(['client_billing_plan_id'], ['did_billing_plan.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['client_trunk_id'], ['resource.resource_id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_did_charge_detail_did_number'), 'did_charge_detail', ['did_number'], unique=False)
    op.create_index(op.f('ix_did_charge_detail_params'), 'did_charge_detail', ['params'], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_did_charge_detail_params'), table_name='did_charge_detail')
    op.drop_index(op.f('ix_did_charge_detail_did_number'), table_name='did_charge_detail')
    op.drop_table('did_charge_detail')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))