"""did_billing_brief

Revision ID: 85e1c8595bb6
Revises: d6b3400181d0
Create Date: 2020-01-14 17:30:16.039558

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):



# revision identifiers, used by Alembic.
revision = '85e1c8595bb6'
down_revision = 'd6b3400181d0'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    connection = op.get_bind()
    row = connection.execute("select * from pg_attribute where attrelid ='did_billing_brief'::regclass and attname='next_mrc_billing_date'")
    if not row or len(row.fetchall())==0:
        op.add_column('did_billing_brief', sa.Column('next_mrc_billing_date', sa.Date(), nullable=True))
        op.add_column('did_billing_brief', sa.Column('nrc_billing_date', sa.Date(), nullable=True))
        op.create_index(op.f('ix_did_billing_brief_next_mrc_billing_date'), 'did_billing_brief', ['next_mrc_billing_date'], unique=False)
        op.create_index(op.f('ix_did_billing_brief_nrc_billing_date'), 'did_billing_brief', ['nrc_billing_date'], unique=False)
    row = connection.execute(
        "select * from pg_attribute where attrelid ='did_setup_fee'::regclass and attname='id';")
    if not row or len(row.fetchall())==0:
        connection.execute("alter table did_setup_fee drop constraint did_setup_fee_pkey")
        op.add_column('did_setup_fee', sa.Column('id', sa.Integer(), nullable=False,primary_key=True))
        connection.execute("alter table did_setup_fee add PRIMARY KEY(id)")
        op.add_column('did_setup_fee', sa.Column('start_date', sa.Date(), nullable=True))
        op.alter_column('did_setup_fee', 'invoice_number',
               existing_type=sa.INTEGER(),
               nullable=True)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('did_setup_fee', 'invoice_number',
               existing_type=sa.INTEGER(),
               nullable=False)
    connection = op.get_bind()
    connection.execute("alter table did_setup_fee add PRIMARY KEY(invoice_number)")
    op.drop_column('did_setup_fee', 'start_date')
    op.drop_column('did_setup_fee', 'id')
    op.drop_index(op.f('ix_did_billing_brief_nrc_billing_date'), table_name='did_billing_brief')
    op.drop_index(op.f('ix_did_billing_brief_next_mrc_billing_date'), table_name='did_billing_brief')
    op.drop_column('did_billing_brief', 'nrc_billing_date')
    op.drop_column('did_billing_brief', 'next_mrc_billing_date')
    # ### end Alembic commands ###
    pass
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))