"""cdr_export_task

Revision ID: 96deabebc396
Revises: 138061af8fde
Create Date: 2019-12-05 16:02:48.729765

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.engine import reflection
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):



# revision identifiers, used by Alembic.
revision = '96deabebc396'
down_revision = '138061af8fde'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    connection = op.get_bind()
    inspector = reflection.Inspector.from_engine(connection)
    tables = inspector.get_table_names()
    if 'cdr_export_task' not in tables:
        op.create_table('cdr_export_task',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('operator_user', sa.String(length=40), nullable=True),
        sa.Column('export_cdr_file', sa.String(length=1024), nullable=True),
        sa.Column('cdr_counts', sa.Integer(), server_default='0', nullable=True),
        sa.Column('cdr_start_time', sa.DateTime(timezone=True), nullable=True),
        sa.Column('cdr_end_time', sa.DateTime(timezone=True), nullable=True),
        sa.Column('csv_file_headers', sa.String(length=2048), nullable=True),
        sa.Column('cdr_headers', sa.String(length=2048), nullable=True),
        sa.Column('cdr_filter', sa.String(length=2048), nullable=True),
        sa.Column('status', sa.SmallInteger(), server_default='0', nullable=False),
        sa.Column('progress', sa.String(length=1024), nullable=True),
        sa.Column('start_time', sa.DateTime(timezone=True), nullable=True),
        sa.Column('end_time', sa.DateTime(timezone=True), nullable=True),
        sa.Column('create_time', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
        sa.PrimaryKeyConstraint('id')
        )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('cdr_export_task')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))