"""rate_analysis_task, lcr_task

Revision ID: cea6c7abfc34
Revises: af17b65998bc
Create Date: 2025-08-28 08:11:07.375308

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os


# revision identifiers, used by Alembic.
revision = 'cea6c7abfc34'
down_revision = 'af17b65998bc'
branch_labels = None
depends_on = None


def upgrade():
    upgrade_sql = """
BEGIN;

CREATE SEQUENCE public.rate_analysis_task_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rate_analysis_task_id_seq OWNER TO class4_user;

CREATE SEQUENCE public.lcr_task_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.lcr_task_id_seq OWNER TO class4_user;

CREATE TABLE public.rate_analysis_task (
    task_id integer DEFAULT nextval('public.rate_analysis_task_id_seq'::regclass) NOT NULL,
    status integer DEFAULT 0 NOT NULL,
    progress integer,
    operator_user character varying(40),
    start_time timestamp with time zone,
    end_time timestamp with time zone,
    create_time timestamp with time zone,
    expense_detail character varying(100),
    source_rate_table_id integer,
    source_effective_date timestamp with time zone,
    target_rate_table_id integer,
    target_effective_date timestamp with time zone,
    target_file_name character varying(512),
    rate_generation_history_id integer,
    created_on timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone NOT NULL,
    started_on timestamp with time zone,
    finished_on timestamp with time zone,
    result_json character varying(512)
);


ALTER TABLE public.rate_analysis_task OWNER TO class4_user;

CREATE TABLE public.lcr_task (
    task_id integer DEFAULT nextval('public.lcr_task_id_seq'::regclass) NOT NULL,
    target_rate_table_id integer NOT NULL,
    egress_id integer[],
    lcr_rate_table_id integer[] NOT NULL,
    created_on timestamp with time zone DEFAULT ('now'::text)::timestamp(0) with time zone,
    started_on timestamp with time zone,
    finished_on timestamp with time zone,
    result_path character varying(256),
    effective_date character varying(40) DEFAULT ('now'::text)::timestamp(0) with time zone
);


ALTER TABLE public.lcr_task OWNER TO class4_user;

ALTER TABLE ONLY public.rate_analysis_task
    ADD CONSTRAINT rate_analysis_task_pkey PRIMARY KEY (task_id);

ALTER TABLE ONLY public.lcr_task
    ADD CONSTRAINT lcr_task_pkey PRIMARY KEY (task_id);

END;
"""
    connection = op.get_bind()
    connection.execute(upgrade_sql)
    # up_rec('resource')


def downgrade():
    # Arch users don't downgrade
    pass


"""
ADDONS
"""
def up_rec(table):
    """
    Update {table}_record schema
    """

    up_rec_sql = """
DO $do$
DECLARE
    rec_id INT := 1;
BEGIN
    -- Check if table exists
    IF NOT EXISTS (SELECT 0 FROM pg_tables WHERE tablename = '{table}') THEN
        RAISE WARNING 'Table {table} does not exist';
    ELSE
        -- Get last record_id
        SELECT record_id FROM {table}_record ORDER BY record_id DESC LIMIT 1
        INTO rec_id;
        -- Delete existing table
        DROP TRIGGER IF EXISTS class4_trig_record_{table} ON {table};
        DROP FUNCTION IF EXISTS class4_trigfun_record_{table};
        DROP TABLE IF EXISTS {table}_record;
        DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
    END IF;

    -- Create new table
    CREATE TABLE {table}_record (LIKE {table},
    "time" integer, flag character(1), record_id SERIAL PRIMARY KEY);
    ALTER TABLE {table}_record OWNER TO class4_user;
    CREATE INDEX IF NOT EXISTS {table}_record_time_idx
    ON {table}_record USING btree ("time");
    EXECUTE format(E'SELECT setval(\\'{table}_record_record_id_seq\\', %%L)',
    rec_id);

    -- Trigger
    CREATE FUNCTION class4_trigfun_record_{table}() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.{table}_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.{table}_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.{table}_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.{table}_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;
    ALTER FUNCTION class4_trigfun_record_{table}() OWNER TO class4_user;
    CREATE TRIGGER class4_trig_record_{table} AFTER INSERT OR DELETE OR UPDATE
    ON {table} FOR EACH ROW EXECUTE PROCEDURE class4_trigfun_record_{table}();
END $do$;
"""
    connection = op.get_bind()
    connection.execute(up_rec_sql.format_map(dict(table=table)))
