"""balance hist date client

Revision ID: dfe30ab7adab
Revises: 00cb7e781257
Create Date: 2017-11-30 02:50:56.633241

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = 'dfe30ab7adab'
down_revision = '00cb7e781257'
branch_labels = None
depends_on = None


def upgrade():
    connection = op.get_bind()
    connection.execute("delete from balance_history_actual where ctid not in (select max(ctid) from balance_history_actual s  group by s.date,s.client_id)")
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('ix_balance_history_actual_date', table_name='balance_history_actual')
    op.create_index(op.f('ix_balance_history_actual_date'), 'balance_history_actual', ['date'], unique=False)
    op.create_unique_constraint(None, 'balance_history_actual', ['date', 'client_id'])
    op.create_unique_constraint(None, 'rate_upload_template', ['name'])
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, 'rate_upload_template', type_='unique')
    op.drop_constraint(None, 'balance_history_actual', type_='unique')
    op.drop_index(op.f('ix_balance_history_actual_date'), table_name='balance_history_actual')
    op.create_index('ix_balance_history_actual_date', 'balance_history_actual', ['date', 'client_id'], unique=True)
    # ### end Alembic commands ###
