import celery
from api_dnl import settings
from datetime import datetime,timedelta
from pytz import UTC
import io,csv,gzip,zipfile
import xlwt
import json
from celery import Celery,group
from celery.app.log import get_logger
from celery.schedules import crontab
from sqlalchemy import (Column, event,distinct,desc, or_, not_,and_, text as text_, PrimaryKeyConstraint, inspect, Index, UniqueConstraint)
from falcon_rest.db import initialize_db
from api_dnl.base_model import DnlApiBaseModel
from api_dnl.model import Client,Client,Resource,Rate,RateTable,RateSendLog,BalanceHistoryActual,C4ClientBalance,\
    RateSendLogDetail,CrdReportDetailTable,MailSender,\
    ResourceBlock,IngressTrunk,SystemParameter,FrundDetection,FrundDetectionHistory,FraudDetectionLogDetail,FraudDetection
from api_dnl.model import PrimaryKeyConstraint,func
from api_dnl.tasks import app,log,db,SqlAlchemyTask,SchLog
from api_dnl import model
from api_dnl.utils.statisticapi2 import StatisticAPI

@app.task(base=SqlAlchemyTask)
def do_fraud_detection():
    slog = SchLog('fraud_detection')
    log.debug('Start fraud detection!')
    for fd in FraudDetection.filter(FraudDetection.active==True).all():
        fraud_detection.delay(fd.id)
    pass
    slog.close()


def check_fraud_detection(fd,trunk):
    import random
    TEST = False

    hourly_minute = trunk.ingress_billed_time(delta=timedelta(hours=1)) / 60

    if TEST:
        hourly_minute = random.randint(0,fd.hourly_minute*10/9)
    if fd.hourly_minute and fd.hourly_minute <= hourly_minute:
        return (True, '1 hour minute', 0, hourly_minute, fd.hourly_minute)

    hourly_revenue = trunk.ingress_cost(delta=timedelta(hours=1))
    if TEST:
        hourly_revenue = random.randint(0,fd.hourly_revenue*10/9)
    if fd.hourly_revenue and fd.hourly_revenue <= hourly_revenue:
        return (True, '1 hour revenue', 1, hourly_revenue, fd.hourly_revenue)

    daily_minute = trunk.ingress_billed_time(delta=timedelta(hours=24)) / 60
    if TEST:
        daily_minute = random.randint(0,fd.daily_minute*10/9)
    if fd.daily_minute and fd.daily_minute <= daily_minute:
        return (True, '24 hour minute', 2, daily_minute, fd.daily_minute)

    daily_revenue = trunk.ingress_cost(delta=timedelta(hours=24))
    if TEST:
        daily_revenue = random.randint(0,fd.daily_revenue*10/9)

    if fd.daily_revenue and fd.daily_revenue <= daily_revenue:
        return (True, '24 hour revenue', 3, daily_revenue, fd.daily_revenue)

    return (False,None,None,None,None)

@app.task(base=SqlAlchemyTask)
def fraud_detection(id):
    try:
        fd=FraudDetection.get(id)
        if fd:
            fd_log = FraudDetectionLog(fraud_detection_id=id,create_by=1,status='normal',create_on=datetime.now(UTC))
            fd_log_id=fd_log.save()
            log.debug('Fraud detection {} {}'.format(id,fd.name))
            if fd.ingress_trunks:
                ingress_trunks=fd.ingress_trunks
            else:
                ingress_trunks = [r.resource_id for r in Resource.filter(and_(Resource.ingress==True,Resource.active==True)).all()]
            for ingress_id in ingress_trunks:
                try:
                    ingress_id=int(ingress_id)
                except:
                    log.warning('Ingress trunk "{}" bad format skip'.format(ingress_id))
                    continue
                if ResourceBlock.filter(ResourceBlock.ingress_trunk_id==ingress_id).count():
                    log.debug('Ingress trunk {} already blocked, skip'.format(ingress_id))
                    continue
                trunk=IngressTrunk.get(ingress_id)
                if not trunk:
                    log.debug('Ingress trunk {} not exists, skip'.format(ingress_id))
                    continue
                if not trunk.client:
                    log.debug('Ingress trunk {} has no client_id , skip'.format(ingress_id))
                    continue
                block,type_name,type,value,limit_value  = check_fraud_detection(fd,trunk)
                if block:
                    log.info('Fraud detected of Ingress trunk {} type_name:{} value:{} limit:{}'.\
                              format(ingress_id, type_name, value, limit_value))
                    fd_log.status='over limit'
                    fd_log_detail = FraudDetectionLogDetail(fraud_detection_log_id=fd_log_id,ingress_id = ingress_id, block_type=type_name,
                                                    limit_value=limit_value,actual_value=value,is_block=fd.is_block)
                    fd_log.detail.append(fd_log_detail)
                    fd_log_detail.save()

                    if fd.is_block:
                        rb = ResourceBlock(ingress_res_id=ingress_id,ingress_client_id=trunk.client_id,action_type='fraud rule',
                                         update_by='fraud detection[{}]'.format(fd.name),block_log_id=fd_log_detail.id).save()
                        log.warning('Fraud rule {} did block trunk {}, resource_block is:{}'.format(id,ingress_id,rb))
                    if fd.is_send_mail:
                        #todo not repeat mail
                        last_log=FraudDetectionLogDetail.filter(FraudDetectionLogDetail.fraud_detection_id==id).\
                            filter(FraudDetectionLogDetail.ingress_id==ingress_id).filter(FraudDetectionLogDetail.is_send_email==True).\
                            order_by(FraudDetectionLogDetail.finish_time.desc()).first()
                        if last_log and last_log.block_type in ('24 hour minute','24 hour revenue') and \
                                last_log.finish_time > datetime.now(UTC)-timedelta(days=1):
                            log.debug('Fraud rule {} trunk_id {} last run was {} block type {} skip email'.\
                                      format(id,ingress_id,last_log.finish_time,last_log.block_type))
                            continue # not send mail
                        if last_log and last_log.block_type in ('1 hour minute','1 hour revenue') and \
                                last_log.finish_time > datetime.now(UTC)-timedelta(hours=1):
                            log.debug('Fraud rule {} trunk_id {} last run was {} block type {} skip email'.\
                                      format(id,ingress_id,last_log.finish_time,last_log.block_type))
                            continue # not send mail
                        to=''
                        if fd.email_to in ['Own NOC Email', 'Both']:
                            sys=SystemParameter.get(1)
                            if sys.noc_email and not sys.noc_email=='':
                                fd_log_detail.system_email=sys.noc_email
                                to=to+sys.noc_email
                            else:
                                log.warning('No noc_email in system_parameters configured')
                        if fd.email_to in ['Partner NOC Email', 'Both']:
                            if trunk.client.noc_email and not trunk.client.noc_email=='':
                                fd_log_detail.partner_email=trunk.client.noc_email
                                to=to+trunk.client.noc_email
                            else:
                                log.warning('No noc_email in client {} configured '.format(trunk.client_id))
                        trunk.block_value = value
                        trunk.limit_value = limit_value
                        trunk.rule_name = fd.name
                        trunk.rule_type = type_name
                        trunk.current_date = datetime.now(UTC)
                        log.debug('Fraud detection email to {} sent'.format(to))

                        mail_not_sent=trunk.apply_mail('fraud_detection',to=to)

                        fd_log_detail.is_send_email=True
                        fd_log_detail.system_email_status = bool(mail_not_sent)
                        fd_log_detail.partner_email_status = bool(mail_not_sent)
                        fd_log_detail.save()
                fd_log.finish_time=datetime.now(UTC)
                fd_log.save()
            log.debug('Fraud detection {} finished'.format(id))

    except Exception as e:
        log.error('fraud_detection id={} error:{}'.format(id,str(e)))
        db.session.rollback()
