import celery
from api_dnl import settings
from datetime import datetime, timedelta
from pytz import UTC
from time import mktime, sleep
import io, csv, gzip, zipfile
import os, shutil
import xlwt
import json
from api_dnl.utils.imp_exp import (csv2xls, dict_to_csv)
from celery import Celery
from celery.app.log import get_logger
from celery.schedules import crontab
from falcon_rest.db import initialize_db
from sqlalchemy import (
    Integer, SmallInteger, Float, Text, String, DateTime, Date, Time, Boolean, ForeignKey, BigInteger,
    Table
)
from sqlalchemy import (Column, desc, and_, or_, not_, text as text_, PrimaryKeyConstraint, inspect, Index,
                        UniqueConstraint)
from sqlalchemy.sql import func, select, alias, case
from api_dnl.base_model import DnlApiBaseModel
from api_dnl.model import Client, Client, Resource, ResourcePrefix, Rate, RateTable, FtpConf, BalanceHistoryActual, \
    C4ClientBalance, \
    CrdReportDetailTable, MailSender, MailTemplate, FraudDetection, FraudDetectionLog, FraudDetectionLogDetail, \
    ResourceBlock, IngressTrunk, SystemParameter, AlertRule, AlertRuleLog, AlertRulesLogDetail, CdrReportDetail, \
    client_cdr, \
    FtpConf, SendCdrDirect, FtpCdrLog
from api_dnl.model import PrimaryKeyConstraint, func, query_to_sting, cast, generate_uuid_str, aliased

from api_dnl.tasks import app, log, db, SqlAlchemyTask, SchLog
from api_dnl import model
from api_dnl.utils.statisticapi2 import StatisticAPI
from api_dnl.scheme import RateScheme
from api_dnl.utils.ws_broker_api import WSBrokerAPI


@app.task(base=SqlAlchemyTask)
def do_ftp_upload():
    log.debug('ftp_upload started')
    now = datetime.now(UTC)
    if now.minute == 0:
        for job in FtpConf.filter(
                and_(FtpConf.active == True, FtpConf.frequency == 'hourly')).all():
            d = now-timedelta(hours=1)
            start = int(datetime(d.year,d.month,d.day,d.hour,0,0).timestamp())
            end = int(datetime(now.year,now.month,now.day,now.hour,0,0).timestamp())
            ftp_upload.delay(job.id,start,end)

        for job in FtpConf.filter(
                and_(FtpConf.active == True, FtpConf.frequency == 'daily', FtpConf.every_hours == now.hour)).all():
            d = now - timedelta(hours=24)
            start = int(datetime(d.year, d.month, d.day, d.hour, 0, 0).timestamp())
            end = int(datetime(now.year, now.month, now.day, now.hour, 0, 0).timestamp())
            ftp_upload.delay(job.id,start,end)
        wd = now.weekday() + 1 if now.weekday() < 6 else 0
        for job in FtpConf.filter(
                and_(FtpConf.active == True, FtpConf.frequency == 'weekly', FtpConf.every_hours == now.hour,
                     FtpConf.every_day == wd)).all():
            d = now - timedelta(days=7)
            start = int(datetime(d.year, d.month, d.day, d.hour, 0, 0).timestamp())
            end = int(datetime(now.year, now.month, now.day, now.hour, 0, 0).timestamp())
            ftp_upload.delay(job.id,start,end)


@app.task(base=SqlAlchemyTask)
def check_ftp_status(request_id):
    job = FtpConf.get(request_id)
    job.test_ftp_server()
    job.save()


@app.task(base=SqlAlchemyTask)
def do_check_ftp_status():
    for job in FtpConf.filter(FtpConf.active):
        try:
            job.test_ftp_server()
            job.save()
        except:
            pass


@app.task(base=SqlAlchemyTask)
def ftp_upload(job_id,start,end):
    from api_dnl.views.cdr import CdrReportList
    from ftplib import FTP,B_CRLF,_SSLSocket
    db1 = initialize_db(conn_string=settings.DB_CONN_STRING, declarative_base=DnlApiBaseModel, db_label='support')
    FtpConf.db_label = 'support'
    FtpCdrLog.db_label = 'support'
    log.debug('ftp_upload job_id={} sheduled.'.format(job_id))
    job = FtpConf.get(job_id)
    if not job or not job.active:
        # sr = FtpConf(request_id=request_id, email_to=email_to, method=method)
        log.debug('ftp_upload job_id={} not exists!'.format(job_id))
        return

    flog = FtpCdrLog(ftp_conf_id=job.id,ftp_start_time=datetime.now(UTC),status='initial',
                     cdr_start_time=datetime.fromtimestamp(start,UTC),
                     cdr_end_time=datetime.fromtimestamp(end,UTC),
                     alias=job.ftp_username,
                     ftp_dir=job.server_dir,
                     ftp_ip=job.ftp_server_ip_1
                     )
    flog.save()
    conn = None
    try:
        file_name = '{}-{}.csv'.format(start, end)
        ws = WSBrokerAPI()
        ws.set_task_id('ftp_upload', id)
        # job.ftp_server_ip='ftp://127.0.0.1'
        # job.ftp_server_port = '21'
        # job.ftp_username = 'ftp'
        # job.ftp_password = '1234'
        # job.server_dir = '/tmp'
        # job.fields= 'time,orig_country,connection_type,egress_client_id,release_cause,egress_bill_time'
        ftp = FTP(host=job.ftp_server_ip_1, user=job.ftp_username, passwd=job.ftp_password, timeout=1)
        ftp.connect(port=int(job.ftp_server_port))
        ftp.login(user=job.ftp_username, passwd=job.ftp_password)
        ftp.cwd("{}".format(job.server_dir))
        ftp.voidcmd('TYPE A')
        conn = ftp.transfercmd('STOR {}'.format(file_name))
        filter = dict(field=job.fields)

        if job.ingress_carriers:
            filter['ingress_carrier_id'] = job.ingress_carriers
        if job.egress_carriers:
            filter['egress_carrier_id'] = job.egress_carriers
        if job.ingresses:
            filter['ingress_id'] = job.ingresses
        if job.egresses:
            filter['egress_id'] = job.egresses
        if job.egress_release_cause:
            filter['release_cause_from_protocol_stack']=job.egress_release_cause
        if job.ingress_release_cause:
            filter['binary_value_of_release_cause_from_protocol_stack'] = job.ingress_release_cause
        size = 0
        count = 0
        progress = 0
        resp_stream = CdrReportList().run(file=None,format='csv',start_time=start, end_time=end, **filter)
        for data in resp_stream:
            s = data#.decode('utf-8')
            lines = s.split(b'\n')
            for buf in lines:
                # if len(buf) > job.max_lines:
                #     raise FTP.Error("got more than %d bytes" % job.max_lines)
                if not buf:
                    break
                if buf[-2:] != B_CRLF:
                    if buf[-1] in B_CRLF: buf = buf[:-1]
                    buf = buf + B_CRLF
                conn.sendall(buf)
            # shutdown ssl layer
            size += len(s)
            count += len(lines) - 1
            ws.notify(count)
            progress += 1
            #flog.progress = '{}'.format(progress)
            if progress == 100:
                progress = 0
            flog.status='in process'
            flog.detail = '{},{}'.format(count,size)
            flog.save()
        flog.detail = '{},{}'.format(count-2, size)
        flog.status = 'finished'
        ws.state('success')
        if _SSLSocket is not None and isinstance(conn, _SSLSocket):
            conn.unwrap()
        del conn
    except Exception as e:
        if conn:
            if _SSLSocket is not None and isinstance(conn, _SSLSocket):
                conn.unwrap()
            del conn
        flog.detail = str(e)[:512]
        flog.status = 'error'
        log.debug('ftp_upload job_id={} error {}'.format(job_id,str(e)))
    flog.save()