import celery
from celery.utils.log import mlevel
from falcon_rest.logger import log
from sqlalchemy.exc import IntegrityError
from falcon_rest.db.orm import generate_uuid_str

from api_dnl import settings
from datetime import datetime, timedelta
from pytz import UTC
import io, csv, gzip, zipfile
import xlwt
import json
import requests
from celery import Celery, group
from celery.app.log import get_logger
from celery.schedules import crontab
from sqlalchemy import (Column, event, distinct, desc, or_, not_, and_, text as text_, PrimaryKeyConstraint, inspect,
                        Index, UniqueConstraint)
from falcon_rest.db import initialize_db
from api_dnl.base_model import DnlApiBaseModel
from api_dnl.model import SystemParameter
from api_dnl.model import PrimaryKeyConstraint, func
from api_dnl.tasks import app, log, db, SqlAlchemyTask, SchLog
from api_dnl import model
from api_dnl.utils.statisticapi2 import StatisticAPI
from api_dnl.model import LergDownloadSchedule, LergImportTask, Lerg, LergDownloadTask, C4UsLerg
from api_dnl.tasks import app, SqlAlchemyTask


@app.task(base=SqlAlchemyTask, time_limit=288000, soft_time_limit=287400)
def do_lerg_download_task(id):
    try:
        log.info('start do_lerg_download_task')
        tsk = LergDownloadTask.get(id)
        if tsk:
            if tsk.status == 'initial':
                try:
                    tsk.status = 'busy'
                    tsk.created_on = datetime.now(UTC)
                    ret = requests.get(tsk.url)
                    if ret.status_code == 200:
                        obj = LergImportTask()
                        obj.uuid = generate_uuid_str()()
                        obj.file = obj.uuid + '.csv'
                        fsz = len(ret.content)
                        log.info('Uploaded file size:{}'.format(fsz))
                        if fsz == tsk.schedule.last_downloaded_count:
                            tsk.status = 'success'
                            tsk.finished_on = datetime.now(UTC)
                            tsk.result = 'file not changed'
                            tsk.save()
                            log.info('exit do_lerg_download_task')
                        else:
                            obj.save()
                            local_file = open(obj.file_name, 'wb')
                            local_file.write(ret.content)
                            local_file.close()
                            tsk.lerg_import_task_uuid = obj.uuid
                            tsk.status = 'success'
                            tsk.finished_on = datetime.now(UTC)
                            tsk.result = 'downloaded ok'
                            tsk.schedule.last_downloaded_count = fsz
                            tsk.schedule.last_downloaded_on = tsk.finished_on
                            tsk.save()
                            countries = ['US', 'CA']
                            s = tsk.url.split('=')
                            if len(s) > 1:
                                countries = s[1].split(',')
                            do_c4uslerg_import_file(obj.uuid, countries)
                    else:
                        raise Exception(
                            'error status: {}  content: {}'.format(ret.status_code, ret.content))
                except Exception as e:
                    log.error('error on do_lerg_download_task {}'.format(e))
                    tsk.finished_on = datetime.now(UTC)
                    tsk.status = 'fail'
                    tsk.result = str(e)
                    tsk.save()
        log.info('finish do_lerg_download_task')
    except Exception as e:
        log.debug('do_lerg_download_task error {}'.format(e))


@app.task(base=SqlAlchemyTask, time_limit=288000, soft_time_limit=287400)
def do_lerg_download_schedules():
    try:
        log.info('start do_lerg_download_schedule')
        start = datetime.now(UTC)
        for sch in LergDownloadSchedule.filter(LergDownloadSchedule.schedule_hour == start.hour).all():
            running = LergDownloadTask.filter(
                and_(LergDownloadTask.schedule_id == sch.id, LergDownloadTask.status.in_(['initial', 'busy']))).first()
            if running is None:
                tsk_id = LergDownloadTask(created_on=start, url=sch.url, status='initial', schedule_id=sch.id).save()
                do_lerg_download_task.delay(tsk_id)
            else:
                log.info('do_lerg_import_schedules skip already running {}'.format(sch.id))
                if (start - running.created_on) > timedelta(hours=22):
                    running.delete()
            log.info('finish do_lerg_import_schedules')
    except Exception as e:
        log.debug('do_lerg_download_schedule error {}'.format(str(e)))


@app.task(base=SqlAlchemyTask, time_limit=288000, soft_time_limit=287400)
def do_lerg_import_file(id):
    log.info('start lerg_import_file {}'.format(id))
    tsk = LergImportTask.get(id)
    from falcon_rest import logger
    logger.log.setLevel(mlevel('ERROR'))
    log.setLevel(mlevel('ERROR'))
    if tsk and tsk.status == 'initial':
        tsk.status = 'busy'
        errors = []
        try:
            Lerg.query().delete()
            file = open(tsk.file_name)
            data = csv.reader(file)
            fields = ["npa", "nxx", "thousands", "state", "company", "ocn", "ratecenter", "clli", "assign_date",
                      "prefix_type", "switch_name", "switch_type", "lata", "country"]
            i = 0
            sk_i = 0
            for row in data:
                npa = row[0].strip().lower()
                row_errors = ''
                if 'npa' in npa:
                    continue
                i = i + 1

                if i % 500 == 0:
                    print('numbers imported {}'.format(i))
                    tsk.result = 'numbers imported {}'.format(i)
                    tsk.save()
                try:
                    data = dict(zip(fields, row))
                    from sqlalchemy.inspection import inspect
                    ins = inspect(Lerg)
                    for k, v in data.items():
                        data[k] = data[k][:ins.columns[k].type.length]
                    lerg = Lerg(**data)

                    tsk.session().add(lerg)

                except IntegrityError as e:
                    errors.append('row {}:{}'.format(i - 1, str(e)))
                    log.warning('error on import {} {}'.format(data, str(e)))
            tsk.finished_on = datetime.now(UTC)
            tsk.status = 'success'
            if errors:
                tsk.result = 'rows imported {} of {}, numbers skiped {}\n' \
                             'IMPORT WARNINGS:\n{}'.format(i - sk_i, i, sk_i, '\n'.join(errors))
            else:
                tsk.result = 'numbers imported {} of {}, numbers skiped {}'.format(i - sk_i, i, sk_i)
            tsk.save()
        except Exception as e:
            tsk.finished_on = datetime.now(UTC)
            tsk.status = 'fail'
            tsk.result = 'Import failure: {}\n{}'.format(str(e)[0:500],
                                                         'IMPORT WARNINGS:\n'.join(errors))
            tsk.save()
            import traceback
            log.error('Import failure: {}'.format(str(traceback.format_exc())))
    else:
        log.info('skip already running import_file {}'.format(id))
    logger.log.setLevel(mlevel(settings.LOG_LEVEL))
    log.setLevel(mlevel(settings.LOG_LEVEL))
    log.info('finish lerg_import_file {}'.format(id))


@app.task(base=SqlAlchemyTask, time_limit=288000, soft_time_limit=287400)
def do_c4uslerg_import_file(id, countries):
    log.info('start lerg_import_file {}'.format(id))
    tsk = LergImportTask.get(id)
    from falcon_rest import logger
    logger.log.setLevel(mlevel('ERROR'))
    log.setLevel(mlevel('ERROR'))
    if tsk and tsk.status == 'initial':
        tsk.status = 'busy'
        errors = []
        try:
            C4UsLerg.filter(C4UsLerg.country.in_(countries)).delete(synchronize_session='fetch')
            file = open(tsk.file_name)
            data = csv.reader(file)
            fields = ['country', 'state', 'prefix', 'ocn', 'lata']
            i = 0
            sk_i = 0
            for row in data:
                x = row[0].strip().lower()
                row_errors = ''
                if 'country' in x:
                    continue
                i = i + 1

                if i % 500 == 0:
                    print('numbers imported {}'.format(i))
                    tsk.result = 'numbers imported {}'.format(i)
                    tsk.save()
                try:
                    data = dict(zip(fields, row))
                    data['npa'] = data['prefix'][0:3]
                    data['nxx'] = data['prefix'][3:6]
                    del data['prefix']
                    from sqlalchemy.inspection import inspect
                    ins = inspect(C4UsLerg)
                    for k, v in data.items():
                        data[k] = data[k][:ins.columns[k].type.length]
                    lerg = C4UsLerg(**data)

                    tsk.session().add(lerg)

                except IntegrityError as e:
                    errors.append('row {}:{}'.format(i - 1, str(e)))
                    log.warning('error on import {} {}'.format(data, str(e)))
            tsk.finished_on = datetime.now(UTC)
            tsk.status = 'success'
            if errors:
                tsk.result = 'rows imported {} of {}, numbers skiped {}\n' \
                             'IMPORT WARNINGS:\n{}'.format(i - sk_i, i, sk_i, '\n'.join(errors))
            else:
                tsk.result = 'numbers imported {} of {}, numbers skiped {}'.format(i - sk_i, i, sk_i)
            tsk.save()
        except Exception as e:
            tsk.finished_on = datetime.now(UTC)
            tsk.status = 'fail'
            tsk.result = 'Import failure: {}\n{}'.format(str(e)[0:500],
                                                         'IMPORT WARNINGS:\n'.join(errors))
            tsk.save()
            import traceback
            log.error('Import failure: {}'.format(str(traceback.format_exc())))
    else:
        log.info('skip already running import_file {}'.format(id))
    logger.log.setLevel(mlevel(settings.LOG_LEVEL))
    log.setLevel(mlevel(settings.LOG_LEVEL))
    log.info('finish lerg_import_file {}'.format(id))
