import time
from pytz import UTC
import requests
import json
from urllib.parse import urlencode,unquote, quote_plus
from falcon_rest.logger import log


from api_dnl.settings import WS_HOST
from websocket import create_connection,WebSocket


class WSBrokerAPI():
    def __init__(self):
        try:
            self.ws = create_connection('ws://{}'.format(WS_HOST))
        except:
            self.ws = None
        self.task = None
        self.id = None
    def __del__(self):
        if hasattr(self,'ws') and self.ws and self.ws.connected:
            self.ws.close()


    def call(self,req):
        try:
            if not self.ws:
                self.ws = create_connection('ws://{}'.format(WS_HOST))
            self.ws.send(json.dumps(req))
            result = self.ws.recv()
            return json.loads(result)
        except Exception as e:
            if hasattr(self, 'ws') and self.ws and self.ws.connected:
                self.ws.close()
            self.ws = None
            return {'success':False,'cause':str(e)}

    def set_task_id(self,task,id):
        self.task = task
        self.id = id
        return self.call(dict(notify=dict(task=task,id=id,value=0,state='start')))

    def notify(self,value,state='run'):
        return self.call(dict(notify=dict(task=self.task, id=self.id,value=value,state=state)))

    def state(self, state):
        return self.call(dict(notify=dict(task=self.task, id=self.id, value=100, state=state)))



def test_one(x):
    from time import sleep
    ws = WSBrokerAPI()
    ws.set_task_id('import_file', x)
    for y in range(0, 20):
        r = ws.notify(y)
        print(r)
        sleep(1)

def test_run():
    from time import sleep
    for x in range(0, 100):
        print(x, '-------------------------------')
        test_one(x)
        print(x, '-------------------------------')



