"""shaken_ani_group

Revision ID: 21695bb183dd
Revises: 40f0f01c19ab
Create Date: 2021-06-04 15:16:22.946624

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):



# revision identifiers, used by Alembic.
revision = '21695bb183dd'
down_revision = '40f0f01c19ab'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('shaken_ani_group',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.Text(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('shaken_ani_group_rel',
    sa.Column('group_id', sa.Integer(), nullable=False),
    sa.Column('did', sa.String(length=16), nullable=False),
    sa.Column('created_on', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.ForeignKeyConstraint(['group_id'], ['shaken_ani_group.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('group_id', 'did')
    )
    op.add_column('resource', sa.Column('shaken_allow_resign', sa.Boolean(), server_default='false', nullable=False))
    op.add_column('resource', sa.Column('shaken_ani_group_id', sa.Integer(), nullable=True))
    op.add_column('resource', sa.Column('shaken_sign_policy', api_dnl.migration_types.ChoiceType(), server_default='0', nullable=False))
    op.add_column('resource', sa.Column('shaken_vfy_policy', api_dnl.migration_types.ChoiceType(), server_default='0', nullable=False))
    op.create_index(op.f('ix_resource_shaken_ani_group_id'), 'resource', ['shaken_ani_group_id'], unique=False)
    op.create_foreign_key(None, 'resource', 'shaken_ani_group', ['shaken_ani_group_id'], ['id'], ondelete='SET NULL')
    op.drop_column('resource', 'require_valid_idt')
    op.drop_column('resource', 'x_identity_pass_through')
    op.drop_column('resource', 'require_valid_idt_check')
    # ### end Alembic commands ###
    up_rec('shaken_ani_group_rel')
    up_rec('resource')
    connection = op.get_bind()
    sql="""
COMMENT ON COLUMN resource.shaken_sign_policy IS '
0 - Do not sign calls;
1 - Sign only US numbers;
2 - Sign any phone number;
3 - Sign only numbers from the SHAKEN ANI group.';

COMMENT ON COLUMN resource.shaken_vfy_policy IS '
0 - Do not check identity;
1 - Block if no identity;
2 - Block if identity is not valid or missing;
3 - Verify identity, but bypass if invalid.';

COMMENT ON COLUMN resource.shaken_allow_resign IS '
Allow signing a new Identity header if original one does not match outgoing source/destination';

COMMENT ON COLUMN resource.shaken_ani_group_id IS '
SHAKEN ANI group reference';
    """
    connection.execute(sql)


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('resource', sa.Column('require_valid_idt_check', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False))
    op.add_column('resource', sa.Column('x_identity_pass_through', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False))
    op.add_column('resource', sa.Column('require_valid_idt', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False))
    op.drop_constraint(None, 'resource', type_='foreignkey')
    op.drop_index(op.f('ix_resource_shaken_ani_group_id'), table_name='resource')
    op.drop_column('resource', 'shaken_vfy_policy')
    op.drop_column('resource', 'shaken_sign_policy')
    op.drop_column('resource', 'shaken_ani_group_id')
    op.drop_column('resource', 'shaken_allow_resign')
    op.drop_table('shaken_ani_group_rel')
    op.drop_table('shaken_ani_group')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))