"""did_vendor_api

Revision ID: 620a4f3af8b0
Revises: c12ce2096b02
Create Date: 2019-05-06 16:27:34.799708

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl

from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '620a4f3af8b0'
down_revision = 'c12ce2096b02'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('did_vendor_api',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('type', sa.SmallInteger(), server_default='1', nullable=True),
    sa.Column('username', sa.String(length=64), nullable=True),
    sa.Column('password', sa.String(length=64), nullable=True),
    sa.Column('sms_enabled', sa.Boolean(), nullable=True),
    sa.Column('rate_per_sms_sent', sa.Numeric(precision=15, scale=6), nullable=True),
    sa.Column('rate_per_sms_received', sa.Numeric(precision=15, scale=6), nullable=True),
    sa.Column('default_received_sms_url', sa.Text(), nullable=True),
    sa.Column('mrc', sa.String(length=10), nullable=True),
    sa.Column('nrc', sa.String(length=10), nullable=True),
    sa.ForeignKeyConstraint(['id'], ['client.client_id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.drop_table('did')
    op.drop_table('did_vendor')
    op.drop_index('qos_resource_report_time_res_id_idx', table_name='qos_resource')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_index('qos_resource_report_time_res_id_idx', 'qos_resource', ['report_time', 'res_id'], unique=False)
    op.create_table('did_vendor',
    sa.Column('id', sa.INTEGER(), server_default=sa.text("nextval('did_vendor_id_seq'::regclass)"), nullable=False),
    sa.Column('type', sa.SMALLINT(), server_default=sa.text("'1'::smallint"), autoincrement=False, nullable=True),
    sa.Column('username', sa.VARCHAR(length=64), autoincrement=False, nullable=True),
    sa.Column('password', sa.VARCHAR(length=64), autoincrement=False, nullable=True),
    sa.Column('sms_enabled', sa.BOOLEAN(), autoincrement=False, nullable=True),
    sa.Column('rate_per_sms_sent', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('rate_per_sms_received', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('default_received_sms_url', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('mrc', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.Column('nrc', sa.VARCHAR(length=10), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='did_vendor_pkey'),
    postgresql_ignore_search_path=False
    )
    op.create_table('did',
    sa.Column('did', sa.VARCHAR(length=16), autoincrement=False, nullable=False),
    sa.Column('type', sa.SMALLINT(), server_default=sa.text("'1'::smallint"), autoincrement=False, nullable=True),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('vendor_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('created_on', postgresql.TIMESTAMP(timezone=True), server_default=sa.text('now()'), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['client_id'], ['client.client_id'], name='did_client_id_fkey', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['vendor_id'], ['did_vendor.id'], name='did_vendor_id_fkey', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('did', name='did_pkey')
    )
    op.drop_table('did_vendor_api')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger class4_trig_record_{table} on {table};
drop table {table}_record;
DROP FUNCTION class4_trigfun_record_{table}();
DROP SEQUENCE {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))