"""resource_ext

Revision ID: 6d436ffc38bb
Revises: 01aebd78c44e
Create Date: 2020-03-05 16:00:32.284784

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):



# revision identifiers, used by Alembic.
revision = '6d436ffc38bb'
down_revision = '01aebd78c44e'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('invoice_summary_ext',
    sa.Column('invoice_number', sa.Integer(), nullable=False),
    sa.Column('scc_calls', api_dnl.migration_types.Numeric(length=32, collation=6), server_default=sa.text('0.00'), nullable=False),
    sa.PrimaryKeyConstraint('invoice_number')
    )
    op.create_table('resource_ext',
    sa.Column('resource_id', sa.Integer(), nullable=False),
    sa.Column('vendor_tech_prefix', api_dnl.migration_types.PrefixRange(), nullable=True),
    sa.PrimaryKeyConstraint('resource_id')
    )
    op.drop_column('invoice_summary', 'scc_calls')
    op.drop_column('resource', 'vendor_tech_prefix')
    # ### end Alembic commands ###
    up_rec('resource')


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('resource', sa.Column('vendor_tech_prefix', sa.NullType(), autoincrement=False, nullable=True))
    op.add_column('invoice_summary', sa.Column('scc_calls', sa.NUMERIC(), server_default=sa.text('0.00'), autoincrement=False, nullable=False))
    op.drop_table('resource_ext')
    op.drop_table('invoice_summary_ext')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))