"""did_billing_rel ip

Revision ID: f2e979ef68c7
Revises: f77d03d598c2
Create Date: 2020-05-05 14:39:02.778531

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):



# revision identifiers, used by Alembic.
revision = 'f2e979ef68c7'
down_revision = 'f77d03d598c2'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('did_billing_rel', sa.Column('ip', sa.String(length=50), nullable=True))
    op.create_index(op.f('ix_did_billing_rel_assigned_client_id'), 'did_billing_rel', ['assigned_client_id'], unique=False)
    op.create_index(op.f('ix_did_billing_rel_did'), 'did_billing_rel', ['did'], unique=False)
    op.create_index(op.f('ix_did_billing_rel_egress_res_id'), 'did_billing_rel', ['egress_res_id'], unique=False)
    op.create_index(op.f('ix_did_billing_rel_end_date'), 'did_billing_rel', ['end_date'], unique=False)
    op.create_index(op.f('ix_did_billing_rel_ingress_res_id'), 'did_billing_rel', ['ingress_res_id'], unique=False)
    op.create_index(op.f('ix_did_billing_rel_ip'), 'did_billing_rel', ['ip'], unique=False)
    op.create_index(op.f('ix_did_billing_rel_start_date'), 'did_billing_rel', ['start_date'], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_did_billing_rel_start_date'), table_name='did_billing_rel')
    op.drop_index(op.f('ix_did_billing_rel_ip'), table_name='did_billing_rel')
    op.drop_index(op.f('ix_did_billing_rel_ingress_res_id'), table_name='did_billing_rel')
    op.drop_index(op.f('ix_did_billing_rel_end_date'), table_name='did_billing_rel')
    op.drop_index(op.f('ix_did_billing_rel_egress_res_id'), table_name='did_billing_rel')
    op.drop_index(op.f('ix_did_billing_rel_did'), table_name='did_billing_rel')
    op.drop_index(op.f('ix_did_billing_rel_assigned_client_id'), table_name='did_billing_rel')
    op.drop_column('did_billing_rel', 'ip')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))