from marshmallow.fields import Str, Int

from api_dnl import model
from api_dnl.fields import Choice
from api_dnl.scheme import *
from api_dnl.schemes.invoice import InvoiceGetScheme


class AgentPortalGetScheme(AgentGetScheme):
    pass


class AgentPortalClientGetScheme(BaseModelScheme):
    # user = Nested(UserGetScheme)
    # agent = Nested(AgentGetScheme)
    # client = Nested('CarrierGetMinScheme')
    status = Bool()
    actual_balance = Decimal()
    credit_limit = Decimal()
    client_id = Int()
    client_name = Str()
    company = Str()
    created_on = DateTime()
    assigned_on = DateTime()
    commission = Decimal()
    method_type = Choice()
    mode = Choice()
    client = Nested('CarrierGetMinWithIngressScheme')
    company_type = Choice()
    unlimited_credit = Bool()

    class Meta:
        model = model.AgentClient
        fields = ('commission', 'method_type', 'client_id', 'client_name', 'assigned_on', 'assigned_by', 'status',
                  'registered_on', 'client', 'actual_balance', 'company_type', 'unlimited_credit')
        search_fields = ('agent_id', 'client_id', 'client_name', 'assigned_by', 'status', 'company', 'mode', 'company_type',
                         'unlimited_credit')
        query_fields = ('assigned_on_gt', 'assigned_on_lt', 'created_on_gt', 'created_on_lt',
                        'actual_balance_gt', 'actual_balance_gt', 'credit_limit_gt')


class AgentPortalVendorGetScheme(BaseModelScheme):
    # user = Nested(UserGetScheme)
    # agent = Nested(AgentGetScheme)
    # client = Nested('CarrierGetMinScheme')
    status = Bool()
    actual_balance = Decimal()
    credit_limit = Decimal()
    client_id = Int()
    client_name = Str()
    company = Str()
    created_on = DateTime()
    assigned_on = DateTime()
    commission = Decimal()
    method_type = Choice()
    mode = Choice()
    client = Nested('CarrierGetMinWithEgressScheme')

    class Meta:
        model = model.AgentClient
        fields = ('commission', 'method_type', 'client_id', 'client_name', 'assigned_on', 'assigned_by', 'status',
                  'registered_on', 'client', 'actual_balance')
        search_fields = ('agent_id', 'client_id', 'client_name', 'assigned_by', 'status', 'company', 'mode')
        query_fields = ('assigned_on_gt', 'assigned_on_lt', 'created_on_gt', 'created_on_lt',
                        'actual_balance_gt', 'actual_balance_gt', 'credit_limit_gt')


class AgentPortalClientPaymentGetScheme(ClientPaymentScheme):
    client_name = Str()
    client_id = Int()
    payment_type_name = Choice()

    class Meta:
        model = model.ClientPayment
        fields = ('client_payment_id', 'client_id', 'client_name', 'amount',
                  'note', 'paid_on', 'update_by', 'payment_time', 'payment_type_name', 'invoice_number')
        search_fields = ('client_id', 'client_name', 'invoice_number', 'payment_type_name')
        query_fields = ('paid_on_gt', 'paid_on_lt', 'amount_gt', 'amount_lt',)


class AgentPortalClientGatewayPaymentGetScheme(PaymentGatewayHistoryGetScheme):
    charge_amount = Decimal()
    fee = Decimal()

    class Meta:
        model = model.PaymentGatewayHistory
        fields = ('transaction_id', 'client_id', 'client_name', 'amount',
                  'fee', 'paid_on', 'charge_amount', 'method')
        search_fields = ('transaction_id', 'client_id', 'client_name', 'method')
        query_fields = ('paid_on_gt', 'paid_on_lt', 'amount_gt', 'amount_lt',
                        'charge_amount_gt', 'charge_amount_lt', 'fee_gt', 'fee_lt',)


class AgentPortalClientGatewayAndPaymentsGetScheme(BaseModelScheme):
    transaction_id = Str()
    client_id = Int()
    client_name = Str()
    amount = Decimal()
    paid_on = DateTime()
    method = Str()
    charge_amount = Decimal()
    fee = Decimal()
    note = Str()

    class Meta:
        model = model.PaymentAndGateway
        fields = ('transaction_id', 'client_id', 'client_name', 'amount',
                  'fee', 'paid_on', 'charge_amount', 'method', 'note')
        search_fields = ('transaction_id', 'client_id', 'client_name', 'method', 'note')
        query_fields = ('paid_on_gt', 'paid_on_lt', 'amount_gt', 'amount_lt',
                        'charge_amount_gt', 'charge_amount_lt', 'fee_gt', 'fee_lt',)


class AgentPortalProductsGetScheme(AgentProductsGetScheme):
    pass


class AgentPortalRateGetScheme(RateGetScheme):
    rate_table_name = Str()

    class Meta:
        model = model.Rate
        # search_fields=('rate_table_name', 'code_deck_id', 'currency_id', 'rate', 'billing_type')
        fields = ('rate_id', 'rate_table_id', 'effective_date', 'inter_rate', 'rate', 'code_name', 'country',
                  'setup_fee', 'interval', 'intra_rate', 'end_date', 'code', 'min_time', 'time_profile_id', 'gmt',
                  'local_rate',
                  'is_effective_now', 'change_status', 'rate_table_name')
        search_fields = ('rate_table_id', 'code', 'code_name', 'country', 'time_profile_id', 'gmt', 'is_effective_now',
                         'change_status', 'rate_table_name', 'effective_date')
        query_fields = ('rate_id_in', 'effective_date_gt', 'effective_date_ld', 'inter_rate_gt', 'inter_rate_lt',
                        'intra_rate_gt', 'intra_rate_lt', 'rate_gt', 'rate_lt', 'rate_table_id')


class AgentPortalClientScheme(CarrierLongScheme):
    pass


class AgentPortalClientModifyScheme(CarrierLongModifyScheme):
    pass


class AgentPortalClientsActualBalanceScheme(ActualBalanceHistoryGetScheme):
    class Meta:
        model = model.BalanceHistoryActual
        fields = ('client_id', 'date', 'payment_sent', 'payment_received', 'short_charges',
                  # 'invoice_received','invoice_sent',
                  'credit_received', 'credit_sent', 'incoming_traffic', 'outgoing_traffic',
                  'actual_balance', 'client_name')
        search_fields = ('date', 'client_id', 'client_name')
        query_fields = ('date_gte', 'date_lte',)


class AgentPortalInvoiceGetScheme(InvoiceGetScheme):
    pass


class AgentPortalPaymentGatewayHistoryScheme(PaymentGatewayHistoryScheme):
    pass
