import celery
from api_dnl import settings
from datetime import datetime, timedelta
from pytz import UTC
from time import mktime, sleep
import io, csv, gzip, zipfile
import xlwt
import json
import traceback
from celery import Celery

from celery.app.log import get_logger, mlevel
from celery.schedules import crontab
from falcon_rest.db import initialize_db
from sqlalchemy import (
    Integer, SmallInteger, Float, Text, String, DateTime, Date, Time, Boolean, ForeignKey, BigInteger,
    Table
)
from sqlalchemy import (Column, desc, and_, text as text_, PrimaryKeyConstraint, inspect, Index, UniqueConstraint)
from sqlalchemy.sql import func, select, alias, case

import csv

from ..view import IntegrityError
from ..model import RateGenerationHistory, RateGenerationHistoryDetail, RateTable, Rate, RateSendLog, RateImportTask
from ..tasks import app, log, db, SqlAlchemyTask, custom_logger
from .. import model
from .. import view

vlog = custom_logger('apply_rates')


@app.task(base=SqlAlchemyTask, time_limit=288000, soft_time_limit=287400)
def apply_rates_task(tsk_id, min_time=None, interval=None):
    start_time = datetime.now(UTC)
    finish_time = None
    vlog.info('start {} apply_rates {}'.format(start_time, tsk_id))

    hist = RateGenerationHistory.get(tsk_id)
    tsk = RateGenerationHistoryDetail.get(tsk_id)
    obj = tsk.rate_generation_history

    name, action, effective_date, code_deck_id = tsk.rate_table_name, tsk.action, tsk.effective_date_new, tsk.code_deck_id
    end_date, email_template_id, create_by = tsk.end_date, tsk.email_template_id, tsk.create_by

    try:
        cls = model.RateGenerationRate
        qrates = cls.filter(cls.rate_generation_history_id == obj.id)
        if not qrates.first():
            vlog.error('apply_rates_task Generated rates is empty:{}'.format(id))
            return 'apply_rates_task Generated rates is empty:{}'.format(id)
        rt = RateTable.filter(model.RateTable.name == name).first()
        if not rt:
            rt = RateTable(name=name)
        try:
            rt.jur_type = tsk.rate_generation_history.rate_generation_template.rate_table_type
            rt.save()
        except:
            rt.jur_type = 'US Jurisdictional'
            rt.save()
        tsk.rate_table_id = rt.rate_table_id
        tsk.save()
        if action == 'delete old rates':
            Rate.filter(model.Rate.rate_table_id == rt.rate_table_id).delete(synchronize_session='fetch')

        if action == 'end date all records':
            Rate.filter(and_(model.Rate.rate_table_id == rt.rate_table_id, model.Rate.end_date.is_(None))). \
                update({'end_date': end_date}, synchronize_session='fetch')
        counter = 0
        window_size = 256  # or whatever limit you like
        window_idx = 0
        fpath = settings.FILES['upload_to']
        if fpath[-1] != '/':
            fpath = fpath + '/'
        fname = 'apply_rate_gen_{}_{}.csv'.format(obj.id, tsk.id)
        full_name = fpath + fname
        file = open(full_name, 'wt+')
        fields = tsk.rate_generation_history.rate_generation_template.csv_head()
        if min_time:
            fields.append('min_time')
        if interval:
            fields.append('interval')
        writer = csv.DictWriter(file, fieldnames=fields)
        writer.writeheader()
        while True:
            start, stop = window_size * window_idx, window_size * (window_idx + 1)
            things = qrates.slice(start, stop).all()
            if things is None:
                break
            for rate in things:
                _row = rate.copy_to_dict(end_date, effective_date)
                row = {}
                for k in fields:
                    row[k] = _row[k]
                if min_time:
                    row['min_time'] = min_time
                if interval:
                    row['interval'] = interval
                if not end_date and 'end_date' in row:
                    del row['end_date']
                if tsk.rate_generation_history.rate_generation_template.calculate_ij_based_on == 'IJ - Intra':
                    row['rate'] = row['intra_rate'] if 'intra_rate' in row else 0.0
                if tsk.rate_generation_history.rate_generation_template.calculate_ij_based_on == 'IJ - Inter':
                    row['rate'] = row['inter_rate'] if 'inter_rate' in row else 0.0
                if tsk.rate_generation_history.rate_generation_template.calculate_ij_based_on == 'IJ - Max(Inter,Intra)':
                    row['rate'] = max(row['inter_rate'] if 'inter_rate' in row else 0.0,
                                      row['intra_rate'] if 'intra_rate' in row else 0.0)
                writer.writerow(row)
                counter += 1
            finish_time = datetime.now(UTC)
            progress = 'applying {} started {} current {} progress {}'.format(tsk_id, start_time, finish_time, counter)
            vlog.debug(progress)
            tsk.progress = progress
            tsk.save()
            if len(things) < window_size:
                vlog.debug('len(things) < window_size')
                break
            window_idx += 1
        file.close()
        # rate_upload step
        # 0: 'reject entire import', 1: 'skip the record', 2: 'overwrite existing record'
        # 1: 'delete old rates', 2: 'end date all records', 3: 'end date existing records', 4: 'none'
        act = 'skip the record'
        act_file = 'skip the record'
        end_date_all_records_time = None
        end_date_other_code_time = None
        if action == 'delete old rates':
            act = 2 # 'overwrite existing record'
            act_file = 2 # 'overwrite existing record'
        elif action == 'end date all records':
            act = 2 # 'overwrite existing record'
            act_file = 2 # 'overwrite existing record'
            end_date_all_records_time = effective_date
            end_date_other_code_time = effective_date
        elif action == 'end date existing records':
            end_date_all_records_time = effective_date
            act = 2 # 'overwrite existing record'
            act_file = 2 # 'overwrite previous record'
        code_deck_id = code_deck_id or tsk.rate_generation_history.rate_generation_template.code_deck_id
        rate_import = RateImportTask(import_file_path=fpath, orig_rate_file=fname, format_rate_file=fname,
                                     rate_table_id=rt.rate_table_id, import_rate_date_format='yyyy-mm-dd',
                                     redup_in_rate_table_action=act,
                                     redup_in_file_action=act_file,
                                     end_date_all_records_time=end_date_all_records_time,
                                     end_date_other_code_time=end_date_other_code_time,
                                     code_deck_id=code_deck_id,
                                     create_time = datetime.now(UTC),
                                     code_name_provider='get code name from code deck table' if code_deck_id else 'get code name from import rate file',
                                     operator_user=tsk.create_by)
        rate_import_task_id = rate_import.save()
        tsk.rate_import_task_id = rate_import_task_id
        progress = 'started {} progress {}' \
                   ' rate_import_task {} started'.format(start_time, counter, rate_import_task_id)
        vlog.debug(progress)
        tsk.progress = progress
        tsk.save()
        loop_counter = 0
        while rate_import.status not in ('Upload successful', 'Upload failed'):
            loop_counter = loop_counter + 1
            if loop_counter > 1024:
                break
            sleep(1)
            RateImportTask.session().expire(rate_import)
            RateImportTask.session().refresh(rate_import)
            rate_import = RateImportTask.get(rate_import_task_id)
        if rate_import.status != 'Upload failed':
            progress = 'apply {} running {} current {} progress {} ' \
                       'rate_import_task {} success'.format(tsk_id, start_time, finish_time, counter,
                                                            rate_import_task_id)
        else:

            progress = 'started {} progress {}' \
                       ' rate_import_task {} failed: {}'.format(start_time, counter, rate_import_task_id,
                                                                rate_import.progress)
            raise Exception(progress)
        vlog.debug(progress)
        tsk.progress = progress
        tsk.save()

        finish_time = datetime.now(UTC)
        tsk.finished_time = finish_time
        progress = 'apply success {} started {} finished {} ' \
                   'progress {}'.format(tsk_id, start_time, finish_time, counter)
        vlog.debug(progress)
        tsk.progress = progress
        tsk.save()
        obj.finished_time = tsk.finished_time
        obj.save()
        if email_template_id:
            tsk.progress = 'apply success {} started {} finished {} ' \
                           'progress {} send email scheduled'.format(tsk_id, start_time, finish_time, counter)
            vlog.debug(tsk.progress)
            send = RateSendLog(is_email_alert=True, email_template_id=email_template_id, status='waiting',
                               rate_table_id=tsk.rate_table_id, send_type='Send to carriers using this rate table',
                               # effective_date=effective_date,
                               format='xls', sent_area='rate')
            sid = send.save()
            loop_counter = 0
            while send.status in ('waiting', 'generated'):
                loop_counter = loop_counter + 1
                if loop_counter > 1024:
                    break
                sleep(1)
                send = RateSendLog.get(sid)
                db.session.expire(send)
                db.session.refresh(send)
            if send.status == 'sent failed':
                tsk.is_send_mail = False
                tsk.finished_time = datetime.now(UTC)
                tsk.progress = 'apply success {} started {} finished {} ' \
                               'progress {} send email failed'.format(tsk_id, start_time, finish_time, counter)
                vlog.debug(tsk.progress)
            else:
                tsk.is_send_mail = True
                tsk.finished_time = datetime.now(UTC)
                tsk.progress = 'apply success {} started {} finished {} ' \
                               'progress {} email sent success'.format(tsk_id, start_time, finish_time, counter)
                vlog.debug(tsk.progress)
        tsk.save()
        obj.progress = tsk.progress
        if hist:
            hist.is_applied = True
            hist.save()
        obj.save()
        vlog.debug(tsk.progress)
    except Exception as e:
        from traceback import format_exc
        msg = 'apply_rates_task error {}'.format(str(e))
        obj.progress = msg[:200]
        tsk.progress = msg[:200]
        tsk.finished_time = datetime.now(UTC)
        obj.save()
        tsk.save()
        vlog.error(msg + str(format_exc()))
        return msg
    vlog.info('finish apply_rates {}'.format(tsk_id))
