from api_dnl import settings
settings.LOG_FILE=settings.LOG_FILE+'.pjsip_testcall'
from falcon_rest.logger import log
import sys
import pjsua as pj
from datetime import datetime
import os,glob,shutil
from subprocess import Popen, PIPE
import json
from pydub import AudioSegment
import sys
import time
import traceback
import threading
from celery import uuid
from pdb import *
from celery.app.log import get_logger,mlevel
from api_dnl.tasks import app,log,db,SqlAlchemyTask,SchLog
from api_dnl import model
from api_dnl.model import CallingQueue,CallingCall,CallingRequest
from api_dnl import settings
from api_dnl.settings import DB_CONN_STRING, CREATE_TABLES,LOG_LEVEL

def get_uploaded_url(id, filename):
    return '{}{}{}/tool/call/{}/{}'.format(settings.API_SCHEME, settings.API_HOST,
                                          settings.API_BASE_PATH, id, filename)

FMT_MP3 = "mp3"
FMT_WAV = "wav"


def wav2mp3(src, dst):
    AudioSegment.from_wav(src).export(dst, format=FMT_MP3)

def mp3wav(src, dst):
    h = Popen(
            ["lame", '--decode', '--quiet', src, dst],
            shell=False)
    stdout, stderr = h.communicate()

    if stderr:
        raise UserWarning("Mp3 to Wav decoding: %s" % stderr)

def print_tb():
    exc_type, exc_value, exc_traceback = sys.exc_info()
    return traceback.format_exception(exc_type, exc_value, exc_traceback)


# Logging callback
def log_cb(level, str, len):
    print(str)
    log.info(str)


def mkdir(base_dir, dirname):
    path = os.path.join(base_dir, dirname)
    if not os.path.exists(path):
        os.mkdir(path)
    return path

def get_uploaded_path(id, filename=None):
    return  "%s/%s/%s" % (settings.FILES['call_uploads'], id, filename)

def find_file(path_pattern):
	return glob.glob(path_pattern)

def move_file(from_file, to_file):
	shutil.move(from_file, to_file)

def copy_file(from_file, to_file):
	shutil.copy(from_file, to_file)

def remove_file(path):
    try:
        os.remove(path)
    except: 
        pass


def get_pcap_stat(infile):
    """Version without DB interaction using Anne custom voipmon version"""
    log.debug("get_pcap_stat for %s" % infile)
    result = []
    proc = Popen(
            [settings.CALL_VOIPMON_EXE, '-r', infile],
            shell=False, stdout=PIPE, bufsize=1)

    for line in iter(proc.stdout.readline, b''):
        log.debug("line: %s" % line)
        if line.startswith(b'{'):
            result.append(json.loads(line.decode("utf-8")))
            #break
    proc.communicate()
    log.debug("get_pcap_stat result %s" % result)
    return str(result)


delta_to_ms = lambda x: int(x.total_seconds() * 1000)


class AudioPlayer(object):
    def __init__(self, pj_lib, path, loop=False):
        self.path = path
        self.lib = pj_lib
        self.loop = loop
        self.player_id = None
        self.started = False
        self.call_slot = None

    def play(self, call_slot):
        if not self.started:
            # print "Start playing"
            self.call_slot = call_slot
            self.player_id = self.lib.create_player(self.path, self.loop)
            self.player_slot = self.lib.player_get_slot(self.player_id)
            self.lib.conf_connect(self.player_slot, call_slot)
        self.started = True

    def stop(self):
        if self.started:
            # print "End playing"
            self.lib.conf_disconnect(self.call_slot, self.player_slot)
            self.lib.player_destroy(self.player_id)
        self.started = False


class CallRecorder(object):
    def __init__(self, pj_lib=None, path=None):
        self.full_path = path
        if path:
            self.path, self.ext = os.path.splitext(path)
            self.ext = self.ext.lstrip('.')
        else:
            self.path, self.ext = (None, None)
        self.start_time = None
        self.end_time = None
        self.pj_rec = None
        self.pj_rec_slot = None
        self.started = False
        self.pj_call_slot = None
        self.lib = pj_lib

    def start(self, call_slot=None):
        if not self.started:
            # print "Start recording"
            self.start_time = datetime.now()
            if self.path and self.lib:
                self.pj_rec = self.lib.create_recorder("%s.%s" % (self.path, FMT_WAV))
                # print "rec=%s" % self.pj_rec
                self.pj_rec_slot = self.lib.recorder_get_slot(self.pj_rec)
                # print "rec_slot=%s" % self.pj_rec_slot
                self.lib.conf_connect(call_slot, self.pj_rec_slot)
                self.pj_call_slot = call_slot
            self.started = True

    def stop(self):
        if self.started:
            # print "End recording"
            self.end_time = datetime.now()
            if self.lib:
                self.lib.conf_disconnect(self.pj_call_slot, self.pj_rec_slot)
                self.lib.recorder_destroy(self.pj_rec)
                self.save()
        self.pj_rec = None
        self.pj_rec_slot = None
        self.started = False

    def duration(self):
        if self.start_time is None or self.end_time is None:
            return None
        delta = self.end_time - self.start_time
        return delta_to_ms(delta)

    def save(self):
        if self.ext == FMT_WAV:
            pass
        elif self.ext == FMT_MP3:
            wav2mp3(self.full_path)
            remove_file("%s.%s" % (self.path, FMT_WAV))


def hangup_callback(cb):
    cb.lib.lib.thread_register('timeout_timer')
    cb.end_call()


# Callback to receive events from Call
class MyCallCallback(pj.CallCallback):
    def __init__(self, call=None, lib=None, rbt_recorder=None, call_recorder=None, player=None, db_call=None):
        pj.CallCallback.__init__(self, call)
        self.lib = lib
        self.rbt_rec = rbt_recorder or CallRecorder()
        self.call_rec = call_recorder or CallRecorder()
        self.player = player
        self.call_slot = None
        self.state = None
        self.pdd = None
        self.invite_time = None
        self.ring_start_time = None
        self.ring_end_time = None
        self.call_timeout_timer = None
        self.ring_timeout_timer = None
        self.db_call = db_call
        self.pcapfile = None
        self.req_uuid = None
        self.hangup = False
        if db_call:
            call = CallingCall.get(db_call)
            if call:
                self.req_uuid = call.req_uuid
                if call.caller_id:
                    self.lib.renew_caller_id(call.caller_id)
        log.debug("MyCallback initied")

    def set_call_timeout(self, sec):
        self.call_timeout_timer = threading.Timer(float(sec), hangup_callback, (self,))
        log.debug("call timeout set to %s sec" % sec)

    def set_ring_timeout(self, sec):
        self.ring_timeout_timer = threading.Timer(float(sec), hangup_callback, (self,))
        log.debug("ring timeout set to %s sec" % sec)

    def set_pdd(self):
        if not self.pdd:
            pdd = datetime.now() - self.invite_time
            self.pdd = delta_to_ms(pdd)

    def end_call(self):
        try:
            log.debug("end_call")
            if self.call is not None and self.call.info().state != pj.CallState.DISCONNECTED:
                self.hangup = True
                self.call.hangup()
                log.info('hangup by end_call')
        except:
            log.error(print_tb())
            # raise

    # Notification when call state has changed
    def on_state(self):
        try:
            info = self.call.info()
            log.info(
                "Call " + info.sip_call_id + " from " + info.uri + " to " + info.remote_uri + " is " + info.state_text + " " +
                "last code = " + str(info.last_code) +
                " (" + str(info.last_reason) + ")")

            # print "Start ", self.call.info().state_text
            state = info.state
            call = CallingCall.get(self.db_call)
            db_call_state = call.state
            self.call_slot = info.conf_slot
            pcapfiles = []

            if state == pj.CallState.CALLING:
                # initial INVITE is sent
                self.invite_time = datetime.now()
            elif state == pj.CallState.EARLY:
                db_call_state = 'RINGING'
                self.ring_start_time = datetime.now()
                # on Ringing
                self.set_pdd()
                # self.rbt_rec.start(call_slot)
                if self.ring_timeout_timer:
                    self.ring_timeout_timer.start()
            elif state == pj.CallState.CONNECTING:
                # 200/OK response has been sent or received
                self.set_pdd()
                self.ring_end_time = datetime.now()
            elif state == pj.CallState.CONFIRMED:
                # ACK has been sent or received
                db_call_state = 'CALLING'

                self.ring_end_time = datetime.now()
                if self.ring_timeout_timer:
                    self.ring_timeout_timer.cancel()

                self.rbt_rec.stop()
                self.call_rec.start(self.call_slot)
                self.player.play(self.call_slot)

                if self.call_timeout_timer:
                    self.call_timeout_timer.start()
            elif state == pj.CallState.DISCONNECTED:
                # on disconnect
                db_call_state = 'COMPLETE'
                self.ring_end_time = datetime.now()
                if self.ring_timeout_timer:
                    self.ring_timeout_timer.cancel()
                if self.call_timeout_timer:
                    self.call_timeout_timer.cancel()
                self.call_rec.stop()
                self.rbt_rec.stop()
                self.player.stop()
                if self.invite_time:
                    pcappath = "{}/{}*.pcap".format(settings.PCAP_PCAP_DIR, str(int(self.invite_time.timestamp()))[0:8])
                    log.debug('pcap path {}'.format(pcappath))
                    pcapfiles = find_file(pcappath)

            call.pdd = self.pdd
            call.ring_duration =  self.rbt_rec.duration()
            call.call_duration =  self.call_rec.duration()
            call.state = db_call_state
            call.call_uuid = info.sip_call_id

            call.start_time = self.invite_time
            call.finish_time = self.ring_end_time

            if info.uri.startswith("sip:"):
                call.caller_id = info.uri[4:]
            if not self.hangup:
                call.response_code = info.last_code
            if self.ring_start_time and self.ring_end_time:
                call.ring_duration = delta_to_ms(self.ring_end_time - self.ring_start_time)
            if (call.ring_duration or 0) > 0:
                call.rbt_audio_path = get_uploaded_url(self.db_call, os.path.basename(self.rbt_rec.full_path))
            if (call.call_duration or 0) > 0:
                call.call_audio_path = get_uploaded_url(self.db_call, os.path.basename(self.call_rec.full_path))
            if len(pcapfiles) > 0:
                copy_file(pcapfiles[0], get_uploaded_path(self.req_uuid, "%s.pcap" % call.call_id))
                call.sip_pcap_path = get_uploaded_url(self.db_call, "%s.pcap" % call.call_id)
                call.pcap_stat = get_pcap_stat(pcapfiles[0])
            call.calling_request.on_complete_call()
            try:
                call.save()
            except:
                raise
            finally:
                #DBPOOL.putconn(conn)
                pass

        except Exception as e:
            log.error(print_tb())
            try:
                call = CallingCall.get(self.db_call)
                call.result='Error: {}'.format(str(e))
                call.save()
            except:
                pass
            finally:
                #DBPOOL.putconn(conn)
                pass

    # Notification when call's media state has changed.
    def on_media_state(self):
        if self.call.info().media_state == pj.MediaState.ACTIVE:
            log.info("Active media")
            self.call_slot = self.call.info().conf_slot
            if self.call.info().last_code == 183:
                self.rbt_rec.start(self.call_slot)
        else:
            log.warning("Media state: %s" % self.call.info().media_state)


class PJLib(object):
    def __init__(self):
        self.lib = pj.Lib()
        self.transport = None
        self.acc_conf = None
        self.acc = None
        self.init()

    def print_codecs(self):
        for c in self.lib.enum_codecs():
            log.debug("%s %s" % (c.name, c.priority))

    def construct_callback(self, play_file, rbt_rec_file=None, call_rec_file=None, call=None):
        # Prepare player and recorders
        rbt_rec = CallRecorder(self.lib, rbt_rec_file)
        call_rec = CallRecorder(self.lib, call_rec_file)
        player = AudioPlayer(self.lib, play_file)
        log.debug("Player and Recorder ready rbt_rec {} call_rec {} play_file {}".format(rbt_rec,call_rec,play_file))

        # Prepare callback
        call_cb = MyCallCallback(lib=self, rbt_recorder=rbt_rec, call_recorder=call_rec, player=player, db_call=call)
        call_cb.set_ring_timeout(settings.CALL_RING_TIMEOUT)
        call_cb.set_call_timeout(settings.CALL_TIMEOUT)
        log.debug("Callback ready")

        return call_cb

    def renew_caller_id(self, caller_id):
        log.info("renew_caller_id to %s" % caller_id)

        if caller_id is None:
            inf = self.def_info
            self.acc_conf.id = "sip:%s:%s" % (inf.host, inf.port)
        else:
            if not '@' in  caller_id:
                caller_id = '{}@{}'.format(caller_id,self.def_info.host)
            self.acc_conf.id = "sip:%s" % caller_id

        log.debug("before acc_mod")
        self.lib.modify_account(self.acc._id, self.acc_conf)
        self.lib.modify_account(self.acc_local._id, self.acc_conf)
        log.debug("after acc_mod {}".format(self.acc_conf.id))

    def new_call(self, dst, callback):
        log.debug("before new_call")
        if self.def_info.host in dst:
            return self.acc_local.make_call(dst, callback)
        else:
            return self.acc.make_call(dst, callback)

    def init(self):
        # Init library with default config
        self.lib.init(log_cfg=pj.LogConfig(level=3, callback=log_cb))

        # Null sound device
        self.lib.set_null_snd_dev()

        # Create UDP transport which listens to any available port
        self.transport_def = self.lib.create_transport(pj.TransportType.UDP)
        self.def_info = self.transport_def.info()
        #self.transport = self.lib.create_transport(pj.TransportType.UDP,pj.TransportConfig(5080,'192.168.0.1'))
        self.transport_local = self.lib.create_transport(pj.TransportType.UDP,pj.TransportConfig(5080,'127.0.0.1'))
        self.transport = self.lib.create_transport(pj.TransportType.UDP,pj.TransportConfig(5061,self.def_info.port))
        # Start the library
        self.lib.start()

        # Set priority
        self.lib.set_codec_priority("PCMU/8000/1", 222)
        self.lib.set_codec_priority("PCMA/8000/1", 221)
        self.lib.set_codec_priority("G722/16000/1", 1)

        # Create local/user-less account
        self.acc_conf = pj.AccountConfig()
        #self.acc_conf = pj.AccountConfig('192.168.0.1','scott','tiger')

        self.acc  = self.lib.create_account_for_transport(self.transport)
        self.acc_local = self.lib.create_account_for_transport(self.transport_local)

        #self.acc = self.lib.create_account(self.acc_conf)
        info = self.transport.info()
        # print("%s:%s" % (info.host,info.port))

        # self.renew_caller_id("")
        # acc_conf = pj.AccountConfig(display="1000")
        # self.acc = self.lib.create_account(acc_conf);
        log.debug("Lib Initied")

    def finalize(self):
        log.info("destroy")
        if self.lib is not None:
            self.lib.hangup_all()
            self.lib.destroy()
            self.lib = None


def new_call(dst, play_file, rbt_rec_file=None, call_rec_file=None, call=None):
    pjlib = None
    try:
        pjlib = PJLib()
        call_pool = []

        for d in dst:
            call_cb = pjlib.construct_callback(play_file, rbt_rec_file, call_rec_file, call)
            call_pool.append(pjlib.new_call(d, call_cb))

        for call in call_pool:
            log.debug("Call %s" % call)
            while call and call.is_valid() and call.info().state != pj.CallState.DISCONNECTED:
                log.debug(call.info())
                time.sleep(1.0)

    except pj.Error as e:
        log.error("pj.Error Exception: " + str(e))
    except:
        log.error(print_tb())
    finally:
        if pjlib:
            pjlib.finalize()


class CallPool(object):
    def __init__(self, lib, max_size=None):
        self.pool = []
        self.max_size = max_size
        self.lib = lib

    def add(self, dst_number, callback):
        while True:
            if len(self.pool) == self.max_size:
                self.free()
            if len(self.pool) < self.max_size:
                self.pool.append(self.lib.new_call(dst_number, callback))
                break
            else:
                if len(self.pool)==0:
                    break;
                log.debug("sleeping...")
                time.sleep(1.0)

    def free(self):
        for c in self.pool:
            # print "%s in pool" % c
            if c and (not c.is_valid() or c.info().state == pj.CallState.DISCONNECTED):
                log.info("call %s removed from pool" % c)
                self.pool.remove(c)


class PJQueueListener(object):
    def __init__(self):
        self.conn = None#DBPOOL.getconn()
        self.queue = CallingQueue
        self.lib = PJLib()
        self.call_pool = CallPool(self.lib, settings.CALL_MAX_CALLS)


    def run(self):
        try:
            req_uuid, call_id = self.queue.get_next()
            if call_id:
                log.info("Start req_uuid=%s call_id=%s" % (req_uuid, call_id))
                mkdir(settings.FILES['call_uploads'], req_uuid)
                call = CallingCall.get(call_id)
                # call.init_attrs(self.conn)
                track_path = None
                if call.track:
                    track_path = call.track.file_name
                else:
                    log.error('no track file on call_id {}'.format(call_id))
                    return True
                log.debug("Call ready call_id {} call_track {}".format(call_id,track_path))
                # Dir structure
                # <req_uuid>
                # |- <call_id>_rbt.wav
                # |- <call_id>_call.wav
                # |- <call_id>.pcap
                try:
                    cb = self.lib.construct_callback(play_file=track_path,
                                                 rbt_rec_file=get_uploaded_path(req_uuid, "%s_rbt.wav" % call_id),
                                                 call_rec_file=get_uploaded_path(req_uuid, "%s_call.wav" % call_id),
                                                 call=call_id)
                except Exception as e:
                    call.result=str(e)
                    call.state='COMPLETE'
                    call.calling_request.on_complete_call()
                    call.save()
                    log.error('error on construct callback {}'.format(e))
                    return True
                try:
                    self.call_pool.add("sip:{}".format(call.dst_number), cb)
                except Exception as e:
                    call.result=str(e)
                    call.state='COMPLETE'
                    call.calling_request.on_complete_call()
                    call.save()
                    log.error('error on place call {}'.format(e))
                    return True
                log.debug("Call added to pool {}".format(call.dst_number))
                return True
                # self.conn.commit()
            else:
                return False

        except Exception as ex:
            log.error("Error in PJQueueListener: %s" % ex)
            try:
                db.session.rollback()
                # self.conn.rollback()
                # DBPOOL.putconn(self.conn)
            except:
                pass
            self.lib.finalize()
            #try to reinit
            log.debug('reinit PJQueueListener')
            self.__init__()
            return False
            #raise ex


    def start(self):
        while True:
            if self.run():
                continue
            else:
                db.session.remove()
                time.sleep(5.0)



def run():
    try:
        req_uuid, call_id = CallingQueue.get_next()
        if not req_uuid:
            log.debug("Queue is empty")
            return False
        log.info("Start req_uuid=%s call_id=%s" % (req_uuid, call_id))
        mkdir(settings.FILES['call_uploads'], req_uuid)
        call = CallingCall.get(call_id)
        track_path = None
        if call.track:
            track_path = call.track.file_name
        else:
            log.error('no track file on call_id {}'.format(call_id))
            return True
        log.debug("Call ready")
        new_call([call.dst_number], track_path, rbt_rec_file=get_uploaded_path(req_uuid, "%s_rbt.wav" % call_id),
                 call_rec_file=get_uploaded_path(req_uuid, "%s_call.wav" % call_id), call=call_id)
        log.debug("Call finished")

    except Exception as e:
        log.error("Error in run : %s" % e)

APP=None
@app.task(base=SqlAlchemyTask)
def do_pjsip_testcall_():
    log.debug('do_pjsip_testcall')
    global APP
    if not APP:
        APP = PJQueueListener()
    while APP.run():
        log.debug('do_pjsip_testcall make one call')
        pass
    APP.call_pool.free()

    log.debug('do_pjsip_testcall finished')

@app.task(base=SqlAlchemyTask)
def do_pjsip_testcall():
    log.debug('do_pjsip_testcall')
    run()
    log.debug('do_pjsip_testcall finished')

def main_func():
    #global log
    #log = get_logger('pjsip_testcall')
    #log.setLevel(mlevel(LOG_LEVEL))
    l = PJQueueListener()
    l.start()
    # Check command line argument
    # if len(sys.argv) < 2:
    #    print "Usage: simplecall.py <dst-URI>"
    #    sys.exit(1)
    # new_call([sys.argv[1], sys.argv[2]], play_file="/home/pavel/gsm-25s.wav", rbt_rec_file="/home/pavel/rbt.wav", call_rec_file="/home/pavel/call.wav")

if __name__ == "__main__":
    main_func()