"""client invoice setting

Revision ID: 0ba90be07aa2
Revises: 6d3415b53eb5
Create Date: 2020-03-09 16:10:47.017157

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):

from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '0ba90be07aa2'
down_revision = '6d3415b53eb5'
branch_labels = None
depends_on = None


def upgrade():
    connection = op.get_bind()
    connection.execute('delete from client_invoice_settings')
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('invoice_settings',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('invoice_setting_name', sa.String(length=200), nullable=True),
    sa.Column('invoice_name', sa.String(length=200), nullable=True),
    sa.Column('tpl_number', sa.Integer(), nullable=True),
    sa.Column('company_info_location', sa.SmallInteger(), nullable=True),
    sa.Column('pdf_tpl', sa.Text(), nullable=True),
    sa.Column('company_info', sa.String(length=500), nullable=True),
    sa.Column('overlap_invoice_protection', sa.Boolean(), nullable=True),
    sa.Column('send_cdr_fields', sa.Text(), nullable=True),
    sa.Column('invoice_send_mode', sa.SmallInteger(), nullable=True),
    sa.Column('invoice_decimal_digits', sa.Integer(), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_by', sa.String(length=255), nullable=True),
    sa.Column('logo_path', sa.String(length=256), nullable=True),
    sa.Column('mail_sender_id', sa.Integer(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.drop_index('ix_client_client_invoice_settings_id', table_name='client')
    op.drop_constraint('client_client_invoice_settings_id_fkey', 'client', type_='foreignkey')
    op.drop_column('client', 'client_invoice_settings_id')
    op.add_column('client_invoice_settings', sa.Column('client_id', sa.Integer(), nullable=False))
    op.add_column('client_invoice_settings', sa.Column('invoice_setting_id', sa.BigInteger(), nullable=True))
    op.create_foreign_key(None, 'client_invoice_settings', 'client', ['client_id'], ['client_id'])
    op.create_foreign_key(None, 'client_invoice_settings', 'invoice_settings', ['invoice_setting_id'], ['id'])
    op.drop_column('client_invoice_settings', 'billing_info_position')
    op.drop_column('client_invoice_settings', 'create_by')
    op.drop_column('client_invoice_settings', 'invoice_decimal_digits')
    op.drop_column('client_invoice_settings', 'create_on')
    op.drop_column('client_invoice_settings', 'invoice_send_mode_cdr')
    op.drop_column('client_invoice_settings', 'company_info_location')
    op.drop_column('client_invoice_settings', 'overlap_invoice_protection')
    op.drop_column('client_invoice_settings', 'invoice_send_mode')
    op.drop_column('client_invoice_settings', 'billing_info')
    op.drop_column('client_invoice_settings', 'update_on')
    op.drop_column('client_invoice_settings', 'send_cdr_fields')
    op.drop_column('client_invoice_settings', 'invoice_name')
    op.drop_column('client_invoice_settings', 'invoices_logo_id')
    op.drop_column('client_invoice_settings', 'company_info')
    op.drop_column('client_invoice_settings', 'tpl_number')
    op.drop_column('client_invoice_settings', 'pdf_tpl')
    op.drop_column('client_invoice_settings', 'invoice_number_format')
    # ### end Alembic commands ###
    up_rec('client')

def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('client_invoice_settings', sa.Column('invoice_number_format', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('client_invoice_settings', sa.Column('pdf_tpl', sa.TEXT(), autoincrement=False, nullable=True))
    op.add_column('client_invoice_settings', sa.Column('tpl_number', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('client_invoice_settings', sa.Column('company_info', sa.VARCHAR(length=500), autoincrement=False, nullable=True))
    op.add_column('client_invoice_settings', sa.Column('invoices_logo_id', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('client_invoice_settings', sa.Column('invoice_name', sa.VARCHAR(length=200), autoincrement=False, nullable=True))
    op.add_column('client_invoice_settings', sa.Column('send_cdr_fields', sa.TEXT(), autoincrement=False, nullable=True))
    op.add_column('client_invoice_settings', sa.Column('update_on', postgresql.TIMESTAMP(), autoincrement=False, nullable=True))
    op.add_column('client_invoice_settings', sa.Column('billing_info', sa.VARCHAR(length=500), autoincrement=False, nullable=True))
    op.add_column('client_invoice_settings', sa.Column('invoice_send_mode', sa.SMALLINT(), autoincrement=False, nullable=True))
    op.add_column('client_invoice_settings', sa.Column('overlap_invoice_protection', sa.BOOLEAN(), autoincrement=False, nullable=True))
    op.add_column('client_invoice_settings', sa.Column('company_info_location', sa.SMALLINT(), autoincrement=False, nullable=True))
    op.add_column('client_invoice_settings', sa.Column('invoice_send_mode_cdr', sa.SMALLINT(), autoincrement=False, nullable=True))
    op.add_column('client_invoice_settings', sa.Column('create_on', postgresql.TIMESTAMP(), autoincrement=False, nullable=True))
    op.add_column('client_invoice_settings', sa.Column('invoice_decimal_digits', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('client_invoice_settings', sa.Column('create_by', sa.VARCHAR(length=256), autoincrement=False, nullable=True))
    op.add_column('client_invoice_settings', sa.Column('billing_info_position', sa.SMALLINT(), autoincrement=False, nullable=True))
    op.drop_constraint(None, 'client_invoice_settings', type_='foreignkey')
    op.drop_constraint(None, 'client_invoice_settings', type_='foreignkey')
    op.drop_column('client_invoice_settings', 'invoice_setting_id')
    op.drop_column('client_invoice_settings', 'client_id')
    op.add_column('client', sa.Column('client_invoice_settings_id', sa.INTEGER(), autoincrement=False, nullable=True))
    op.create_foreign_key('client_client_invoice_settings_id_fkey', 'client', 'client_invoice_settings', ['client_invoice_settings_id'], ['id'], ondelete='SET NULL')
    op.create_index('ix_client_client_invoice_settings_id', 'client', ['client_invoice_settings_id'], unique=False)
    op.drop_table('invoice_settings')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))