"""did_export_async_task

Revision ID: 2fbd25802cc5
Revises: 63886fcdd1ed
Create Date: 2021-04-27 17:15:29.616179

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):



# revision identifiers, used by Alembic.
revision = '2fbd25802cc5'
down_revision = '63886fcdd1ed'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('did_export_async_task',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('request_client_id', sa.Integer(), nullable=True),
    sa.Column('user_id', sa.Integer(), nullable=True),
    sa.Column('did_client_id', sa.Integer(), nullable=True),
    sa.Column('did_vendor_id', sa.Integer(), nullable=True),
    sa.Column('did_prefix', sa.String(length=11), nullable=True),
    sa.Column('did_is_active', sa.Boolean(), nullable=True),
    sa.Column('did_is_assigned', sa.Boolean(), nullable=True),
    sa.Column('did_end_dated', sa.Boolean(), nullable=True),
    sa.Column('job_start_time', sa.Integer(), nullable=True),
    sa.Column('job_end_time', sa.Integer(), nullable=True),
    sa.Column('msg', sa.String(length=512), nullable=True),
    sa.Column('progress', sa.String(length=4), nullable=True),
    sa.Column('count', sa.Integer(), nullable=True),
    sa.Column('size', sa.Integer(), nullable=True),
    sa.Column('status', api_dnl.migration_types.ChoiceType(), nullable=True),
    sa.Column('action', api_dnl.migration_types.ChoiceType(), nullable=True),
    sa.Column('orig_file', sa.String(length=512), nullable=True),
    sa.ForeignKeyConstraint(['request_client_id'], ['client.client_id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['user_id'], ['users.user_id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('did_export_async_task')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))