"""ticket history

Revision ID: 5e1e4f99ad1a
Revises: d2027700f94d
Create Date: 2018-04-19 20:16:07.818671

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = '5e1e4f99ad1a'
down_revision = 'd2027700f94d'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('ticket_history',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('ticket_id', sa.Integer(), nullable=True),
    sa.Column('update_by', sa.String(length=100), nullable=True),
    sa.Column('update_on', sa.DateTime(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), nullable=True),
    sa.Column('ticket_status', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['ticket_id'], ['ticket.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.drop_constraint('rate_upload_task_rule_log_id_fkey', 'rate_upload_task', type_='foreignkey')
    op.create_foreign_key(None, 'rate_upload_task', 'rate_auto_import_rule_log', ['rule_log_id'], ['id'], ondelete='SET NULL')
    op.add_column('ticket', sa.Column('ticket_id', sa.Integer(), nullable=True))
    op.add_column('ticket', sa.Column('ticket_status', sa.Integer(), nullable=True))
    op.add_column('ticket', sa.Column('update_by', sa.String(length=100), nullable=True))
    op.add_column('ticket', sa.Column('update_on', sa.DateTime(timezone=True), server_default=sa.text("('now'::text)::timestamp(0) with time zone"), nullable=True))
    op.create_foreign_key(None, 'ticket', 'ticket', ['ticket_id'], ['id'], ondelete='CASCADE')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, 'ticket', type_='foreignkey')
    op.drop_column('ticket', 'update_on')
    op.drop_column('ticket', 'update_by')
    op.drop_column('ticket', 'ticket_status')
    op.drop_column('ticket', 'ticket_id')
    op.drop_constraint(None, 'rate_upload_task', type_='foreignkey')
    op.create_foreign_key('rate_upload_task_rule_log_id_fkey', 'rate_upload_task', 'rate_auto_import_rule_log', ['rule_log_id'], ['id'], ondelete='SET NULL')
    op.drop_table('ticket_history')
    # ### end Alembic commands ###
