from collections import OrderedDict

# import agent
# import api_dnl.client
from falcon_rest.contrib.objects_history.object_revision import object_revision
from falcon_rest.conf import settings

from api_dnl.settings import AUTH_END_POINT
from api_dnl.views import agent, client, testcall, cdr, cdr1, rt_proxy, paypal, smshook, report, cloud, log, invoice, \
    shaken, stat, sms_rate, fault_route_alert_rule, did_export
from api_dnl import view
from api_dnl import auth
from api_dnl import dbconfig

# settings.API_TEST_ROUTES = 'True'
TEST_ROUTES = OrderedDict([
    ('Test', {
        'description': 'This is a set of test functions',
        'routes': [
            dict(path=AUTH_END_POINT, method='post', resource=auth.Auth()),
            dict(path='/user/list', resource=view.UserList(), method='get'),
        ]
    }
     )
])

_Auth = [
    dict(path=AUTH_END_POINT, method='post', resource=auth.Auth()),
    # settings.get_auth_module().auth_endpoints.Auth() ),
    dict(path='/auth/as_client', method='post', resource=auth.AuthAsClient()),
    dict(path='/auth/as_agent', method='post', resource=auth.AuthAsAgent()),
    dict(path='/auth/check-password', method='post',
         resource=settings.get_auth_module().auth_endpoints.PasswordCheck()),
    dict(path='/auth/check-token', method='post', resource=auth.TokenCheck()),
    dict(path='/auth/is_admin', method='get', resource=auth.AdminTokenCheck()),
    dict(path='/auth/reset_email', method='post', resource=view.UserResetPasswordEmail()),
    dict(path='/auth/reset/{token}', method='post', resource=view.UserResetPassword()),
    dict(path='/auth/session/list', resource=view.WebSessionList(), method='get'),
    dict(path='/user/admin', method='post', resource=view.UserCreateAdmin()),
    dict(path='/user/create', resource=view.UserCreate(), method='post'),
    dict(path='/user', resource=view.UserInfoResource(), method='path'),
    dict(path='/user/{user_id}', resource=view.UserResource(), method='path'),
    dict(path='/user/all', resource=view.UserActivate(), method='path'),
    dict(path='/user/list', resource=view.UserList(), method='get'),
    dict(path='/registration/create', resource=view.SignupCreate(), method='post'),
    dict(path='/registration/confirm/{token}', resource=view.SignupConfirm(), method='get'),
    dict(path='/registration/{id}', resource=view.SignupResource(), method='path'),
    dict(path='/registration/list', resource=view.SignupList(), method='get'),
    dict(path='/registration/all', resource=view.SignupAllDelete(), method='get'),
    dict(path='/registration/{id}/approve', resource=view.SignupApproveResource(), method='path'),
    dict(path='/registration/get_referal_name/{referal_key}', resource=view.AgentReferalNameResource(), method='get'),
    dict(path='/ticket/issue_type', resource=view.TicketTypeCreate(), method='post'),
    dict(path='/ticket/issue_type/{ticket_type}', resource=view.TicketTypeResource(), method='post'),
    dict(path='/ticket/issue_type/list', resource=view.TicketTypeList(), method='post'),
    dict(path='/ticket/create', resource=view.TicketCreate(), method='post'),
    dict(path='/ticket/{id}', resource=view.TicketResource(), method='path'),
    dict(path='/ticket/{id}/attach', resource=view.TicketAttachmentCreate(), method='post'),
    dict(path='/ticket/{id}/send', resource=view.TicketSendResource(), method='path'),
    dict(path='/ticket/send_trouble_ticket', resource=view.SendTroubleTicketResource(), method='post'),
    dict(path='/ticket/list', resource=view.TicketList(), method='get'),
    dict(path='/ticket/file/{uuid}', resource=view.TicketAttachmentResource(), method='get'),
    dict(path='/ticket/{id}/comment/create', resource=view.TicketCommentCreate(), method='post'),
    dict(path='/ticket/comment/{id}', resource=view.TicketCommentResource(), method='post'),
    # dict(path='/ticket/comment/{id}/attach', resource=view.TicketAttachmentCreate(), method='post'),
    dict(path='/ticket/comment/{id}/send', resource=view.TicketCommentSendResource(), method='path'),
]
_Agent = [
    dict(path='/agent/create', resource=view.AgentCreate(), method='post'),

    dict(path='/agent/{agent_id}', resource=view.AgentResource(), method='path'),
    dict(path='/agent/all', resource=view.AgentActivate(), method='path'),
    dict(path='/agent/list', resource=view.AgentList(), method='get'),
    dict(path='/agent/{agent_id}/add_carrier', resource=view.AgentCarriersAdd(), method='post'),
    dict(path='/agent/{agent_id}/carrier', resource=view.AgentCarriersResource(), method='path'),
    dict(path='/agent/{agent_id}/{carrier_id}', resource=view.AgentClientResource(), method='path'),
    dict(path='/agent/{agent_id}/products/list', resource=view.AgentProductList(), method='get'),
    dict(path='/agent/{agent_id}/share', resource=view.AgentSendLinkAction(), method='post'),
    dict(path='/agent/commission', resource=view.AgentCommissionHistoryList(), method='get'),
    dict(path='/agent/clients', resource=view.AgentClientList(), method='get'),
    dict(path='/agent/not_assigned_clients', resource=view.AgentNotAssignedClientList(), method='get'),
    dict(path='/agent/{agent_id}/assign_products', resource=view.AgentAssignProducts(), method='path'),
    dict(path='/agent/commission_payment', method='post', resource=view.AgentCommissionPaymentCreate()),
    dict(path='/agent/commission_payment/{id}', method='path', resource=view.AgentCommissionPaymentResource()),
    dict(path='/agent/commission_payment/list', method='get', resource=view.AgentCommissionPaymentList()),
    dict(path='/agent/mail_template/{title}', resource=view.AgentMailTemplateResource(), method='path'),
    dict(path='/agent/mail_template', resource=view.AgentMailTemplateCreate(), method='get'),
]
_AgentPortal = [
    dict(path='/home/agent', resource=agent.AgentPortalResource(), method='get'),
    dict(path='/home/agent/clients', resource=agent.AgentPortalClientList(), method='get'),
    dict(path='/home/agent/vendors', resource=agent.AgentPortalVendorList(), method='get'),
    dict(path='/home/agent/client_payments', resource=agent.AgentPortalClientPaymentsList(), method='get'),
    dict(path='/home/agent/client_gateway_payments', resource=agent.AgentPortalClientGatewayPaymentsList(),
         method='get'),
    dict(path='/home/agent/client_and_gateway_payments', resource=agent.AgentPortalClientGatewayAndPaymentsList(),
         method='get'),
    dict(path='/home/agent/client_balances', resource=agent.AgentPortalClientsActualBalanceList(), method='get'),
    dict(path='/home/agent/products', resource=agent.AgentPortalProductList(), method='get'),
    dict(path='/home/agent/share', resource=agent.AgentPortalAgentSendLinkAction(), method='get'),
    dict(path='/home/agent/rate_table/{rate_table_id}/list', resource=agent.AgentPortalRateList(), method='get'),
    dict(path='/home/agent/all_rates/list', resource=agent.AgentPortalAllRateslList(), method='get'),
#     dict(path='/home/agent/download/{token}', resource=view.RateDownload(), method='get'),
    dict(path='/home/agent/client/create', resource=agent.AgentPortalClientCreate(), method='post'),
    dict(path='/home/agent/client/{client_id}', resource=agent.AgentPortalClientResource(), method='path'),
    dict(path='/home/agent/client/{client_id}/gateway_payment', resource=agent.AgentPortalPaymentGatewayHistoryCreate(),
         method='post'),
    dict(path='/home/agent/invoice/list', resource=agent.AgentPortalInvoiceList(), method='get'),
]
_ClientPortal = [
    # dict(path=AUTH_END_POINT, method='post', resource=auth.Auth()),
    dict(path='/home/client', resource=client.ClientPortalResource(), method='get'),
    dict(path='/home/api_key/create', resource=client.ApiKeyCreate(), method='post'),
    dict(path='/home/api_key', resource=client.ApiKeyDelete(), method='delete'),
    dict(path='/home/client/payments', resource=client.ClientPortalPaymentList(), method='get'),
    dict(path='/home/client/gateway_payments', resource=client.ClientPortalPaymentGatewayHistoryList(), method='get'),
    dict(path='/home/client/gateway_and_payments', resource=client.ClientPortalGatewayAndPaymentsList(), method='get'),
    dict(path='/home/client/product/create', resource=client.ClientPortalProductRoutRateTableCreate(), method='post'),
    dict(path='/home/client/product/{id}', resource=client.ClientPortalProductRoutRateTableResource(), method='path'),
    dict(path='/home/client/product/{id}/send', resource=client.ClientPortalProductSendToEmails(), method='path'),
#     dict(path='/home/client/client_did_product/{client_id}/send', resource=client.ClientPortalDidProductSendToEmails(), method='path'),
    dict(path='/home/client/products/available', resource=client.ClientPortalProductRoutRateTableList(), method='get'),
    dict(path='/home/client/products', resource=client.ClientPortalProductList(), method='get'),
    dict(path='/home/client/rate_table/list', resource=client.ClientPortalRateTableList(), method='get'),
    dict(path='/home/client/rate/list', resource=client.ClientPortalRateList(), method='get'),
    dict(path='/home/client/npa/list', resource=client.NpaList(), method='get'),
    dict(path='/home/client/lata/list', resource=client.LataList(), method='get'),
    dict(path='/home/client/state/list', resource=client.StateList(), method='get'),
    dict(path='/home/client/did/list', resource=client.ClientPortalDidBillingRelList(), method='get'),
    dict(path='/home/client/did/billing_rule/list', resource=client.ClientPortalDidBillingPlanList(), method='get'),
    dict(path='/home/client/did/{id}/disable', resource=client.ClientPortalDisableDidBillingRelResource(),
         method='path'),
    dict(path='/home/client/did/{id}/assign', resource=client.ClientPortalAssignDidBillingRelResource(), method='path'),
    dict(path='/home/client/did/free/list', resource=client.ClientPortalFreeDidBillingRelList(), method='get'),
    dict(path='/home/client/did/import', resource=client.DidImportCreate(), method='post'),
    dict(path='/home/client/did/import/log', resource=client.DidImportList(), method='post'),

    dict(path='/home/client/invoice/list', resource=client.ClientPortalInvoiceList(), method='get'),
    dict(path='/home/client/orig_invoice/list', resource=client.ClientPortalOrigInvoiceList(), method='get'),
    dict(path='/home/client/payment', resource=client.ClientPortalPaymentGatewayHistoryCreate(), method='get'),
    dict(path='/home/vendor/did/list', resource=client.ClientPortalOrigDidBillingRelList(), method='get'),
    dict(path='/home/client/alert/list', resource=client.ClientPortalAlertList(), method='get'),
    dict(path='/home/client/message/list', resource=client.ClientPortalMessageList(), method='get'),
    dict(path='/home/client/actual_finance_history', resource=client.ClientPortalActualBalanceHistoryList(),
         method='get'),
    dict(path='/home/client/default_ip/create', resource=client.ClientDefaultIpCreate(), method='post'),
    dict(path='/home/client/default_ip/{id}', resource=client.ClientDefaultIpResource(), method='path'),
    dict(path='/home/client/default_ip/list', resource=client.ClientDefaultIpList(), method='get'),
    dict(path='/home/client/ingress_trunk', resource=client.ClientPortalIngressTrunkCreate(), method='post'),
    dict(path='/home/client/ingress_trunk/{resource_id}', resource=client.ClientPortalIngressTrunkResource(),
         method='path'),
    dict(path='/home/client/ingress_trunk/list', resource=client.ClientPortalIngressTrunkList(), method='get'),
    dict(path='/home/client/egress_trunk', resource=client.ClientPortalEgressTrunkCreate(), method='post'),
    dict(path='/home/client/egress_trunk/{resource_id}', resource=client.ClientPortalEgressTrunkResource(),
         method='path'),
    dict(path='/home/client/egress_trunk/list', resource=client.ClientPortalEgressTrunkList(), method='get'),
    dict(path='/home/client/ip/list', resource=client.ClientPortalResourceIpList(), method='get'),
    dict(path='/home/client/trunk/ip/{resource_ip_id}', resource=client.ClientPortalResourceIpResource(), method='path'),
    dict(path='/home/client/unique_ip/list', resource=client.ClientPortalResourceIpUniqueList(), method='get'),
    dict(path='/home/client/trunk/{trunk_id}/assign_product/{product_id}',
         resource=client.ClientPortalTrunkAssignProduct(), method='path'),
    dict(path='/home/client/trunk/{trunk_id}/prefix', resource=client.ClientPortalResourcePrefixCreate(),
         method='post'),
    dict(path='/home/client/trunk/prefix/{id}', resource=client.ClientPortalResourcePrefixResource(), method='path'),
    dict(path='/home/client/trunk/{trunk_id}/prefix/list', resource=client.ClientPortalResourcePrefixList(),
         method='get'),
    dict(path='/did_api/search_local', resource=client.DidApiSearchLocal(), method='get'),
    dict(path='/did_api/coverage_local', resource=client.DidApiCoverageLocal(), method='get'),
    # dict(path='/did_api/search_order_local', resource=client.DidApiSearchOrderLocal(), method='post'),
    dict(path='/did_api/order_local', resource=client.DidApiOrderLocal(), method='post'),
    dict(path='/did_api/assigned', resource=client.DidApiAssigned(), method='get'),
    dict(path='/did_api/release', resource=client.DidApiDisconnect(), method='post'),
    dict(path='/did_api/admin_release', resource=view.DidApiAdminDisconnect(), method='post'),
    dict(path='/did_api/admin_release_all', resource=view.DidApiAdminDisconnectAll(), method='post'),
    dict(path='/did_api/admin_release/list', method='get', resource=view.DidDisconnectTaskList()),

    dict(path='/did_api/search_toll_free', resource=client.DidApiSearchTollFree(), method='get'),
    dict(path='/did_api/coverage_toll_free', resource=client.DidApiCoverageTollFree(), method='get'),
    # dict(path='/did_api/search_order_toll_free', resource=client.DidApiSearchOrderTollFree(), method='post'),
    dict(path='/did_api/order_toll_free', resource=client.DidApiOrderTollFree(), method='post'),
    # dict(path='/did_api/assigned_toll_free', resource=client.DidApiAssignedTollFree(), method='get'),

    # dict(path='/did_api/set_webhook', resource=client.DidApiSetWebhook(), method='post'),
#     dict(path='/did_api/webhook', method='post', resource=client.WebHookCreate()),
#     dict(path='/did_api/web_hook/{id}', method='path', resource=client.WebHookResource()),
#     dict(path='/did_api/web_hook/list', method='get', resource=client.WebHookList()),

    #dict(path='/sms', method='post', resource=client.SmsCreate()),
    #dict(path='/sms/{id}', method='path', resource=client.SmsResource()),
    #dict(path='/sms/list', method='get', resource=client.SmsList()),
]
_Carrier = [
    dict(path='/carrier/group/create', resource=view.CarrierGroupCreate(), method='post'),
    dict(path='/carrier/group/{group_id}', resource=view.CarrierGroupResource(), method='path'),
    dict(path='/carrier/group/list', resource=view.CarrierGroupList(), method='get'),
    dict(path='/carrier/group/all', resource=view.CarrierGroupAllDelete(), method='get'),
    dict(path='/carrier/basic/create', resource=view.CarrierCreate(), method='post'),
    dict(path='/carrier/full/create', resource=view.CarrierLongCreate(), method='post'),
    dict(path='/carrier/create_from_template/{id}', resource=view.CarrierCreateFromTemplate(), method='post'),
    dict(path='/carrier/{client_id}/apply_template', resource=view.CarrierApplyTemplateResource(), method='path'),
    dict(path='/carrier/{client_id}', resource=view.CarrierResource(), method='path'),
    dict(path='/carrier/full/{client_id}', resource=view.CarrierLongResource(), method='path'),
    dict(path='/carrier/all', resource=view.CarrierResourceAll(), method='path'),
    dict(path='/carrier/list', resource=view.CarrierList(), method='get'),
    dict(path='/carrier/minimized/list', resource=view.CarrierSmallList(), method='get'),
    dict(path='/carrier/simple/list', resource=view.ClientSimpleList(), method='get'),
    dict(path='/carrier/client/list', resource=view.ClientDidOrCarrierList(), method='get'),
    dict(path='/carrier/{client_id}/alerts', resource=view.CarrierAlertsResource(), method='path'),
    dict(path='/carrier/{client_id}/invoices', resource=view.CarrierInvoiceSettingsResource(), method='path'),
    dict(path='/carrier/{client_id}/scc', resource=view.CarrierSccResource(), method='path'),
    dict(path='/carrier/{client_id}/portal', resource=view.CarrierPortalResource(), method='path'),
    dict(path='/carrier/{client_id}/contacts', resource=view.CarrierContactsResource(), method='path'),
    dict(path='/carrier/{client_id}/low_balance_config', resource=view.CarrierLowBalanceConfigResource(),
         method='path'),
    dict(path='/carrier/{client_id}/egress_trunk', resource=view.EgressTrunkCreate(), method='post'),
    dict(path='/egress_trunk/{resource_id}', resource=view.EgressTrunkResource(), method='path'),
    dict(path='/egress_trunk/origination/{resource_id}', resource=view.EgressTrunkOriginationResource(), method='path'),
    dict(path='/egress_trunk/{resource_id}/actions', resource=view.EgressTrunkActionsResource(), method='path'),
    dict(path='/egress_trunk/{resource_id}/failover', method='post', resource=view.EgressFailOverCreate()),
    dict(path='/egress_trunk/{resource_id}/failover/{id}', method='path', resource=view.EgressFailOverResource()),
    dict(path='/egress_trunk/{resource_id}/failover/list', method='get', resource=view.EgressFailOverList()),
    dict(path='/carrier/{client_id}/egress_trunk/list', resource=view.EgressTrunkList(), method='get'),
    dict(path='/egress_trunk/{resource_id}/pass', resource=view.EgressTrunkPassResource(), method='path'),
    dict(path='/egress_trunk/{resource_id}/profile', resource=view.EgressProfileCreate(), method='post'),
    dict(path='/egress_trunk/{resource_id}/profiles', resource=view.EgressTrunkProfilesResource(), method='path'),
    dict(path='/egress_profile/{id}', resource=view.EgressProfileResource(), method='path'),
    dict(path='/egress_trunk/{resource_id}/profile/list', resource=view.EgressProfileList(), method='post'),
    dict(path='/egress_trunk/{resource_id}/capacity', resource=view.ResourceCapacityCreate(), method='post'),
    dict(path='/egress_capacity/{egress_id}/{ingress_id}', resource=view.ResourceCapacityResource(), method='path'),
    dict(path='/egress_trunk/{resource_id}/capacity/list', resource=view.ResourceCapacityList(), method='post'),
    dict(path='/egress_trunk/{resource_id}/dyn_routes', resource=view.EgressTrunkDynRouteResource(), method='path'),
    dict(path='/egress_trunk/{resource_id}/static_routes', resource=view.EgressTrunkStaticRouteItemsResource(),
         method='path'),
    dict(path='/ingress_trunk/{resource_id}/capacity/list', resource=view.ResourceCapacityIngressList(), method='post'),
    # {'path':'/carrier/{client_id}/egress_trunk/import','resource':view.EgressTrunkFileCreate(),'method':'post' ),
    # {'path':'/carrier/{client_id}/egress_trunk/export','resource':view.EgressTrunkFileList(),'method':'get' ),
    dict(path='/carrier/{client_id}/ingress_trunk', resource=view.IngressTrunkCreate(), method='post'),
    dict(path='/ingress_trunk/{resource_id}', resource=view.IngressTrunkResource(), method='path'),
    dict(path='/resource/{resource_id}/cid_block_config', method='path',resource=view.ResourceCidBlockConfigResource() ),
    dict(path='/resource/{resource_id}/enfource_cid/create', method='post', resource=view.EnfourceCidCreate()),
    dict(path='/resource/{resource_id}/enfource_cid', method='path', resource=view.EnfourceCidResource()),
    dict(path='/ingress_trunk/{resource_id}/actions', resource=view.IngressTrunkActionsResource(), method='path'),
    dict(path='/ingress_trunk/{resource_id}/failover', method='post', resource=view.IngressFailOverCreate()),
    dict(path='/ingress_trunk/{resource_id}/failover/{id}', method='path', resource=view.IngressFailOverResource()),
    dict(path='/ingress_trunk/{resource_id}/failover/list', method='get', resource=view.IngressFailOverList()),
    dict(path='/ingress_trunk/{resource_id}/sip_error_code', method='post', resource=view.IngressSipErrorCodeCreate()),
    dict(path='/ingress_trunk/{resource_id}/sip_error_code/{sip_error_code_id}', method='path', resource=view.IngressSipErrorCodeResource()),
    dict(path='/ingress_trunk/{resource_id}/sip_error_code/list', method='get', resource=view.IngressSipErrorCodeList()),
    dict(path='/carrier/{client_id}/ingress_trunk/list', resource=view.IngressTrunkList(), method='get'),
    # {'path':'/carrier/{client_id}/ingress_trunk/import','resource':view.IngressTrunkFileCreate(),'method':'get' ),
    # {'path':'/carrier/{client_id}/ingress_trunk/export','resource':view.IngressTrunkFileList(),'method':'get' ),
    # {'path':'/account/DeleteClient','resource':client.client.Delete(),'method':'delete' ),
    # {'path':'/account/ModifyClient','resource':client.client.Modify(),'method':'path' ),
    # {'path':'/GetCarrier','resource':client.client.Get(),'method':'get' ),
    dict(path='/client/credit/{client_id}', resource=view.ClientCreditResource(), method='path'),
    dict(path='/client/credit/list', resource=view.ClientCreditList(), method='get'),
    dict(path='/carrier/{client_id}/send_low_balance_alert', resource=view.CarrierSendLowBalanceAlert(), method='path'),
    dict(path='/carrier/{client_id}/send_welcom', resource=view.CarrierSendWelcon(), method='path'),
    dict(path='/carrier/{client_id}/save_as_template', resource=view.CarrierTemplateFromClientCreate(), method='post'),
    dict(path='/carrier/{client_id}/password', resource=view.CarrierPasswordResource(), method='patch'),
    dict(path='/client/past_due/list', resource=view.ClientPastDueList(), method='get'),
]
_Cloud = [
    # dict(path='/cloud/status', method='post', resource=cloud.DnlCloudStatusCreate()),
    # dict(path='/cloud/status/{server_name}', method='path', resource=cloud.DnlCloudStatusResource()),
    dict(path='/cloud/status/list', method='get', resource=cloud.DnlCloudStatusList()),
    dict(path='/cloud/storage', method='post', resource=cloud.DnlCloudStorageCreate()),
    dict(path='/cloud/storage/{uuid}', method='path', resource=cloud.DnlCloudStorageResource()),
    dict(path='/cloud/storage/list', method='get', resource=cloud.DnlCloudStorageList()),

    dict(path='/cloud/dbman_cfg', method='post', resource=cloud.DnlCloudDbmanCfgCreate()),
    dict(path='/cloud/dbman_cfg/{server_name}', method='path', resource=cloud.DnlCloudDbmanCfgResource()),
    dict(path='/cloud/dbman_cfg/list', method='get', resource=cloud.DnlCloudDbmanCfgList()),

    dict(path='/cloud/gcloud_cfg/{uuid}', method='path', resource=cloud.DnlCloudGCloudCfgResource()),
    dict(path='/cloud/gcloud_cfg/list', method='get', resource=cloud.DnlCloudGCloudCfgList()),

    dict(path='/cloud/cloud_ftp_cfg/{uuid}', method='path', resource=cloud.DnlCloudFtpCfgResource()),
    dict(path='/cloud/cloud_ftp_cfg/list', method='get', resource=cloud.DnlCloudFtpCfgList()),

    dict(path='/cloud/downloader_cfg', method='post', resource=cloud.DnlCloudDownloaderCfgCreate()),
    dict(path='/cloud/downloader_cfg/{server_name}', method='path', resource=cloud.DnlCloudDownloaderCfgResource()),
    dict(path='/cloud/downloader_cfg/list', method='get', resource=cloud.DnlCloudDownloaderCfgList()),

    dict(path='/cloud/search_cfg', method='post', resource=cloud.DnlCloudSearchCfgCreate()),
    dict(path='/cloud/search_cfg/{server_name}', method='path', resource=cloud.DnlCloudSearchCfgResource()),
    dict(path='/cloud/search_cfg/list', method='get', resource=cloud.DnlCloudSearchCfgList()),

    dict(path='/cloud/log', method='get', resource=cloud.DnlCloudLogList()),
    dict(path='/cloud/server/{server_name}/switch/list', method='get', resource=cloud.CloudSwitchListGet()),
    dict(path='/cloud/server/{server_name}/switch/add', method='post', resource=cloud.CloudSwitchAdd()),
    dict(path='/cloud/server/{server_name}/switch/delete', method='post', resource=cloud.CloudSwitchDelete()),
    dict(path='/cloud/server/{server_name}/stat', method='get', resource=cloud.CloudStatusGet()),
    dict(path='/cloud/server/{server_name}/reload', method='post', resource=cloud.CloudRestart()),
    dict(path='/cloud/server/{server_name}/restart', method='post', resource=cloud.CloudRestart()),
    dict(path='/cloud/server/{server_name}/shutdown', method='post', resource=cloud.CloudShutdown()),
    dict(path='/cloud/server/{server_name}/reindex', method='post', resource=cloud.CloudReindex()),
    dict(path='/cloud/server/{server_name}/run-backup', method='post', resource=cloud.CloudRunBackup()),

    dict(path='/cloud/file/server/{server_name}/list/cdr', method='get', resource=cloud.CloudServerFileListCdr()),
    dict(path='/cloud/file/server/{server_name}/list/pcap', method='get', resource=cloud.CloudServerFileListPcap()),

    dict(path='/cloud/file/server/{server_name}/reload', method='post', resource=cloud.CloudServerFileAction()),
    dict(path='/cloud/file/server/{server_name}/restart', method='post', resource=cloud.CloudServerFileAction()),
    dict(path='/cloud/file/server/{server_name}/shutdown', method='post', resource=cloud.CloudServerFileAction()),
    dict(path='/cloud/file/server/{server_name}/status', method='get', resource=cloud.CloudServerFileStatus()),

    dict(path='/cloud/file/list/cdr', method='get', resource=cloud.CloudFileListCdr()),
    dict(path='/cloud/file/list/pcap', method='get', resource=cloud.CloudFileListPcap()),

    dict(path='/cloud/file/get/cdr', method='get', resource=cloud.CloudFileGetCdr()),
    dict(path='/cloud/file/get/pcap', method='get', resource=cloud.CloudFileGetPcap()),


    dict(path='/cloud/search/cdr', method='post', resource=cloud.CloudSearchCdr()),
    dict(path='/cloud/search/pcap', method='post', resource=cloud.CloudSearchPcap()),

    dict(path='/cloud/search/list', method='post', resource=cloud.CloudSearchGetList()),
    dict(path='/cloud/search/list/cdr', method='post', resource=cloud.CloudSearchGetListCdr()),
    dict(path='/cloud/search/list/pcap', method='post', resource=cloud.CloudSearchGetListPcap()),
    dict(path='/cloud/search/{req_uuid}', method='get', resource=cloud.CloudSearchGet()),
    dict(path='/cloud/search/{req_uuid}/download', method='get', resource=cloud.CloudSearchDownload()),
]
_Config = [

    dict(path='/version', resource=rt_proxy.VersionInfoGet(), method='get'),
    dict(path='/public/has_user', resource=view.HasUser(), method='get'),
    dict(path='/auth_token/list', resource=view.AuthTokenList(), method='get'),
    dict(path='/token/{token}/invalidate', resource=view.AuthTokenDisable(), method='post'),
    dict(path='/config/db', resource=dbconfig.DbConfigResource(), method='path'),
    dict(path='/config/rt_api', resource=dbconfig.RtConfigResource(), method='path'),
    dict(path='/config/import', resource=view.ImportCreate(), method='post'),
    dict(path='/config/import/{id}/kill', resource=view.ImportExportLogsKill(), method='post'),
    dict(path='/config/import/{id}/run', resource=view.ImportExportLogsRerun(), method='post'),
    dict(path='/config/import/ani_dnis', resource=view.ResourceBlockImportCreate(), method='post'),
    dict(path='/config/export', resource=view.ExportCreate(), method='post'),
    dict(path='/config/rate/export', resource=view.RateExportCreate(), method='post'),
    dict(path='/config/export/{id}', resource=view.ExportGet(), method='get'),
    dict(path='/config/export/{id}/status', resource=view.ExportStatus(), method='get'),
    dict(path='/config/export_errors/{id}', resource=view.ExportGetErrors(), method='get'),
    dict(path='/config/export/public/{id}', resource=view.ExportPublicGet(), method='get'),
    dict(path='/rate/download/{token}/{filename}', resource=view.RateDownload(), method='get'),
    dict(path='/config/country/create', resource=view.CodeCountryCreate(), method='post'),
    dict(path='/config/country/{time_profile_id}', resource=view.CodeCountryResource(), method='path'),
    dict(path='/config/country/list', resource=view.CodeCountryList(), method='get'),
    dict(path='/config/time_profile/create', resource=view.TimeProfileCreate(), method='post'),
    dict(path='/config/time_profile/{time_profile_id}', resource=view.TimeProfileResource(), method='path'),
    dict(path='/config/time_profile/list', resource=view.TimeProfileList(), method='get'),
    dict(path='/config/time_profile/all', resource=view.TimeProfileAllDelete(), method='get'),
    dict(path='/config/sys_main_menu', resource=view.SysMainMenuCreate(), method='post'),
    dict(path='/config/sys_main_menu/{id}', resource=view.SysMainMenuResource(), method='path'),
    dict(path='/config/sys_main_menu/list', resource=view.SysMainMenuList(), method='get'),
    dict(path='/config/sys_submenu', resource=view.SysSubMenuCreate(), method='post'),
    dict(path='/config/sys_submenu/{id}', resource=view.SysSubMenuResource(), method='path'),
    dict(path='/config/sys_submenu/list', resource=view.SysSubMenuList(), method='get'),
    dict(path='/config/system_function', resource=view.SystemFunctionCreate(), method='post'),
    dict(path='/config/system_function/{system_function_id}', resource=view.SystemFunctionResource(), method='path'),
    dict(path='/config/system_function/list', resource=view.SystemFunctionList(), method='get'),
    dict(path='/config/system_function/list/{group_id}', resource=view.SystemGroupFunctionList(), method='get'),
    dict(path='/config/system_function/{system_function_id}', resource=view.SystemFunctionResource(), method='path'),
    dict(path='/config/system_function/list', resource=view.SystemFunctionList(), method='get'),
    dict(path='/config/system_modules/list', resource=view.SystemFunctionModulesList(), method='get'),
    dict(path='/config/system_function_group/create', resource=view.SystemFunctionGroupCreate(), method='post'),
    dict(path='/config/system_function_group/{id}', resource=view.SystemFunctionGroupResource(), method='path'),
    dict(path='/config/system_function_group/list', resource=view.SystemFunctionGroupList(), method='get'),
    dict(path='/config/role/create', resource=view.RoleCreate(), method='post'),
    dict(path='/config/role/{role_id}', resource=view.RoleResource(), method='path'),
    dict(path='/config/role/{role_id}/defaults', resource=view.RoleCreateDefaultPrivileges(), method='path'),
    dict(path='/config/role/list', resource=view.RoleList(), method='get'),
    dict(path='/config/role/{role_id}/privileges', resource=view.RoleList(), method='get'),
    dict(path='/config/role/{role_id}/menus', resource=view.RoleFunctionGroupList(), method='get'),
    dict(path='/config/role/{role_id}/{system_function_id}/privilege', resource=view.RolePrivilegeCreate(),
         method='post'),
    dict(path='/config/role/privilege/{role_privilege_id}', resource=view.RolePrivilegeResource(), method='path'),
    dict(path='/config/role/{role_id}/privilege/list', resource=view.RolePrivilegeList(), method='get'),
    dict(path='/config/role/{role_id}/privilege/list/{system_function_group_id}', resource=view.RoleFunctionGroupPrivilegeList(), method='get'),
    dict(path='/config/payment_term/create', resource=view.PaymentTermCreate(), method='post'),
    dict(path='/config/payment_term/{payment_term_id}', resource=view.PaymentTermResource(), method='path'),
    dict(path='/config/payment_term/list', resource=view.PaymentTermList(), method='get'),
    dict(path='/config/payment_term/all', resource=view.PaymentTermAllDelete(), method='get'),
    dict(path='/config/auto_rate_mailbox', resource=view.SystemParameterAutoRateEmailResource(), method='path'),
    dict(path='/config/mail_sender/create', resource=view.MailSenderCreate(), method='post'),
    dict(path='/config/mail_sender/{id}', resource=view.MailSenderResource(), method='path'),
    dict(path='/config/mail_sender/{id}/status', resource=view.MailSenderResourceStatus(), method='get'),
    dict(path='/config/mail_sender/list', resource=view.MailSenderList(), method='get'),
    dict(path='/config/mail_sender_status/list', resource=view.MailSenderStatusList(), method='get'),
    dict(path='/config/mail_sender/all', resource=view.MailSenderAllDelete(), method='get'),
    dict(path='/config/mail_sender/{id}/test', resource=view.MailSenderAction(), method='path'),
    dict(path='/config/mail_template/{title}', resource=view.MailTemplateResource(), method='path'),
    dict(path='/config/mail_template/list', resource=view.MailTemplateList(), method='get'),
    dict(path='/config/send_rate_template/create', resource=view.SendRateTemplateCreate(), method='post'),
    dict(path='/config/send_rate_template/{id}', resource=view.SendRateTemplateResource(), method='path'),
    dict(path='/config/send_rate_template/list', resource=view.SendRateTemplateList(), method='get'),
    dict(path='/config/send_rate_template/all', resource=view.SendRateTemplateAllDelete(), method='get'),
    dict(path='/config/cdr_visibility/create', resource=view.DailyCdrFieldCreate(), method='post'),
    dict(path='/config/cdr_visibility/{id}', resource=view.DailyCdrFieldResource(), method='path'),
    dict(path='/config/cdr_visibility/list', resource=view.DailyCdrFieldList(), method='get'),
    dict(path='/config/cdr_visibility/edit', resource=view.DailyCdrFieldEditManyResource(), method='path'),
    dict(path='/config/auto_cdr_format/edit', resource=view.DailyCdrFieldAutoEditManyResource(), method='path'),
    dict(path='/config/route_error/create', resource=view.GlobalRouteErrorCreate(), method='post' ),
    dict(path='/config/route_error/{id}', resource=view.GlobalRouteErrorResource(), method='path'),
    dict(path='/config/route_error/list', resource=view.GlobalRouteErrorList(), method='get'),
    dict(path='/config/route_error', resource=view.GlobalRouteErrorEditManyResource(), method='path'),
#     dict(path='/config/failover/global/create', resource=view.GlobalFailoverCreate(), method='post'),
#     dict(path='/config/failover/global/{id}', resource=view.GlobalFailoverResource(), method='path'),
#     dict(path='/config/failover/global/list', resource=view.GlobalFailoverList(), method='get'),
#     dict(path='/config/failover/global', resource=view.GlobalFailoverEditManyResource(), method='path'),
    dict(path='/config/failover/termination/create', resource=view.TerminationFailoverCreate(), method='post' ),
    dict(path='/config/failover/termination/{id}', resource=view.TerminationFailoverResource(), method='path'),
    dict(path='/config/failover/termination/list', resource=view.TerminationFailoverList(), method='get'),
    dict(path='/config/failover/termination', resource=view.TerminationFailoverEditManyResource(), method='path'),
    # dict(path='/config/failover/origination/create', resource=view.OriginationFailoverCreate(), method='post' ),
    dict(path='/config/failover/origination/{id}', resource=view.OriginationFailoverResource(), method='path'),
    dict(path='/config/failover/origination/list', resource=view.OriginationFailoverList(), method='get'),
    dict(path='/config/failover/origination', resource=view.OriginationFailoverEditManyResource(), method='path'),
    dict(path='/config/ftp/create', resource=view.FtpConfCreate(), method='post'),
    dict(path='/config/ftp/{id}/copy', resource=view.FtpConfCopy(), method='post'),
    dict(path='/config/ftp/{id}', resource=view.FtpConfResource(), method='path'),
    dict(path='/config/ftp/{id}/test', resource=view.FtpConfTest(), method='path'),
    dict(path='/config/ftp/{id}/manual', resource=view.FtpConfManualTrigger(), method='path'),
    dict(path='/config/ftp/all', resource=view.FtpConfActivate(), method='path'),
    dict(path='/config/ftp/list', resource=view.FtpConfList(), method='get'),
    dict(path='/config/login/public', resource=view.SystemParameterLoginPageGetResource(), method='get'),
    dict(path='/config/login', resource=view.SystemParameterLoginPageResource(), method='path'),
    dict(path='/config/portal', resource=view.SystemParameterPortalResource(), method='path'),
    dict(path='/config/invoice', resource=view.SystemParameterInvoiceSettingResource(), method='path'),
    dict(path='/config/payment', resource=view.SystemParameterPaymentSettingResource(), method='path'),
    dict(path='/config/public/payment', resource=view.SystemParameterPaymentSettingPublicResource(), method='path'),
    dict(path='/config/system', resource=view.SystemParameterSystemSettingResource(), method='path'),
    dict(path='/config/system/public', resource=view.SystemParameterSystemSettingPublicResource(), method='path'),
    dict(path='/config/timeouts', resource=view.SystemParameterSystemTimeoutsResource(), method='path'),
    dict(path='/config/emails', resource=view.SystemParameterSystemEmailsResource(), method='path'),
    dict(path='/config/qos', resource=view.SystemParameterQosRoutingResource(), method='path'),
    dict(path='/config/first_time_wizard', resource=view.SystemParameterFirstTimeWizard(), method='path'),
    dict(path='/config/daily_cdr_cloud', resource=cdr.DailyCdrCloudUpdate(), method='patch'),
    dict(path='/config/daily_cdr_cloud/clear', resource=cdr.DailyCdrCloudDelete(), method='get'),
    dict(path='/c4_lrn', method='post', resource=view.C4LrnCreate()),
    dict(path='/c4_lrn/{id}', method='path', resource=view.C4LrnResource()),
    dict(path='/c4_lrn/list', method='get', resource=view.C4LrnList()),
    
#     dict(path='/config/many/shaken', method='post', resource=shaken.C4ShakenConfManyCreate()),
#     dict(path='/config/shaken', method='post', resource=shaken.C4ShakenConfCreate()),
#     dict(path='/config/shaken/{id}', method='path', resource=shaken.C4ShakenConfResource()),
#     dict(path='/config/shaken/many/{id}', method='path', resource=shaken.C4ShakenConfManyResource()),
#     dict(path='/config/shaken/list', method='get', resource=shaken.C4ShakenConfList()),
    dict(path='/config/shaken/ani_group', method='post',resource=shaken.ShakenAniGroupCreate() ),
    dict(path='/config/shaken/ani_group/{id}', method='path',resource=shaken.ShakenAniGroupResource() ),
    dict(path='/config/shaken/ani_group/list', method='get',resource=shaken.ShakenAniGroupList() ),
    dict(path='/config/shaken/ani_group/import', method='post',resource=shaken.ShakenAniGroupRelImportTaskCreate() ),
    dict(path='/config/shaken/ani_group/import/{id}', method='get',resource=shaken.ShakenAniGroupRelImportTaskResource() ),
    dict(path='/config/shaken/ani_group/import/warnings/{id}', method='get',resource=shaken.ShakenAniGroupRelImportTaskWarningsResource()),
    dict(path='/config/shaken/ani_group/import/list', method='get',resource=shaken.ShakenAniGroupRelImportTaskList() ),
    dict(path='/config/shaken/ani_group_did', method='post',resource=shaken.ShakenAniGroupRelCreate() ),
    dict(path='/config/shaken/ani_group_did/{group_id}/{did}', method='path',resource=shaken.ShakenAniGroupRelResource() ),
    dict(path='/config/shaken/ani_group_did/list', method='get',resource=shaken.ShakenAniGroupRelList() ),
    dict(path='/config/shaken/ani_group_dids_delete/{group_id}', method='delete', resource=shaken.ShakenAniGroupRelNumbersDelete()),
    dict(path='/config/shaken/ani_pool', method='post',resource=shaken.ShakenAniGroupListCreate() ),
    dict(path='/config/shaken/ani_pool/{id}', method='path',resource=shaken.ShakenAniGroupListResource() ),
    dict(path='/config/resource/shaken/ani_group/{resource_id}', method='path', resource=shaken.ResourceShakenAniGroupListRelAdd()),
    dict(path='/config/resource/shaken/ani_group/resource/{id}', method='path', resource=shaken.ResourceShakenAniGroupListRelResource()),
    dict(path='/config/shaken/ani_pool/list', method='get',resource=shaken.ShakenAniGroupListList() ),
    dict(path='/config/shaken/ani_pool/{id}/add_group', method='post',resource=shaken.ShakenAniGroupListRelAdd() ),
    #dict(path='/config/shaken/ani_pool_group', method='post',resource=shaken.ShakenAniGroupListRelCreate() ),
    dict(path='/config/shaken/ani_pool_group/{id}', method='path',resource=shaken.ShakenAniGroupListRelResource() ),
    dict(path='/config/shaken/ani_pool_group/list', method='get',resource=shaken.ShakenAniGroupListRelList() ),
    dict(path='/config/stir_shaken_config/create', method='post',resource=shaken.ShakenStiSpConfCreate() ),
    # dict(path='/config/stir_shaken_config', method='get',resource=shaken.ShakenStiSpConfList() ),
    dict(path='/config/stir_shaken_config', method='post',resource=shaken.ShakenStiSpConfResource() ),


    dict(path='/config/us_jurisdictionprefix/create', resource=view.JurisdictionPrefixCreate(), method='post'),
    dict(path='/config/us_jurisdictionprefix/{id}', resource=view.JurisdictionPrefixResource(), method='path'),
    dict(path='/config/us_jurisdictionprefix/list', resource=view.JurisdictionPrefixList(), method='get'),
    dict(path='/config/us_jurisdictionprefix/all', resource=view.JurisdictionPrefixAllDelete(), method='get'),
    dict(path='/config/carrier_template/create', resource=view.CarrierTemplateCreate(), method='post'),
    dict(path='/config/carrier_template/{id}', resource=view.CarrierTemplateResource(), method='path'),
    dict(path='/config/carrier_template/list', resource=view.CarrierTemplateList(), method='get'),
    dict(path='/config/carrier_template/all', resource=view.CarrierTemplateAllDelete(), method='get'),
    dict(path='/config/egress_trunk_template/create', resource=view.EgressTrunkTemplateCreate(), method='post'),
    dict(path='/config/egress_trunk_template/{resource_template_id}', resource=view.EgressTrunkTemplateResource(),
         method='path'),
    dict(path='/config/egress_trunk_template/list', resource=view.EgressTrunkTemplateList(), method='get'),
    dict(path='/config/egress_trunk_template/all', resource=view.EgressTrunkTemplateAllDelete(), method='get'),
    dict(path='/config/ingress_trunk_template/create', resource=view.IngressTrunkTemplateCreate(), method='post'),
    dict(path='/config/ingress_trunk_template/{resource_template_id}', resource=view.IngressTrunkTemplateResource(),
         method='path'),
    dict(path='/config/ingress_trunk_template/list', resource=view.IngressTrunkTemplateList(), method='get'),
    dict(path='/config/ingress_trunk_template/all', resource=view.IngressTrunkTemplateAllDelete(), method='get'),
    dict(path='/config/egress_trunk_template/apply/{resource_template_id}/{client_id}',
         resource=view.EgressTrunkFromTemplateCreate(), method='post'),
    dict(path='/config/ingress_trunk_template/apply/{resource_template_id}/{client_id}',
         resource=view.IngressTrunkFromTemplateCreate(), method='post'),
    dict(path='/config/storage/{conf_type}', resource=view.StorageConfigResource(), method='path'),
    dict(path='/config/code_deck_update/az', resource=view.SystemParameterUploadAZCodedeck(), method='path'),
    dict(path='/config/code_deck_update/us', resource=view.SystemParameterUploadUSCodedeck(), method='path'),
    dict(path='/config/codec/list', resource=view.CodecList(), method='get'),
    dict(path='/config/client_invoice_settings', method='post', resource=view.ClientInvoiceSettingsCreate()),
    dict(path='/config/client_invoice_settings/{id}', method='path', resource=view.ClientInvoiceSettingsResource()),
    dict(path='/config/client_invoice_settings/list', method='get', resource=view.ClientInvoiceSettingsList()),
    dict(path='/config/clean_data_management', method='post', resource=view.CleanDataManagementCreate()),
    dict(path='/config/clean_data_management/{id}', method='path', resource=view.CleanDataManagementResource()),
    dict(path='/config/clean_data_management/list', method='get', resource=view.CleanDataManagementList()),
    dict(path='/config/disk_management', method='path', resource=view.DiskManagementCustomDnlResource()),
    dict(path='/config/release_cause/list', method='get', resource=view.ReleaseCauseList()),
    dict(path='/config/egress_release_cause/list', method='get', resource=view.EgressReleaseCauseList()),
    dict(path='/config/lerg_download', method='post', resource=view.LergDownload()),
    dict(path='/config/lerg_download_schedule', method='post', resource=view.LergDownloadScheduleCreate()),
    dict(path='/config/lerg_download_schedule/{id}', method='path', resource=view.LergDownloadScheduleResource()),
    dict(path='/config/lerg_download_schedule/list', method='get', resource=view.LergDownloadScheduleList()),
    dict(path='/config/media_asr_filter', method='post', resource=view.MediaAsrFilterCreate()),
    dict(path='/config/media_asr_filter/{id}', method='path', resource=view.MediaAsrFilterResource()),
    dict(path='/config/media_asr_filter/list', method='get', resource=view.MediaAsrFilterList()),
    dict(path='/config/media_capture_filter', method='post', resource=view.MediaCaptureFilterCreate()),
    dict(path='/config/media_capture_filter/{id}', method='path', resource=view.MediaCaptureFilterResource()),
    dict(path='/config/media_capture_filter/list', method='get', resource=view.MediaCaptureFilterList()),
    dict(path='/config/signal_capture_filter', method='post', resource=view.SignalCaptureFilterCreate()),
    dict(path='/config/signal_capture_filter/{id}', method='path', resource=view.SignalCaptureFilterResource()),
    dict(path='/config/signal_capture_filter/list', method='get', resource=view.SignalCaptureFilterList()),
]
_Finance = [
    dict(path='/carrier/{client_id}/payment', resource=view.ClientPaymentCreate(), method='post'),
    dict(path='/carrier/{client_id}/extra_charges', resource=view.ClientPaymentExtraCreate(), method='post'),
    dict(path='/carrier/extra_charge/{client_payment_id}', resource=view.ClientPaymentExtraResource(), method='post'),
    dict(path='/carrier/{client_id}/extra_charges/list', resource=view.ClientPaymentExtraList(), method='post'),
    dict(path='/carrier/extra_charges/list', resource=view.ClientPaymentAllExtraList(), method='post'),
    dict(path='/finance/payment/{client_payment_id}', resource=view.ClientPaymentResource(), method='path'),
    dict(path='/finance/payment/{client_payment_id}/edit_and_send_note', resource=view.ClientPaymentSendNote(),
         method='post'),
    dict(path='/carrier/{client_id}/payment/list', resource=view.ClientPaymentList(), method='get'),
    # dict(path='/finance/invoice', resource=view.InvoiceManyCreate(), method='post'),
    # dict(path='/carrier/{client_id}/manual_invoice', resource=view.InvoiceManualCreate(), method='post'),
    # dict(path='/carrier/{client_id}/invoice', resource=view.InvoiceCreate(), method='post'),
    dict(path='/finance/invoice/{invoice_id}', resource=invoice.InvoiceDeleteResource(), method='path'),
    dict(path='/finance/invoice/file/{invoice_id}', resource=invoice.InvoiceFileGet(), method='get'),
    dict(path='/carrier/{client_id}/invoice/list', resource=invoice.InvoiceClientList(), method='get'),
    dict(path='/finance/invoice/list', resource=invoice.InvoiceList(), method='get'),
    dict(path='/finance/invoice/all', resource=invoice.InvoiceAllDelete(), method='get'),
    dict(path='/finance/auto_invoice/list', resource=view.CarrierAutoInvoicingList(), method='get'),
    dict(path='/finance/invoice/{invoice_id}/send', resource=invoice.InvoiceSend(), method='path'),
    dict(path='/finance/invoice/{invoice_id}/create_credit_note', resource=view.ClientPaymentCreditNoteCreate(),
         method='path'),
    dict(path='/finance/invoice/{invoice_id}/regenerate', resource=invoice.InvoiceReCreate(), method='post'),
    dict(path='/finance/invoice/{invoice_id}/void', resource=invoice.InvoiceVoid(), method='post'),
    dict(path='/finance/invoice/{invoice_id}/payment/list', resource=view.ClientPaymentForInvoiceList(), method='get'),
    dict(path='/finance/invoice/{invoice_id}/credit_note/list', resource=view.ClientPaymentCreditNotesForInvoiceList(),
         method='get'),
    dict(path='/carrier/{client_id}/balance', resource=view.CarrierBalanceResource(), method='path'),
    dict(path='/carrier/{client_id}/mutual_balance', resource=view.BalanceHistoryClientList(), method='get'),
    dict(path='/finance/mutual_balance/list', resource=view.BalanceHistoryList(), method='get'),
    dict(path='/carrier/{client_id}/actual_balance', resource=view.ActualBalanceHistoryClientList(), method='get'),
    dict(path='/finance/actual_balance/list', resource=view.ActualBalanceHistoryList(), method='get'),
    dict(path='/carrier/{client_id}/regenerate_balance', resource=view.BalanceDailyResetTaskAction(), method='post'),
    dict(path='/carrier/all/regenerate_balance', resource=view.BalanceDailyResetTaskAllAction(), method='path'),
    dict(path='/carrier/{client_id}/transactions/list', resource=view.ClientPaymentTransList(), method='get'),
    # dict(path='/carrier/{client_id}/gateway_payment', resource=view.PaymentGatewayHistoryCreate(), method='post'),
    dict(path='/carrier/{client_id}/gateway_payments', resource=view.PaymentGatewayHistoryClientList(), method='get'),
    dict(path='/finance/gateway_payments', resource=view.PaymentGatewayHistoryList(), method='get'),
    dict(path='/finance/sent_payment', resource=view.ClientPaymentSentCreate(), method='post'),
    dict(path='/finance/sent_payment/{client_payment_id}', resource=view.ClientPaymentSentResource(), method='path'),
    dict(path='/finance/sent_payment/list', resource=view.ClientPaymentSentList(), method='get'),
    dict(path='/finance/received_payment/list', resource=view.ClientPaymentReceivedList(), method='get'),
    dict(path='/finance/all_payment/list', resource=view.ClientPaymentAllList(), method='get'),
    dict(path='/finance/all_invoice_payment/list', resource=view.ClientPaymentInvoiceList(), method='get'),

    dict(path='/manual_invoice_task', method='post', resource=invoice.ManualInvoiceTaskCreate()),
    dict(path='/manual_multi_invoice_task', method='post', resource=invoice.ManualInvoiceTaskManyCreate()),
    dict(path='/manual_invoice_task/{id}', method='path', resource=invoice.ManualInvoiceTaskResource()),
    dict(path='/manual_invoice_task/list', method='get', resource=invoice.ManualInvoiceTaskList()),
    # dict(path='/invoice_summary', method='post', resource=view.InvoiceSummaryCreate()),
    dict(path='/invoice_data/{invoice_num}', method='path', resource=invoice.InvoiceData()),
    dict(path='/invoice_summary/list', method='get', resource=invoice.InvoiceSummaryList()),
]
_Log = [
    dict(path='/log/revisions', resource=view.ObjectRevisionList(), method='get'),
    dict(path='/log/revisions/{id}/restore', resource=view.RestoreObject(), method='get'),
    dict(path='/log/auth', resource=log.AuthorizationLogList(), method='get'),
    dict(path='/log/email', resource=view.EmailLogList(), method='get'),
    # dict(path='/log/cdr_export', resource=view.CdrExportLogList(), method='get'),
    dict(path='/log/regenerate_balance', resource=view.BalanceDailyResetTaskList(), method='get'),
    dict(path='/log/balance', resource=view.BalanceLogList(), method='get'),
    dict(path='/log/credit', resource=view.CreditLogList(), method='get'),
    dict(path='/log/export', resource=view.ImportExportLogsExportList(), method='get'),
    dict(path='/log/import', resource=view.ImportExportLogsImportList(), method='get'),
    dict(path='/log/ftp', resource=view.FtpCdrLogList(), method='get'),
    dict(path='/log/ftp_server', resource=view.FtpServerLogList(), method='get'),
    dict(path='/log/invoice_cdr', resource=view.InvoiceCdrLogList(), method='get'),
    dict(path='/log/invoice', resource=view.InvoiceLogList(), method='get'),
    dict(path='/log/ip_modify', resource=view.IpModifLogList(), method='get'),
    dict(path='/log/modify', resource=view.ModifLogList(), method='get'),
    dict(path='/log/license_modify', resource=view.LicenseModificationLogList(), method='get'),
    dict(path='/log/orig', resource=view.OrigLogList(), method='get'),
    # dict(path='/log/rate_upload', resource=view.RateUploadTaskList(), method='get'),
    dict(path='/log/rate_import', resource=view.RateImportTaskList(), method='get'),
    dict(path='/log/rate_download', resource=view.RateDownloadLogList(), method='get'),
    dict(path='/log/rate_mass_edit', resource=view.RateMassEditLogList(), method='get'),
    dict(path='/log/rate_generation', resource=view.RateGenerationHistoryList(), method='get'),
    dict(path='/log/rate_generation_detail', resource=view.RateGenerationHistoryDetailList(), method='get'),
    dict(path='/log/retrieve_password', resource=view.RetrievePasswordLogList(), method='get'),
    dict(path='/log/scheduled_report', resource=view.ScheduledReportLogList(), method='get'),
    dict(path='/log/scheduler', resource=view.SchedulerLogList(), method='get'),
    dict(path='/log/sip_register', resource=view.SipRegistrationList(), method='get'),
    dict(path='/log/sql', resource=log.PgStatActivityList(), method='get'),
    dict(path='/log/user_signon', resource=view.WebSessionList(), method='get'),
    dict(path='/log/fraud_detection', resource=view.FraudDetectionLogList(), method='get'),
    dict(path='/log/alert_rule', resource=view.AlertRuleLogList(), method='get'),
    dict(path='/log/rerate/exec', resource=view.RerateReportExecLogList(), method='get'),
    dict(path='/log/rerate/cdr_download', resource=view.RerateCdrDownloadLogList(), method='get'),
    dict(path='/log/versions', resource=view.VersionInformationList(), method='get'),
    dict(path='/log/entities', resource=view.EntityList(), method='get'),
    dict(path='/log/async_ftp', resource=view.AsyncFtpExportList(), method='get'),
    dict(path='/log/rate_auto_import_rule', resource=view.RateAutoImportRuleLogList(), method='get'),
    dict(path='/log/frund_detection_history', method='get', resource=view.FrundDetectionHistoryList()),
    dict(path='/log/watchdog_systemd', method='get', resource=log.WatchdogSystemdLogList()),
    dict(path='/log/watchdog_systemd_events', method='get', resource=log.WatchdogSystemdEventsList()),
    dict(path='/log/rate_auto_import_mailbox_log', method='get', resource=view.RateAutoImportMailboxLogList()),
    dict(path='/log/lerg_download_task', method='get', resource=view.LergDownloadTaskList()),
    dict(path='/log/did_vendor', method='get', resource=log.DidVendorLogList()),
    dict(path='/log/did_client', method='get', resource=log.DidClientLogList()),
    dict(path='/log/did_repository', method='get', resource=log.DidRepositoryLogList()),
    dict(path='/log/did_assignment', method='get', resource=log.DidAssignmentsLogList()),
    dict(path='/log/resource_cid_block', method='get',resource=view.ResourceCidBlockLogList() ),
]
_Monitoring = [
    dict(path='/monitoring/loop_detection', resource=view.LoopDetectionCreate(), method='post'),
    dict(path='/monitoring/loop_detection/{id}', resource=view.LoopDetectionResource(), method='path'),
    dict(path='/monitoring/loop_detection/all', resource=view.LoopDetectionActivate(), method='path'),
    dict(path='/monitoring/loop_detection/list', resource=view.LoopDetectionList(), method='get'),
    dict(path='/monitoring/loop_detection/blocked', resource=view.LoopDetectionDetailList(), method='get'),
    dict(path='/monitoring/fraud_detection', resource=view.FraudDetectionCreate(), method='post'),
    dict(path='/monitoring/fraud_detection/{id}', resource=view.FraudDetectionResource(), method='path'),
    dict(path='/monitoring/fraud_detection/all', resource=view.FraudDetectionActivate(), method='path'),
    dict(path='/monitoring/fraud_detection/list', resource=view.FraudDetectionList(), method='get'),
    dict(path='/monitoring/rule', resource=view.AlertRuleCreate(), method='post'),
    dict(path='/monitoring/rule/{id}', resource=view.AlertRuleResource(), method='path'),
    dict(path='/monitoring/rule/all', resource=view.AlertRuleActivate(), method='path'),
    dict(path='/monitoring/rule/list', resource=view.AlertRuleList(), method='get'),
    dict(path='/monitoring/spam_traffic_ip', method='post', resource=view.SpamTrafficIpCreate()),
    dict(path='/monitoring/spam_traffic_ip/{ip}', method='path', resource=view.SpamTrafficIpResource()),
    dict(path='/monitoring/spam_traffic_ip/list', method='get', resource=view.SpamTrafficIpList()),
    dict(path='/monitoring/spam_traffic_ip/all', method='patch', resource=view.SpamTrafficIpActivate()),

    dict(path='/monitored_rule', method='post', resource=view.MonitoredRuleCreate()),
    dict(path='/monitored_rule/{id}', method='path', resource=view.MonitoredRuleResource()),
    dict(path='/monitored_rule/list', method='get', resource=view.MonitoredRuleList()),
    dict(path='/monitored_rule/all', resource=view.MonitoredRuleActivate(), method='path'),
    dict(path='/monitored_rule_history/list', method='get', resource=view.MonitoredRuleHistoryList()),

    dict(path='/monitoring/frund_detection', method='post', resource=view.FrundDetectionCreate()),
    dict(path='/monitoring/frund_detection/{id}', method='path', resource=view.FrundDetectionResource()),
    dict(path='/monitoring/frund_detection/list', method='get', resource=view.FrundDetectionList()),
    dict(path='/monitoring/fault_route_alert_rule', method='post',
         resource=fault_route_alert_rule.FaultRouteAlertRuleCreate()),
    dict(path='/monitoring/fault_route_alert_rule/{id}', method='path',
         resource=fault_route_alert_rule.FaultRouteAlertRuleResource()),
    dict(path='/monitoring/fault_route_alert_rule/list', method='get',
         resource=fault_route_alert_rule.FaultRouteAlertRuleList()),
    dict(path='/monitoring/fault_route_alert_rule/log', method='get',
         resource=fault_route_alert_rule.FaultRouteAlertRuleLogList()),
]
_Origination = [
    dict(path='/did/client/create', resource=view.ClientDidCreate(), method='post'),
    dict(path='/did/client/{client_id}', resource=view.ClientDidResource(), method='path'),
    dict(path='/did/client/{client_id}/{client_billing_rule_id}/assign_dids', resource=view.ClientDidAssignDidsAction(),
         method='path'),
    dict(path='/did/client/all', resource=view.ClientDidResourceAll(), method='path'),
    dict(path='/did/client/list', resource=view.ClientDidList(), method='get'),
    dict(path='/did/vendor/create', resource=view.VendorDidCreate(), method='post'),
    dict(path='/did/vendor/{client_id}', resource=view.VendorDidResource(), method='path'),
    dict(path='/did_repository/{vendor_id}/did_count', resource=view.VendorDidCount(), method='get'),
    dict(path='/did_assignment/{client_id}/did_count', resource=view.ClientDidAssignCount(), method='get'),
    dict(path='/did/vendor/all', resource=view.VendorDidResourceAll(), method='path'),
    dict(path='/did/vendor/list', resource=view.VendorDidList(), method='get'),
    dict(path='/did/vendor/{client_id}/upload_dids', resource=view.VendorDidUpload(), method='post'),
    dict(path='/did/billing_rule/create', resource=view.DidBillingPlanCreate(), method='post'),
    dict(path='/did/billing_rule/{id}', resource=view.DidBillingPlanResource(), method='path'),
    dict(path='/did/billing_rule/list', resource=view.DidBillingPlanList(), method='get'),
    dict(path='/did/billing_rule/all', resource=view.DidBillingPlanAllDelete(), method='get'),
    dict(path='/did/billing_rule/{id}/rate_params', resource=view.DidBillingPlanRateParamsResource(), method='path'),
    dict(path='/did/assignments/list', resource=view.DidAssignmentsList(), method='get'),
#     dict(path='/did/repository/create', resource=view.DidBillingRelCreate(), method='post'),
    dict(path='/did/repository/create', resource=view.DidRepositoryCreate(), method='post'),
    dict(path='/did/repository/{id}', resource=view.DidRepositoryResource(), method='path'),
    dict(path='/did/repository/{id}/assign', resource=view.DidRepositoryAssign(), method='post'),
    dict(path='/did/repository_new/{id}', resource=view.DidRepositoryResource(), method='delete'),
#     dict(path='/did/repository/list', resource=view.DidBillingRelList(), method='get'),
    dict(path='/did/repository/list', resource=view.DidRepositoryList(), method='get'),
    dict(path='/did/repository/all', resource=view.DidBillingRelAllDelete(), method='get'),
    dict(path='/did/repository/mass_assign', resource=view.DidBillingRelMassAssign(), method='path'),
    dict(path='/did/repository/available/list', resource=view.DidBillingRelAvailableList(), method='get'),
    dict(path='/did/repository/active/list', resource=view.DidRepositoryActiveList(), method='get'),
    dict(path='/did/repository/did_param/update/{action}', resource=view.DidParamUpdate(), method='post'),
    dict(path='/did/routing/list', resource=view.ProductItemsForDidList(), method='get'),
    # dict(path='/did/{client_id}/orig_invoice', resource=view.OrigInvoiceCreate(), method='post'),
    dict(path='/did/orig_invoice/{invoice_id}', resource=invoice.InvoiceResource(), method='path'),
    dict(path='/did/orig_invoice/{invoice_id}/file', resource=invoice.InvoiceFileGet(), method='get'),
    dict(path='/did/orig_invoice/list', resource=invoice.InvoiceList(), method='get'),
    dict(path='/did/orig_invoice/all', resource=invoice.InvoiceAllDelete(), method='get'),
    dict(path='/did/lerg/import', method='post', resource=view.LergImportCreate()),
    dict(path='/did/lerg/import/log', method='post', resource=view.LergImportList()),
    dict(path='/did/available/country/list', resource=view.AvailableCountryList(), method='get'),
    dict(path='/did/available/state/list', resource=view.AvailableStateList(), method='get'),
    dict(path='/did/available/lata/list', resource=view.AvailableLataList(), method='get'),
    dict(path='/did/available/npa/list', resource=view.AvailableNpaList(), method='get'),
    dict(path='/did_product', method='post', resource=view.DidProductCreate()),
    dict(path='/did_product/{id}', method='path', resource=view.DidProductResource()),
    dict(path='/did_product/list', method='get', resource=view.DidProductList()),
    dict(path='/did_product_item', method='post', resource=view.DidProductItemCreate()),
    dict(path='/did_product_item/{id}', method='path', resource=view.DidProductItemResource()),
    dict(path='/did_product_item/list', method='get', resource=view.DidProductItemList()),
    dict(path='/client_did_product', method='post', resource=view.ClientDidProductCreate()),
    dict(path='/client_did_product/{client_id}', method='path', resource=view.ClientDidProductResource()),
    dict(path='/client_did_product/list', method='get', resource=view.ClientDidProductList()),
    #dict(path='/did/sms_rate_table', method='post', resource=sms_rate.SmsRateTableCreate()),
    #dict(path='/did/sms_rate_table/{id}', method='path', resource=sms_rate.SmsRateTableResource()),
    #dict(path='/did/sms_rate_table/list', method='get', resource=sms_rate.SmsRateTableList()),
    #dict(path='/did/sms_rate', method='post', resource=sms_rate.SmsRateCreate()),
    #dict(path='/did/sms_rate/{id}', method='path', resource=sms_rate.SmsRateResource()),
    #dict(path='/did/sms_rate/list', method='get', resource=sms_rate.SmsRateList()),
]
_Product = [
    dict(path='/product/create', resource=view.ProductRoutRateTableCreate(), method='post'),
    dict(path='/product/{id}', resource=view.ProductRoutRateTableResource(), method='path'),
    dict(path='/product/{id}/send', resource=view.ProductRoutRateTableSendResource(), method='path'),
    dict(path='/product/list', resource=view.ProductRoutRateTableList(), method='get'),
    dict(path='/product/public', resource=view.ProductRoutRateTablePublicList(), method='get'),
    # {'path':'/product/{id}/clients','resource':view.ProductRoutRateTableClientsResource(),'method':'path' ),
    dict(path='/product/analysis/create', resource=view.ProductRouteAnalysisCreate(), method='post'),
    dict(path='/product/analysis/{uuid}', resource=view.ProductRouteAnalysisResource(), method='path'),
    dict(path='/product/analysis/list', resource=view.ProductRouteAnalysisList(), method='get'),
    dict(path='/product_code_name', resource=view.ProductCodeNameCreate(), method='post'),
    dict(path='/product_code_name/{item_id}', resource=view.ProductCodeNameResource(), method='path'),
    dict(path='/product_code_name/list', resource=view.ProductCodeNameList(), method='get'),
    dict(path='/product_code_name/{item_id}/{resource_id}', resource=view.ProductCodeNameResourceCreate(), method='post'),
    dict(path='/product_code_name/{item_id}/{resource_id}/delete', resource=view.ProductCodeNameResourceDelete(), method='delete'),
]
_Reports = [
    dict(path='/report/system_call_stats/{type}/{period}', resource=stat.SystemCallStats(), method='get'),
    dict(path='/report/sip_active', resource=view.SipRegistrationActiveList(), method='get'),
    dict(path='/report/cdr_active', resource=view.ClientCdrActiveList(), method='get'),
    dict(path='/report/switch/{switch_id}/telnet', resource=view.VoipGatewayTestTelnet(), method='get'),
    dict(path='/report/switch/{switch_id}/active_calls', resource=view.VoipGatewayActiveCalls(), method='get'),
    dict(path='/report/switch/{switch_id}/system_call_stats', resource=view.VoipGatewaySystemCallStats(), method='get'),
    dict(path='/report/switch/{switch_id}/system_peak_stats', resource=view.VoipGatewaySystemPeakStats(), method='get'),
    dict(path='/report/switch/{switch_id}/call_stats', resource=view.VoipGatewayCallStats(), method='get'),
    dict(path='/report/switch/{switch_id}/rate_sorting', resource=view.VoipGatewayRateSorting(), method='get'),
    dict(path='/report/switch/{switch_id}/sign_call', resource=view.VoipGatewayCallSigning(), method='get'),
    dict(path='/report/switch/{switch_id}/get_license_limit', resource=view.VoipGatewayGetLicenseLimit(), method='get'),
    dict(path='/report/switch/active_calls', resource=view.VoipGatewayFullActiveCalls(), method='get'),
    dict(path='/report/cdr_report1', resource=cdr.CdrReportList(), method='get'),
    dict(path='/report/cdr_report', resource=cdr1.CdrReportList(), method='get'),
    dict(path='/report/cdr_report_detail', resource=report.Report(), method='get'),
    dict(path='/report/cdr_report_detail/earliest_report_date', resource=cdr.CdrReportDetailEarliestGet(),
         method='get'),
    dict(path='/report/cdr_report_detail/latest_report_date', resource=cdr.CdrReportDetailLatestGet(),
         method='get'),
    dict(path='/report', resource=report.Report(), method='get'),
    dict(path='/report/daily', resource=report.ReportDaily(), method='get'),
    dict(path='/report/daily_simple', resource=report.ReportDailySimple(), method='get'),
    dict(path='/report/code_report', resource=report.ReportCodeReport(), method='get'),
    dict(path='/report/detail', resource=report.CdrReportDetailGroupableList(), method='get'),
    dict(path='/report/template', method='post', resource=report.ReportTemplateCreate()),
    dict(path='/report/template/resource/{id}', method='path', resource=report.ReportTemplateResource()),
    dict(path='/report/template/{id}/run', method='get', resource=report.ReportTemplateApply()),
    dict(path='/report/template/list', method='get', resource=report.ReportTemplateList()),
    dict(path='/report/did', resource=report.DidReport(), method='get'),
    dict(path='/report/host', resource=report.HostBasedReport(), method='get'),
    dict(path='/report/client_cdr', resource=report.ClientCdrReport(), method='get'),
    dict(path='/report/qos', resource=view.QosReport(), method='get'),
    dict(path='/report/qos_total', resource=view.QosTotalReport(), method='get'),
    dict(path='/report/qos_total_by_time_range', resource=view.QosTotalRangeReport(), method='get'),
    dict(path='/report/qos_resource', resource=view.QosResourceReport(), method='get'),
    dict(path='/report/qos_ip', resource=view.QosIpReport(), method='get'),

    dict(path='/report/qos_resource_by_time_range', resource=view.QosResourceRangeReport(), method='get'),
    dict(path='/report/top_10', resource=view.QosRouteTop10Report(), method='get'),
    dict(path='/report/qos_route/{field}', resource=view.QosRouteReport(), method='get'),
    dict(path='/did_usage_report/list', method='get', resource=view.DidUsageReport()),
    dict(path='/did_cost_report/list', method='get', resource=view.DidCostReport()),
#     dict(path='/sms/report', method='get', resource=view.SmsReport()),
]
_Route = [
    dict(path='/route/plan', resource=view.RouteStrategyCreate(), method='post'),
    dict(path='/route/plan/extended', resource=view.RouteStrategyExCreate(), method='post'),
    dict(path='/route/plan/{route_plan_id}', resource=view.RouteStrategyResource(), method='path'),
    dict(path='/route/plan/{route_plan_id}/copy', resource=view.RouteStrategyCopy(), method='path'),
    dict(path='/route/plan/list', resource=view.RouteStrategyList(), method='get'),
    dict(path='/route/plan/all', resource=view.RouteStrategyAllDelete(), method='get'),
    dict(path='/route/static/create', resource=view.ProductCreate(), method='post'),
    dict(path='/route/static/{static_route_id}', resource=view.ProductResource(), method='path'),
    dict(path='/route/static/list', resource=view.ProductList(), method='get'),
    dict(path='/route/static/all', resource=view.ProductAllDelete(), method='get'),
    dict(path='/route/static/{static_route_id}/item/create', resource=view.ProductItemsCreate(), method='post'),
    dict(path='/route/static/item/{item_id}', resource=view.ProductItemsResource(), method='path'),
    dict(path='/route/static/item/many/{item_id}', resource=view.ProductItemsManyResource(), method='path'),
    dict(path='/route/static/item/{item_id}/copy', resource=view.ProductItemsCopy(), method='path'),
    dict(path='/route/static/{static_route_id}/item/list', resource=view.ProductItemsList(), method='get'),
    dict(path='/route/static/items/list', resource=view.ProductItemsAllList(), method='get'),
    dict(path='/route/static/item/all', resource=view.ProductItemsAllDelete(), method='get'),
    dict(path='/route/plan/{route_plan_id}/add_route', resource=view.RoutesCreate(), method='post'),
    dict(path='/route/plan/{route_plan_id}/delete_route', resource=view.RoutesDelete(), method='post'),
    dict(path='/route/plan/{route_plan_id}/add_multiple_route', resource=view.MultipleRoutesCreate(), method='post'),
    dict(path='/route/plan/{route_plan_id}/delete_multiple_route', resource=view.MultipleRoutesDelete(), method='post'),
    dict(path='/route/{route_id}', resource=view.RouteResource(), method='path'),
    dict(path='/route/list', resource=view.RouteList(), method='get'),
    dict(path='/route/all', resource=view.RouteAllDelete(), method='get'),
    dict(path='/route/plan/{route_plan_id}/list_routes', resource=view.RoutesList(), method='get'),
    dict(path='/route/dynamic', resource=view.DynamicRouteCreate(), method='post'),
    dict(path='/route/dynamic/{dynamic_route_id}', resource=view.DynamicRouteResource(), method='path'),
    dict(path='/route/dynamic/{dynamic_route_id}/copy', resource=view.DynamicRouteCopy(), method='path'),
    dict(path='/route/dynamic/list', resource=view.DynamicRouteList(), method='get'),
    dict(path='/route/dynamic/all', resource=view.DynamicRouteAllDelete(), method='get'),
    dict(path='/route/dynamic/{dynamic_route_id}/add_trunk', resource=view.DynamicRouteItemCreate(), method='path'),
    dict(path='/route/dynamic/{dynamic_route_id}/add_trunks', resource=view.DynamicRouteItemMultiplyCreate(),
         method='path'),
    dict(path='/route/dynamic/{dynamic_route_id}/remove_trunks', resource=view.DynamicRouteItemMultiplyRemove(),
         method='path'),
    dict(path='/route/dynamic/{dynamic_route_id}/qos/create', resource=view.DynamicRouteQosCreate(), method='post'),
    dict(path='/route/dynamic/qos/{id}', resource=view.DynamicRouteQosResource(), method='path'),
    dict(path='/route/dynamic/{dynamic_route_id}/qos/list', resource=view.DynamicRouteQosInnerList(), method='get'),
    dict(path='/route/dynamic/qos/list', resource=view.DynamicRouteQosList(), method='get'),
    dict(path='/route/dynamic/{dynamic_route_id}/pri/create', resource=view.DynamicRoutePriCreate(), method='post'),
    dict(path='/route/dynamic/pri/{id}', resource=view.DynamicRoutePriResource(), method='path'),
    dict(path='/route/dynamic/{dynamic_route_id}/pri/list', resource=view.DynamicRoutePriList(), method='get'),
    dict(path='/route/dynamic/{dynamic_route_id}/override/create', resource=view.DynamicRouteOverCreate(),
         method='post'),
    dict(path='/route/dynamic/override/{id}', resource=view.DynamicRouteOverResource(), method='path'),
    dict(path='/route/dynamic/{dynamic_route_id}/override/list', resource=view.DynamicRouteOverList(), method='get'),
    dict(path='/route/block', resource=view.ResourceBlockCreate(), method='post'),
    dict(path='/route/block/{res_block_id}', resource=view.ResourceBlockResource(), method='path'),
    dict(path='/route/block/list', resource=view.ResourceBlockList(), method='get'),
    dict(path='/route/block/all', resource=view.ResourceBlockAllDelete(), method='get'),
    dict(path='/route/digit_map', resource=view.DigitTranslationCreate(), method='post'),
    dict(path='/route/digit_map/{translation_id}', resource=view.DigitTranslationResource(), method='path'),
    dict(path='/route/digit_map/list', resource=view.DigitTranslationList(), method='get'),
    dict(path='/route/digit_map/all', resource=view.DigitTranslationAllDelete(), method='get'),
    dict(path='/route/digit_map/{translation_id}/item', resource=view.TranslationItemCreate(), method='post'),
    dict(path='/route/digit_map/item/{ref_id}', resource=view.TranslationItemResource(), method='path'),
    dict(path='/route/digit_map/{translation_id}/item/list', resource=view.TranslationItemList(), method='get'),
    dict(path='/route/digit_map/item/all', resource=view.TranslationItemAllDelete(), method='get')
]
_Switch = [
    # ge2p(rate_table, 'rate_table', 'rate_table_id')+
    dict(path='/switch', resource=view.VoipGatewayCreate(), method='post'),
    dict(path='/switch/{switch_id}', resource=view.VoipGatewayResource(), method='path'),
    dict(path='/switch/list', resource=view.VoipGatewayList(), method='get'),
    dict(path='/switch/full/list', resource=view.VoipGatewayFullList(), method='get'),
    dict(path='/switch/{switch_id}/reload', resource=view.VoipGatewayReloadResource(), method='path'),
    dict(path='/switch/{switch_id}/sip_host/create', resource=view.SipHostCreate(), method='post'),
    dict(path='/switch/sip_host/{id}', resource=view.SipHostResource(), method='path'),
    dict(path='/switch/sip_host/list', resource=view.SipHostList(), method='get'),
    # dict(path='/switch/profile', resource=view.SwitchProfileCreate(), method='post' ),
    dict(path='/switch/capacity/{id}', resource=view.SwitchProfileResource(), method='path'),
    dict(path='/switch/capacity/list', resource=view.SwitchProfileList(), method='get'),
    dict(path='/switch/code/create', resource=view.CodeCreate(), method='post'),
    dict(path='/switch/code/{code_id}', resource=view.CodeResource(), method='path'),
    dict(path='/switch/code/list', resource=view.CodeList(), method='get'),
    dict(path='/switch/code/unique/list', resource=view.CodeUniqueList(), method='get'),
    dict(path='/switch/code/all', resource=view.CodeAllDelete(), method='get'),
    dict(path='/switch/destination/list', resource=view.CodeDestinationList(), method='get'),
    dict(path='/switch/code_deck/create', resource=view.CodeDeckCreate(), method='post'),
    dict(path='/switch/code_deck/{code_deck_id}', resource=view.CodeDeckResource(), method='path'),
    dict(path='/switch/code_deck/list', resource=view.CodeDeckList(), method='get'),
    dict(path='/switch/code_deck/all', resource=view.CodeDeckAllDelete(), method='get'),
    dict(path='/switch/currency/create', resource=view.CurrencyCreate(), method='post'),
    dict(path='/switch/currency/{currency_id}', resource=view.CurrencyResource(), method='path'),
    dict(path='/switch/currency/list', resource=view.CurrencyList(), method='get'),
    dict(path='/switch/rate_table/create', resource=view.RateTableCreate(), method='post'),
    dict(path='/switch/rate_table/{rate_table_id}', resource=view.RateTableResource(), method='path'),
    dict(path='/switch/rate_table/{rate_table_id}/copy', resource=view.RateTableCopyTo(), method='path'),
    dict(path='/switch/rate_table/list', resource=view.RateTableList(), method='get'),
    dict(path='/switch/rate_table/all', resource=view.RateTableAllDelete(), method='delete'),
    dict(path='/switch/rate_table/{rate_table_id}/rate', resource=view.RateCreate(), method='post'),
    dict(path='/switch/rate_table/{rate_table_id}/rates', resource=view.RateManyCreate(), method='post'),
    dict(path='/switch/rate_table/{rate_table_id}/edit_rates', resource=view.RateManyResource(), method='path'),
    dict(path='/switch/rate_table/{rate_table_id}/mass_edit', resource=view.RateMassEditResource(), method='path'),
    dict(path='/switch/rate_table/{rate_table_id}/assign_trunks', resource=view.RateTableAssignTrunks(), method='path'),
    dict(path='/switch/rate_table/{rate_table_id}/rate/list', resource=view.RateList(), method='get'),
    dict(path='/switch/rate_table/{rate_table_id}/rate.csv', resource=view.RateCsvList(), method='get'),
    dict(path='/switch/rate_table/{rate_table_id}/code_name', resource=view.RateCodeNameList(), method='get'),
    dict(path='/switch/rate_table/{rate_table_id}/effective_date', resource=view.RateEffectiveDate(), method='get'),
    dict(path='/switch/rate/{rate_id}', resource=view.RateResource(), method='path'),
    dict(path='/switch/rate/all', resource=view.RateAllDelete(), method='path'),
    dict(path='/switch/rate_code/{rate_table_id}/{code}', resource=view.RateByCodeResource(), method='path'),
    dict(path='/switch/rate_code/{rate_table_id}/send_to_clients', resource=view.RateSendToClients(), method='post'),
    dict(path='/switch/random_ani_group', method='post', resource=view.RandomAniGroupCreate()),
    dict(path='/switch/random_ani_group/{id}', method='path', resource=view.RandomAniGroupResource()),
    dict(path='/switch/random_ani_group_numbers/{group_id}', method='delete', resource=view.RandomAniGroupNumbersDelete()),
    dict(path='/switch/random_ani_group/list', method='get', resource=view.RandomAniGroupList()),
    dict(path='/switch/random_ani', method='post', resource=view.RandomAniGenerationCreate()),
    dict(path='/switch/random_ani/{id}', method='path', resource=view.RandomAniGenerationResource()),
    dict(path='/switch/random_ani/list', method='get', resource=view.RandomAniGenerationList()),
    dict(path='/switch/random_ani/all', method='get', resource=view.RandomAniGenerationAllDelete()),
]
_Tool = [
    dict(path='/tool/verify_cert', resource=view.VerifyCertificate(), method='get'),
    dict(path='/tool/verify_sti_identity', resource=view.VerifyTokenHeader(), method='post'),
    dict(path='/tool/simulate_call', resource=view.ClientCdrSimulateCallCreate(), method='post'),
    dict(path='/tool/switch/{switch_id}/kill_all_sip_channels', resource=view.VoipGatewayKillAllChannels(),
         method='post'),
    dict(path='/tool/switch/{switch_id}/kill_sip_channel/{uuid}', resource=view.VoipGatewayKillChannel(),
         method='post'),
    dict(path='/tool/rate_generation', resource=view.RateGenerationTemplateCreate(), method='post'),
    dict(path='/tool/rate_generation/{id}', resource=view.RateGenerationTemplateResource(), method='path'),
    dict(path='/tool/rate_generation/{id}/start', resource=view.RateGenerationHistoryCreate(), method='post'),
    dict(path='/tool/rate_generation/list', resource=view.RateGenerationTemplateList(), method='get'),
    dict(path='/tool/rate_generation/all', resource=view.RateGenerationTemplateAllDelete(), method='get'),
    dict(path='/tool/rate_generation/rates/{rate_generation_history_id}', resource=view.RateGenerationRateList(),
         method='get'),
    dict(path='/tool/rate_type_override/list', resource=view.RateTypeOverrideList(), method='get'),
    dict(path='/tool/rate_type_override/{id}', resource=view.RateTypeOverrideResource(), method='path'),
    dict(path='/tool/rate_type_override/many', resource=view.RateTypeOverrideManyResource(), method='path'),
    dict(path='/tool/rate_type_override/trunk/{trunk_id}', resource=view.RateTypeOverrideByTrunkResource(), method='path'),
    dict(path='/tool/rate_generation/apply/{id}', resource=view.RateGenerationHistoryApply(), method='path'),
    dict(path='/tool/rate_generation/what_if/{id}/{rate_table_id}', resource=view.RateGenerationTemplateWhatIf(), method='get'),
    dict(path='/tool/rerate', resource=view.RerateCdrTaskCreate(), method='post'),
    dict(path='/tool/rerate/{id}', resource=view.RerateCdrTaskResource(), method='path'),
    dict(path='/tool/rerate/list', resource=view.RerateCdrTaskList(), method='get'),
    # old rate upload
    # dict(path='/tool/rate/upload', resource=view.RateUploadTaskCreate(), method='post'),
    # dict(path='/tool/rate/upload/{id}', resource=view.RateUploadTaskResource(), method='post'),
    # dict(path='/tool/rate/upload/{id}/orig', resource=view.RateUploadTaskDownloadOrig(), method='get'),
    # dict(path='/tool/rate/upload/{id}/format', resource=view.RateUploadTaskDownloadFormat(), method='get'),
    # dict(path='/tool/rate/upload/{id}/error', resource=view.RateUploadTaskDownloadError(), method='get'),
    # dict(path='/tool/rate/upload/list', resource=view.RateUploadTaskList(), method='get'),
    # dict(path='/tool/rate/upload/all', resource=view.RateUploadTaskAllDelete(), method='get'),
    # dict(path='/tool/rate/upload/{id}/preview', resource=view.RateUploadValuesList(), method='get'),
    # dict(path='/tool/rate/upload/{id}/approve', resource=view.RateUploadTaskApproveResource(), method='post'),
    # dict(path='/tool/rate/upload/{id}/get_header/{start_from}', resource=view.RateUploadTaskGetHeader(), method='post'),

    dict(path='/tool/rate/import/create', method='post', resource=view.RateImportTaskCreate()),
    dict(path='/tool/rate/import/public/create', method='post', resource=view.RateImportTaskCreatePublic()),
    dict(path='/tool/rate/import/{id}', method='path', resource=view.RateImportTaskResource()),
    dict(path='/tool/rate/import/list', method='get', resource=view.RateImportTaskList()),
    dict(path='/tool/rate_analysis_task', method='post', resource=view.RateAnalysisTaskCreate()),
    dict(path='/tool/rate_analysis_task/{task_id}', method='get', resource=view.RateAnalysisTaskResource()),
    dict(path='/tool/rate_analysis_summary/{rate_table_id}', method='get', resource=view.RateAnalysisSummaryResource()),
    dict(path='/tool/rate_analysis/{code}/LCR', method='get', resource=view.RateAnalysisLCR()),
    dict(path='/tool/lcr_task', method='post', resource=view.LcrTaskCreate()),
    dict(path='/tool/lcr_task/{task_id}', method='path', resource=view.LcrTaskResource()),
    dict(path='/tool/lcr_task/list', method='get', resource=view.LcrTaskList()),
    dict(path='/tool/rate/import/{id}/orig/rate.csv', method='path', resource=view.RateImportTaskDownloadOrig()),
    dict(path='/tool/rate/import/{id}/format/rate.csv', method='path', resource=view.RateImportTaskDownloadFormat()),
    dict(path='/tool/rate/import/{id}/error/rate_import.log', method='path',
         resource=view.RateImportTaskDownloadError()),

    dict(path='/tool/rate_upload_template', resource=view.RateUploadTemplateCreate(), method='post'),
    dict(path='/tool/rate_upload_template/{id}', resource=view.RateUploadTemplateResource(), method='path'),
    dict(path='/tool/rate_upload_template/list', resource=view.RateUploadTemplateList(), method='get'),
    dict(path='/tool/rate_auto_import_rule', resource=view.RateAutoImportRuleCreate(), method='post'),
    dict(path='/tool/rate_auto_import_rule/{id}', resource=view.RateAutoImportRuleResource(), method='path'),
    dict(path='/tool/rate_auto_import_rule/list', resource=view.RateAutoImportRuleList(), method='get'),
    dict(path='/tool/send_rate', resource=view.RateSendCreate(), method='post'),
    dict(path='/tool/send_rate/{job_id}/resend', resource=view.RateSendCopyCreate(), method='post'),
    dict(path='/tool/send_rate/rate_download/{token}', resource=view.RateSendLogGet(), method='get'),
    dict(path='/tool/send_rate/rate_request/{id}', resource=view.RateSendLogResultGet(), method='get'),
    dict(path='/tool/send_rate/list', resource=view.RateSendList(), method='get'),
    dict(path='/tool/send_rate/all', resource=view.RateSendAllDelete(), method='get'),
    dict(path='/tool/send_rate/detail_list', resource=view.RateSendDetailList(), method='get'),
    # dict(path='/tool/pcap/query', resource=view.PcapQueryCreate(), method='post'),
    # dict(path='/tool/pcap/query/{query_key}', resource=view.PcapQueryResource(), method='path'),
    # dict(path='/tool/pcap/query/{query_key}/restart', resource=view.PcapQueryRestart(), method='path'),
    # dict(path='/tool/pcap/download/{query_key}', resource=view.PcapQueryGet(), method='get'),
    # dict(path='/tool/pcap/log', resource=view.PcapQueryList(), method='get'),
    dict(path='/tool/pcap/query_task/create', method='post', resource=view.PcapQueryTaskCreate()),
    dict(path='/tool/pcap/query_task/{id}', method='path', resource=view.PcapQueryTaskResource()),
    dict(path='/tool/pcap/query_task/list', method='get', resource=view.PcapQueryTaskList()),
    dict(path='/tool/pcap/download_result/{id}', resource=view.PcapQueryTaskGet(), method='get'),
    dict(path='/tool/pcap/send_mail/{id}', resource=view.PcapQueryTaskSendMail(), method='get'),
    dict(path='/tool/pcap/show_stir_shaken/{id}', resource=view.ShowStirShaken(), method='get'),
    dict(path='/tool/lcr_test/create', resource=view.LcrTestCreate(), method='post'),
    dict(path='/tool/lcr_test/{id}', resource=view.LcrTestResource(), method='path'),
    dict(path='/tool/lcr_test/{id}/call', resource=view.LcrTestCall(), method='get'),
    # dict(path='/tool/cdr_task/create', resource=view.CdrDownloadTaskCreate(), method='post'),
    # dict(path='/tool/cdr_task/{request_uuid}/{file_name}', resource=view.CdrDownloadTaskResource(), method='get'),
    # dict(path='/tool/cdr_task/list', resource=view.CdrDownloadTaskList(), method='get'),
    dict(path='/tool/rt_callback/{request_uuid}', resource=view.RtCallbackResource(), method='post'),
    dict(path='/tool/calls/create', resource=testcall.CallingRequestCreate(), method='post'),
    dict(path='/tool/calls/{req_uuid}', resource=testcall.CallingRequestResource(), method='get'),
    dict(path='/tool/calls/list', resource=testcall.CallingRequestList(), method='get'),
    dict(path='/tool/call/{call_id}/{file}', resource=testcall.CallingCallResource(), method='get'),
    dict(path='/tool/call/track/create', resource=testcall.CallingTrackCreate(), method='post'),
    dict(path='/tool/call/track/{uuid}', resource=testcall.CallingTrackResource(), method='post'),
    dict(path='/tool/call/track/list', resource=testcall.CallingTrackList(), method='get'),
    # dict(path='/rt/cdr_get', resource=rt_proxy.RtSyncGet(), method='get'),
    dict(path='/rt/cdr_get', resource=cdr1.CdrReportList(), method='get'),
    # dict(path='/rt/cdr_request', resource=rt_proxy.RtAsyncPost(), method='post'),
    dict(path='/rt/cdr_request', resource=cdr.CdrAsyncTaskCreate(), method='post'),
    # dict(path='/rt/cdr_request/{request_id}', resource=rt_proxy.RtAsyncGet(), method='get'),
    dict(path='/rt/cdr_request/{request_id}', resource=cdr.CdrAsyncTaskGet(), method='get'),
    # dict(path='/rt/cdr_request/{request_id}', resource=rt_proxy.RtAsyncDelete(), method='delete'),
    dict(path='/rt/cdr_request/{request_id}', resource=cdr.CdrAsyncTaskGet(), method='delete'),
    # dict(path='/rt/cdr_request/{request_id}/restart', resource=rt_proxy.RtAsyncRestart(), method='post'),
    dict(path='/rt/cdr_request/{request_id}/stop', resource=cdr.CdrAsyncTaskStop(), method='post'),

    dict(path='/rt/cdr_request/{request_id}/restart', resource=cdr.CdrAsyncTaskRestart(), method='post'),
    # dict(path='/rt/cdr_request/{request_id}/sendmail', resource=rt_proxy.RtAsyncSend(), method='post'),
    dict(path='/rt/cdr_request/{request_id}/sendmail', resource=cdr.CdrAsyncTaskSendMail(), method='post'),
    # dict(path='/rt/cdr_request/{request_id}/download', resource=rt_proxy.RtAsyncOpenFile(), method='get'),
    dict(path='/rt/cdr_request/{request_id}/download', resource=cdr.CdrAsyncTaskDownload(), method='get'),
    # dict(path='/rt/cdr_request/list', resource=rt_proxy.RtAsyncList(), method='get'),
    dict(path='/rt/cdr_request/list', resource=cdr.CdrAsyncTaskList(), method='get'),
    # dict(path='/rt/report', resource=rt_proxy.RtReportGet(), method='get'),
    dict(path='/rt/report', resource=report.Report(), method='get'),
    dict(path='/rt/simple_report', resource=report.ReportSimple(), method='get'),
    # dict(path='/rt/qos', resource=rt_proxy.RtQosPost(), method='post'),
    # dict(path='/rt/qos/{port}', resource=rt_proxy.RtWsHelper(), method='get'),
    # dict(path='/rt/ports_status', resource=rt_proxy.RtPortStatus(), method='get'),
    dict(path='/tool/cdr_export_task', method='post', resource=view.CdrExportTaskCreate()),
    dict(path='/tool/cdr_export_task/{id}', method='path', resource=view.CdrExportTaskResource()),
    dict(path='/tool/cdr_export_task/list', method='get', resource=view.CdrExportTaskList()),

    dict(path='/routing/block_number/import', method='post', resource=view.BlockNumberImportTaskCreate()),
    dict(path='/routing/block_number/{id}/log', method='get', resource=view.BlockNumberImportTaskLogGet()),
    dict(path='/routing/block_number/list', method='get', resource=view.BlockNumberImportTaskList()),

    dict(path='/tool/did_number_upload_task', method='post', resource=view.DidNumberUploadTaskCreate()),
    dict(path='/tool/did_number_upload_task/{id}', method='path', resource=view.DidNumberUploadTaskResource()),
    dict(path='/tool/did_number_upload_task/{id}/log', method='get', resource=view.DidNumberUploadTaskLogGet()),
    dict(path='/tool/did_number_upload_task/list', method='get', resource=view.DidNumberUploadTaskList()),
    dict(path='/tool/did_number_delete_task', method='post', resource=view.DidNumberDeleteTaskCreate()),
    dict(path='/tool/did_number_delete_task/{id}', method='path', resource=view.DidNumberDeleteTaskResource()),
    dict(path='/tool/did_number_delete_task/{id}/log', method='get', resource=view.DidNumberDeleteTaskLogGet()),
    #dict(path='/tool/did_number_delete_task/list', method='get', resource=view.DidNumberDeleteTaskList()),
    #dict(path='/tool/did_number_assign_task', method='post', resource=view.DidNumberAssignTaskCreate()),
    #dict(path='/tool/did_number_assign_task/{id}', method='path', resource=view.DidNumberAssignTaskResource()),
    dict(path='/tool/did_export_async_task', method='post', resource=did_export.DidExportAsyncTaskCreate()),
    dict(path='/tool/did_export_async_task/{id}', method='get', resource=did_export.DidExportAsyncTaskResource()),
    dict(path='/tool/did_export_async_task/list', method='get', resource=did_export.DidExportAsyncTaskList()),

    dict(path='/watchdog/server/{server_ip}/status', method='get', resource=view.WatchdogServerStatusGet()),
    dict(path='/watchdog/server/{server_ip}/{service}/action', method='post', resource=view.WatchdogServiceAction()),

    dict(path='/tool/code_deck_import_task', method='post', resource=view.CodeDeckImportTaskCreate()),
    dict(path='/tool/code_deck_import_task/{id}', method='path', resource=view.CodeDeckImportTaskResource()),
    dict(path='/tool/code_deck_import_task/{id}/log', method='get', resource=view.CodeDeckImportTaskLogGet()),
    dict(path='/tool/code_deck_import_task/list', method='get', resource=view.CodeDeckImportTaskList()),

    dict(path='/tool/get_number_analytic/{number}', method='get', resource=view.NumberAnalyticsGet()),
    dict(path='/tool/check_lerg_db/{number}', method='post', resource=view.CheckLergDb()),
    dict(path='/tool/check_dnc/{number}', method='post', resource=view.CheckDnc()),
    dict(path='/tool/check_dno/{number}', method='post', resource=view.CheckDno()),
    dict(path='/tool/check_youmail/{number}', method='post', resource=view.CheckYoumail()),
    dict(path='/tool/check_ftc/{number}', method='post', resource=view.CheckFtc()),
    dict(path='/tool/check_lrn/{number}', method='post', resource=view.CheckLrn()),

]
_Trunk = [
    dict(path='/trunk/list', resource=view.ResourceList(), method='get'),
    dict(path='/trunk/gatewaygroup/list', resource=view.ResourceGatewayGroupList(), method='get'),
    dict(path='/trunk/unclaimed/list', resource=view.ResourceUnclaimedList(), method='get'),
    dict(path='/trunk/egress/list', resource=view.ResourceEgressList(), method='get'),
    dict(path='/trunk/egress/small/list', resource=view.ResourceEgressSmallList(), method='get'),
    dict(path='/trunk/egress/all', resource=view.EgressTrunkResourceAll(), method='get'),
    dict(path='/trunk/ingress/list', resource=view.ResourceIngressList(), method='get'),
    dict(path='/trunk/ingress/orig_vendor/list', resource=view.ResourceIngressOrigVendorList(), method='get'),
    dict(path='/trunk/ingress/all', resource=view.IngressTrunkResourceAll(), method='get'),
    dict(path='/trunk/egress/{trunk_id}/save_as_template', resource=view.EgressTrunkTemplateFromResourceCreate(),
         method='post'),
    dict(path='/trunk/ingress/{trunk_id}/save_as_template', resource=view.IngressTrunkTemplateFromResourceCreate(),
         method='post'),
    dict(path='/trunk/egress/{trunk_id}/reapply/{template_id}', resource=view.EgressTrunkReapplyTemplate(),
         method='path'),
    dict(path='/trunk/ingress/{trunk_id}/reapply/{template_id}', resource=view.IngressTrunkReapplyTemplate(),
         method='path'),
    dict(path='/trunk/ingress/{trunk_id}/allowed_send_ip/create', resource=view.AllowedSendToIpCreate(), method='post'),
    dict(path='/trunk/ingress/{trunk_id}/allowed_send_ip', resource=view.AllowedSendToIpResource(), method='patch'),
    dict(path='/trunk/ingress/{trunk_id}/allowed_send_ips', resource=view.AllowedSendToIpList(), method='patch'),
    dict(path='/trunk/allowed_send_ip/{id}', resource=view.AllowedSendToIpByIdResource(), method='patch'),
    dict(path='/trunk/group', resource=view.TrunkGroupCreate(), method='post'),
    dict(path='/trunk/group/{group_id}', resource=view.TrunkGroupResource(), method='path'),
    dict(path='/trunk/group/list', resource=view.TrunkGroupList(), method='get'),
    dict(path='/trunk/group/all', resource=view.TrunkGroupAllDelete(), method='get'),
    dict(path='/trunk/group/{group_id}/add_trunk', resource=view.TrunkGroupAddTrunk(), method='post'),
    dict(path='/trunk/max_channels', resource=view.QosTotalIngressList(), method='get'),
    dict(path='/trunk/{trunk_id}/ip', resource=view.ResourceIpCreate(), method='post'),
    dict(path='/trunk/ip/{resource_ip_id}', resource=view.ResourceIpResource(), method='path'),
    dict(path='/trunk/ip/list', resource=view.ResourceIpList(), method='get'),
    dict(path='/trunk/ip/{resource_ip_id}/limit', resource=view.ResourceIpLimitCreate(), method='post'),
    dict(path='/trunk/ip/{resource_ip_id}/limits', resource=view.ResourceIpLimitsResource(), method='path'),
    dict(path='/trunk/ip/limit/{limit_id}', resource=view.ResourceIpLimitResource(), method='path'),
    dict(path='/trunk/ip/limit/list', resource=view.ResourceIpLimitList(), method='get'),
    dict(path='/trunk/ip/limit_ext/list', resource=view.ResourceIpLimitExtList(), method='get'),
    dict(path='/trunk/{trunk_id}/prefix', resource=view.ResourcePrefixCreate(), method='post'),
    dict(path='/trunk/prefix/{id}', resource=view.ResourcePrefixResource(), method='path'),
    dict(path='/trunk/{trunk_id}/prefix/list', resource=view.ResourcePrefixList(), method='get'),
    dict(path='/trunk/prefix/list', resource=view.ResourcePrefixFullList(), method='get'),
    dict(path='/trunk/{trunk_id}/direction', resource=view.ResourceDirectionCreate(), method='post'),
    dict(path='/trunk/{trunk_id}/directions', resource=view.TrunkWithDirectionResource(), method='path'),
    dict(path='/trunk/direction/{direction_id}', resource=view.ResourceDirectionResource(), method='path'),
    dict(path='/trunk/{trunk_id}/direction/list', resource=view.ResourceDirectionList(), method='get'),
    dict(path='/trunk/{trunk_id}/ocn', resource=view.ResourceOcnCreate(), method='post'),
    dict(path='/trunk/ocn/{id}', resource=view.ResourceOcnResource(), method='path'),
    dict(path='/trunk/{trunk_id}/ocn/list', resource=view.ResourceOcnList(), method='get'),
    dict(path='/trunk/{trunk_id}/replace_action', resource=view.ResourceReplaceActionCreate(), method='post'),
    dict(path='/trunk/{trunk_id}/replace_actions', resource=view.TrunkWithReplaceActionResource(), method='path'),
    dict(path='/trunk/replace_action/{id}', resource=view.ResourceReplaceActionResource(), method='path'),
    dict(path='/trunk/{trunk_id}/replace_action/list', resource=view.ResourceReplaceActionList(), method='get'),
    dict(path='/trunk/{trunk_id}/{digit_map_id}/{time_profile_id}/add_digit_map',
         resource=view.ResourceTranslationRefCreate(), method='post'),
    dict(path='/trunk/digit_map/{ref_id}', resource=view.ResourceTranslationRefResource(), method='path'),
    dict(path='/trunk/{trunk_id}/digit_map/list', resource=view.ResourceTranslationRefList(), method='get'),
    dict(path='/trunk/rate_summary/list', resource=view.IngressTrunkRateSummaryList(), method='get'),
    dict(path='/trunk/rate_summary_unique/list', resource=view.IngressTrunkRateSummaryUniqueList(), method='get'),
    dict(path='/trunk/{trunk_id}/send_interop', resource=view.TrunkSendInterop(), method='path'),
    dict(path='/trunk/{trunk_id}/assign_product/{product_id}', resource=view.TrunkAssignProduct(), method='path'),
    dict(path='/ocn_blocklist/list', resource=view.OcnBlocklistList(), method='get'),
    dict(path='/ocn_blocklist/{id}', resource=view.OcnBlocklist(), method='path'),
    dict(path='/ocn_blocklist', resource=view.OcnBlocklistPost(), method='post'),
]
_Ext = [
    dict(path='/paypal/webhook', resource=paypal.PaypalWebhook(), method='post'),
    dict(path='/stripe/webhook', resource=paypal.StripeWebhook(), method='post'),
    dict(path='/stripe/checkout', resource=paypal.StripeCheckout(), method='post'),
#     dict(path='/smshook', resource=smshook.SmsCreate(), method='post'),
    dict(path='/test', resource=smshook.SmsTestHook(), method='post')
]

PRODUCTION_ROUTES = OrderedDict([
    ('Auth', dict(description='Authentication functions', routes=_Auth)),
    ('Agent', _Agent),
    ('AgentPortal', _AgentPortal),
    ('ClientPortal', _ClientPortal),
    ('Carrier', _Carrier),
    ('Config', _Config),
    ('Cloud', _Cloud),
    ('Finance', _Finance),
    ('Log', _Log),
    ('Monitoring', _Monitoring),
    ('Origination', _Origination),
    ('Product', _Product),
    ('Reports', _Reports),
    ('Route', _Route),
    ('Switch', _Switch),
    ('Tool', _Tool),
    ('Trunk', _Trunk),
    ('External', _Ext),
]
)
CLIENT_ROUTES = OrderedDict([
    ('ClientPortal', _ClientPortal),
])

if settings.API_TEST_ROUTES == 'True':
    ROUTES = TEST_ROUTES
else:
    ROUTES = PRODUCTION_ROUTES
