from marshmallow import validate
from marshmallow.fields import Bool, Str, Decimal, Int, Nested, DateTime, Float, List, UUID, Dict

from api_dnl import model
from api_dnl.fields import Choice
from api_dnl.scheme import BaseModelScheme

from api_dnl.scheme import IP_REGEXP, NAME_REGEXP, PREFIX_REGEXP


# region +++AuthorizationLog
class AuthorizationLogGetScheme(BaseModelScheme):
    # --- US Jurisdiction ---
    time = Int()
    login_time = DateTime()
    username = Str()
    status = Choice()
    login_ip = Str()
    failed_reason = Choice()
    # entered_password = Str()
    agent = Str()
    direction = Str()
    referer = Str()

    class Meta:
        model = model.AuthorizationLog
        fields = ('login_time', 'username', 'status', 'login_ip',
                  'failed_reason',  # 'entered_password',
                  'agent', 'direction', 'referer')
        search_fields = ('username', 'status', 'login_ip',
                         'failed_reason', 'agent')
        query_fields = ('login_time_gt', 'login_time_lt')


# endregion  ---AuthorizationLog
# region +++PgStatActivity
class PgStatActivityScheme(BaseModelScheme):
    usename = Str()
    query_text = Str()
    pid = Int()
    query_start = DateTime()

    class Meta:
        model = model.PgStatActivity
        fields = ('pid', 'query_start', 'usename', 'query_text')


# endregion ---PgStatActivity
# region +++WatchdogSystemdLog+++
class WatchdogSystemdLogScheme(BaseModelScheme):
    id = Int()
    server_name = Str()
    time = DateTime()
    service = Str()
    unit = Str()
    priority = Int()
    message = Str()

    class Meta:
        model = model.WatchdogSystemdLog
        fields = ('server_name', 'time', 'service', 'unit', 'priority', 'message',)


class WatchdogSystemdLogSchemeGet(WatchdogSystemdLogScheme):
    class Meta:
        model = model.WatchdogSystemdLog
        fields = ('server_name', 'time', 'service', 'unit', 'priority', 'message',)
        search_fields = ('id', 'server_name', 'service', 'unit', 'priority', 'message',)
        query_fields = ('time_gt', 'time_lt',)


class WatchdogSystemdLogSchemeModify(WatchdogSystemdLogScheme):
    pass


# endregion ---WatchdogSystemdLog---
# region +++WatchdogSystemdEvents+++
class WatchdogSystemdEventsScheme(BaseModelScheme):
    id = Int()
    server_name = Str()
    time = DateTime()
    service = Str()
    unit = Str()
    event = Str()
    message = Str()

    class Meta:
        model = model.WatchdogSystemdEvents
        fields = ('server_name', 'time', 'service', 'unit', 'event', 'message',)


class WatchdogSystemdEventsSchemeGet(WatchdogSystemdEventsScheme):
    class Meta:
        model = model.WatchdogSystemdEvents
        fields = ('server_name', 'time', 'service', 'unit', 'event', 'message',)
        search_fields = ('id', 'server_name', 'service', 'unit', 'event', 'message',)
        query_fields = ('time_gt', 'time_lt',)


class WatchdogSystemdEventsSchemeModify(WatchdogSystemdEventsScheme):
    pass


# endregion ---WatchdogSystemdEvents---

# region +++DidClientLog+++
class DidClientLogScheme(BaseModelScheme):
    id = Int()
    did = Str(validate=[validate.Length(max=50)])
    client_id = Int()
    sell_billing_plan_id = Int()
    buy_billing_plan_id = Int()
    ingress_res_id = Int()
    egress_res_id = Int()
    start_date = DateTime()
    assigned_on = DateTime()
    assigned_by = Int()
    released_on = DateTime()
    released_by = Int()
    assign_method = Choice()
    release_method = Choice()
    created_on = DateTime()

    class Meta:
        model = model.DidClientLog
        fields = ('did', 'client_id', 'sell_billing_plan_id', 'buy_billing_plan_id',
                  'ingress_res_id', 
                  'assigned_on', 'assigned_by', 'released_on', 'released_by', 'assign_method',
                  'release_method', 'created_on')


class DidClientLogSchemeGet(DidClientLogScheme):
    assigned_by_name = Str()
    released_by_name = Str()
    is_available = Bool()
    is_assigned = Bool()

    class Meta:
        model = model.DidClientLog
        fields = ('id', 'did', 'client_id', 'sell_billing_plan_id', 'buy_billing_plan_id',
                  'ingress_res_id', 'egress_res_id', 'start_date', 'is_assigned', 'did_vendor_name', 
                  'assigned_on', 'assigned_by', 'released_on', 'released_by', 'assign_method',
                  'release_method', 'assigned_by_name', 'released_by_name', 'is_available')
        search_fields = (
        'id', 'did', 'client_id', 'sell_billing_plan_id', 'buy_billing_plan_id',
        'ingress_res_id', 'egress_res_id', 'start_date', 'assigned_by', 'released_by',
        'assign_method', 'release_method', 'assigned_by_name', 'released_by_name')
        query_fields = ('assigned_on_gt', 'assigned_on_lt', 'released_on_gt', 'released_on_lt',)


class DidClientLogSchemeModify(DidClientLogScheme):
    pass


# endregion ---DidClientLog---

# region ---DidRepositoryLog---

class DidRepositoryLogScheme(BaseModelScheme):
    id = Int()
    did = Str(validate=[validate.Length(max=50)])
    vendor_trunk_id = Int()
    vendor_billing_plan_id = Int()
    created_at = DateTime()
    created_by = Int()
    deleted_at = DateTime()
    deleted_by = Int()

    class Meta:
        model = model.DidRepositoryLog
        fields = (
        'id', 'did', 'vendor_trunk_id', 'vendor_billing_plan_id', 'created_at', 'created_by', 'deleted_at', 'deleted_by')


class DidAssignmentsLogScheme(BaseModelScheme):
    id = Int()
    did = Str(validate=[validate.Length(max=50)])
    vendor_trunk_id = Int()
    vendor_billing_plan_id = Int()
    client_trunk_id = Int()
    client_billing_plan_id = Int()
    fallback_id = Int()
    created_at = DateTime()
    created_by = Int()
    deleted_at = DateTime()
    deleted_by = Int()

    class Meta:
        model = model.DidAssignmentsLog
        fields = (
            'id', 'did', 'vendor_trunk_id', 'vendor_billing_plan_id', 'client_trunk_id', 'client_billing_plan_id',
            'fallback_id', 'created_at', 'created_by', 'deleted_at', 'deleted_by')

        search_fields = ('did', 'vendor_trunk_id', 'vendor_billing_plan_id', 'client_trunk_id',
                         'client_billing_plan_id', 'fallback_id')



# endregion +++DidRepositoryLog+++

# region +++DidVendorLog+++
class DidVendorLogScheme(BaseModelScheme):
    id = Int()
    did = Str(validate=[validate.Length(max=50)])
    vendor_id = Int()
    created_on = DateTime()
    created_by = Int()

    deleted_on = DateTime()
    deleted_by = Int()

    created_method = Choice()
    delete_method = Choice()
    api_vendor_type = Choice()

    class Meta:
        model = model.DidVendorLog
        fields = (
        'did', 'vendor_id', 'created_on', 'created_by', 'deleted_on', 'deleted_by', 'created_method', 'delete_method',
        'api_vendor_type',)


class DidVendorLogSchemeGet(DidVendorLogScheme):
    created_by_name = Str()
    deleted_by_name = Str()

    class Meta:
        model = model.DidVendorLog
        fields = ('id', 'did', 'vendor_id', 'created_on', 'created_by', 'deleted_on', 'deleted_by', 'created_method',
                  'delete_method', 'api_vendor_type', 'created_by_name', 'deleted_by_name')
        search_fields = (
        'id', 'did', 'vendor_id', 'created_by', 'deleted_by', 'created_method', 'delete_method', 'api_vendor_type',
        'deleted_by_name')
        query_fields = ('created_on_gt', 'created_on_lt', 'deleted_on_gt', 'deleted_on_lt',)


class DidVendorLogSchemeModify(DidVendorLogScheme):
    pass
# endregion ---DidVendorLog---
