from falcon_rest.logger import log

from .did_api import DidAPI


class DidAPIMuliVendor(DidAPI):
    def __init__(self, vendors=[]):
        self.vendors = vendors
        self.apis = [v.get_api() for v in vendors]

    def coverage_local(self, country=None, state=None, npa=None, lata=None,group=None):
        ret = []
        for api, vendor_id in [(v.get_api(), v.id) for v in self.vendors]:
            items = api.coverage_local(country,state, npa, lata, group)
            if vendor_id:
                ret = ret + [{**i, 'vendor_id': vendor_id} for i in items]
            else:
                ret = ret + [{**i} for i in items]
        return ret

    def disconnect_local(self, items):
        ret = []
        vendor_id = None
        for api, vendor_id in [(v.get_api(), v.id) for v in self.vendors]:
            try:
                last = api.disconnect_local(items)
                log.debug('mutli disconnect last:{}'.format(str(last)[0:4096]))
            except:
                last = [{'number': i['number'], 'status': 'error'} for i in items]
            ret = ret + [{'number': i['number'], 'status': 'success', 'vendor_id': vendor_id} for i in last if
                         i['status'] != 'error']
            items = [i for i in last if i['status'] == 'error']
            if not items:
                break
        ret = ret + [{'number': i['number'], 'status': i['status'], 'error': i['error'] if 'error' in i else None,
                      'vendor_id': vendor_id} for i in items]
        return ret

    def order_local(self, items, client_id=None):
        ret = []
        numbers = set()
        vendor_id = None
        for api, vendor_id in [(v.get_api(), v.id) for v in self.vendors]:
            try:
                fitems = [i for i in items if 'vendor_id' not in i or i['vendor_id'] == vendor_id or vendor_id is None]
                last = api.order_local(fitems, client_id)
            except:
                last = [{'number': i['number'], 'status': 'error'} for i in items]
            ret = ret + [{'number': i['number'], 'status': 'success', 'vendor_id': vendor_id or i['vendor_id']
                          } for i in last if
                         i['status'] != 'error']
            items = [i for i in last if i['status'] == 'error']
            if not items:
                break
        ret = ret + [{'number': i['number'], 'status': i['status'], 'error': i['error'] if 'error' in i else None,
                      'vendor_id': vendor_id} for i in items]
        return ret

    def search_local(self, country=None, state=None, npa=None, lata=None, pattern=None, count=100, client_id=None, order=None, nxx=None):
        ret = []
        numbers = set()
        repeat = 0
        count = int(count)
        log.debug('search vendors {}'.format([v.vendor.name for v in self.vendors]))
        try:
            while len(ret) < count:
                for api, vendor_id in [(v.get_api(), v.id) for v in self.vendors]:
                    cnt = count  # int(1 + count / len(self.vendors))
                    items = api.search_local(country,state, npa, lata, pattern, cnt, client_id, nxx)
                    if order:
                        reverse = order[1] != 'asc'
                        items.sort(reverse=reverse, key=lambda i: i[order[0]])
                    if items:
                        ret = ret + [{**i, 'vendor_id': vendor_id if vendor_id else i['vendor_id']} for i in items if
                                     i['number'] not in numbers]
                        numbers = numbers.union(set([i['number'] for i in items]))
                repeat += 1
                if repeat > 2:
                    break
        except Exception as e:
            log.debug('error on search ret ={} '.format(ret))
            log.debug('error on search {}'.format(e))
            import traceback
            trace = traceback.format_exc()
            log.error(trace)

        return ret[:count]

    def search_order_local(self, country=None, state=None, npa=None, lata=None, count=100, client_id=None, nxx=None):
        items = self.search_local(country,state, npa, lata, pattern=None, count=count, nxx=nxx)
        order = self.order_local(items, client_id)
        return order

    def coverage_toll_free(self, state=None, npa=None, lata=None):
        ret = []
        for api, vendor_id in [(v.get_api(), v.id) for v in self.vendors]:
            items = api.coverage_toll_free(state, npa, lata)
            ret = ret + [{**i, 'vendor_id': vendor_id} for i in items]
        return ret

    def disconnect_toll_free(self, items):
        ret = []
        vendor_id = None
        for api, vendor_id in [(v.get_api(), v.id) for v in self.vendors]:
            try:
                last = api.disconnect_toll_free(items)
                log.debug('mutli disconnect last:{}'.format(str(last)[0:4096]))
            except:
                last = [{'number': i['number'], 'status': 'error'} for i in items]
            ret = ret + [{'number': i['number'], 'status': 'success', 'vendor_id': vendor_id} for i in last if
                         i['status'] != 'error']
            items = [i for i in last if i['status'] == 'error']
            if not items:
                break
        ret = ret + [{'number': i['number'], 'status': i['status'], 'error': i['error'] if 'error' in i else None,
                      'vendor_id': vendor_id} for i in items]
        return ret

    def order_toll_free(self, items, routing_label=None, client_id=None):
        ret = []
        vendor_id = None
        for api, vendor_id in [(v.get_api(), v.id) for v in self.vendors]:
            try:
                fitems = [i for i in items if 'vendor_id' not in i or i['vendor_id'] == vendor_id]
                last = api.order_toll_free(fitems, routing_label,client_id)
            except Exception as e:
                last = [{'number': i['number'], 'status': 'error', 'error': str(e)} for i in items]
            ret = ret + [{'number': i['number'], 'status': 'success',
                          'vendor_id': i['vendor_id'] if 'vendor_id' in i else vendor_id} for i in last if
                         i['status'] != 'error']
            items = [i for i in last if i['status'] == 'error']
            if not items:
                break
        ret = ret + [{'number': i['number'], 'status': i['status'], 'error': i['error'] if 'error' in i else None,
                      'vendor_id': vendor_id} for i in items]
        return ret

    def search_toll_free(self, pattern=None, count=100, client_id=None):
        ret = []
        numbers = set()
        repeat = 0
        count = int(count)
        log.debug('search vendors {}'.format([v.vendor.name for v in self.vendors]))
        try:
            while len(ret) < count:
                for api, vendor_id in [(v.get_api(), v.id) for v in self.vendors]:
                    cnt = count  # 1 + count / len(self.vendors)
                    items = api.search_toll_free(pattern, cnt, client_id)
                    if items:
                        ret = ret + [{**i, 'vendor_id': vendor_id if vendor_id else i['vendor_id']} for i in items if
                                     i['number'] not in numbers]
                        numbers = numbers.union(set([i['number'] for i in items]))
                repeat += 1
                if repeat > 2:
                    break
        except Exception as e:
            log.debug('error on search ret ={} '.format(ret))
            log.debug('error on search {}'.format(e))
            import traceback
            trace = traceback.format_exc()
            log.error(trace)

        return ret[:count]

    def search_order_toll_free(self, pattern=None, routing_label=None, count=100):
        items = self.search_toll_free(pattern=None, count=count)
        order = self.order_toll_free(items, routing_label)
        return order

    def pending(self):
        ret = []
        numbers = set()
        repeat = 0
        log.debug('search pending in vendors {}'.format([v.vendor.name for v in self.vendors]))
        try:
            for api, vendor_id in [(v.get_api(), v.id) for v in self.vendors]:
                ret = ret + [dict(**i, vendor_id=vendor_id) for i in api.pending()]
        except:
            pass
        log.debug('pending dids found {}'.format(str(ret)[0:4096]))
        return ret
