"""invoice changes

Revision ID: a8ce06fa34e7
Revises: 270171cba240
Create Date: 2021-03-22 14:24:52.299276

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):

from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = 'a8ce06fa34e7'
down_revision = '270171cba240'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('invoice_cdr_log')
    op.drop_table('did_mrc_info')
    op.drop_table('invoice_trunk_prefix_detail')
    op.drop_table('did_port_usage_info')
    op.drop_table('did_setup_fee')
    op.drop_table('did_invoice_number_fee_detail')
    op.drop_table('invoice_country_detail')
    op.drop_table('invoice_trunk_detail')
    op.drop_table('invoice_code_name_detail')
    op.drop_table('invoice_daily_detail')
    op.drop_table('dnl_invoice_history')
    op.drop_constraint('did_billing_rel_sell_billing_plan_id_fkey', 'did_billing_rel', type_='foreignkey')
    op.drop_constraint('did_billing_rel_buy_billing_plan_id_fkey', 'did_billing_rel', type_='foreignkey')
    op.add_column('invoice_summary', sa.Column('invoice_zone', sa.String(length=20), nullable=True))
    op.add_column('invoice_summary', sa.Column('payment_dur_date', sa.Date(), nullable=True))
    op.drop_constraint('ticket_user_name_fkey', 'ticket', type_='foreignkey')
    op.create_foreign_key(None, 'ticket', 'users', ['user_name'], ['name'], ondelete='CASCADE')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, 'ticket', type_='foreignkey')
    op.create_foreign_key('ticket_user_name_fkey', 'ticket', 'users', ['user_name'], ['name'], onupdate='CASCADE', ondelete='CASCADE')
    op.drop_column('invoice_summary', 'payment_dur_date')
    op.drop_column('invoice_summary', 'invoice_zone')
    op.create_foreign_key('did_billing_rel_buy_billing_plan_id_fkey', 'did_billing_rel', 'did_billing_plan', ['buy_billing_plan_id'], ['id'], ondelete='CASCADE')
    op.create_foreign_key('did_billing_rel_sell_billing_plan_id_fkey', 'did_billing_rel', 'did_billing_plan', ['sell_billing_plan_id'], ['id'], ondelete='CASCADE')
    op.create_table('dnl_invoice_history',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('invoice_number', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('invoice_generation_time', postgresql.TIMESTAMP(), autoincrement=False, nullable=True),
    sa.Column('invoice_start_time', postgresql.TIMESTAMP(), autoincrement=False, nullable=True),
    sa.Column('invoice_end_time', postgresql.TIMESTAMP(), autoincrement=False, nullable=True),
    sa.Column('status', sa.SMALLINT(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['invoice_number'], ['invoice_summary.invoice_number'], name='dnl_invoice_history_invoice_number_fkey', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='dnl_invoice_history_pkey')
    )
    op.create_table('invoice_daily_detail',
    sa.Column('invoice_number', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('report_date', sa.DATE(), autoincrement=False, nullable=True),
    sa.Column('did_number', sa.VARCHAR(length=64), autoincrement=False, nullable=True),
    sa.Column('total_calls', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('total_minutes', sa.NUMERIC(), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.Column('total_amount', sa.NUMERIC(), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.Column('inter_calls', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('intra_calls', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('ij_calls', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=True),
    sa.Column('inter_minutes', sa.NUMERIC(), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.Column('intra_minutes', sa.NUMERIC(), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.Column('ij_minutes', sa.NUMERIC(), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.Column('inter_amount', sa.NUMERIC(), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.Column('intra_amount', sa.NUMERIC(), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.Column('ij_amount', sa.NUMERIC(), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.Column('invoice_daily_detail_id', sa.INTEGER(), server_default=sa.text("nextval('invoice_daily_detail_id_seq'::regclass)"), nullable=False),
    sa.ForeignKeyConstraint(['invoice_number'], ['invoice_summary.invoice_number'], name='invoice_daily_detail_invoice_number_fkey', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('invoice_daily_detail_id', name='invoice_daily_detail_pkey')
    )
    op.create_table('invoice_code_name_detail',
    sa.Column('invoice_number', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('code_name', sa.VARCHAR(length=256), autoincrement=False, nullable=False),
    sa.Column('rate', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('total_calls', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('total_minutes', sa.NUMERIC(), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.Column('total_amount', sa.NUMERIC(), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.Column('inter_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ij_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('inter_minutes', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('intra_minutes', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('ij_minutes', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('inter_amount', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('intra_amount', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('ij_amount', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['invoice_number'], ['invoice_summary.invoice_number'], name='invoice_code_name_detail_invoice_number_fkey', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('invoice_number', 'code_name', name='invoice_code_name_detail_pkey')
    )
    op.create_table('invoice_trunk_detail',
    sa.Column('invoice_number', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('trunk_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('total_calls', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('total_minutes', sa.NUMERIC(), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.Column('total_amount', sa.NUMERIC(), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.Column('inter_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ij_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('inter_minutes', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('intra_minutes', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('ij_minutes', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('inter_amount', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('intra_amount', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('ij_amount', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['invoice_number'], ['invoice_summary.invoice_number'], name='invoice_trunk_detail_invoice_number_fkey', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('invoice_number', 'trunk_id', name='invoice_trunk_detail_pkey')
    )
    op.create_table('invoice_country_detail',
    sa.Column('invoice_number', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('country', sa.VARCHAR(length=256), autoincrement=False, nullable=False),
    sa.Column('total_calls', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('total_minutes', sa.NUMERIC(), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.Column('total_amount', sa.NUMERIC(), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['invoice_number'], ['invoice_summary.invoice_number'], name='invoice_country_detail_invoice_number_fkey', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('invoice_number', 'country', name='invoice_country_detail_pkey')
    )
    op.create_table('did_invoice_number_fee_detail',
    sa.Column('invoice_number', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('did_number', sa.VARCHAR(length=64), autoincrement=False, nullable=False),
    sa.Column('nrc', sa.NUMERIC(), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.Column('mrc', sa.NUMERIC(), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['invoice_number'], ['invoice_summary.invoice_number'], name='did_invoice_number_fee_detail_invoice_number_fkey', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('invoice_number', 'did_number', name='did_invoice_number_fee_detail_pkey')
    )
    op.create_table('did_setup_fee',
    sa.Column('invoice_number', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('did_number', sa.VARCHAR(length=64), autoincrement=False, nullable=False),
    sa.Column('fee', sa.NUMERIC(), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('start_date', sa.DATE(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['invoice_number'], ['invoice_summary.invoice_number'], name='did_setup_fee_invoice_number_fkey', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='did_setup_fee_pkey')
    )
    op.create_table('did_port_usage_info',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('invoice_number', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('port_limit_per_did', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('total_port_limit', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('port_usage', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('did_count', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('fee_per_port', sa.NUMERIC(), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.Column('total_fee', sa.NUMERIC(), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.Column('start_date', sa.DATE(), autoincrement=False, nullable=True),
    sa.Column('end_date', sa.DATE(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='did_port_usage_info_pkey')
    )
    op.create_table('invoice_trunk_prefix_detail',
    sa.Column('invoice_number', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('trunk_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('prefix', sa.VARCHAR(length=100), autoincrement=False, nullable=True),
    sa.Column('total_calls', sa.INTEGER(), server_default=sa.text('0'), autoincrement=False, nullable=False),
    sa.Column('total_minutes', sa.NUMERIC(), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.Column('total_amount', sa.NUMERIC(), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.Column('inter_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('intra_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('ij_calls', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('inter_minutes', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('intra_minutes', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('ij_minutes', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('inter_amount', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('intra_amount', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('ij_amount', sa.NUMERIC(), autoincrement=False, nullable=True),
    sa.Column('invoice_trunk_prefix_detail_id', sa.INTEGER(), server_default=sa.text("nextval('invoice_trunk_prefix_detail_id_seq'::regclass)"), nullable=False),
    sa.ForeignKeyConstraint(['invoice_number'], ['invoice_summary.invoice_number'], name='invoice_trunk_prefix_detail_invoice_number_fkey', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('invoice_trunk_prefix_detail_id', name='invoice_trunk_prefix_detail_pkey')
    )
    op.create_table('did_mrc_info',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('invoice_number', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('client_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('did_number', sa.VARCHAR(length=64), autoincrement=False, nullable=False),
    sa.Column('rent', sa.NUMERIC(), server_default=sa.text('0.00'), autoincrement=False, nullable=False),
    sa.Column('start_date', sa.DATE(), autoincrement=False, nullable=True),
    sa.Column('end_date', sa.DATE(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='did_mrc_info_pkey')
    )
    op.create_table('invoice_cdr_log',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('start_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('end_time', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('type', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('invoice_number', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('carrier_name', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='invoice_cdr_log_pkey')
    )
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))