# coding: utf-8

"""
    DNL API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: 1.2.98
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import os
import sys
import unittest

import cli_dnl
from cli_dnl.rest import ApiException
from cli_dnl.apis.agent_api import AgentApi
from . settings import *

def agent():
    ret = cli_dnl.AgentApi().agent_not_assigned_clients_get(per_page=64)
    assert (ret.success)
    random.shuffle(ret.payload.items)
    data = {
        'name':'agent_'+bla(6),
        'carriers': []
    }
    for i in ret.payload.items[0:3]:
        cli = random.choice(ret.payload.items)
        rec = {
            "method_type": random.choice(["By Profit", "By Revenue"]),
            "commission": random.random() * 50,
            "client_id": cli.client_id
        }
        data['carriers'].append(rec)
    print(json.dumps(data))
    return data

class TestAgentApi(unittest.TestCase):
    """ AgentApi unit test stubs """

    def setUp(self):
        self.api = cli_dnl.apis.agent_api.AgentApi()
        auth()

    def tearDown(self):
        pass

    def test_agent_agent_id_add_carrier_post(self):
        """
        Test case for agent_agent_id_add_carrier_post


        """
        pass

    def test_agent_agent_id_assign_products_post(self):
        """
        Test case for agent_agent_id_assign_products_post


        """
        pl = rand_product()[2]
        random.shuffle(pl)
        data ={'products':[pl[0].id,pl[1].id]}
        aid = rand_agent()[0]
        ret = self.api.agent_agent_id_assign_products_patch(agent_id=aid,body=data)
        print(aid,data)
        assert(ret.success)
        ret = self.api.agent_agent_id_assign_products_patch(agent_id=aid, body={'products':[]})
        print(aid, data)
        assert (ret.success)
        pass

    def test_agent_agent_id_carrier_get(self):
        """
        Test case for agent_agent_id_carrier_get

        
        """
        auth()
        ret=self.api.agent_list_get()
        assert (ret.success)
        tr = random.choice(ret.payload.items)
        a  = self.api.agent_agent_id_get(agent_id=tr.agent_id)
        assert (a.success)
        pass

    def test_agent_agent_id_carrier_id_delete(self):
        """
        Test case for agent_agent_id_carrier_id_delete

        
        """
        id=self.test_agent_create_post().object_id

        data = agent()
        del data['name']
        a = self.api.agent_agent_id_carrier_patch(agent_id=id, body=data)
        assert (a.success)
        ret0 = self.api.agent_agent_id_get(id).payload

        ret=self.api.agent_agent_id_carrier_id_delete(agent_id=id,carrier_id=ret0.carriers[0].client_id)
        assert(ret.success)
        pass

    def test_agent_agent_id_carrier_patch(self):
        """
        Test case for agent_agent_id_carrier_patch

        
        """
        auth()
        ret = self.api.agent_list_get(usage_count=0)
        assert (ret.success)
        tr = random.choice(ret.payload.items)
        a = self.api.agent_agent_id_patch(agent_id=tr.agent_id,body={'edit_permission':False})
        assert (a.success)

        a = self.api.agent_agent_id_get(agent_id=tr.agent_id)
        assert (a.success and not a.payload.edit_permission)
        ac = self.api.agent_agent_id_carrier_get(agent_id=tr.agent_id)
        assert (ac.success)

        data=agent()
        del data['name']
        for it in ac.payload.carriers:
            rec = {
                "method_type": it.method_type,
                "commission": it.commission,
                "client_id": it.client_id
            }
            data['carriers'].append(rec)
            # data['carriers'].append(rec)
        a = self.api.agent_agent_id_carrier_patch(agent_id=tr.agent_id, body=data)
        assert (a.success)
        assert (len(a.payload.carriers)==len(data['carriers']))

        id=rand_agent(per_page=100)[0]

        data=agent()
        del data['name']
        a = self.api.agent_agent_id_carrier_patch(agent_id=id, body=data)
        assert (a.success)

        pass

    def test_agent_agent_id_add_carrier_post(self):
        """
        Test case for agent_agent_id_carrier_post


        """
        data=agent()
        del data['name']
        id=rand_agent(per_page=100)[0]
        ret=self.api.agent_agent_id_add_carrier_post(agent_id=id,body=data)
        assert (ret.success)

        a = self.api.agent_agent_id_carrier_get(agent_id=id)
        assert (a.success)
        lst=[c.client_id for c in a.payload.carriers]
        for c in data['carriers']:
            assert(c['client_id'] in lst)
        pass

    def test_agent_agent_id_delete(self):
        """
        Test case for agent_agent_id_delete

        
        """
        r=self.test_agent_create_post()
        ret=self.api.agent_agent_id_delete(agent_id=r.object_id)
        assert(ret.success)
        pass

    def test_agent_agent_id_get(self):
        """
        Test case for agent_agent_id_get

        
        """
        auth()
        ret = self.api.agent_list_get()
        assert (ret.success)
        tr = random.choice(ret.payload.items)
        a = self.api.agent_agent_id_get(agent_id=tr.agent_id)
        assert (a.success)
        pass

    def test_agent_agent_id_patch(self):
        """
        Test case for agent_agent_id_patch

        
        """
        ret = self.api.agent_agent_id_patch(agent_id=rand_agent()[0],body={'name':'ag_'+bla(8)})
        assert (ret.success)
        ag=ret.payload
        if ag.user:
            name=ag.user.name
        else:
            name=ag.agent_name
        ret1 = self.api.agent_agent_id_patch(agent_id=ag.agent_id, body={'agent_name': ret.payload.agent_name,
                                                                                  'user':{'name':name,
                                                                                          'avatar_id':rand_png()[0]}})
        assert (ret.success)
        lst=rand_agent()[2]
        random.shuffle(lst)
        id =  None
        for ag in lst:
            id=ag.agent_id
            if ag.agent_id != ret.payload.agent_id:
                break
        try:
            ret2 = self.api.agent_agent_id_patch(agent_id=id, body={'agent_name': ret.payload.agent_name})
            assert (not ret2.success)
        except Exception as e:
            assert ('Agent already exists' in str(e))
        pass

    def test_agent_agent_id_products_list_get(self):
        """
        Test case for agent_agent_id_products_list_get


        """
        a_id = rand_agent(usage_count_gt=0)[0]
        # a = auth_a(agent_id=18)
        print('GET/agent/{}/product/list'.format(a_id))
        ret = self.api.agent_agent_id_products_list_get(agent_id=a_id)
        assert (ret.success)
        assert(len(ret.payload.items))
        print(ret)
        pass

    def test_agent_all_delete(self):
        """
        Test case for agent_all_delete


        """
        for i in range(0,3):
            agent_name = 'A007_' + bla(6)
            data = {
                'edit_permission': get_rand('bool'),
                'method_type': random.choice(['By Profit', 'By Revenue']),
                'commission': random.random() * 40,
                'status': get_rand('bool'),
                'agent_name': agent_name,
                'email': bla_mail(),
                'user': {
                    'passwd': bla(5),
                    'name': 'user_' + agent_name,
                    'fullname': agent_name + ' ' + bla(5)
                },
                'frequency_type': random.choice(['daily', 'weekly', 'monthly'])
            }

            ret = self.api.agent_create_post(body=data)
            assert (ret.success)
        ret = self.api.agent_all_delete(agent_name='A007*')
        assert (ret.success)
        print(ret.payload.to_dict())
        pass

    def test_agent_all_patch(self):
        """
        Test case for agent_all_patch


        """
        ret=self.api.agent_all_patch(body={'status':True},agent_name='A*')
        assert(ret.success)
        print(ret.payload.to_dict())
        ret = self.api.agent_all_patch(body={'status': True}, commission_gt=15)
        assert (ret.success)
        print(ret.payload.to_dict())
        ret = self.api.agent_all_patch(body={'status': True}, method_type='By Profit')
        assert (ret.success)
        print(ret.payload.to_dict())
        pass

    def test_agent_clients_get(self):
        """
        Test case for agent_clients_get

        
        """
        ret = self.api.agent_clients_get()
        assert(ret.success and len(ret.payload.items))
        pass

    def test_agent_commission_get(self):
        """
        Test case for agent_commission_get

        
        """
        pass

    def test_agent_create_post(self):
        """
        Test case for agent_create_post

        
        """
        auth()
        agent_name = 'agent_'+bla(6)
        data={
  'edit_permission': get_rand('bool'),
  'method_type': random.choice(['By Profit','By Revenue']),
  'commission': random.random()*40,
  'status': get_rand('bool'),
  'agent_name': agent_name,
  'email': bla_mail(),
  'user': {
    'passwd': bla(5),
    'name': 'user_'+agent_name,
    'fullname': agent_name+' '+bla(5)
  },
  'frequency_type': random.choice(['daily', 'weekly', 'monthly'])
}

        ret=self.api.agent_create_post(body=data)
        assert(ret.success)
        try:
            ret = self.api.agent_create_post(body=data)
            assert (not ret.success)
        except Exception as e:
            assert('Agent already exists' in str(e))
        try:
            data['agent_name']='agent_'+bla(8)
            ret = self.api.agent_create_post(body=data)
            assert (not ret.success)
        except Exception as e:
            assert('User name already exists' in str(e))
        return ret
        pass

    def test_agent_list_get(self):
        """
        Test case for agent_list_get

        
        """
        auth()
        ret = self.api.agent_list_get()
        assert (ret.success)
        pass

    def test_agent_not_assigned_clients_get(self):
        """
        Test case for agent_not_assigned_clients_get


        """
        auth()
        ret=self.api.agent_not_assigned_clients_get()
        assert(ret.success)
        pass


if __name__ == '__main__':
    unittest.main()
