import json
from falcon_rest.signals import receive
from falcon_rest.contrib.auth.auth_signals import auth_success, auth_failed
from falcon_rest.contrib.middleware.middleware_signals import process_resource_end,process_request_start
from falcon_rest.db import orm
from falcon_rest.helpers import get_request_ip
#from .. model import AuthorizationLog,WebSession
from falcon_rest.conf import settings
from falcon_rest.logger import log


@receive(process_request_start, send_sender=False, send_keys=['req', 'resp'])
def on_process_request_start(req,resp):
    if hasattr(settings,'ALLOW_ORIGIN') and  ( '*' in settings.ALLOW_ORIGIN or req.headers.get('ORIGIN') in settings.ALLOW_ORIGIN ):
            if 'ORIGIN' in req.headers:
                resp.append_header('Access-Control-Allow-Origin', req.headers['ORIGIN'])
                resp.append_header('Access-Control-Allow-Headers', 'Authorization, Content-Type, X-Auth-Token,Cache-Control,X-Requested-With')
                resp.append_header('Access-Control-Allow-Methods', 'GET, POST, PUT, PATCH, DELETE')
                log.debug('CORS headers to {}'.format(req.headers.get('ORIGIN')))
            else:
                log.debug('CORS headers not send: no ORIGIN')
    else:
        log.debug('CORS headers not send: not ALLOW')

@receive(auth_success, send_sender=False, send_keys=['req', 'user'])
def on_auth_success(req, user):
    if req.context['app_name'] != 'dnl_api':
        return
    if req.context['service']:
        log.debug('on_auth_success service SUCCESS')
        return
    from api_dnl.model import WebSession,AuthorizationLog
    #from models.logs import AuthorizationLog
    user.last_login_time = orm.func.now()
    user.login_ip = get_request_ip(req)
    #user.is_online = 1
    user.save()
    #WebSession(user_id=user.user_id, host=get_request_ip(req), agent=req.user_agent, msg=json.dumps(dict(succes=True))).save()
    AuthorizationLog(username=user.name,request_ip= get_request_ip(req),referer=req.headers.get('REFERER',None),
                     direction=req.method,auth_type='pass',error_type='success',agent=req.user_agent).set_time().save()

@receive(auth_failed, send_sender=False, send_keys=['req', 'data'])
def on_auth_failed(req, data):
    if req.context['app_name'] != 'dnl_api':
        return
    from api_dnl.model import WebSession, AuthorizationLog
    if req.context['service']:
        return
    #log.debug('AUTH FAILED', str(req.headers))
    #from models.logs import AuthorizationLog
    #WebSession(user_id=None, host=get_request_ip(req), agent=req.user_agent, msg=json.dumps(dict(success=False, email_or_name=data['email_or_name'], password=data['password']))).save()
    try:
        AuthorizationLog(username=data.get('email_or_name',None), request_ip=get_request_ip(req),referer=req.headers.get('REFERER',None),
            entered_password=data.get('password',None),direction=req.method,
            auth_type='pass', error_type='fail',agent=req.user_agent).set_time().save()
    except Exception as e:
        log.debug('Database error:{}'.format(e))

@receive(process_resource_end, send_sender=False, send_keys=['req'])
def on_process_resource_end(req):
    from api_dnl.model import User
    if req.context['app_name'] != 'dnl_api':
        return
    if req.context['service']:
        log.debug('on_process_resource_end service SUCCESS')
        return
    try:
        if 'user' in req.context:
            req.context['user'].last_seen = orm.func.now()
            req.context['user'].save()
        else:
            try:
                User.session().commit()
            except:
                pass
        log.debug('on_process_resource_end SUCCESS')
    except Exception as e:  # if no user were set
        log.debug('on_process_resource_end DATABASE ERROR:{}'.format(e))
        try:
            User.session().rollback()
        except:
            pass
