"""rate_import_task

Revision ID: 60d89328267a
Revises: 620a4f3af8b0
Create Date: 2019-05-23 21:06:11.807510

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = '60d89328267a'
down_revision = '620a4f3af8b0'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('rate_import_task',
    sa.Column('id', sa.Integer(), server_default=sa.text("nextval('rate_upload_task_id_seq'::regclass)"), nullable=False),
    sa.Column('operator_user', sa.String(length=40), nullable=True),
    sa.Column('import_file_path', sa.String(length=256), nullable=True),
    sa.Column('orig_rate_file', sa.String(length=256), nullable=True),
    sa.Column('format_rate_file', sa.String(length=256), nullable=True),
    sa.Column('import_log_path', sa.String(length=256), nullable=True),
    sa.Column('rate_table_id', sa.Integer(), nullable=False),
    sa.Column('code_deck_id', sa.Integer(), nullable=True),
    sa.Column('code_name_provider', sa.SmallInteger(), server_default='0', nullable=False),
    sa.Column('import_rate_date_format', sa.String(length=40), nullable=True),
    sa.Column('end_date_all_records_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('end_date_other_code_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('redup_in_rate_table_action', sa.SmallInteger(), server_default='0', nullable=False),
    sa.Column('redup_in_file_action', sa.SmallInteger(), server_default='0', nullable=False),
    sa.Column('status', sa.SmallInteger(), server_default=sa.text('0'), nullable=False),
    sa.Column('progress', sa.String(length=1024), nullable=True),
    sa.Column('expense_detail', sa.String(length=100), nullable=True),
    sa.Column('start_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('end_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('create_time', sa.DateTime(timezone=True), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('rate_import_task')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger class4_trig_record_{table} on {table};
drop table {table}_record;
DROP FUNCTION class4_trigfun_record_{table}();
DROP SEQUENCE {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))