"""system_parameter codedeck_last_updates

Revision ID: d1003f3d4088
Revises: 650fc67c0e05
Create Date: 2018-04-16 20:44:55.848592

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = 'd1003f3d4088'
down_revision = '650fc67c0e05'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('user_codedeck_alerts',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('user_id', sa.Integer(), nullable=True),
    sa.Column('show_az_codedeck', sa.Boolean(), nullable=False),
    sa.Column('show_us_codedeck', sa.Boolean(), nullable=False),
    sa.ForeignKeyConstraint(['user_id'], ['users.user_id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.add_column('system_parameter', sa.Column('codedeck_last_az_update', sa.DateTime(timezone=True), nullable=True))
    op.add_column('system_parameter', sa.Column('codedeck_last_us_update', sa.DateTime(timezone=True), nullable=True))
    op.add_column('system_parameter', sa.Column('codedeck_prompt_az_update', sa.DateTime(timezone=True), nullable=True))
    op.add_column('system_parameter', sa.Column('codedeck_prompt_us_update', sa.DateTime(timezone=True), nullable=True))
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('system_parameter', 'codedeck_prompt_us_update')
    op.drop_column('system_parameter', 'codedeck_prompt_az_update')
    op.drop_column('system_parameter', 'codedeck_last_us_update')
    op.drop_column('system_parameter', 'codedeck_last_az_update')
    op.drop_table('user_codedeck_alerts')
    # ### end Alembic commands ###
