"""did_param

Revision ID: d7e8f01adf8e
Revises: 4c9a2617cc1b
Create Date: 2020-12-17 12:29:12.832526

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):



# revision identifiers, used by Alembic.
revision = 'd7e8f01adf8e'
down_revision = '4c9a2617cc1b'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('did_param',
    sa.Column('did', sa.String(length=11), nullable=False),
    sa.Column('country_iso', sa.String(length=3), nullable=True),
    sa.Column('ocn', sa.String(length=8), nullable=True),
    sa.Column('lata', sa.String(length=8), nullable=True),
    sa.Column('rate_type', sa.String(), nullable=True),
    sa.Column('clec', sa.String(), nullable=True),
    sa.Column('type', sa.SmallInteger(), server_default='0', nullable=True),
    sa.PrimaryKeyConstraint('did')
    )
    op.create_index(op.f('ix_did_param_clec'), 'did_param', ['clec'], unique=False)
    op.create_index(op.f('ix_did_param_country_iso'), 'did_param', ['country_iso'], unique=False)
    op.create_index(op.f('ix_did_param_lata'), 'did_param', ['lata'], unique=False)
    op.create_index(op.f('ix_did_param_ocn'), 'did_param', ['ocn'], unique=False)
    op.create_index(op.f('ix_did_param_rate_type'), 'did_param', ['rate_type'], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_did_param_rate_type'), table_name='did_param')
    op.drop_index(op.f('ix_did_param_ocn'), table_name='did_param')
    op.drop_index(op.f('ix_did_param_lata'), table_name='did_param')
    op.drop_index(op.f('ix_did_param_country_iso'), table_name='did_param')
    op.drop_index(op.f('ix_did_param_clec'), table_name='did_param')
    op.drop_table('did_param')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))