import cgi
import cgi
import json
import smtplib
import traceback
from datetime import datetime
from pytz import UTC
from email import encoders
from email.mime.application import MIMEApplication
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText
from email.utils import formatdate
from time import sleep

import re
from sqlalchemy import (select, Column, text as text_)
from sqlalchemy import (
    Integer, Text, String, DateTime, Boolean, ForeignKey)
from sqlalchemy.orm import synonym, column_property
from sqlalchemy.sql import func
from sqlalchemy.ext.hybrid import hybrid_property

from api_dnl import model
from api_dnl.models.user import User
from api_dnl.base_model import DnlApiBaseModel
from api_dnl.fields.choice import ChoiceType
# from base_model import DnlApiBaseModel
# from falcon_rest.db import Column
from falcon_rest.logger import log
import jinja2

MAIL_TYPE = {
    0: 'undefined',
    1: 'lowbalance',
    2: 'auto_summary',
#    3: 'auto_delivery',
#    4: 'route_update_alert_email',
    5: 'download_cdr',
#    6: 'exchange_auto_summary',
    7: 'invoice',
    8: 'payment',
    9: 'auto_balance',
#    10: 'carrier_invoice',
    11: 'auto_cdr',
#    12: 'no_route_available_alert_email',
#    13: 'target_match_alert_email',
   14: 'rate_watch_alert_email',
   15: 'noc_email',
#    16: 'rate_update_alert_email',
    17: 'low_balance_alert_email',
#    18: 'new_invoice_posted_mail_alert_email',
    19: 'payment_sent',
    20: 'trouble_ticket',
    21: 'payment_received',
    22: 'send_cdr',
   23: 'select_route_up_email',
   24: 'alert_email',
   25: 'finance_alert',
#    26: 'buy_qos_alert',
#    27: 'sell_qos_alert',
    28: 'rate_mail_success',
#    29: 'rate_mail_fail',
#    30: 'daily_payment',
   31: 'rate',
#    32: 'dialer_detection',
    33: 'retrieve_password',
    34: 'registration',
    35: 'trunk_change',
    36: 'fraud_detection',
    37: 'welcome',
    38: 'download_rate_notice',
    39: 'no_download_rate',
#    40: 'carrier_email',
#    41: 'vendor_invoice_dispute',
    42: 'trunk_interop',
    43: 'regletter',
    44: 'paymresvd',
    45: 'zerobalance',
    46: 'did_order_letter',
    47: 'pending_trunk',
    48: 'hour_48_suspension_warning',
    49: 'hour_24_suspension_warning',
    50: 'hour_3_suspension_warning',
    51: 'hour_1_suspension_warning',
    52: 'agent_share_link',
    53: 'send_product',
    54: 'send_pcap',
    55: 'sign_on_notification',
    56: 'registration_accepted',
    57: 'registration_rejected',
    58: 'email_confirmation',
    59: 'faultroutealertrule',
    60: 'monitoredrule'
}

MAIL_DEFAULT_TAGS = {
    'undefined': 'company_name,client_name',
    'lowbalance': 'company_name,client_name,current_date,balance,payment_terms,credit_limit,remaining_credit',
    'auto_summary': 'company_name,begin_time,actual_received,client_name,end_time,customer_gmt,total_call_buy,'
                    'total_non_zero_calls_buy,total_success_calls_buy,total_billed_amount_buy,credit_limit,remaining_credit,'
                    'balance,total_call_sell,total_non_zero_calls_sell,total_success_calls_sell,total_billed_min_sell,'
                    'total_billed_amount_sell,buy_total_duration,sell_total_duration,switch_alias',
    'auto_delivery': 'company_name,client_name',
    'route_update_alert_email': 'company_name,client_name',
    'download_cdr': 'company_name,client_name,begin_time,end_time,customer_gmt,cdr_count,download_link,current_day',
    'exchange_auto_summary': 'company_name,client_name',
    'invoice': 'invoice_link,company_name,client_name,start_date,end_date,invoice_amount,invoice_number,cdr_url',
    'payment': 'company_name,amount,receiving_time,actual_received,client_name,total_debit_amount,transaction_id,finance_fee',
    'auto_balance': 'company_name,client_name,current_date,balance,payment_terms,credit_limit,remaining_credit',
    'carrier_invoice': 'invoice_link,company_name,client_name,start_date,end_date,invoice_amount,invoice_number,cdr_url',
    'auto_cdr': 'company_name,client_name,begin_time,end_time,customer_gmt,cdr_count,download_link,current_day',
    'no_route_available_alert_email': 'company_name,client_name',
    'target_match_alert_email': 'company_name,client_name',
    'rate_watch_alert_email': 'company_name,client_name',
    'noc_email': 'company_name,client_name',
    'rate_update_alert_email': 'company_name,client_name',
    'low_balance_alert_email': 'company_name,client_name,current_date,balance,payment_terms,credit_limit,remaining_credit',
    'new_invoice_posted_mail_alert_email': 'company_name,client_name',
    'payment_sent': 'company_name,amount,receiving_time,client_name,note',
    'trouble_ticket': 'name,title,content,department,user_ip,client_company,client_email',
    'payment_received': 'company_name,amount,receiving_time,client_name,note',
    'send_cdr': 'company_name,client_name,download_link,username,share_link',
    'select_route_up_email': 'email',
    'alert_email': 'company_name,client_name,monitoring_result,rule_name,rule_setup',
    'finance_alert': 'company_name,client_name,balance',
    'buy_qos_alert': 'company_name,client_name,monitoring_result,rule_name,rule_setup',
    'sell_qos_alert': 'company_name,client_name,monitoring_result,rule_name,rule_setup',
    'rate_mail_success': 'download_link,rate_table_name',
    'rate_mail_fail': 'download_link,rate_table_name',
    'daily_payment': 'company_name,amount,receiving_time,client_name',
    'rate': 'download_link,rate_table_name,effective_date,allowed_ip,switch_ip,download_token,billing_type,jur_type',
    'dialer_detection': 'block_value,limit_value,rule_name,rule_type,trunk_name,client_name,current_date',
    'retrieve_password': 'company_name,client_name,username,login_url,token',
    'registration': 'company_name,client_name,username,email,login_url',
    'trunk_change': 'company_name,client_name,trunk_name,detail_table',
    'fraud_detection': 'block_value,limit_value,rule_name,rule_type,trunk_name,client_name,current_date',
    'welcome': 'company_name,client_name,username,password,login_url',
    'download_rate_notice': 'company_name,client_name,trunk_name,effective_date,rate_update_file_name,download_deadline',
    'no_download_rate': 'company_name,client_name,trunk_name,effective_date,rate_update_file_name,download_deadline',
    'carrier_email': 'company_name,client_name,username,login_url',
    'vendor_invoice_dispute': 'invoice_link,company_name,client_name,start_date,end_date,invoice_amount,invoice_number,cdr_url',
    'trunk_interop': 'company_name,client_name,trunk_name,trunk_type,route_info,ip_listing',
    'regletter': 'company_name,client_name,username,email,login_url',
    'paymresvd': 'company_name,client_name',
    'zerobalance': 'company_name,date,client_name,notify_balance,balance,allow_credit,payment_terms',
    'did_order_letter': 'company_name,client_name,did,setup_fee,monthly_fee,',
    'pending_trunk': 'company_name,client_name,trunk_name,effective_date,rate_update_file_name,download_deadline',
    'hour_48_suspension_warning': 'company_name,client_name,trunk_name,effective_date,rate_update_file_name,download_deadline',
    'hour_24_suspension_warning': 'company_name,client_name,trunk_name,effective_date,rate_update_file_name,download_deadline',
    'hour_3_suspension_warning': 'company_name,client_name,trunk_name,effective_date,rate_update_file_name,download_deadline',
    'hour_1_suspension_warning': 'company_name,client_name,trunk_name,effective_date,rate_update_file_name,download_deadline',
    'agent_share_link': 'agent_name,referal_key,referal_link',
    'send_product': 'download_link,rate_table_name,effective_date,switch_ip,download_token,billing_type,jur_type',
    'sign_on_notification':'company_name,client_name,username,email,login_url',
    'registration_accepted': 'company_name,client_name,username,email,login_url',
    'registration_rejected': 'company_name,client_name,username,email,login_url',
    'email_confirmation': 'company_name,client_name,username,email,login_url',
}

MAIL_DEFAULT_TO = {
    'undefined': 'email',
    'lowbalance': 'billing_email',
    'auto_summary': 'email',
    'auto_delivery': 'email',
    'route_update_alert_email': 'email',
    'download_cdr': 'noc_email',
    'exchange_auto_summary': 'email',
    'invoice': 'billing_email',
    'payment': 'billing_email',
    'auto_balance': 'billing_email',
    'carrier_invoice': 'email',
    'auto_cdr': 'noc_email',
    'no_route_available_alert_email': 'email',
    'target_match_alert_email': 'email',
    'rate_watch_alert_email': 'email',
    'noc_email': 'noc_email',
    'rate_update_alert_email': 'rate_email',
    'low_balance_alert_email': 'billing_email',
    'new_invoice_posted_mail_alert_email': 'billing_email',
    'payment_sent': 'billing_email',
    'trouble_ticket': 'email',
    'payment_received': 'billing_email',
    'send_cdr': 'noc_email',
    'select_route_up_email': 'email',
    'alert_email': 'email',
    'finance_alert': 'billing_email',
    'buy_qos_alert': 'email',
    'sell_qos_alert': 'email',
    'rate_mail_success': 'rate_email',
    'rate_mail_fail': 'rate_email',
    'daily_payment': 'billing_email',
    'rate': 'rate_email',
    'dialer_detection': 'email',
    'retrieve_password': 'email',
    'registration': 'email',
    'trunk_change': 'noc_email',
    'fraud_detection': 'email',
    'welcome': 'email',
    'download_rate_notice': 'rate_email',
    'no_download_rate': 'rate_email',
    'carrier_email': 'email',
    'vendor_invoice_dispute': 'email',
    'trunk_interop': 'noc_email',
    'regletter': 'email',
    'paymresvd': 'billing_email',
    'zerobalance': 'noc_email',
    'did_order_letter': 'email',
    'pending_trunk': 'noc_email',
    'hour_48_suspension_warning': 'rate_email',
    'hour_24_suspension_warning': 'rate_email',
    'hour_3_suspension_warning': 'rate_email',
    'hour_1_suspension_warning': 'rate_email',
    'sign_on_notification':'email',
    'registration_accepted': 'email',
    'registration_rejected': 'email',
    'email_confirmation': 'email',
}


class EmailLog(DnlApiBaseModel):
    __tablename__ = 'email_log'
    TYPE = MAIL_TYPE
    ALERT_TYPES = ['auto_balance', 'auto_summary', 'payment_received']
    MESSAGE_TYPES = ['lowbalance', 'send_cdr', 'welcome']

    #        {0: 'system',1: 'low balance', 2: 'daily summary', 3: 'auto delivery',
    #           4: 'alert_route', 5: 'cdr_down', 6: 'exchange_alert_route',
    #            7: 'invoice', 21: 'payment received',
    #            22: 'rule alert'}

    STATUS = {0: 'success', 1: 'fail'}
    id = Column(Integer, primary_key=True)
    send_time = Column(DateTime(timezone=True), nullable=True, onupdate=func.now())
    client_id = Column(Integer)
    email_addresses = Column(String(500))
    files = Column(String(500))
    type = Column(ChoiceType(TYPE))
    email_res = Column(Text)
    alert_block_egress_id = Column(Integer)
    alert_block_code_name = Column(Text)
    status = Column(ChoiceType(STATUS))  # 0, null-success; 1-fail
    error = Column(Text)  # email error
    resend_email = Column(Text)
    subject = Column(String(100))
    content = Column(Text)
    is_view = Column(Integer, nullable=False, server_default=text_("0"))  # is viewed on the self page
    sent_from = Column(String(100))

    date = synonym('send_time')
    sent_to = synonym('email_addresses')

    def _client_name(self):
        from api_dnl.model import Client
        try:
            return Client.filter(Client.client_id == self.client_id).first().name
        except:
            return None


def process_template(templ, env):
    """Render template on environment dictionary."""
    from api_dnl.model import get_default_billing_decimal, Decimal

    def prn(v):
        if callable(v):
            return str(v())
        return str(v)

    def _fmt(r, env, f, out):
        if f == 'login_url':
            from api_dnl.model import SystemParameter
            member = SystemParameter.session().query(SystemParameter.base_url).first().base_url
            out = r.sub(prn(member), out)
            return out, True
        if f == 'logo_url':
            from api_dnl.model import SystemParameter
            system_parameter = SystemParameter.session().query(SystemParameter.base_url, SystemParameter.public_logo_url).first()
            member = system_parameter.base_url+system_parameter.public_logo_url
            if system_parameter.public_logo_url.isdigit():
                logo_url = '{}/api_dnl/v1/config/export/public/{}'.format(system_parameter.base_url, system_parameter.public_logo_url)
            out = r.sub(prn(member), out)
            return out, True
        if hasattr(env, f):
            member = getattr(env, f, None)
            out = r.sub(prn(member), out)
            return out, True
        if hasattr(env, 'has_key') and f in env:
            out = r.sub(prn(env[f]), out)
            return out, True
        if '.' in f:
            fx = f.split('.')
            f0 = fx[0]
            f1 = fx[1]
            if hasattr(env, f0):
                m = getattr(env, f0, None)
                member = getattr(m, f1, None)
                if member:
                    out = r.sub(prn(member), out)
                    return out, True
        if hasattr(env, 'client'):
            out, ret = _fmt(r, env.client, f, out)
            if ret:
                return out, True
        return out, False

    def fmt(r, env, f, out):
        ff = 'fmt_' + f
        out, ret = _fmt(r, env, ff, out)
        if ret:
            return out, True
        out, ret = _fmt(r, env, f, out)
        return out, ret

    if templ == '' or templ is None:
        raise Exception('Empty template')
    if env is None:
        raise Exception('No object in template to render!')
    if '{{' in templ:
        try:
            if type(env) == type({}):
                return jinja2.Template(templ).render(**env)
            else:
                return jinja2.Template(templ).render(**env.__dict__)
        except Exception as e:
            return 'TEMPLATE ERRORS:<br>' + str(e) + '<br>' + templ

    try:
        r = re.compile(r'{(?P<name>[^}]*?)}', re.VERBOSE)
        fields = r.findall(templ)
        log.debug('template fields:' + str(fields))
        out = templ
        for f in fields:
            r = re.compile('{%s}' % f, re.VERBOSE)
            f = cgi.escape(f)  # .encode('ascii', 'xmlcharrefreplace')
            try:
                out, ret = fmt(r, env, f, out)
                if ret:
                    continue
                out = r.sub(str('{%s:not found!}' % f), out)
            except Exception as e:
                e = cgi.escape(str(e))  # .encode('ascii', 'xmlcharrefreplace')
                out = r.sub(str('{%s error:%s}' % (f, str(e))), out)
        log.debug('RENDERED TEMPLATE:\n' + out)
        return out
    except Exception as e:
        log.error('Template error:' + str(e) + traceback.format_exc())
        return 'Notice to staff: the template for this letter is emty or damaged'


def render(tpl, title, env):
    # tpl = cls.get(title)

    if tpl:
        if tpl.html_content:
            content = process_template(tpl.html_content, env)
        else:
            env.title = title
            content = process_template('This is letter type [{title}] for {name} without template.', env)
        if tpl.subject:
            subject = process_template(tpl.subject, env)
        else:
            env.title = title
            subject = process_template('[{title}] letter for {company} without template.', env)
        cc_list = tpl.cc_mail.split(';') if tpl.cc_mail else []
        cc_mail = []
        for cc in cc_list:
            if hasattr(env, cc):
                cc_mail.append(getattr(env, cc))
            elif hasattr(env, 'client') and hasattr(env.client, str(tpl.cc_mail)):
                cc_mail.append(getattr(env.client, cc, ''))
            elif hasattr(env, 'carrier') and hasattr(env.carrier, str(tpl.cc_mail)):
                cc_mail.append(getattr(env.client, cc, ''))
            else:
                cc_mail.append(cc)
        cc_mail = ';'.join(cc_mail)
        if hasattr(env, 'from_mail_id'):
            from_mail_id = getattr(env, 'from_mail_id', None)
        elif tpl.from_mail_id:
            from_mail_id = tpl.from_mail_id
        else:
            from_mail_id = 1
        sender = MailSender.get(from_mail_id)
        if not sender:
            from_mail_id = 1
            sender = MailSender.get(from_mail_id)
            if not sender:
                raise Exception('No default mail sender configured!')
            tpl.from_mail_id = 1
            tpl.save()
        to_mail = str(tpl.to_mail) if tpl.to_mail else ''
        if hasattr(env, str(tpl.to_mail)):
            to_mail = getattr(env, str(tpl.to_mail))
        elif hasattr(env, 'client'):
            if hasattr(env.client, str(tpl.to_mail)):
                to_mail = getattr(env.client, str(tpl.to_mail))
        elif hasattr(env, 'carrier'):
            if hasattr(env.carrier, str(tpl.to_mail)):
                to_mail = getattr(env.carrier, str(tpl.to_mail))
        elif hasattr(env, 'has_key') and tpl.to_mail in env:
            to_mail = env[str(tpl.to_mail)]
        else:
            to_mail = ''
        if callable(to_mail):
            to_mail = str(to_mail())
        att = tpl.get_attachment(env)
        if to_mail == 'None':
            to_mail = ''
        return (subject, content, from_mail_id, cc_mail, to_mail, att)
    else:
        return None


class SendRateTemplate(DnlApiBaseModel):
    __tablename__ = 'send_rate_template'
    DOWNLOAD_METHOD = {0: 'send as link', 1: 'send as attachment'}
    HEADERS = ['code', 'country', 'code_name', 'intra_rate', 'inter_rate',
               'interval', 'min_time', 'local_rate', 'effective_date',
               'rate_id', 'rate_table_id', 'rate', 'setup_fee', 'end_date',
               'grace_time', 'time_profile_id', 'seconds', 'basic_percentages',
               'gift_percentages',
               'rate_type', 'zone', 'ocn', 'lata', 'create_time',
               'did_type']

    id = Column(Integer, primary_key=True)  # , server_default=text_("nextval('send_rate_template_id_seq'::regclass)"))
    name = Column(String(200), unique=True)
    subject = Column(String(200))
    content = Column(Text)
    download_method = Column(ChoiceType(DOWNLOAD_METHOD), default=1)
    header = Column(Text)
    sender_id = Column(ForeignKey('mail_sender.id', ondelete='SET NULL'))
    mail_cc = Column(String(200))
    to_mail = Column(String(200), default='rate_email')

    @property
    def html_content(self):
        return self.content

    @property
    def cc_mail(self):
        return self.mail_cc

    @property
    def from_mail_id(self):
        return self.sender_id

    @hybrid_property
    def headers(self):
        try:
            if self.header:
                return list(dict.fromkeys(self.header.split(',')))
            else:
                return list(set(self.HEADERS))
        except:
            return list(set(self.HEADERS))

    @headers.setter
    def headers(self, value):
        try:
            self.header = ','.join([str(x) for x in value])
        except Exception as e:
            log.warning('Bad SendRateTemplate headers array: {}'.format(e))
            pass

    def get_attachment(self, env):
        return []

    @classmethod
    def init(cls):
        q = cls.get(1)
        if not q:
            q = cls(id=1, name='default', subject='Send rate', content='Hi {name} it is aut send rate letter',
                    sender_id=1, header=cls.HEADERS)
            q.save()


class SendRateDirect(DnlApiBaseModel):
    __tablename__ = 'send_rate_direct'
    id = Column(ForeignKey('rate_send_log.id', ondelete='CASCADE'), primary_key=True, )
    subject = Column(String(200))
    content = Column(Text)
    download_method = Column(ChoiceType(SendRateTemplate.DOWNLOAD_METHOD), default=1)
    header = Column(Text)
    sender_id = Column(ForeignKey('mail_sender.id', ondelete='SET NULL'))
    mail_cc = Column(String(200))
    to_mail = Column(String(200), default='rate_email')

    # mail_from = Column(String(200))

    @property
    def html_content(self):
        return self.content

    @property
    def cc_mail(self):
        return self.mail_cc

    @property
    def from_mail_id(self):
        return self.sender_id

    @hybrid_property
    def headers(self):
        try:
            if self.header:
                return self.header.split(',')
            else:
                return SendRateTemplate.HEADERS
        except:
            return SendRateTemplate.HEADERS

    @headers.setter
    def headers(self, value):
        try:
            self.header = ','.join([str(x) for x in value])
        except Exception as e:
            log.warning('Bad SendRateTemplate headers array: {}'.format(e))
            pass

    def get_attachment(self, env):
        return []


class MailTemplate(DnlApiBaseModel):
    __tablename__ = 'mail_template'
    TYPE = MAIL_TYPE

    title = Column(String(200), primary_key=True)
    subject = Column(String(200))
    from_mail_id = Column(Integer, ForeignKey('mail_sender.id', ondelete='SET NULL'))
    cc_mail = Column(String(200))
    to_mail = Column(String(200))
    html_content = Column(Text)

    @hybrid_property
    def _html_content(self):
        from api_dnl.model import SystemParameter
        system_parameter = SystemParameter.session().query(SystemParameter.base_url, SystemParameter.public_logo_url).first()
        logo_url = str(system_parameter.base_url)+str(system_parameter.public_logo_url)
        if system_parameter.public_logo_url.isdigit():
            logo_url = '{}/api_dnl/v1/config/export/public/{}'.format(system_parameter.base_url, system_parameter.public_logo_url)
        r = re.compile('{logo_url}', re.VERBOSE)
        return r.sub(logo_url, str(self.html_content))

    @_html_content.setter
    def _html_content(self, value):
        self.html_content = value

    @classmethod
    def _get(cls, title):
        return cls.get(title)

    @classmethod
    def get_title(cls, title):
        return cls.filter(cls.title == title).first()

    def before_save(self):
        if not self.to_mail:
            if self.title in MAIL_DEFAULT_TO:
                self.to_mail = MAIL_DEFAULT_TO[self.title]
            else:
                self.to_mail = ''
        pass

    def get_attachment(self, env):
        return []

    @classmethod
    def init(cls):
        from api_dnl import settings
        for name in cls.TYPE.values():
            subject = 'Letter template {}'.format(name.upper()),
            html_content = '<p>Hi {name}</p> <p> This is empty template of type "%s" from dnl_api.' % name
            tags = ['client_name', 'company_name', 'login_url', 'balance', 'credit_limit', 'create_time', 'company',
                    'email', 'payment_terms']
            if name in MAIL_DEFAULT_TAGS:
                tags = (MAIL_DEFAULT_TAGS[name]).split(',')
            if name == 'send_pcap':
                tags = ['start_time', 'end_time', 'download_link'] + tags
            if name == 'rate':
                host = settings.API_HOST.split(':')[0]
                html_content += """
                <p><b>download_link:</b>http://""" + host + """:9001/download/rate/{download_token}</p><p><b>rate_
table_name:</b>{rate_table_name}</p><p><b>effective_date:</b>{effective_date}</p><p><b>allowed_ip:</b>{allowed_ip}</p><p><b>switch_ip:</b>{switch_ip}</p>
                """
            else:
                for tag in tags:
                    html_content = html_content + '<p><b>' + tag + ':</b>{' + tag + '}</p>'
            cc_mail = ''
            if name in MAIL_DEFAULT_TO:
                to_mail = MAIL_DEFAULT_TO[name]
            else:
                to_mail = 'email'
            old = cls.get(name)
            # if old and not old.subject in (None,'') and not old.html_content in (None,''):
            #    continue
            if old:
                if old.subject in (None, ''):
                    old.subject = subject
                    old.save()
                if old.html_content in (None, ''):
                    old.html_content = html_content
                    old.save()
                continue
            sender = MailSender.filter().order_by(MailSender.id).all()
            from_mail_id = 1
            for s in sender:
                if s.status == 'connected':
                    from_mail_id = s.id
                    break
            tpl = cls(title=name, subject=subject, html_content=html_content, from_mail_id=from_mail_id,
                      cc_mail=cc_mail, to_mail=to_mail)
            tpl.save()


class MailSender(DnlApiBaseModel):
    __tablename__ = 'mail_sender'
    SECURE = {25: 'NO', 465: 'SSL', 587: 'TLS'}
    id = Column(Integer, primary_key=True)
    smtp_host = Column(String(255))
    smtp_port = Column(String(255))
    username = Column(String(255))
    password = Column(String(255))
    email = Column(String(255))
    name = Column(String(255), unique=True)
    secure = Column(ChoiceType(SECURE), nullable=False)
    # authentication = Column(Boolean, default=True, server_default='true')
    loginemail = Column(String(12))
    last_modified_on = Column(DateTime(True), onupdate=func.now())
    modified_by = Column(String(40))
    enable_auth = Column(Boolean, default=True)

    update_by = synonym('modified_by')
    update_on = synonym('last_modified_on')
    mail_server = synonym('smtp_host')
    mail_port = synonym('smtp_port')

    @hybrid_property
    def passwd(self):
        return '*' * len(self.password or '')

    @passwd.setter
    def passwd(self, value):
        self.password = value

    @staticmethod
    def cleanhtml(raw_html):
        cleanr = re.compile('<.*?>')
        raw_html = raw_html.replace('\r', '').replace('\n', '').replace('\t', '')
        cleantext = re.sub(cleanr, ' ', raw_html)
        ' '.join(cleantext.split())
        return cleantext

    @property
    def status(self):
        (host, port, user, passw) = (self.smtp_host, self.smtp_port, self.username, self.password)
        try:
            error_cause = ''
            server = None
            if port == '465':
                server = smtplib.SMTP_SSL(host + ':' + port)
            else:
                server = smtplib.SMTP(host + ':' + port)
            server.ehlo_or_helo_if_needed()
            if port == '587':
                server.starttls()
            server.login(user, passw)
            return "connected"
        except Exception as e:
            error_cause = str(e)
            return "disconnected"

    @staticmethod
    def _send_mail(self, to, subject, text, type='undefined', client_id=0, frm=None, cc=None, att=[]):
        """sending email."""
        self.last_error = None
        status = 0
        from api_dnl.model import SystemParameter
        (host, port, user, passw) = (self.smtp_host, self.smtp_port, self.username, self.password)

        if frm:
            if frm in ['default', 'admin']:
                mfrom = SystemParameter.get(1).fromemail
            else:
                mfrom = frm
        else:
            mfrom = self.email

        if not (host and port and user and passw and mfrom):
            log.error(
                'MAIL NOT SENT, BAD CONFIG: host:%s port:%s user:%s passw:%s from: %s to: %s status: %d subj: %s body:%s ' % (
                    host, str(port), user, passw, mfrom, to, status, subject, MailSender.cleanhtml(text)[0:1024]))
            self.last_error = 'MAIL NOT SENT, BAD CONFIG'
            return 1
        msg = MIMEMultipart()
        msg['Subject'] = subject
        msg['From'] = mfrom
        msg['To'] = to.replace(';', ',')
        msg['Date'] = formatdate(localtime=True)
        if cc:
            msg['CC'] = cc.replace(';', ',')
        txt = MIMEText(text, 'html')
        msg.attach(txt)
        att_num = 0
        if att:
            for file, data in att:
                if '.' in file:
                    typ = file.split('.')[-1]
                else:
                    typ = file
                subtype = 'octet-stream'
                if typ == 'pdf':
                    subtype = 'pdf'
                if typ == 'xls':
                    subtype = 'vnd.ms-excel'
                if typ == 'csv':
                    subtype = 'vnd.ms-excel'
                if typ == 'json':
                    subtype = 'json'
                attachment = MIMEApplication(data, subtype)
                # attachment.set_payload(fp.read())
                encoders.encode_base64(attachment)
                if typ == file:
                    file = 'attachment' + str(att_num) + '.' + typ
                attachment.add_header("Content-Disposition", "attachment", filename=file)
                msg.attach(attachment)

        errors = ''
        status = 0
        ret = {}
        lastto = ''
        to_set = []

        to = '' if not to else to
        cc = '' if not cc else cc
        to_set = set([x for x in to.split(';') + cc.split(';') if x != '' and '@' in x])
        tocc = ';'.join(list(to_set))
        server = None
        try:
            # for t in to_set:
            #     lastto = t
            #     if port == '465':
            #         server = smtplib.SMTP_SSL(host + ':' + port)
            #     else:
            #         server = smtplib.SMTP(host + ':' + port)
            #     server.ehlo_or_helo_if_needed()
            #     if port == '587':
            #         server.starttls()
            #     server.login(user, passw)
            #     server.sendmail(mfrom, t, msg.as_string())
            #     server.quit()
            #     sleep(0.1)

            if port == '465':
                server = smtplib.SMTP_SSL(host + ':' + port)
            else:
                server = smtplib.SMTP(host + ':' + port)
            server.ehlo_or_helo_if_needed()
            if port == '587':
                server.starttls()
                server.ehlo_or_helo_if_needed()
            server.login(user, passw)
            ret = server.sendmail(mfrom, list(to_set), msg.as_string())

        except Exception as e:
            log.error("MAIL EROR: from:%s to:%s err: %s" % (mfrom, tocc, str(e)))
            errors = errors + str(e)
            self.last_error = errors
            status = 1
        finally:
            if server:
                server.quit()
        if ret != {}:
            log.error("MAIL NOT SENT: from:%s to:%s err: %s" % (mfrom, tocc, str(ret)))
            errors = errors + str(ret)
            self.last_error = errors
            status = 1
        if status:
            log.warning('MAIL NOT SENT!: from: %s to: %s status: %d subj: %s body:%s ' % (
                mfrom, tocc, status, subject, MailSender.cleanhtml(text)[0:1024]))
        else:
            log.info('MAIL SENT: from: %s to: %s status: %d subj: %s body:%s ' % (
                mfrom, tocc, status, subject, MailSender.cleanhtml(text)[0:1024]))
        try:
            self.last_error = errors
            email_addresses = ';'.join(sorted(list(to_set)))
            text = json.dumps(text)
            subject = json.dumps(subject)
            errors = json.dumps(errors).replace("'", '"')
            log_rec = EmailLog(client_id=int(client_id), email_addresses=email_addresses[0:500],
                               type=type, status=status, error=errors, subject=subject[0:100], content=text,
                               # alert_rule=alert_rule[0:500],
                               send_time=datetime.now(UTC),
                               sent_from=mfrom)
            log_rec.save()

        except Exception as e:
            log.error('MAIL SENT: cannot write in email_log table {}'.format(e))
            self.last_error = errors + str(e)
            status = 1
        return status

    def send_mail(self, to, subject, text, type='undefined', alert_rule='', client_id=0, frm=None, cc=None, att=[]):
        return self._send_mail(self, to, subject, text, type, client_id, frm, cc, att)

    @classmethod
    def apply_mail(cls, data, template, to=None, att=[]):
        from api_dnl.model import MonitoredRule, FrundDetection,FaultRouteAlertRule
        try:
            tpl = MailTemplate.get(template)
            if type(data).__name__ == 'Client' and template not in ('lowbalance', 'welcome'):
                clsA = model.AgentClient
                agent = clsA.filter(clsA.client_id == data.client_id).first()
                if agent:
                    templateA = template + str(agent.agent_id)
                    tpl = MailTemplate.get(templateA)
                    if not tpl:
                        tpl = MailTemplate.get(template)

            if not tpl:
                try:
                    tl = template.split('_')
                    if tl[0] == 'sendrate':
                        t = int(tl[1])
                        tpl = SendRateTemplate.get(t)
                        template = 'rate'
                    if tl[0] == 'sendratedirect':
                        t = int(tl[1])
                        tpl = SendRateDirect.get(t)
                        template = 'rate'
                    if tl[0] == 'sendcdrdirect':
                        t = tl[1]
                        tpl = SendCdrDirect.get(t)
                        template = 'send_cdr'
                    if tl[0] == 'sendcdrexport':
                        t = tl[1]
                        tpl = SendCdrExportTemplate.get(t)
                        template = 'download_cdr'
                    if tl[0] == 'monitoredrule':
                        t = tl[1]
                        tpl = MonitoredRule.get(t)
                        template = 'monitoredrule'
                    if tl[0] == 'frund':
                        t = tl[1]
                        tpl = FrundDetection.get(t)
                        template = 'fraud_detection'
                    if tl[0] == 'faultroutealertrule':
                        t = tl[1]
                        tpl = FaultRouteAlertRule.get(t)
                        template = 'faultroutealertrule'
                except:
                    raise Exception('Sendrate mail template not found!')
            if not tpl:
                raise Exception('No one mail template found!')
            (subject, content, from_mail_id, cc_mail, to_mail, att_x) = render(tpl, template, data)
            if att_x:
                att = att + att_x
            if to:
                if to_mail:
                    to = to + ';' + to_mail
            else:
                if to_mail:
                    to = to_mail
                else:
                    raise Exception('No one TO address!')
            if not from_mail_id:
                from_mail_id = 1

            if (template in ('auto_summary', 'auto_balance')) and hasattr(data, 'auto_daily_balance_recipient'):
                partner = model.AgentClient.filter(model.AgentClient.client_id == data.client_id).first()
                tolst=[]
                if data.auto_daily_balance_recipient == 'Partner Billing Contact':
                    if partner:
                        tolst.append(partner.agent.email)
                    else:
                        tolst.append(data.billing_email)
                if data.auto_daily_balance_recipient == 'Owner Billing Contact':
                    tolst.append(data.billing_email)
                if data.auto_daily_balance_recipient == 'Both':
                    tolst.append(data.billing_email)
                    if partner:
                        tolst.append(partner.agent.email)
                to=';'.join(tolst)

            sender = cls.get(from_mail_id)
            failed_ids = []
            while sender.status != 'connected' and len(failed_ids) < 5:
                failed_ids.append(sender.id)
                sender = cls.filter(cls.id.notin_(failed_ids)).order_by(cls.id).first() or sender
            dic = dict((v, k) for k, v in EmailLog.TYPE.items())
            if template in dic:
                typ = dic[template]
            else:
                typ = 0
            if hasattr(data, 'client_id') and data.client_id:
                client_id = data.client_id
            elif hasattr(data, 'client') and hasattr(data.client, 'client_id') and data.client.client_id:
                client_id = data.client.client_id
            else:
                client_id = 0
            # if not to and hasattr(data,'email'):
            #    to = data.email
            if sender:
                #frm = sender.email
                frm = '{}<{}>'.format(sender.name, sender.email)
                # if hasattr(tpl,'mail_from') and getattr(tpl, 'mail_from',None):
                #    frm=getattr(tpl,'mail_from',frm)
                ret = sender.send_mail(to, subject, content, template, template, client_id, frm, cc_mail, att)
                if ret and hasattr(sender, 'last_error'):
                    return ret, sender.last_error
                return 0
            else:
                from api_dnl.model import SystemParameter
                sys_sender = SystemParameter.get(1)
                if not sys_sender:
                    log.warning('No one email configuration found!')
                    return 1
                #frm = sys_sender.email
                frm = '{}<{}>'.format('system', sys_sender.email)
                # if hasattr(tpl, 'mail_from') and getattr(tpl, 'mail_from',None):
                #    frm = getattr(tpl, 'mail_from',frm)
                ret = cls._send_mail(sys_sender, to, subject, content, template, client_id, frm, cc_mail, att)
                if ret and hasattr(sys_sender, 'last_error'):
                    return ret, sys_sender.last_error
                return 0
        except Exception as e:
            MailSender.last_error = 'Apply email error: {}'.format(str(e))
            log.error('Apply email error: {}'.format(str(e)))
            return 1, str(e)


SendRateTemplate.mail_from = column_property(
    select([MailSender.email]).where(SendRateTemplate.sender_id == MailSender.id).correlate_except(MailSender))
SendRateDirect.mail_from = column_property(
    select([MailSender.email]).where(SendRateDirect.sender_id == MailSender.id).correlate_except(MailSender))
from sqlalchemy import ARRAY, VARCHAR, Time


class SendMail(DnlApiBaseModel):
    __tablename__ = 'send_mails'

    id = Column(Integer, primary_key=True, server_default=text_("nextval('send_mails_id_seq'::regclass)"))
    client_id = Column(Integer)
    mail_subject = Column(String(200))
    mail_content = Column(Text)
    mail_to = Column(String(200))
    mail_cc = Column(String(200))
    files = Column(ARRAY(VARCHAR(length=200)))
    status = Column(Integer)
    send_time = Column(Time(True))


class SendCdrDirect(DnlApiBaseModel):
    __tablename__ = 'send_cdr_direct'
    uuid = Column(ForeignKey('cdr_async_task.request_id', ondelete='CASCADE'), primary_key=True, )
    subject = Column(String(200))
    html_content = Column(Text)
    sender_id = Column(ForeignKey('mail_sender.id', ondelete='SET NULL'))
    cc_mail = Column(String(200))
    to_mail = Column(String(200), default='email')

    @property
    def from_mail_id(self):
        return self.sender_id

    def get_attachment(self, env):
        return []

class SendCdrExportTemplate(DnlApiBaseModel):
    __tablename__ = 'send_cdr_export_template'
    id = Column(ForeignKey('cdr_export_email_task.id', ondelete='CASCADE'), primary_key=True, )
    subject = Column(String(200))
    html_content = Column(Text)
    sender_id = Column(ForeignKey('mail_sender.id', ondelete='SET NULL'))
    cc_mail = Column(String(200))
    to_mail = Column(String(200), default='email')

    @property
    def from_mail_id(self):
        return self.sender_id

    def get_attachment(self, env):
        return []
