import traceback
import celery
from api_dnl import settings
from datetime import date,datetime,timedelta
from dateutil.relativedelta import relativedelta
from pytz import UTC
from time import mktime,gmtime,strftime,strptime,localtime
import calendar
import requests
import io,csv,gzip,zipfile
import os,shutil
import xlwt
import json
from celery import Celery
from celery.app.log import get_logger
from celery.schedules import crontab
from falcon_rest.db import initialize_db
from sqlalchemy import (
    Integer, SmallInteger, Float, Text, String, DateTime, Date, Time, Boolean, ForeignKey, BigInteger,
    Table
)
from sqlalchemy import (Column, desc, and_,or_,not_, text as text_, PrimaryKeyConstraint, inspect, Index, UniqueConstraint)
from sqlalchemy.sql import func, select,alias,case
from api_dnl.base_model import DnlApiBaseModel
from api_dnl.model import SchedulerLog,ScheduledReportLog,Client,OrigInvoiceHistory,PaymentTerm,OrigInvoice,\
    DidBillingPlan,DidBillingRel,Client,Resource,JurisdictionPrefix,Code,ImportExportLogs,\
    ResourcePrefix,Rate,RateTable,RateSendLog,BalanceHistoryActual,C4ClientBalance,\
    RateSendLogDetail,CrdReportDetailTable,MailSender,FraudDetection,FraudDetectionLog,FraudDetectionLogDetail,\
    ResourceBlock,IngressTrunk,SystemParameter,AlertRule,AlertRuleLog,AlertRulesLogDetail,CdrReportDetail,client_cdr
from api_dnl.model import PrimaryKeyConstraint,func,query_to_sting,cast,generate_uuid_str,aliased,get_db
from api_dnl.tasks import app,log,db,SqlAlchemyTask
from api_dnl import model
from api_dnl.utils.statisticapi2 import StatisticAPI
from api_dnl.scheme import RateScheme

from api_dnl.utils.render_invoice import OrigInvoiceRender

TOLL_FREE = ['800', '888', '877', '866', '855', '844']
CODE_DECK_ID = 1


@app.task(base=SqlAlchemyTask)
def do_orig_invoice():
    log.debug('Invoice started')
    sl=SchedulerLog(script_name='orig_invoice',start_time=datetime.now(UTC))
    sl.save()
    total_invoices=0
    now_date=int(datetime.now(UTC).timestamp())
    cl = Client.filter(and_(Client.auto_invoicing==True,Client.egress_count>0,Client.status==True,
                            Client.payment_term_id.isnot(None),Client.name.isnot(None))).all()
    
    for client in cl:
        try:
            try:
                time_zone= set_time_zone(SystemParameter.query().one().sys_timezone)
            except:
                time_zone = 0

            if not client.name or not client.payment_term or not client.payment_term.type:
                print('invoice, client {} has not name or payment_term {} or payment_term.type'.format(client.client_id,client.payment_term_id))
                log.warning('invoice, client {} has not name or payment_term {} or payment_term.type'.format(client.client_id,client.payment_term_id))
                continue
            
            client_invoice_history=OrigInvoiceHistory.filter(OrigInvoiceHistory.client_id==client.client_id).order_by(OrigInvoiceHistory.last_invoice_for.desc()).first()
            if not client_invoice_history:
                log.debug('Invoice Client {} with Id:  {} is type {} is never invoiced before'.format(
                client.name, client.client_id, client.payment_term.type))
                last_invoiced = client.create_time - timedelta(weeks=100)
            else:
                _l = client_invoice_history.last_invoice_for
                last_invoiced = datetime(_l.year,_l.month,_l.day)

            invoice_start_from = int(last_invoiced.timestamp())
            sql_mod = None
            #TYPE_DICT = { 1: 'Every', 2: 'Day of Month', 3: 'Day of Week', 4: 'Some day of month', 5: 'Twice a month'}
            if client.payment_term.type == 'Every':  # Every Nth day
            #if client.payment_term.type == 1:  # Every Nth day
                print("Every Nth day")
                log.debug("Every Nth day")
                send_epoch = invoice_start_from + 24 * 3600 * client.payment_term.days
                print(last_invoiced.date() == datetime.today().date(), last_invoiced.date(),
                      datetime.today().date())
                end_epoch = invoice_start_from + 24 * 3600 * (
                        client.payment_term.days - 1)  # end of billing period invoice is one day before send date
                print("Last invoice: %s Send: %s  Now: %s  End of billing period: %s" % (
                last_invoiced, str(send_epoch), str(now_date), end_epoch))
                log.debug("Last invoice: %s Send: %s  Now: %s  End of billing period: %s" % (
                last_invoiced, str(send_epoch), str(now_date), end_epoch))
                if last_invoiced.date() < datetime.today().date():  # and  invoice_start_from < send_epoch  :  # send_epoch <= now_date  and
                    today = date.today()
                    send_datetime = today  # . replace(day=client_days) #same year, month  but the day is changed 
                    send_epoch = calendar.timegm(send_datetime.timetuple())
                    send_epoch_str = datetime.utcfromtimestamp(send_epoch)
                    end_timestamp = strftime("%Y-%m-%d", gmtime(send_epoch))
                    invoice_end_time = send_datetime + timedelta(days=-1)
                    invoice_start_time = send_datetime + timedelta(
                        days=-client.payment_term.days)  # timedelta(months=-1)  # send_datetime.replace(day=1)
                    # update invoice log
                    end_timestamp = strftime("%Y-%m-%d", gmtime(send_epoch))
                    # invoice_start_time = str(invoice_start_time)  + " 00:00:00"
                    # invoice_end_time = str(invoice_end_time) + " 23:59:59" 
                    sql_mod = OrigInvoiceHistory(last_invoice_for=end_timestamp,client_id=client.client_id)
                    total_invoices = total_invoices + 1
                    print(""" New Invoice for client %s , from: %s, To: %s """ % (
                    client, invoice_start_time, invoice_end_time))
                    log.debug(""" New Invoice for client %s , from: %s, To: %s """ % (
                    client, invoice_start_time, invoice_end_time))
                    invoice_delay(client.client_id, invoice_start_time, invoice_end_time)
                else:  # no invoice
                    print(
                        "No Invoice For client %s with Id %s with billing every %s-th day, Last invoice: %s   Now: %s  End of billing period: %s" % (
                        client.name, client.client_id, client.payment_term.days, last_invoiced,
                        strftime('%Y-%m-%d', localtime(now_date)),
                        strftime('%Y-%m-%d', localtime(end_epoch))))
                    log.debug(
                        "No Invoice For client %s with Id %s with billing every %s-th day, Last invoice: %s   Now: %s  End of billing period: %s" % (
                        client.name, client.client_id, client.payment_term.days, last_invoiced,
                        strftime('%Y-%m-%d', localtime(now_date)),
                        strftime('%Y-%m-%d', localtime(end_epoch))))
            # - if it is weekly, then we check the day of week , the invoice should be generated from the last week’s till end of yesterday
            if client.payment_term.type == 'Day of Month':  # # Day of month
                print("type: Month ")
                today = datetime.now() + timedelta(
                    hours=time_zone)  # date.today() +  timedelta(days=-7)
                client_days = client.payment_term.days  # which day
                send_datetime = today  # .replace(day=client_days) #same year, month  but the day is changed 
                send_epoch = calendar.timegm(send_datetime.timetuple())
                send_epoch_str = datetime.utcfromtimestamp(send_epoch)
                end_timestamp = strftime("%Y-%m-%d", gmtime(send_epoch))
                invoice_end_time = send_datetime + timedelta(days=-1)
                invoice_start_time = today.replace(
                    day=1)  # timedelta(months=-1)  # send_datetime.replace(day=1)
                print("invoice_start_time", invoice_start_time, invoice_end_time, relativedelta(months=-1))
                print("Today is %s" % today.day, today.day == client.payment_term.days)
                print(today, invoice_start_from, today.timestamp() - invoice_start_from, type(last_invoiced),
                      strftime('%Y-%m-%d', localtime(now_date)))
                # strftime("%Y-%m-%d 23:59:59");
                # invoice_start_time = str(invoice_start_time)  + " 00:00:00"
                # invoice_end_time = str(invoice_end_time) + " 23:59:59" 
                if today.day == client.payment_term.days and last_invoiced.day != today.day:  # int( today.timestamp() - invoice_start_from) > 24 * 3601): #  or client.payment_term.days == 28:
                    end_timestamp = str(send_datetime)
                    sql_mod = OrigInvoiceHistory(last_invoice_for=end_timestamp,client_id=client.client_id)
                    total_invoices = total_invoices + 1 
                    invoice_delay(client.client_id, invoice_start_time, invoice_end_time)
                    log.debug(
                        "New once in month invoice For client %s with Id %s with billing at %s-th day, Last invoice: %s   Now: %s , Invoice start date: %s, Invoice end date %s" % (
                        (client.name, client.client_id, client.payment_term.days, last_invoiced,
                         strftime('%Y-%m-%d ', localtime(now_date)), invoice_start_time,
                         invoice_end_time)))
                    print(
                        "New once in month invoice For client %s with Id %s with billing at %s-th day, Last invoice: %s   Now: %s , Invoice start date: %s, Invoice end date %s" % (
                        (client.name, client.client_id, client.payment_term.days, last_invoiced,
                         strftime('%Y-%m-%d ', localtime(now_date)), invoice_start_time,
                         invoice_end_time)))
                else:
                    print(
                        "No new once in month invoice For client %s with Id %s with billing at %s-th day, Last invoice: %s   Now: %s " % (
                        client.name, client.client_id, client.payment_term.days, last_invoiced,
                        strftime('%Y-%m-%d', localtime(now_date))))


            elif client.payment_term.type == 'Day of Week':  # Day of Week
                print("Day of Week")
                log.debug("Day of Week")
                DAYS_OF_WEEK = PaymentTerm.DAYS_OF_WEEK
                today = datetime.now() + timedelta(hours=time_zone)
                # today = date.fromtimestamp(time.time() + timedelta(hours=time_zone)  )    #today = date.today()  #+ timedelta(days=-2)   date.fromtimestamp(time.time())
                day_of_week = today.weekday() + 1  # monday is zero in Python!!!
                diff = client.payment_term.days - day_of_week
                print(client.payment_term.days, day_of_week)
                log.debug("invoice_start_from %s" % invoice_start_from)
                print("invoice_start_from %s" % invoice_start_from)
                print("diff", diff, mktime(today.timetuple()), invoice_start_from,
                      now_date - invoice_start_from)
                print()
                if diff == 0 and int(mktime(
                        today.timetuple()) - invoice_start_from) > 24 * 3601:  # if not same day of week, Skip!! Also the diff in seconds between now and last invoice must be bigger from 24 * 3601(a day)
                    client_days = client.payment_term.days  # which day of week
                    send_epoch = calendar.timegm(today.timetuple())
                    send_epoch_str = datetime.utcfromtimestamp(send_epoch)
                    end_timestamp = strftime("%Y-%m-%d", gmtime(send_epoch))
                    today = date.today()  # + timedelta(days=-2)
                    invoice_start_time = today + timedelta(days=-7)  # str(last_invoiced) 
                    invoice_end_time = today + timedelta(days=-1)
                    sql_mod = OrigInvoiceHistory(last_invoice_for=end_timestamp, client_id=client.client_id)
                    total_invoices = total_invoices + 1
                    invoice_delay(client.client_id, invoice_start_time, invoice_end_time)
                    print(
                        "For client with id %s ,with billing: Day of week: %s. New Invoiced is made.Last invoice was at: %s .Today  is %s,  %s" % (
                        client.client_id, DAYS_OF_WEEK[client.payment_term.days], invoice_start_time,
                        DAYS_OF_WEEK[day_of_week], strftime("%Y-%m-%d", gmtime(now_date))))
                    log.debug(
                        "For client with id %s ,with billing: Day of week: %s. New Invoiced is made.Last invoice was at: %s .Today  is %s,  %s" % (
                        client.client_id, DAYS_OF_WEEK[client.payment_term.days], invoice_start_time,
                        DAYS_OF_WEEK[day_of_week], strftime("%Y-%m-%d", gmtime(now_date))))
                # Make Invoice!
                else:  # NO invoice!
                    print(
                        "For client with id %s ,with billing: Day of week: %s. New Invoiced is not neeeded now.Last invoice was at: %s .Today is %s, %s" % (
                        client.client_id, DAYS_OF_WEEK[client.payment_term.days], client.last_invoiced,
                        DAYS_OF_WEEK[day_of_week], strftime("%Y-%m-%d", gmtime(now_date))))
                    log.debug(
                        "For client with id %s ,with billing: Day of week: %s. New Invoiced is not neeeded now.Last invoice was at: %s .Today is %s, %s" % (
                        client.client_id, DAYS_OF_WEEK[client.payment_term.days], client.last_invoiced,
                        DAYS_OF_WEEK[day_of_week], strftime("%Y-%m-%d", gmtime(now_date))))

            elif client.payment_term.type == 'Some day of month':  # Some Day of month
                payment_days = client.payment_term.more_days_arr #client.payment_term.more_days.split(",")
                today = date.today()
                today_now = datetime.now() + timedelta(hours=time_zone)
                invoice_end_time = today + timedelta(days=-1)
                invoice_start_time = today + relativedelta(
                    months=-1)  # str(last_invoiced) timedelta(months=-1)
                invoice_end_time = invoice_end_time
                Make_invoice = False
                for day in payment_days:
                    print(today.day, type(today.day), day, type(day))
                    log.debug("Today: %s, Payment Day %s" % (str(today.day), str(day)))
                    if int(today.day) == int(day):
                        if int(mktime(
                                today_now.timetuple()) - invoice_start_from) > 24 * 3601:  # if not same day of week, Skip!! Also the diff in seconds between now and last invoice must be bigger from 24 * 3601(a day)
                            Make_invoice = True
                            break
                if Make_invoice == True:
                    print(
                        "For client_id %s billing type : Days of month: %s . New Invoice is created. From: %s , To: %s .Last invoice was at: %s .Today is %s" % (
                        client.client_id, payment_days, invoice_start_time, invoice_end_time, last_invoiced,
                        strftime('%Y-%m-%d %H:%M:%S', localtime(now_date))))
                    log.debug(
                        "For client_id %s billing type : Days of month: %s . New Invoice is created. From: %s , To: %s .Last invoice was at: %s .Today is %s" % (
                        client.client_id, payment_days, invoice_start_time, invoice_end_time, last_invoiced,
                        strftime('%Y-%m-%d %H:%M:%S', localtime(now_date))))
                    send_epoch = calendar.timegm(today.timetuple())
                    send_epoch_str = datetime.utcfromtimestamp(send_epoch)
                    end_timestamp = strftime("%Y-%m-%d", gmtime(send_epoch))
                    total_invoices = total_invoices + 1
                    invoice_delay(client.client_id, invoice_start_time, invoice_end_time)
                    sql_mod = OrigInvoiceHistory(last_invoice_for=end_timestamp, client_id=client.client_id)
                else:
                    log.debug(
                        "For client_id %s billing type : Days of month: %s . Invoice is not created. Today is %s" % (
                        client.client_id, payment_days,
                        strftime('%Y-%m-%d', localtime(now_date))))
                    print(
                        "For client_id %s billing type : Days of month: %s . Invoice is not created. Today is %s" % (
                        client.client_id, payment_days,
                        strftime('%Y-%m-%d', localtime(now_date))))

            if sql_mod != None:
                print("Updating DB invoice history with SQL: %s" % (sql_mod))
                sql_mod.save()
   
        except Exception as e:
            log.debug('Invoice error:{} {}'.format(e,str( traceback.print_exc())))
            return False
    
    log.debug('Invoice finished, scheduled total {} invoices'.format(total_invoices))
    sl.end_time=datetime.now(UTC)
    sl.save()
    return True

def invoice_delay(client_id,invoice_start_time, invoice_end_time):
    #invoice.delay(client_id, invoice_start_time, invoice_end_time)
    orig_invoice(client_id, invoice_start_time, invoice_end_time)


@app.task(base=SqlAlchemyTask)
def orig_invoice(client_id,invoice_start_time, invoice_end_time):
    try:

        client = Client.get(client_id)

        invoice_id=render_orig_invoice(client_id, invoice_end_time, invoice_start_time, 30,
                                       show_account_summary=client.is_invoice_account_summary,
                                       show_transaction_summary_analysis=client.is_auto_summary,
                                       show_authorization_code_summary=client.is_show_code_100,
                                       show_all_area_codes_summary=client.is_show_code_name,
                                       show_origination_lata_summary=client.is_show_country,
                                       create_type='auto')
        if invoice_id:
            invoice=OrigInvoice.get(invoice_id)
            if client and client.email_invoice:
                if SystemParameter.query().first().invoice_send_mode=='attachment':
                    att=[('pdf',invoice.file_data)]
                else:
                    att=[]
                ret=MailSender.apply_mail(invoice,'invoice',att=att)
                if ret:
                    if hasattr(MailSender,'last_error'):
                        log.debug('Invoice sent error client_id {} {}'.format(client_id,MailSender.last_error))
                    else:
                        log.debug('Invoice sent error client_id {} '.format(client_id))
                invoice.state='send'
                invoice.save()
            else:
                log.debug('Invoice generated but not sent  client_id {}'.format(client_id))
        else:
            log.debug('Invoice not generated  client_id {}'.format(client_id))
    except Exception as e:
        log.debug('Invoice generate failed client_id {} error is:{}'.format(client_id,e))

def set_time_zone(time_zone):
    if '(' in  time_zone:
        time_zone=time_zone.replace('(','').replace(')','')
    sign = time_zone[0]
    hour = int(time_zone[1:3])
    mins = int(time_zone[4:])
    mins = (10 / 6) * mins
    if sign == "+":
        hour = hour
    else:
        hour = -1 * hour
    return hour



def render_orig_invoice(client_id, date_end, date_start, due,show_account_summary = True,
    show_transaction_summary_analysis = True,show_authorization_code_summary = True,show_all_area_codes_summary = True,
                  show_origination_lata_summary = True,create_type='manual'):

    end_date = datetime(date_end.year,date_end.month,date_end.day,23,59,59)
    if date_start == None:
        start_date = end_date.replace(day=1, hour=0, minute=0, second=0)
    else:
        start_date = datetime(date_start.year,date_start.month,date_start.day)
    conf = SystemParameter.query().first()
    if not conf.allow_invoice_overlap:
        cls=OrigInvoice
        q=cls.filter(and_(cls.client_id==client_id,cls.invoice_end>start_date,cls.invoice_start<end_date,cls.state!=-1)).first()
        if q:
            raise Exception('Overlap orig_invoice {} start {} end {}'.format(q.invoice_id,q.invoice_start,q.invoice_end))
    invoice_dates = (
        int(start_date.timestamp()), int(end_date.timestamp()))
    context = _collect_context( client_id, invoice_dates, due)
    context.update(dict(show_account_summary=show_account_summary,
            show_transaction_summary_analysis=show_transaction_summary_analysis,
            show_authorization_code_summary=show_authorization_code_summary,
            show_all_area_codes_summary=show_all_area_codes_summary,
            show_origination_lata_summary=show_origination_lata_summary))
    filename = '{}{}.pdf'.format(context["invoice_name"] , datetime.now(UTC).strftime("%Y%m%d%H%M") )
    fullname='{}/{}'.format(settings.FILES['invoices'],filename)
    log.debug("Collected context {}".format(context))
    log.debug("filename {}".format(filename))
    if context["client_name"] is None:
        log.debug("No client with this client_id")
        return None

    invoice = OrigInvoiceRender(context, fullname)
    if invoice.generate():
        inv = OrigInvoice(
            invoice_number=context["invoice_name"],
            state=1,
            client_id=client_id,
            invoice_time=datetime.now(UTC),
            invoice_start=start_date,#.timestamp(),  # end_date.replace(day=1, hour=0, minute=0, second=0).timestamp(),
            invoice_end=end_date,#.timestamp(),
            total_amount=context["amount_due"],
            pdf_path=filename,
            create_type=create_type,
            due_date=datetime.strptime(context["due_date"],'%m-%d-%Y').date(),
            show_account_summary=show_account_summary,
            show_transaction_summary_analysis=show_transaction_summary_analysis,
            show_authorization_code_summary=show_authorization_code_summary,
            show_all_area_codes_summary=show_all_area_codes_summary,
            show_origination_lata_summary=show_origination_lata_summary
            # current_balance=context["prev_balance"]
        )
        
        invoice_id=inv.save()
        
        did_billing = DidBillingPlan.query().outerjoin(DidBillingRel,DidBillingRel.buy_billing_plan_id==DidBillingPlan.id).\
            outerjoin(Resource,and_(Resource.resource_id==DidBillingRel.ingress_res_id,Resource.egress==True)).\
            filter(Resource.client_id==client_id).first()
        if did_billing:
            log.debug("get did_billing {}".format(did_billing.id))
            did_billing.did_price = 0
            log.debug("zero did_billing price" )
            did_billing.save()
        
        c=Client.filter(Client.client_id==client_id).first()
        c.last_invoiced = datetime.now(UTC)
        c.save() 

        #with open(filename, 'rb') as fd:
        #    data = fd.read()
        return invoice_id
    else:
        log.debug("Invoice is not generated")
        return None


def _collect_context(client_id, invoice_dates, due):
    log.debug("Start collect context")
    company_name = None
    egress_ids = []
    
    #auth_token = _get_token()
    #log.info("Received auth token <{}>".format(auth_token))

    inv = SystemParameter.query().first()
    tpl_number = inv.tpl_number
    pdf_tpl = inv.pdf_tpl
    company_info = inv.company_info
    company_info_location = inv.company_info_location
    invoice_decimal_digits = inv.invoice_decimal_digits
    
    cl = Client.get(client_id)
    company_name = cl.company if cl.company else 'UNKNOWN'
    egress_ids = cl._egress()
    

    log.debug("Start collect acs")
    authorization_code_summary = _authorization_code_summary_report( invoice_dates, egress_ids)
    log.debug("Start collect aacs")
    all_area_codes_summary = _all_area_codes_summary_report(invoice_dates, egress_ids)
    log.debug("Start collect ols")
    origination_lata_summary = _origination_lata_summary_report(invoice_dates, egress_ids)
    log.debug("Start coleect tsa")
    transaction_summary_analysis, recurring_charges = _transaction_summary_analysis_report(invoice_dates, client_id)
    code_usage = {}
    code_usage_date = {}

    log.debug("authorization_code_summary %s" % str(authorization_code_summary))
    for code in authorization_code_summary:
        if code_usage.get(code[0] + strftime('%Y-%m-%d', localtime(code[5]))):
            code_usage[code[0] + strftime('%Y-%m-%d', localtime(code[5]))] = (
                code_usage[code[0] + strftime('%Y-%m-%d', localtime(code[5]))][0] + code[3],
                code_usage[code[0] + strftime('%Y-%m-%d', localtime(code[5]))][1] + code[4],
                "{} minutes of usage to {}".format(
                    round(float(code_usage[code[0] + strftime('%Y-%m-%d', localtime(code[5]))][0] + code[3]),
                          invoice_decimal_digits)
                    , code[0]), code[-1])
        else:
            code_usage[code[0] + strftime('%Y-%m-%d', localtime(code[5]))] = (
                code[3], code[4],
                "{} minutes of usage to {}".format(round(float(code[3]), invoice_decimal_digits), code[0]), code[-1])
    # authorization_code_summary [('7180000000', 'International', 1, 1.02, 1.02, 1503122760),
    for code in authorization_code_summary:
        if code_usage_date.get(code[0] + strftime('%Y-%m-%d', localtime(code[5]))):
            code_usage_date[code[0] + strftime('%Y-%m-%d', localtime(code[5]))] = \
                [code[0], code[1], code_usage_date[code[0] + strftime('%Y-%m-%d', localtime(code[5]))][2] + code[2],
                round(float(code_usage_date[code[0] + strftime('%Y-%m-%d', localtime(code[5]))][3] + code[3]), invoice_decimal_digits),
                code_usage_date[code[0] + strftime('%Y-%m-%d', localtime(code[5]))][4] + code[4], code[5]]

        else:
            code_usage_date[code[0] + strftime('%Y-%m-%d', localtime(code[5]))] = [code[0], code[1], code[2],
                                                                                             code[3], code[4], code[5]]

    long_distance_charges_withoutTSA = 0
    month_charges = sum([item[2] for item in transaction_summary_analysis])
    long_distance_charges = sum([item[4] for item in all_area_codes_summary])
    print("monthly_charges", month_charges, "long_distance_charges", long_distance_charges)
    for k, v in code_usage.items():
        long_distance_charges_withoutTSA += round(float(v[1]), invoice_decimal_digits)
        transaction_summary_analysis.append((
            # datetime.fromtimestamp(float(invoice_dates[1])).strftime('%Y-%m-%d'),
            datetime.fromtimestamp(v[-1]).strftime('%Y-%m-%d'),
            v[2],
            round(float(v[1]), invoice_decimal_digits)))
    authorization_code_summary = []
    for k, v in code_usage_date.items():
        authorization_code_summary.append(v)
    log.debug("authorization_code_summary2 %s" % str(authorization_code_summary))

    prev_balance = cl.actual_balance
    if not  prev_balance:
        prev_balance= 0.0
    # try:
    #    long_distance_charges = long_distance_charges_withoutTSA  #sum([item[2] for item in transaction_summary_analysis])
    # except IndexError:
    #    print("INDEXEEROR in long_distance_charges_withoutTSA ") 
    #    long_distance_charges = 0.0
    # if long_distance_charges_withoutTSA  == 0:
    #  print("long_distance_charges_withoutTSA:",long_distance_charges_withoutTSA)
    # long_distance_charges = 0.0
    # month_charges = 0 
    # recurring_charges = _get_recurring_charges(conn, client_id, invoice_dates)
    # recurring_charges += month_charges

    amount_due = round(long_distance_charges + month_charges, invoice_decimal_digits)  # - recurring_charges
    try:
        print("long_distance_charges %s   - recurring_charges2: %s  + month_charges %s" % (
        long_distance_charges, recurring_charges, month_charges))
    except Exception as e:
        print(e)
    try:
        int(due)
    except:
        due = 0
    due_date = datetime.now(UTC) + timedelta(days=int(due))
    logo=ImportExportLogs.filter(ImportExportLogs.id==SystemParameter.logo_image_id).first().file
    return {
        "logo":logo,
        "company_info": company_info,
        "pdf_tpl": pdf_tpl,
        "invoice_name": _get_new_invoice_number(),
        "invoice_decimal_digits": invoice_decimal_digits,
        "company_info_location": company_info_location,
        "tpl_number": tpl_number,
        "acc_num": "{}_{}".format(client_id, invoice_dates[1]),
        "bill_date": datetime.now(UTC).strftime('%m-%d-%Y'),
        "due_date": due_date.strftime('%m-%d-%Y'),
        "billing_period": "{} - {}".format(
            datetime.fromtimestamp(float(invoice_dates[0])).strftime('%m-%d-%Y'),
            datetime.fromtimestamp(float(invoice_dates[1])).strftime('%m-%d-%Y')),
        "amount_due": amount_due,
        "client_name": company_name,
        "prev_balance": round(float(prev_balance), invoice_decimal_digits),
        "long_distance_charges": round(float(long_distance_charges), invoice_decimal_digits),
        "recurring_charges": round(float(recurring_charges), invoice_decimal_digits),
        "transaction_summary_analysis": transaction_summary_analysis,
        "authorization_code_summary_report": authorization_code_summary,
        "all_area_codes_summary_report": all_area_codes_summary,
        "origination_lata_summary_report": origination_lata_summary
    }




def is_toll_free(number):
    if str(number)[0:3] in TOLL_FREE:
        return True
    if str(number)[1:4] in TOLL_FREE:
        return True
    else:
        return False

def get_did_type( number):
    # US Toll Free
    if str(number)[0:3] in TOLL_FREE:
        return 'US Toll Free'
    if str(number)[1:4] in TOLL_FREE:
        return 'US Toll Free'
    # US Local
    if str(number)[0] == '1':
        did = str(number)[1:]
    else:
        did = str(number)

    us=JurisdictionPrefix.filter(text_("prefix @> '{}'".format(did))).first()
    if us:
        return 'US Local'
    # International
    return 'International'

def get_did_area_code( number):
    # US Toll Free
    if str(number)[0:3] in TOLL_FREE:
        return 'US Toll Free'
    if str(number)[1:4] in TOLL_FREE:
        return 'US Toll Free'
    # US Local
    us=JurisdictionPrefix.filter(text_("prefix @> '{}'".format(number))).first()
    if us:
        print ("get_did_area code US",str(us))
        if us.jurisdiction_name != "": 
          print ("get_did_code US returned",str(us.prefix))
          return us.prefix
    # International
    print("International")
    row = Code.filter(and_(Code.code_deck_id==CODE_DECK_ID,text_("code @> '{}'".format(number)))).first()
    if row:
        print ("get_did_area code EU ",str(row.name))
        if row.name != "": 
          print ("get_did_code EU returned ",str(row.name))
          return row.code
    # Unknown
    print ("Anonymous")
    return "Anonymous"


def get_did_location( number):
    # US Toll Free
    if str(number)[0:3] in TOLL_FREE:
        return 'US Toll Free'
    if str(number)[1:4] in TOLL_FREE:
        return 'US Toll Free'
    # US Local
    us=JurisdictionPrefix.filter(text_("prefix @> '{}'".format(number))).first()
    if us:
        print ("get_did_location code US",str(us))
        if us.jurisdiction_name != "": 
          print ("get_did_location US returned",str(us.jurisdiction_name))
          return us.jurisdiction_name
    # International
    print("International")
    row = Code.filter(and_(Code.code_deck_id==CODE_DECK_ID,text_("code @> '{}'".format(number)))).first()
    if row:
        print ("get_did_area code EU ",str(row.name))
        if row.name != "": 
          print ("get_did_code EU returned ",str(row.name))
          return row.name
    # Unknown
    print ("Anonymous")
    return "Anonymous"


def get_did_lata(number):
    # US Toll Free
    if str(number)[0:3] in TOLL_FREE:
        return 'US Toll Free'
    if str(number)[1:4] in TOLL_FREE:
        return 'US Toll Free'
    # US Local
    us = JurisdictionPrefix.filter(text_("prefix @> '{}'".format(number))).first()
    if us:
        print ("get_did_lata",str(us.jurisdiction_name))
        if us.lata != "": 
          print ("get_did_lata returned",str(us.lata))
          return us.lata
    # International
    return 'OTHERs'


def _get_new_invoice_number():
    sql="SELECT nextval('class4_seq_invoice_no') AS last_invoice_number"
    last_invoice_number = get_db().session.execute(sql).fetchall()[0][0]
    while OrigInvoice.filter(OrigInvoice.invoice_number==str(last_invoice_number)).first():
        last_invoice_number = get_db().session.execute(sql).fetchall()[0][0]
    return last_invoice_number

def _authorization_code_summary_report(invoice_dates, egress_ids):
    res = []
    if egress_ids:
        params = {
            "start_time": invoice_dates[0],
            "end_time": invoice_dates[1],
            "step": "86400",  #"86400",
            "method": "total",
            "field": "calls",
            "egress_id": egress_ids,
            "group": "dest_number",
            #"output": "http"
        }
        timeout = (1, 5)
        log.debug("Start request _authorization_code_summary_report")
        log.debug(params)
        calls = StatisticAPI.send_request(params=params)
        log.debug("CALLS %s" % str( calls.json() ) )
        if calls.json()["data"]:
            params["field"] = "egress_billed_time"
            egress_billed_time = StatisticAPI.send_request(params=params)
            log.debug("egress_billed_time %s"%str(egress_billed_time))
            params["field"] = "egress_cost"
            egress_cost = StatisticAPI.send_request(params=params)
            d_calls = [item for item in calls.json()["data"] if item]
            d_time = [item for item in egress_billed_time.json()["data"] if item]
            d_cost = [item for item in egress_cost.json()["data"] if item]
            log.debug(len(d_calls))
            #log.debug(d_time)
            #log.debug(d_cost)
            invoice_decimal_digits = SystemParameter.query().one().invoice_decimal_digits
            for i, item in enumerate(d_calls):
                if not "dest_number" in item or not is_toll_free(item["dest_number"]):
                   log.debug("item is not TOLL FREE %s" % str(item) )      
                   continue
                else:
                   log.debug("item is TOLL FREE %s" % str(item) )      
                #log.debug("item %s" % str(item) )
                try:
                 res.append((
                    item["dest_number"],
                    get_did_type(item["dest_number"]),
                    int(item["calls"]),
                    round(float(d_time[i]["egress_billed_time"]) / 60, invoice_decimal_digits),
                    round(float(d_cost[i]["egress_cost"]), invoice_decimal_digits),
                    round(float(item["time"]), invoice_decimal_digits)
                ))
                except Exception as e :
                 pass #print(e)
    print ("returned list ",res  )
    return res


def _all_area_codes_summary_report( invoice_dates, egress_ids):
    res = []
    if egress_ids:
        #headers = {"Authorization": "Token {}".format(auth_token)}
        params = {
            "start_time": invoice_dates[0],
            "end_time": invoice_dates[1],
            "step": "86400",
            "method": "total",
            "field": "calls",  # "calls",
            "egress_id": egress_ids,
            "group": "source_number",
            # "output": "http"
        }
        timeout = (1, 5)
        # log.debug("all_area_codes_summary_report")
        calls = StatisticAPI.send_request(params=params)
        log.debug("CALLS all_area_codes_summary_report %s" % str(calls.json()))
        if calls.json()["data"]:
            # print ("their is calls")
            params["field"] = "egress_billed_time"
            egress_billed_time = StatisticAPI.send_request( params=params)
            log.debug("egress_billed_time %s" % str(egress_billed_time.json()))
            params["field"] = "egress_cost"
            egress_cost = StatisticAPI.send_request( params=params)
                
            log.debug("egress_cost %s" % str(egress_cost.json()))
            d_calls = [item for item in calls.json()["data"] if item]
            d_time = [item for item in egress_billed_time.json()["data"] if item]
            d_cost = [item for item in egress_cost.json()["data"] if item]
            log.debug(d_calls)
            log.debug(d_time)
            log.debug(d_cost)
            invoice_decimal_digits = SystemParameter.query().one().invoice_decimal_digits
            for i, item in enumerate(d_calls):
                # if not is_toll_free(item["destination number"]):
                print(i, item)
                if not "source_number" in item:
                    continue


                try:
                    res.append((

                        get_did_area_code(item["source_number"]),
                        get_did_location(item["source_number"]),
                        # int(item["value"]),
                        int(item["calls"]),
                        round(float(d_time[i]["egress_billed_time"]) / 60, invoice_decimal_digits),
                        round(float(d_cost[i]["egress_cost"]), invoice_decimal_digits)
                    ))
                except:
                    print("Exception in code line 82. Possible calls = 0.0 , source_number is omitted from the API")
                    pass
    print("res ALL AREA CODES SUMMARY REPORT", res)
    return res


def _origination_lata_summary_report(invoice_dates, egress_ids):
    res = []
    if egress_ids:
        params = {
            "start_time": invoice_dates[0],
            "end_time": invoice_dates[1],
            "step": "86400",
            "method": "total",
            "field": "calls",
            "egress_id": egress_ids,
            "group": "source_number",
            # "output": "http"
        }
        timeout = (1, 5)
        log.debug("Start request _origination_lata_summary_report")
        calls = StatisticAPI.send_request( params=params)
        log.debug("CALLS lata_summary %s" % str(calls.json()))
        if calls.json()["data"]:
            params["field"] = "egress_billed_time"
            egress_billed_time = StatisticAPI.send_request( params=params)
            params["field"] = "egress_cost"
            egress_cost = StatisticAPI.send_request( params=params)

            d_calls = [item for item in calls.json()["data"] if item]
            d_time = [item for item in egress_billed_time.json()["data"] if item]
            d_cost = [item for item in egress_cost.json()["data"] if item]
            log.debug(d_calls)
            log.debug(d_time)
            log.debug(d_cost)
            invoice_decimal_digits = SystemParameter.query().one().invoice_decimal_digits
            for i, item in enumerate(d_calls):
                # if not is_toll_free(item["destination number"]):
                print(i, item)
                if not "source_number" in item:
                    continue
                lata = get_did_lata(item["source_number"])
                print("lata", lata)

                location = "Anonymous" if lata == 'OTHERs' else get_did_location(item["source_number"])
                dup = [(j, k) for j, k in enumerate(res) if lata == k[0]]
                if dup:
                    index, old_record = dup[0]
                    res[index] = (
                        lata,
                        location,
                        old_record[2] + int(item["calls"]),
                        round(old_record[3] + float(d_time[i]["egress_billed_time"]) / 60, invoice_decimal_digits),
                        round(old_record[4] + float(d_cost[i]["egress_cost"]), invoice_decimal_digits)
                    )
                else:
                    res.append((
                        lata,
                        location,
                        int(item["calls"]),
                        round(float(d_time[i]["egress_billed_time"]) / 60, invoice_decimal_digits),
                        round(float(d_cost[i]["egress_cost"]), invoice_decimal_digits)
                    ))

    return res


transaction_summary_analysis = '''
    SELECT t.description, t.fee
    FROM (
        SELECT 'One-time Setup Fee for DID ' || did_billing_rel.did AS description,
            CASE 
                WHEN date_trunc('month', coalesce(did_billing_rel.start_date, CURRENT_DATE)) = 
                    date_trunc('month', '{invoice_date}'::date) THEN coalesce(did_billing_plan.did_price, 0.0)
                ELSE 0.0
            END AS fee
        FROM resource
            INNER JOIN did_billing_rel ON did_billing_rel.ingress_res_id = resource.resource_id
            INNER JOIN did_billing_plan ON did_billing_rel.buy_billing_plan_id = did_billing_plan.id
        WHERE resource.egress 
            AND resource.client_id = {client_id}
        UNION ALL
        SELECT 'Monthly Fee for DID ' || did_billing_rel.did AS description, 
            coalesce(did_billing_plan.monthly_charge, 0.0) AS fee
        FROM resource
            INNER JOIN (
                SELECT t.did, t.ingress_res_id, t.buy_billing_plan_id, t.days_in_month, t.end_date - t.start_date + 1 AS days
                FROM (
                    SELECT did_billing_rel.did, did_billing_rel.ingress_res_id, did_billing_rel.buy_billing_plan_id,
                        date_part('days', date_trunc('month', '{invoice_date}'::date) + '1 MONTH'::interval - '1 DAY'::interval) AS days_in_month,
                        GREATEST(did_billing_rel.start_date, date_trunc('month', '{invoice_date}'::date)::date) AS start_date,
                        LEAST(did_billing_rel.end_date, date_trunc('month', '{invoice_date}'::date) + '1 MONTH'::interval - '1 DAY'::interval)::date AS end_date
                    FROM did_billing_rel
                ) t
                WHERE t.end_date - t.start_date > -1) did_billing_rel ON did_billing_rel.ingress_res_id = resource.resource_id
            INNER JOIN did_billing_plan ON did_billing_rel.buy_billing_plan_id = did_billing_plan.id
        WHERE resource.egress 
            AND resource.client_id = {client_id}
            AND did_billing_rel.days / did_billing_rel.days_in_month * coalesce(did_billing_plan.monthly_charge, 0.0) > 0
    ) AS t
    WHERE  t.fee > 0 '''

def _transaction_summary_analysis_report(invoice_dates, client_id):
    from_date = datetime.fromtimestamp(float(invoice_dates[0])).strftime('%Y-%m-%d')
    query = transaction_summary_analysis.format(invoice_date=from_date, client_id=client_id)
    log.debug("transaction_summary_analysis_report with recurring_charges")
    log.debug(query)
    result = []
    cur = get_db().session.execute(query)
    charges_list = []
    recurring_charges = 0.0
    invoice_decimal_digits = SystemParameter.query().one().invoice_decimal_digits
    for row in cur.fetchall():
        log.debug("Charges list %s" % str(charges_list) )
        if row[0] in charges_list:
           log.debug("This fee already exists %s" % row[0] )
           continue
        charges_list.append(row[0])
        result.append((
            datetime.fromtimestamp(float(invoice_dates[1])).strftime('%Y-%m-%d'),
            row[0],
            round(float(row[1]), invoice_decimal_digits)))
        recurring_charges += round(float(row[1]), invoice_decimal_digits)

    return result,recurring_charges