#!/usr/bin/python3
from falcon_rest.testing import get_random_object
from falcon_rest.logger import log
from falcon_rest.conf import settings
from falcon_rest.db import initialize_db, errors
from api_dnl.base_model import DnlApiBaseModel
from . entities.api_permission.api_entity import ApiEntityModel
from . settings import DB_CONN_STRING

from . entities.user.user import UserScheme


def create_admin_user(name=None, email=None, password=None):
    log.warning('Creating admin user')
    user = get_random_object(UserScheme, login_ip='127.0.0.1')

    if name is not None:  # pragma: no cover
        user.name = name
    if email is not None:  # pragma: no cover
        user.email = email
    if password is not None:  # pragma: no cover
        user.password = password

    plain_text_password = user.password
    user.password = settings.get_auth_module().auth.get_hashed_password(plain_text_password)
    user.save()
    return user.name, plain_text_password

if __name__ == '__main__':
    initialize_db(DB_CONN_STRING, DnlApiBaseModel)
    # create_admin_user('admin','admin@acme.com','yoo5Iche')
