"""rate_generation_history_detail

Revision ID: 5698d17f29c6
Revises: 838106f3a379
Create Date: 2018-02-25 16:06:08.334677

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = '5698d17f29c6'
down_revision = '838106f3a379'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    from sqlalchemy.schema import Sequence, CreateSequence
    op.execute(CreateSequence(Sequence('rate_generation_history_detail_id_seq')))
    op.create_table('rate_generation_history_detail',
    sa.Column('id', sa.Integer(), server_default=sa.text("nextval('rate_generation_history_detail_id_seq'::regclass)"), nullable=False),
    sa.Column('rate_table_id', sa.Integer(), nullable=True),
    sa.Column('effective_date_new', sa.DateTime(timezone=True), nullable=True),
    sa.Column('effective_date_increase', sa.DateTime(timezone=True), nullable=True),
    sa.Column('effective_date_decrease', sa.DateTime(timezone=True), nullable=True),
    sa.Column('is_send_mail', sa.Boolean(), nullable=True),
    sa.Column('end_date', sa.Date(), nullable=True),
    sa.Column('email_template_id', sa.Integer(), nullable=True),
    sa.Column('rate_generation_history_id', sa.Integer(), nullable=True),
    sa.Column('create_on', sa.DateTime(timezone=True), nullable=True),
    sa.Column('create_by', sa.String(length=100), nullable=True),
    sa.Column('finished_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('end_date_method', sa.Integer(), server_default=sa.text('1'), nullable=True),
    sa.Column('rand_flg', sa.String(length=100), nullable=True),
    sa.Column('new_rate_end_date', sa.Date(), nullable=True),
    sa.ForeignKeyConstraint(['email_template_id'], ['send_rate_template.id'], ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['rate_generation_history_id'], ['rate_generation_history.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('rate_generation_history_detail')
    # ### end Alembic commands ###
