"""new email_template

Revision ID: 61ec5b211ed2
Revises: d922fab2d660
Create Date: 2017-11-05 04:48:31.421481

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = '61ec5b211ed2'
down_revision = 'd922fab2d660'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('mail_template',
    sa.Column('title', sa.String(length=200), nullable=False),
    sa.Column('subject', sa.String(length=200), nullable=True),
    sa.Column('from_mail_id', sa.Integer(), nullable=True),
    sa.Column('cc_mail', sa.String(length=200), nullable=True),
    sa.Column('html_content', sa.Text(), nullable=True),
    sa.ForeignKeyConstraint(['from_mail_id'], ['mail_sender.id'], ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('title')
    )
    op.drop_table('mail_tmplate')
    op.drop_index('ix_balance_history_actual_date', table_name='balance_history_actual')
    op.create_index(op.f('ix_balance_history_actual_date'), 'balance_history_actual', ['date'], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_balance_history_actual_date'), table_name='balance_history_actual')
    op.create_index('ix_balance_history_actual_date', 'balance_history_actual', ['date', 'client_id'], unique=True)
    op.create_table('mail_tmplate',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('invoice_from', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('invoice_to', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('invoice_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('invoice_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('payment_from', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('payment_to', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('payment_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('payment_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('lowbalance_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('lowbalance_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('noc_email_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('noc_email_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('carrier_email_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('carrier_email_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('alert_email_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('alert_email_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('carrier_invoice_subject', sa.TEXT(), server_default=sa.text("'Invoice form {start_Date} – {end_date}'::text"), autoincrement=False, nullable=True),
    sa.Column('carrier_invoice_content', sa.TEXT(), server_default=sa.text("'Dear {carrier_name},\r\n          This is invoice {invoice_number} for {start_date} – {end_date}.\r\n        Please remit your due balance within the terms of your contractual\r\n        agreement to avoid disconnection of service.\r\n--\r\nAutogenerated by billing system'::text"), autoincrement=False, nullable=True),
    sa.Column('auto_summary_subject', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('auto_summary_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('auto_balance_subject', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('auto_balance_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('auto_delivery_subject', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('auto_delivery_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('auto_cdr_subject', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('auto_cdr_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('no_route_available_alert_email_subject', sa.VARCHAR(length=225), autoincrement=False, nullable=True),
    sa.Column('no_route_available_alert_email_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('target_match_alert_email_subject', sa.VARCHAR(length=225), autoincrement=False, nullable=True),
    sa.Column('target_match_alert_email_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('rate_watch_alert_email_subject', sa.VARCHAR(length=225), autoincrement=False, nullable=True),
    sa.Column('rate_watch_alert_email_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('route_update_alert_email_subject', sa.VARCHAR(length=225), autoincrement=False, nullable=True),
    sa.Column('route_update_alert_email_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('rate_update_alert_email_subject', sa.VARCHAR(length=225), autoincrement=False, nullable=True),
    sa.Column('rate_update_alert_email_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('low_balance_alert_email_subject', sa.VARCHAR(length=225), autoincrement=False, nullable=True),
    sa.Column('low_balance_alert_email_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('new_invoice_posted_mail_alert_email_subject', sa.VARCHAR(length=225), autoincrement=False, nullable=True),
    sa.Column('new_invoice_posted_mail_alert_email_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('payment_sent_subject', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('payment_sent_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('payment_received_subject', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('payment_received_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('trouble_ticket_subject', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('trouble_ticket_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('send_cdr_subject', sa.VARCHAR(length=255), autoincrement=False, nullable=True),
    sa.Column('send_cdr_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('select_route_up_email_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('select_route_up_email_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('exchange_auto_summary_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('exchange_auto_summary_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('finance_alert_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('finance_alert_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('buy_qos_alert_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('buy_qos_alert_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('sell_qos_alert_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('sell_qos_alert_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('lowbalance_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('noc_email_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('carrier_email_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('alert_email_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('auto_summary_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('auto_balance_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('auto_cdr_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('payment_sent_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('payment_received_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('trouble_ticket_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('send_cdr_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('no_route_available_alert_email_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('target_match_alert_email_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('rate_watch_alert_email_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('route_update_alert_email_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('rate_update_alert_email_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('low_balance_alert_email_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('select_route_up_email_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('new_invoice_posted_mail_alert_email_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('exchange_auto_summary_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('finance_alert_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('buy_qos_alert_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('sell_qos_alert_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('rate_mail_success_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('rate_mail_success_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('rate_mail_success_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('rate_mail_fail_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('rate_mail_fail_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('rate_mail_fail_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('invoice_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('payment_from_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('lowbalance_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('alert_email_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('auto_summary_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('auto_balance_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('auto_cdr_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('send_cdr_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('payment_sent_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('payment_received_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('daily_payment_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('daily_payment_subject', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('daily_payment_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('rate_from', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('rate_subject', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('rate_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('dialer_detection_subject', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('dialer_detection_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('retrieve_password_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('retrieve_password_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('retrieve_password_from', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('registration_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('registration_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('registration_from', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('registration_success', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('registration_failure', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('trunk_change_from', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('trunk_change_subject', sa.VARCHAR(length=200), autoincrement=False, nullable=True),
    sa.Column('trunk_change_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('fraud_detection_from', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('fraud_detection_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('fraud_detection_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('welcom_from', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('welcom_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('welcom_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('download_rate_notice_from', sa.VARCHAR(length=50), autoincrement=False, nullable=True),
    sa.Column('download_rate_notice_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('download_rate_notice_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('no_download_rate_from', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('no_download_rate_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('no_download_rate_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('download_cdr_from', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('download_cdr_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('download_cdr_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('download_cdr_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('vendor_invoice_dispute_from', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('vendor_invoice_dispute_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('vendor_invoice_dispute_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('vendor_invoice_dispute_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('trunk_interop_from', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('trunk_interop_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('trunk_interop_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('trunk_interop_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('regletter_from', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('regletter_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('regletter_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('regletter_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('paymresvd_from', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('paymresvd_subject', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('paymresvd_content', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('paymresvd_cc', sa.TEXT(), autoincrement=False, nullable=True),
    sa.PrimaryKeyConstraint('id', name='mail_tmplate_pkey')
    )
    op.drop_table('mail_template')
    # ### end Alembic commands ###
