"""ignore_zero_rates

Revision ID: 9bc65b0ffea8
Revises: 4d9182082105
Create Date: 2024-07-12 18:47:50.588029

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):

from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '9bc65b0ffea8'
down_revision = '4d9182082105'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('rate_generation_template', sa.Column('ignore_zero_rates', sa.BOOLEAN(), nullable=True, server_default=sa.text('false')))
    op.execute('ALTER TABLE resource DROP CONSTRAINT IF EXISTS unique_alias')
    op.drop_constraint('termination_global_failover_from_sip_code_fkey', 'termination_global_failover', type_='foreignkey')
    op.drop_constraint('origination_global_failover_from_sip_code_fkey', 'origination_global_failover', type_='foreignkey')
    op.drop_table('global_failover')
    op.drop_table('resource_failover')
    op.alter_column(
        'client',
        'corporate_contact_email',
        existing_type=sa.String(length=100),
        type_=sa.String(length=250),
        existing_nullable=True,
    )
    op.alter_column(
        'client',
        'email',
        existing_type=sa.String(length=100),
        type_=sa.String(length=250),
        existing_nullable=True,
    )
    op.alter_column(
        'client',
        'noc_email',
        existing_type=sa.String(length=100),
        type_=sa.String(length=250),
        existing_nullable=True,
    )
    op.alter_column(
        'client',
        'rate_email',
        existing_type=sa.String(length=100),
        type_=sa.String(length=250),
        existing_nullable=True,
    )
    up_rec('client')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    pass
    # ### end Alembic commands ###

"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger class4_trig_record_{table} on {table};
drop table {table}_record;
DROP FUNCTION class4_trigfun_record_{table}();
DROP SEQUENCE {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))
