"""Backend schema release 7.4.10 (eef41e650b)

Revision ID: a261acff264f
Revises: 42365ac26f14
Create Date: 2025-10-16 23:11:49.290745

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os


# revision identifiers, used by Alembic.
revision = 'a261acff264f'
down_revision = '42365ac26f14'
branch_labels = None
depends_on = None


def upgrade():
    upgrade_sql = """
BEGIN;

/* [SIPSWITCH-635] Reject calls without PANI header */
ALTER TABLE resource ADD COLUMN reject_no_pani boolean;
COMMENT ON COLUMN resource.reject_no_pani IS
'Reject calls without P-Access-Network-Info header';
INSERT INTO release_cause_string (id, name, err, err_string)
VALUES (96, 'P-Access-Network-Info header missing', 403, 'Forbidden');

/* [SIPSWITCH-621] Support multiple STIR/SHAKEN keys */
ALTER TABLE shaken_sti_sp_conf DROP COLUMN enabled;
ALTER TABLE shaken_sti_sp_conf DROP COLUMN id;
CREATE SEQUENCE shaken_sti_sp_conf_id_seq;
ALTER TABLE shaken_sti_sp_conf ADD COLUMN id bigint PRIMARY KEY DEFAULT nextval('shaken_sti_sp_conf_id_seq');
ALTER TABLE shaken_sti_sp_conf ADD COLUMN default_key boolean DEFAULT NULL UNIQUE;
ALTER TABLE resource ADD COLUMN shaken_sti_sp_id bigint REFERENCES shaken_sti_sp_conf (id) ON DELETE RESTRICT;
COMMENT ON COLUMN resource.shaken_sti_sp_id IS
'STI SP key to use for signing calls';
ALTER TABLE client_cdr ADD COLUMN shaken_key_id bigint;
COMMENT ON COLUMN client_cdr.shaken_key_id IS
'References shaken_sti_sp_conf.id';

/* [SIPSWITCH-636] Min STIR/SHAKEN vfy level */
ALTER TABLE resource ADD COLUMN shaken_vfy_min_attest_lvl character varying(1);
COMMENT ON COLUMN resource.shaken_vfy_min_attest_lvl IS
'Require min attestation level for STIR/SHAKEN signatures: A, B, C';
INSERT INTO release_cause_string (id, name, err, err_string)
VALUES (97, 'SHAKEN attestation level not allowed', 438, 'Invalid Identity Header');
INSERT INTO egress_error_string (id, name)
VALUES (86, 'SHAKEN attestation level not allowed');

/* [SIPSWITCH-618] SIP404 filtering */
ALTER TABLE resource ADD COLUMN block_404_days integer;
COMMENT ON COLUMN resource.block_404_days IS
'Block SIP404 DNIS (allowed values 7, 14 days)';
INSERT INTO egress_error_string (id, name) VALUES (87, '404 Number Block');

/* [SIPSWITCH-630] Do not filter ingress connection port by default */
ALTER TABLE resource_ip ALTER COLUMN port SET DEFAULT NULL;

/* [DEPRECATED] */
ALTER TABLE resource DROP COLUMN block_404_number_time;
ALTER TABLE resource DROP COLUMN use_sip404_ani;
DROP TABLE sip_404_number;
DROP TABLE sip_404_number_record;

/* Bump version */
UPDATE c4db_version SET version_num = 'eef41e650b624d05c3a19ab3a6b1c46d', tag = '7.4.10';

END;
"""
    connection = op.get_bind()
    connection.execute(upgrade_sql)
    up_rec('resource')
    up_rec('shaken_sti_sp_conf')


def downgrade():
    # Arch users don't downgrade
    pass


"""
ADDONS
"""
def up_rec(table):
    """
    Update {table}_record schema
    """

    up_rec_sql = """
DO $do$
DECLARE
    rec_id INT := 1;
BEGIN
    -- Check if table exists
    IF NOT EXISTS (SELECT 0 FROM pg_tables WHERE tablename = '{table}') THEN
        RAISE WARNING 'Table {table} does not exist';
    ELSE
        -- Get last record_id
        SELECT record_id FROM {table}_record ORDER BY record_id DESC LIMIT 1
        INTO rec_id;
        -- Delete existing table
        DROP TRIGGER IF EXISTS class4_trig_record_{table} ON {table};
        DROP FUNCTION IF EXISTS class4_trigfun_record_{table};
        DROP TABLE IF EXISTS {table}_record;
        DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
    END IF;

    -- Create new table
    CREATE TABLE {table}_record (LIKE {table},
    "time" integer, flag character(1), record_id SERIAL PRIMARY KEY);
    ALTER TABLE {table}_record OWNER TO class4_user;
    CREATE INDEX IF NOT EXISTS {table}_record_time_idx
    ON {table}_record USING btree ("time");
    EXECUTE format(E'SELECT setval(\\'{table}_record_record_id_seq\\', %%L)',
    rec_id);

    -- Trigger
    CREATE FUNCTION class4_trigfun_record_{table}() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
        BEGIN
        IF (TG_OP = 'INSERT') THEN
            INSERT INTO public.{table}_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'I';
        ELSEIF (TG_OP = 'DELETE') THEN
            INSERT INTO public.{table}_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'D';
        ELSEIF (TG_OP = 'UPDATE') THEN
            INSERT INTO public.{table}_record SELECT OLD.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'B';
            INSERT INTO public.{table}_record SELECT NEW.*,
            EXTRACT(EPOCH FROM current_timestamp(0)), 'A';
        END IF;
        return null;
        END;
    $$;
    ALTER FUNCTION class4_trigfun_record_{table}() OWNER TO class4_user;
    CREATE TRIGGER class4_trig_record_{table} AFTER INSERT OR DELETE OR UPDATE
    ON {table} FOR EACH ROW EXECUTE PROCEDURE class4_trigfun_record_{table}();
END $do$;
"""
    connection = op.get_bind()
    connection.execute(up_rec_sql.format_map(dict(table=table)))
