#!/usr/bin/env python3


VERSION = {'ver': "V6.1.0a", 'date': '2018-03-12'}
# latest - math.abs() fixed

from api_dnl.utils.render_invoice import TermInvoiceRender
# import InvoiceCreateJur as IC_Jur
import types
import psycopg2
import psycopg2.extras, multiprocessing, signal
import datetime, time, calendar
from decimal import *
from decimal import Decimal
# noinspection PyCompatibility
import configparser  # , get_cdr_records
import logging
import re, json, ast, requests, shutil, os
import time, math, random, string, pytz
import datetime as dt
import base64
from timeit import default_timer as timer

import logging, os, signal, sys, traceback
from logging.handlers import TimedRotatingFileHandler
from logging.handlers import RotatingFileHandler
from lockfile.pidlockfile import PIDLockFile
from lockfile import AlreadyLocked

import smtplib, requests, multiprocessing
from email.mime.multipart import MIMEMultipart
from email.mime.base import MIMEBase
from email.mime.text import MIMEText
from email.utils import COMMASPACE, formatdate
from email import encoders
import PIL
from PIL import Image, ImageFile
from collections import defaultdict as def_dict

from api_dnl import settings
from api_dnl.model import SystemParameter, Client

class InvoiceException(Exception):
    pass

TABLE_NAMES = ""
CDR_UI = "/homes/cdr_from_invoice/%s"  # invoice_id

LOGGER_LIST = []
LOGO_URL = "http://yaro.denovolab.com/upload/images/ilogo.png"  # http://switchui.denovolab.com/dial_master/web/upload/images/ilogo.png

logger = logging.getLogger('manual invoice')
pidfile = ''
pg_cur = 1
logo_file = "blank_logo.png"
log_id = ""
invoice_log_id = 0
config = ""

SQL_DICT = {
    'buy_cdr_field':
        'trunk_id_origination,route_prefix,orig_code_name,ingress_rate_effective_date,ingress_client_bill_time,ingress_client_cost,ingress_client_id,answer_time_of_date,ingress_client_bill_result,time,call_duration,ingress_client_rate,ingress_rate_type',
    'sell_cdr_field':
        'term_code_name,egress_rate_effective_date,egress_bill_time,egress_cost,egress_client_id,answer_time_of_date,egress_bill_result,time,call_duration,egress_rate,egress_rate_type',
    'buy_group_field': 'trunk_id_origination,route_prefix,orig_code_name,ingress_rate_effective_date',
    'sell_group_field': 'term_code_name,egress_rate_effective_date',
    'cdr_split': '\t',
    'group_split': ';'
}  # maybe can be deleted!

SWITCH_INVOICE_SETTINGS = '''SELECT invoice_name, tpl_number, pdf_tpl, company_info,overlap_invoice_protection,send_cdr_fields, invoice_send_mode,company_info_location,invoice_decimal_digits
 FROM system_parameter'''

float_form2 = "%0.2f"
float_form3 = "%0.3f"


def log_to_file_with_date(filename, new_line, mode="a"):
    """Logging to file from subproccess started from the daemon. Accept filename and mode for opening the file. Valid options a (for append),w ,w+ "" and line to be written"""
    time_log_str = datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    with open(filename, mode) as f:
        f.write("\n%s:\n" % (time_log_str))
        f.write(str(new_line))
        f.write("\n\n")
        f.flush()


def connect_to_postgresql(host, port, database, user, password=None):
    time_log_str = datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    try:
        conn = psycopg2.connect(host=host, port=port, database=database, user=user, password=password)
        conn.autocommit = True
        cursor = conn.cursor(cursor_factory=psycopg2.extras.DictCursor)
        logger.debug("connected to DB")
    except Exception as e:
        logger.error(" Exception in DB connecting:  %s" % (str(e)))
        # print ("errorInv.txt"," Exception in DB connecting:  %s" % (str(e) ) )
        print(" Exception in DB connecting:  %s" % (str(e)))
        return -1, -1
    return conn, cursor


def download_logo_no_resize():
    path = 'resized_' + logo_file

    r = requests.get(LOGO_URL, stream=True)
    if r.status_code == 200:
        with open(path, 'wb') as f:
            r.raw.decode_content = True
            shutil.copyfileobj(r.raw, f)


def apiTest():
    """Api Test"""
    import logging
    if True:
        ret = {"status": "OK"}
        return "running"

    try:
        # Get config.ini
        config = configparser.ConfigParser()
        config.read('./config.ini')
        h1 = [config["log"]["invoice_manual_path"], config["log"]["invoice_manual_when"]]
        config = True
    except:
        config = False
    try:
        if int(config["log"].get('by_time', 0)) == 1:
            handler = TimedRotatingFileHandler("logs/api_test", when=config["log"].get("invoice_manual_when", 'm'),
                                               interval=int(config["log"].get("invoice_manual_interval", 0)),
                                               backupCount=int(config["log"].get("invoice_manual_backupCount", 5)))
        else:  # by size
            handler = RotatingFileHandler("logs/api_test",
                                          maxBytes=int(config["log"].get("invoice_manual_maxBytes", 1024 * 1024 * 128)),
                                          backupCount=int(config["log"].get("invoice_manual_backupCount", 5)))

        if int(config["log"].get("debug_level", 0)) == 1:
            logger.setLevel(logging.DEBUG)
        else:
            logger.setLevel(logging.INFO)
        formatstr = '%(asctime)s - %(name)s - %(levelname)s - %(message)s'
        formatstr = '%(asctime)s: %(levelname)s:  %(message)s'
        formatter = logging.Formatter(formatstr)
        handler.setFormatter(formatter)
        logger.addHandler(handler)

        logging = True
    except:
        logging = False

    try:
        pg_conn, pg_cur = connect_to_postgresql(config["POSTGRES"]["hostaddr"], int(config["POSTGRES"]["port"]),
                                                config["POSTGRES"]["dbname"], config["POSTGRES"]["user"],
                                                config["POSTGRES"]["password"])  # config["POSTGRES"]["password"]
        DB = True
        if pg_conn == -1:
            DB = False
    except Exception as e:
        DB = False
    if config and logging and DB:
        ret = {"status": "OK"}
    else:
        ret = {"status": "Internal error"}

    return ret


def download_logo():
    from api_dnl.model import SystemParameter,ImportExportLogs
    from api_dnl import settings
    import base64
    try:
        conf=SystemParameter.get(1)
        logger.debug("Logo ID is set to {}".format(conf.invoices_logo_id))
        expd=ImportExportLogs.get(conf.invoices_logo_id)
        if expd:
            logger.debug("Logo path from ImportExport is set to {} {}".format(expd.file_path,expd.file_name))
        else:
            logger.debug("Logo ID from ImportExport not found")
        path = conf._logo_path
        logger.debug("Logo path is set to {}".format(conf._logo_path))
    except Exception as e:
        logger.debug("Error in getting Logo path {}".format(str(e)))
        path = None
    if path is None or not os.path.exists(path):
        path = settings.FILES['upload_to']+'/logo.png'
        if not os.path.exists(path):
            s=b'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'
            with open(path,'wb') as f:
                f.write(base64.b64decode(s))

    # r = requests.get(LOGO_URL,timeout=1)
    # if r.status_code == 200:
    #    LOGO_URL = r.textt
    print("Logo.logo URL is set to " + path)
    logger.debug("Logo URL is set to " + path)
    LOGGER_LIST.append("Logo URL is set to " + path)
    basewidth = 300
    ImageFile.LOAD_TRUNCATED_IMAGES = True
    img = Image.open(path).convert('RGB')
    if img.size[0] != basewidth:
        wpercent = (basewidth / Decimal(img.size[0]))
        hsize = int((Decimal(img.size[1]) * Decimal(wpercent)))
        img = img.resize((basewidth, hsize), PIL.Image.ANTIALIAS)
        #resized = settings.FILES['upload_to'] + '/resized_' + logo_file
        img.save(path)
    return path


def setup():
    global logo_file, config
    # Get config.ini
    """
	config = configparser.ConfigParser()
	config.read('./config.ini')
	# set logger
	if int(config["log"].get('by_time',0) )== 1:
		handler = TimedRotatingFileHandler(config["log"].get ("invoice_manual_path","invoice_manual.log"),when=config["log"].get ("invoice_manual_when",'m'),
		interval= int( config["log"].get ("invoice_manual_interval",0) ),backupCount= int( config["log"].get ("invoice_manual_backupCount",5)  ) )
	else: # by size
		handler = RotatingFileHandler(config["log"].get ("invoice_manual_path","invoice_manual.log"),maxBytes=int( config["log"].get ("invoice_manual_maxBytes", 1024*1024*128 ) ),
		backupCount= int( config["log"].get ("invoice_manual_backupCount",5)  ) )

	if int (config["log"].get ("debug_level",0) ) == 1:
		logger.setLevel(logging.DEBUG)
	else:
		logger.setLevel(logging.INFO)
	formatstr = '%(asctime)s - %(name)s - %(levelname)s - %(message)s'
	formatstr = '%(asctime)s: %(levelname)s:  %(message)s'
	formatter = logging.Formatter(formatstr)
	handler.setFormatter(formatter)
	logger.addHandler(handler)

	try:
		LOGO_URL = config['other']['logo_file_get']
	except Exception as e:
		logger.error(" Exception in getting logo path. Possible error in config.ini:  %s" % (str(e) ) )
		LOGGER_LIST.append(" Exception in getting logo path. Possible error in config.ini:  %s" % (str(e) ) )

	try:
		pg_cur = -1
		while pg_cur ==-1:
			print ("Connecting to DB")
			pg_conn, pg_cur = connect_to_postgresql(config["POSTGRES"]["hostaddr"],int(config["POSTGRES"]["port"]), config["POSTGRES"]["dbname"], config["POSTGRES"]["user"],config["POSTGRES"]["password"]) #config["POSTGRES"]["password"]
			time.sleep(.5)
	except Exception as e:
		logger.error(" Exception in connecting postgress:  %s" % (str(e) ) )
		print (" Exception in connecting postgress:  %s" % (str(e) ) )
		LOGGER_LIST.append(" Exception in connecting postgress:  %s" % (str(e) ) )
	"""
    from api_dnl.tasks import app, log, db, SqlAlchemyTask
    config = SystemParameter.get(1)
    LOGO_URL = config._logo_url
    logger = log
    pg_cur = db.session
    return pg_cur, logger


def new_cursor():
    """Returns new DB cursor """

    # Get config.ini
    """
	config = configparser.ConfigParser()
	config.read('./config.ini')
	try:
		pg_conn, pg_cur = connect_to_postgresql(config["POSTGRES"]["hostaddr"], int(config["POSTGRES"]["port"]),
												config["POSTGRES"]["dbname"], config["POSTGRES"]["user"],
												config["POSTGRES"]["password"])  # config["POSTGRES"]["password"]
	except Exception as e:
		print(" Exception in connecting postgress:  %s" % (str(e)))
		return None
	"""
    return db.session


def __main(args):
    global logo_file, config
    # Get config.ini
    config = configparser.ConfigParser()
    config.read('./config.ini')
    # set logger
    if int(config["log"].get('by_time', 0)) == 1:
        handler = TimedRotatingFileHandler(config["log"].get("invoice_manual_path", "invoice_manual.log"),
                                           when=config["log"].get("invoice_manual_when", 'm'),
                                           interval=int(config["log"].get("invoice_manual_interval", 0)),
                                           backupCount=int(config["log"].get("invoice_manual_backupCount", 5)))
    else:  # by size
        handler = RotatingFileHandler(config["log"].get("invoice_manual_path", "invoice_manual.log"),
                                      maxBytes=int(config["log"].get("invoice_manual_maxBytes", 1024 * 1024 * 128)),
                                      backupCount=int(config["log"].get("invoice_manual_backupCount", 5)))

    if int(config["log"].get("debug_level", 0)) == 1:
        logger.setLevel(logging.DEBUG)
    else:
        logger.setLevel(logging.INFO)
    formatstr = '%(asctime)s - %(name)s - %(levelname)s - %(message)s'
    formatstr = '%(asctime)s: %(levelname)s:  %(message)s'
    formatter = logging.Formatter(formatstr)
    handler.setFormatter(formatter)
    logger.addHandler(handler)

    try:
        LOGO_URL = config['other']['logo_file_get']
    except Exception as e:
        logger.error(" Exception in getting logo path. Possible error in config.ini:  %s" % (str(e)))
        LOGGER_LIST.append(" Exception in getting logo path. Possible error in config.ini:  %s" % (str(e)))

    try:
        pg_conn, pg_cur = connect_to_postgresql(config["POSTGRES"]["hostaddr"], int(config["POSTGRES"]["port"]),
                                                config["POSTGRES"]["dbname"], config["POSTGRES"]["user"],
                                                config["POSTGRES"]["password"])  # config["POSTGRES"]["password"]
    except Exception as e:
        logger.error(" Exception in connecting postgress:  %s" % (str(e)))
        print(" Exception in connecting postgress:  %s" % (str(e)))
        LOGGER_LIST.append(" Exception in connecting postgress:  %s" % (str(e)))

    return pg_cur, logger


def get_invoice_next():
    get_number_sql = "SELECT nextval('class4_seq_invoice_no'::regclass) as no;"
    print("get_invoice_no")
    # изключено заради теста , нямам достъп до базата данни !
    #

    logger.debug("Entering get invoice number")
    try:
        cur = pg_cur.execute(get_number_sql)
        result_id = dict_or_none(cur.fetchone())
        print("result Id:", str(result_id))
        new_id = int(result_id['no'])
        return new_id
    except Exception as e:
        logger.error(" Exception in getting invoice num:  %s" % (str(e)))
        print(" Exception in getting invoice number:  %s" % (str(e)))
        # print ("result Id:",str(result_id) )
        invoice_log_set_error(str(e))
        # logger.debug (" Exception in getting invoice number:  %s" % (str(e) ) )
        return -1


def get_invoice_no():
    """ Gets new No for invoice"""
    start = timer()

    new_id = get_invoice_next()

    while True:
        exist_no_sql = "select invoice_number as no from invoice where invoice_number='%s' limit 1 " % (new_id)
        cur = pg_cur.execute(exist_no_sql)
        result_check = dict_or_none(cur.fetchone())
        if result_check is not None:
            print("exisiting invoice number %s." % new_id)
            logger.debug("exisiting invoice number")
            # new_id = new_id + 1
            new_id = get_invoice_next()
        else:
            print("NOT exisiting invoice number %s. " % (new_id))
            print(str(result_check))
            break

    ###v stariq code ima proverka dali ne se izpolsva ?!??! "select invoice_number as no from invoice where invoice_number='$get_number' limit 1 " Warning 01
    # new_id = 13
    end = timer()
    logger.debug("execution time  in milliseconds: %s" % ((end - start) * 1000))

    return new_id


def get_params(options, regenInvoice=False):
    """Getting and setting params from api request """
    global pg_cur
    invoice_option = dict(options)
    #
    start = timer()
    logger.debug("Entering get client options/params")

    # if regenInvoice == False:   even regenerated invoices must have new invoice number
    invoice_option['invoice_number'] = get_invoice_no()
    # else:
    #	pass #it must be in dict

    try:
        print('Getting and setting params from api request ', invoice_option, invoice_option['client_id'])
        client_id = invoice_option['client_id'][0]
    except:
        client_id = invoice_option['client_id']
        print(type(options), options.get('client_id'), type(invoice_option), invoice_option.get('client_id'))

    sql = """select current_timestamp(0) as balance_time,c4_client_balance.balance as current_balance,* from client left join c4_client_balance on 
	c4_client_balance.client_id=client.client_id::text where client.client_id=%s""" % (client_id)
    print("SQL for getting sql data: ", sql)
    LOGGER_LIST.append("SQL for getting sql data: %s" % sql)
    try:
        cur = pg_cur.execute(sql)
        client_data = dict_or_none(cur.fetchone())
        if client_data is None:
            print("ERROR! No CLIENT_DATA!!")
            logger.error("ERROR! No CLIENT_DATA!!")
            LOGGER_LIST.append("ERROR! No CLIENT_DATA!!")
            return -1
        invoice_option['scc_bellow'] = client_data.get('scc_bellow')
        invoice_option['scc_percent'] = client_data.get('scc_percent')
        invoice_option['scc_charge'] = client_data.get('scc_charge')
        invoice_option['scc_type'] = client_data.get('scc_type')
        invoice_option['invoice_file_type'] = client_data.get('invoice_format')
        invoice_option['invoice_zero'] = client_data.get('invoice_zero')
        invoice_option['current_balance'] = client_data.get('current_balance')
        invoice_option['balance_time'] = client_data.get('balance_time')
        invoice_option['is_send_as_link'] = 0
        invoice_option['balance_time'] = client_data.get('balance_time')
        # invoice_option['is_invoice_account_summary'] = client_data.get('is_invoice_account_summary')

        invoice_option['jurisdict'] = invoice_option.get('jurisdict', False)  # ('dayusage')
        if client_data['include_tax']:
            invoice_option['tax'] = client_data['tax']

        else:
            invoice_option['tax'] = 0

    except Exception as e:
        # log_to_file("errorManInv.txt","Exception in fetching client data:  %s" % (str(e) ) )
        print("Exception in fetching client data:  %s" % (str(e)))
        logger.debug("Exception in fetching client data:  %s" % (str(e)))
        invoice_log_set_error(str(e))
        return -1
    end = timer()
    logger.debug("execution time  in milliseconds: %s" % ((end - start) * 1000))
    return invoice_option


# noinspection PyComparisonWithNone,PyComparisonWithNone
def GetParamsAuto(options):
    """Getting and setting params from api request """
    global pg_cur
    invoice_option = dict(options[0])
    invoice_option['end_date'] = options[2].replace("+00:00", "")
    invoice_option['start_date'] = options[1].replace("+00:00", "")
    invoice_option['balance_time'] = options[3].replace("+00:00", "")
    invoice_option['invoice_date'] = options[3].replace("+00:00", "")
    invoice_option['is_invoice_usage_detail'] = invoice_option['is_show_daily_usage']
    invoice_option['jurisdict'] = invoice_option['invoice_jurisdictional_detail']
    invoice_option['is_short_duration_call_surcharge_detail'] = invoice_option[
        'is_short_duration_call_surcharge_detail']
    invoice_option['is_invoice_account_summary'] = invoice_option[
        'is_invoice_account_summary']  # is_invoice_account_summary
    invoice_option['detail_by_trunk'] = invoice_option['is_show_detail_trunk']
    # invoice_option['include_origination_billing'] =invoice_option ['']
    invoice_option['show_calls_date'] = invoice_option['is_show_by_date']
    invoice_option['show_code_summery'] = invoice_option['is_show_code_100']
    invoice_option['show_trafic_country'] = invoice_option['is_show_country']
    invoice_option['show_trafic_code_name'] = invoice_option['is_show_code_name']  # Show Traffic Analysis by Code Name
    invoice_option['summary_of_payments'] = invoice_option['invoice_include_payment']
    invoice_option['ingress_prefix'] = invoice_option['is_show_total_trunk']

    #
    #
    start = timer()
    logger.debug("Entering get client options/params")

    ''''
{'current_balance': Decimal('20.250000'), 'is_invoice_usage_detail': ,   : ['show_code_summery'],, 
'summary_of_payments': ['summary_of_payments'], 'tax': 0, 
, 'dayusage': ['dayusage'], , 
: ['show_trafic_code_name'],  'is_send_as_link': 0, 'invoice_number': 1021, 'show_calls_date': ['show_calls_date'], 
'scc_bellow': 50, : ['include_origination_billing'], 
: datetime.datetime(2016, 12, 19, 13, 52, 2, tzinfo=psycopg2.tz.FixedOffsetTimezone(offset=0, name=None)), 
 'invoice_zero': True, : ['ingress_prefix'], 'Submit': ['1'], 'client_id': '297'} 

	'''
    invoice_option['invoice_number'] = get_invoice_no()

    sql = """select current_timestamp(0) as balance_time,c4_client_balance.balance as current_balance,* from client left join c4_client_balance on 
	c4_client_balance.client_id=client.client_id::text where client.client_id=%s""" % (invoice_option['client_id'])
    print("SQL for getting sql data: ", sql)
    try:
        cur = pg_cur.execute(sql)
        client_data = dict_or_none(cur.fetchone())
        # noinspection PyComparisonWithNone
        if client_data == None:
            print("ERROR! No CLIENT_DATA!!")
            return -1
        invoice_option['scc_bellow'] = client_data.get('scc_bellow')
        invoice_option['scc_percent'] = client_data.get('scc_percent')
        invoice_option['scc_charge'] = client_data.get('scc_charge')
        invoice_option['scc_type'] = client_data.get('scc_type')
        invoice_option['invoice_file_type'] = client_data.get('invoice_format')
        invoice_option['invoice_zero'] = client_data.get('invoice_zero')
        invoice_option['current_balance'] = client_data.get('current_balance')
        invoice_option['balance_time'] = client_data.get('balance_time')
        invoice_option['is_send_as_link'] = 0

        if client_data['include_tax']:
            invoice_option['tax'] = client_data['tax']
            invoice_option['include_tax'] = client_data['include_tax']
        else:
            invoice_option['tax'] = 0
    # print invoice_option['tax']
    except Exception as e:
        # log_to_file("errorManInv.txt","Exception in fetching client data:  %s" % (str(e) ) )
        print("Exception in fetching client data:  %s" % (str(e)))
        logger.error("Exception in fetching client data:  %s" % (str(e)))

        return -1
    end = timer()
    logger.debug("execution time  in milliseconds: %s" % ((end - start) * 1000))
    return invoice_option


def _get_token(auth_host):
    resp = requests.post(auth_host)
    return resp.json()["token"]


from api_dnl.utils.statisticapi2 import StatisticAPI


def send_api_request_old(start_date, end_date, params, step='all'):
    api = StatisticAPI()
    method = "total"
    params['step'] = step
    params['start_time'] = int(start_date.timestamp())
    params['end_time'] = int(end_date.timestamp())
    params['method'] = "total"
    print("params peter", params)
    timeout = (1, 5)
    logger.debug(params)
    calls = api.send_request(params=params)
    return calls.json()


def send_api_request(start_date, end_date, params, step='all'):
    from api_dnl.views.report import Report
    api = Report()
    method = "total"
    params['step'] = step
    params['start_time'] = int(start_date.timestamp())
    params['end_time'] = int(end_date.timestamp())
    params['method'] = "total"
    print("params peter", params)
    timeout = (1, 5)
    calls = api.send_request(params=params)
    return calls.json()


def check_table_names(start_date_obj, delta):
    sql = "select table_name from information_schema.tables where table_name LIKE '%cdr_report_detail%';"
    try:
        cur = pg_cur.execute(sql)
        TABLE_NAMES = cur.fetchall()
        if TABLE_NAMES is not None:
            TABLE_NAMES = [elem[0] for elem in TABLE_NAMES]
        else:
            TABLE_NAMES = []
        print("Table_Names Length: %s" % len(TABLE_NAMES))
        logger.debug("Table_Name Length: %s" % len(TABLE_NAMES))
    except Exception as e:
        logger.error(" Exception in getting  TABLE_NAMES:  %s" % (str(e)))
        invoice_log_set_error(str(e))
        print(" Exception in getting invoice TABLE_NAMES:  %s" % (str(e)))
        return (-1, " Exception in getting  TABLE_NAMES:  %s" % (str(e)))

        print("TABLE_NAMES", str(TABLE_NAMES), type(TABLE_NAMES))
    for i in range(1, delta.days + 1):
        day = start_date_obj + datetime.timedelta(days=i)  # .replace("-","")
        day = day.strftime("%Y%02m%02d")
        if "cdr_report_detail" + day not in TABLE_NAMES:
            table_date = "cdr_report_detail" + day
            error_msg = " Missing table:  %s" % (table_date)
            logger.error(error_msg)
            invoice_log_set_error(error_msg)
            print(error_msg)
            return (-2, error_msg)
    return (0, "OK")


def check_table_names_new(param_dict):
    start_date = param_dict.get('start_date').replace("+00:00", "")
    end_date = param_dict.get('end_date').replace("+00:00", "")
    # print ("start_date ",start_date ,end_date)
    client_id = param_dict.get('client_id')
    try:
        start_date_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S").date()
        start_datetime_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S")
    except:
        start_date_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d").date()
        start_datetime_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d")
    try:
        end_date_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S").date()
        end_datetime_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S")
    except:
        end_date_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d").date()
        end_datetime_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d")

    delta = end_date_obj - start_date_obj

    sql = "select table_name as table_name from information_schema.tables where table_name LIKE '%cdr_report_detail%';"

    print("Checking for tables")
    # print(sql)
    try:
        pg_q = cur = pg_cur.execute(sql)
        rows = pg_q.fetchall()
        # noinspection PyComparisonWithNone
        if rows != None:
            TABLE_NAMES = [row[0] for row in rows]
        else:
            TABLE_NAMES = []
        print("Table_Names Length: %s" % len(TABLE_NAMES))
        logger.debug("Table_Name Length: %s" % len(TABLE_NAMES))
    except Exception as e:
        logger.error(" Exception in getting  TABLE_NAMES:  %s" % (str(e)))
        invoice_log_set_error(str(e))
        print(" Exception in getting invoice TABLE_NAMES:  %s" % (str(e)))
        return (-1, " Exception in getting  TABLE_NAMES:  %s" % (str(e)))

    # print ("TABLE_NAMES" , str(TABLE_NAMES), type(TABLE_NAMES))
    for i in range(0, delta.days + 1):
        day = start_date_obj + datetime.timedelta(days=i)  # .replace("-","")
        day = day.strftime("%Y%02m%02d")
        print("looking for cdr_report_detail" + day, "in:", TABLE_NAMES)
        if "cdr_report_detail" + day not in TABLE_NAMES:
            table_date = "cdr_report_detail" + day
            error_msg = " Missing table:  %s" % (table_date)
            logger.error(error_msg)
            invoice_log_set_error(error_msg)
            print(error_msg)
            return (-2, error_msg)
    return (0, "OK")


def get_bill(param_dict):
    basic_result = None
    details_result = None
    #
    start = timer()
    logger.debug("Entering Get Bill / Summery of charges")
    LOGGER_LIST.append("Entering Get Bill ")
    start_date = param_dict.get('start_date').replace("+00:00", "")
    end_date = param_dict.get('end_date').replace("+00:00", "")
    # print ("start_date ",start_date ,end_date)
    client_id = param_dict.get('client_id')

    if start_date is None or end_date is None or client_id is None:
        print("Error! Must suply client_id,start_date and end_date!")
        logger.debug(" Must suply client_id,start_date and end_date")
        return (-1, "Error! Must suply client_id,start_date and end_date!")
    try:
        start_date_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S").date()
        end_date_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S").date()
        start_datetime_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S")
        end_datetime_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S")
    except Exception as e:
        print(str(e))
        logger.error(str(e))
        logger.debug(" Exception in getting GEtBill:  %s" % (str(e)))
        invoice_log_set_error(str(e))
        return (-1, str(e))
    params = dict()
    try:
        params = {'field': "ingress_bill_time,ingress_call_cost,not_zero_calls",
                  'ingress_id': ",".join(str(e) for e in param_dict['ingress_ids']),
                  'group': "ingress_id"}  # , ingress_busy_calls, ingress_cancel_calls

    except Exception as e:
        print("Exception in generating params for peterAPI %s" % e)
        traceback.print_tb(e.__traceback__)

    result = send_api_request(start_datetime_obj, end_datetime_obj, params)

    results_dict = dict(basic=dict())

    try:
        total_amount = result['data'][0]['ingress_call_cost']
        # ingress_bill_time  ,not_zero_calls, ingress_call_cost  - old mapping
        results_dict['basic']['call_cost'] = result['data'][0]['ingress_call_cost']
        results_dict['basic']['bill_time'] = int(result['data'][0]['ingress_bill_time'])
        results_dict['basic']['not_zero_calls'] = int(result['data'][0]['not_zero_calls'])
        # results_dict['basic'] = ["",int( result['data'][0]['ingress_bill_time']     ) ,  ]
        print(results_dict['basic'])

    except Exception as e:
        msg = "Exception in GetBill after Peter Call.Creating table %s" % e
        print(msg)
        logger.error(msg)
        traceback.print_tb(e.__traceback__)
        raise
    end = timer()

    # ingress_client_id | bill_time | not_zero_calls | call_cost
    # -------------------+-----------+----------------+-----------
    #               837 |       338 |              9 | 11.267100

    return (results_dict, total_amount)


def zn(value):
    """takes value and if its None, returns zero instead"""
    # noinspection PyComparisonWithNone
    if value == None:
        return Decimal(0.0)
    else:
        return Decimal(value)


def report_balance(id_client, balance_start_time, balance_end_time):
    balance_start_time = "2000-01-01"
    #
    start = timer()
    logger.debug("Entering Report Balance")
    LOGGER_LIST.append("Entering Report Balance")
    print("Entering Report Balance")
    # my $payment_hr;
    # my $cdr_cost_hr;
    reset_balance = 0
    sql_reset_hr = """select * from client_payment where client_id = %s and payment_type = 13 order by receiving_time desc limit 1""" % (
        id_client)
    print(sql_reset_hr)
    try:
        cur = pg_cur.execute(sql_reset_hr)
        result_reset_hr = dict_or_none(cur.fetchone())
        # print ("result_reset_hr:",result_reset_hr)
        logger.debug("result_reset_hr:{}".format(result_reset_hr))
    except Exception as e:
        logger.error(" Exception in report_balance.sql_reset_hr :  %s" % (str(e)))
        print("errorInv.txt", " Exception in report_balance.sql_reset_hr:  %s" % (str(e)))
        invoice_log_set_error(str(e))
        print("result_reset_hr:", result_reset_hr)
        return -1

    if result_reset_hr:
        reset_balance = (result_reset_hr.get("amount", 0) or Decimal(0.0)) + (
                    result_reset_hr.get("egress_amount", 0) or Decimal(0.0))
        sql = """select sum(case when payment_type=4 then amount else 0 end) as invoice_received,sum(case when payment_type=5 then amount else 0 end) as payment_received,sum(case when payment_type=8 then amount else 0 end) as credit_note_sent,sum(case when payment_type=12 then amount else 0 end) as debit_note_sent,sum(case when payment_type=3 then amount else 0 end) as invoice_sent,sum(case when payment_type=6 then amount else 0 end) 
		as payment_sent,sum(case when payment_type=7 then amount else 0 end) as credit_note_received,sum(case when payment_type=11 then amount else 0 end) as debit_note_received
		 from client_payment where client_id=%s and payment_time between '%s' and '%s' and payment_time >= '%s' """ % (
            id_client, balance_start_time, balance_end_time, result_reset_hr['payment_time'])
        logger.debug("result_reset_hr:" + sql)
        print(sql)
        try:
            cur = pg_cur.execute(sql)
            payment_hr = dict_or_none(cur.fetchone())
            print("payment_hr:", sql)
        except Exception as e:
            logger.error(" Exception in report_balance.sql_payment_hr :  %s" % (str(e)))
            print("errorInv.txt", " Exception in report_balance.sql_payment_hr:  %s" % (str(e)))
            print("payment_hr:", sql)
            logger.debug("errorInv.txt", " Exception in report_balance.sql_reset_hr Else :  %s" % (str(e)))
            return -1

        # $cdr_cost_hr = $dbh->selectrow_hashref( "select sum(case when ingress_client_id=$id_client then ingress_call_cost else 0 end) as total_ingress_call_cost, sum(case when egress_client_id=$id_client then egress_call_cost else 0 end) as total_egress_cost from cdr_report where report_time between '$balance_start_time' and '$balance_end_time' and report_time >= '$reset_hr->{ payment_time }' and (ingress_client_id=$id_client or egress_client_id=$id_client)" );
        sql_invoice_balance_hr = """select sum(case type when 3 then total_amount else 0 end) as invoice_received,sum(case type when 0 then total_amount else 0 end) as
		 invoice_send from invoice where client_id=%s and invoice_time between '%s' and '%s' and invoice_time >= '%s'
		  and state != -1""" % (id_client, balance_start_time, balance_end_time, result_reset_hr['payment_time'])
        print(sql_invoice_balance_hr)
        try:
            cur = pg_cur.execute(sql_invoice_balance_hr)
            invoice_balance_hr = dict_or_none(cur.fetchone())
            print("sql_invoice_balance_hr:", sql_invoice_balance_hr)
        except Exception as e:
            logger.error(" Exception in report_balance.sql_reset_hr :  %s" % (str(e)))
            print("sql_invoice_balance_hr:", sql_invoice_balance_hr)
            logger.error(" Exception in report_balance.sql_reset_hr Else :  %s" % (str(e)))
            return -1

    else:
        result_reset_hr = {}
        sql = """select sum(case when payment_type=4 then amount else 0 end) as invoice_received,sum(case when payment_type=5 then amount else 0 end) as payment_received,
		sum(case when payment_type=8 then amount else 0 end) as credit_note_sent,sum(case when payment_type=12 then amount else 0 end) as debit_note_sent,sum(case when payment_type=3
		 then amount else 0 end) as invoice_sent,sum(case when payment_type=6 then amount else 0 end) as payment_sent,sum(case when payment_type=7 then amount else 0 end) as credit_note_received,
		 sum(case when payment_type=11 then amount else 0 end) as debit_note_received from client_payment where client_id=%s and payment_time between '%s' and '%s' """ % (
            id_client, balance_start_time, balance_end_time)
        logger.debug("result_reset_hr:" + sql)
        print("payment_hr:", sql)
        try:
            cur = pg_cur.execute(sql)
            payment_hr = dict_or_none(cur.fetchone())

        except Exception as e:
            logger.error(" Exception in report_balance.sql_payment_hr Else :  %s" % (str(e)))
            print("errorInv.txt", " Exception in report_balance.sql_payment_hr: Else  %s" % (str(e)))
            print("payment_hr: Else", sql)
            logger.debug("errorInv.txt", " Exception in report_balance.sql_reset_hr Else :  %s" % (str(e)))
            return -1

        # $cdr_cost_hr = $dbh->selectrow_hashref( "select sum(case when ingress_client_id=$id_client then ingress_call_cost else 0 end) as total_ingress_call_cost, sum(case when egress_client_id=$id_client then egress_call_cost else 0 end) as total_egress_cost from cdr_report where report_time between '$balance_start_time' and '$balance_end_time' and report_time >= '$reset_hr->{ payment_time }' and (ingress_client_id=$id_client or egress_client_id=$id_client)" );
        sql_invoice_balance_hr = """select sum(case type when 3 then total_amount else 0 end) as invoice_received,sum(case type when 0 then total_amount else 0 end) as invoice_send from 
		invoice where client_id=%s and invoice_time between '%s'
		 and '%s'""" % (id_client, balance_start_time, balance_end_time)
        logger.debug("result_reset_hr:" + sql_invoice_balance_hr)
        LOGGER_LIST.append("result_reset_hr:" + sql_invoice_balance_hr)
        print("sql_invoice_balance_hr Else:", sql_invoice_balance_hr)
        try:
            cur = pg_cur.execute(sql_invoice_balance_hr)
            invoice_balance_hr = dict_or_none(cur.fetchone())

        except Exception as e:
            logger.error(" Exception in report_balance.sql_reset_hr Else :  %s" % (str(e)))
            print("Exception in report_balance.sql_reset_hr: Else %s" % (str(e)))
            print("sql_invoice_balance_hr Else: ", sql_invoice_balance_hr)
            logger.debug("errorInv.txt", " Exception in report_balance.sql_reset_hr Else :  %s" % (str(e)))
            invoice_log_set_error(str(e))
            return -1
    # noinspection PyComparisonWithNone
    if invoice_balance_hr == None:
        invoice_balance_hr = {}
    print("payment_hr,invoice_balance_hr,reset_balance:", payment_hr, invoice_balance_hr, reset_balance)
    # LOGGER_LIST.append("payment_hr,invoice_balance_hr,reset_balance:" + payment_hr+invoice_balance_hr+reset_balance )

    end = timer()
    logger.debug("execution time  in milliseconds: %s" % ((end - start) * 1000))

    return (zn(reset_balance) + zn(payment_hr.get("invoice_received", 0)) + zn(
        payment_hr.get("payment_received", 0)) + zn(payment_hr.get("credit_note_sent", 0))
            + zn(payment_hr.get("debit_note_sent", 0)) + zn(invoice_balance_hr.get("invoice_received", 0)) - zn(
                payment_hr.get("invoice_sent", 0))
            - zn(payment_hr.get("payment_sent", 0)) - zn(payment_hr.get("credit_note_received", 0)) - zn(
                payment_hr.get("debit_note_received", 0))
            - zn(invoice_balance_hr.get('invoice_send', 0))
            )


def get_acount_summary(param_dict, inv_num):
    """gets amd makes acount summary if its needed """
    #
    start = timer()
    logger.debug("Entering Get Acount Summery")
    LOGGER_LIST.append("Entering Get Acount Summery")
    print("Entering Get Acount Summery")

    start_date = param_dict['start_date']
    end_date = param_dict.get('end_date', 0)

    sql = """select * from invoice where client_id=%s and state != -1 and status > 0 and type=0 and invoice_time < now()  and invoice_number != '%s'
	 order by invoice_time desc limit 1; """ % (param_dict['client_id'], inv_num)  #
    previous_balance = None
    payment_credit = 0
    non_recurring_charge = None
    logger.debug(sql)
    try:
        cur = pg_cur.execute(sql)
        result = dict_or_none(cur.fetchone())
        print("sql for summery:", sql)
        LOGGER_LIST.append("sql for summery: " + sql)
    except Exception as e:
        logger.error(" Exception in getting invoice details:  %s" % (str(e)))
        print(" Exception in getting invoice summary:  %s" % (str(e)))
        print("sql for summery:", sql)
        logger.debug(" Exception in getting invoice summary:  %s" % (str(e)))
        return None

    # noinspection PyComparisonWithNone
    if result != None:
        sql = """select sum(case payment_type when 3 then amount*(0-1) when 4 then amount when 5 then amount when 6 then amount*(0-1) else 0 end) 
		as total_payment, sum(case payment_type when 7 then amount*(0-1) when 8 then amount when 11 then amount when 12 then amount*(0-1) else 0 end) 
		as total_note from client_payment where payment_time between '%s' and '%s' and client_id=%s and payment_type in
		 (3,4,5,6,7,8,11,12)""" % (param_dict['start_date'], param_dict['end_date'], param_dict['client_id'])

        logger.debug(sql)
        try:
            cur = pg_cur.execute(sql)
            result_sum = dict_or_none(cur.fetchone())
            print("sql for summery_sum:", sql)
        except Exception as e:
            logger.error(" Exception in getting invoice summary_sum:  %s" % (str(e)))
            print(" Exception in getting invoice summary_sum:  %s" % (str(e)))
            print("sql for summery_sum:", sql)
            logger.debug(" Exception in getting invoice summary_sum:  %s" % (str(e)))
            invoice_log_set_error(str(e))
            return None

        if param_dict.get('invoice_use_balance_type', False):
            print("balance bt!")
            if not result.get('new_balance', False):
                print("No new balance")
                LOGGER_LIST.append("No new balance")
                previous_balance = report_balance(param_dict['client_id'], 0, result['invoice_time'])  #
            else:
                previous_balance = result.get('new_balance', 0)
        else:
            if not result.get('new_balance', False):
                print("No new balance")
                LOGGER_LIST.append("No new balance")
                previous_balance = report_balance(param_dict['client_id'], 0, result['invoice_time'])  #
            else:
                previous_balance = result.get('new_balance', 0)
        payment_credit = result_sum.get('total_payment', 0)
        # noinspection PyComparisonWithNone
        if payment_credit == None:
            payment_credit = 0
        non_recurring_charge = result_sum.get('total_note', 0)
        # noinspection PyComparisonWithNone
        if non_recurring_charge == None:
            non_recurring_charge = 0

    else:
        print("No invoice history")
        LOGGER_LIST.append("No invoice history")

        sql = """select sum(case payment_type when 3 then amount*(0-1) when 4 then amount when 5 then amount when 6 then amount*(0-1) else 0 end) 
		as total_payment, sum(case payment_type when 7 then amount*(0-1) when 8 then amount when 11 then amount when 12 then amount*(0-1) else 0 end) 
		as total_note from client_payment where payment_time between '%s' and '%s' and client_id=%s and payment_type in
		 (3,4,5,6,7,8,11,12)""" % (start_date, end_date, param_dict['client_id'])

        logger.debug(sql)
        print("sql for summery_sum:", sql)
        try:
            cur = pg_cur.execute(sql)
            result_sum = dict_or_none(cur.fetchone())

        except Exception as e:
            logger.error(" Exception in getting invoice summary_sum:  %s" % (str(e)))
            print(" Exception in getting invoice summary_sum:  %s" % (str(e)))
            print("sql for summery_sum:", sql)
            logger.debug(" Exception in getting invoice summary_sum:  %s" % (str(e)))
            invoice_log_set_error(str(e))
            return None

        previous_balance = 0
        payment_credit = result_sum.get('total_payment', 0)
        # noinspection PyComparisonWithNone
        if payment_credit == None:
            payment_credit = 0
        non_recurring_charge = result_sum.get('total_note', 0)
        # noinspection PyComparisonWithNone
        if non_recurring_charge == None:
            non_recurring_charge = 0

        param_dict['current_balance'] = previous_balance + payment_credit + non_recurring_charge + payment_credit
        end = timer()
        logger.debug("execution time  in milliseconds: %s" % ((end - start) * 1000))
        print("previous_balance: ", previous_balance, "payment_credit", payment_credit, "non_recurring_charge",
              non_recurring_charge)
        return {"previous_balance": previous_balance, "payment_credit": payment_credit,
                "non_recurring_charge": non_recurring_charge, "invoice_end_time:": "2001-10-21 00:00:00+00:00"}
    print("previous_balance: ", previous_balance)

    param_dict['current_balance'] = previous_balance + payment_credit + non_recurring_charge
    # logging
    end = timer()
    logger.debug("previous_balance:" + str(previous_balance) + "  payment_credit: " + str(
        payment_credit) + "  non_recurring_charge: " + str(non_recurring_charge) +
                 " invoice_end_time:" + str(result['invoice_time']))
    LOGGER_LIST.append("previous_balance:" + str(previous_balance) + "  payment_credit: " + str(
        payment_credit) + "  non_recurring_charge: " + str(non_recurring_charge) +
                       " invoice_end_time:" + str(result['invoice_time']))
    logger.debug("execution time  in milliseconds: %s" % ((end - start) * 1000))
    return {"previous_balance": previous_balance, "payment_credit": payment_credit,
            "non_recurring_charge": non_recurring_charge, "invoice_end_time": result['invoice_time']}


def invoice_log_insert():
    global invoice_log_id
    sql = """insert into invoice_log (start_time,status,cnt ) VALUES ( current_timestamp(0),0,1) returning id """
    print("InsertInLogInvoice( ):", sql)
    LOGGER_LIST.append("InsertInLogInvoice( ):" + sql)
    try:
        cur = pg_cur.execute(sql)
        invoice_log_result = dict_or_none(cur.fetchone())
        invoice_log_id = invoice_log_result['id']
    except Exception as e:
        traceback.print_tb(e.__traceback__)
        logger.error("  Error in import log:  %s" % (str(e)))
        return -1

    return invoice_log_id


def invoice_log_set_error(reason):
    sql = """update  invoice_log  SET end_time = current_timestamp(0) ,status= 3    where id = %s """ % invoice_log_id
    print("Reason for error:", reason)
    LOGGER_LIST.append("Reason for error: " + reason)
    try:
        cur = pg_cur.execute(sql)

    except Exception as e:
        traceback.print_tb(e.__traceback__)
        logger.error("  Error in error import log:  %s" % (str(e)))
        return -1

    return 0


def invoice_log_set_finish(status=2, cnt=1):
    sql = """update  invoice_log  SET end_time =  current_timestamp(0) ,status = %s  ,cnt = %s  where id = %s """ % (
        status, cnt, invoice_log_id)
    print("FinishInLogInvoice( ):", sql)
    LOGGER_LIST.append("FinishInLogInvoice( ):" + sql)
    try:
        cur = pg_cur.execute(sql)

    except Exception as e:
        traceback.print_tb(e.__traceback__)
        logger.error("  Error in error import log:  %s" % (str(e)))
        return -1

    return 0


def invoice_insert(start_date, end_date, invoice_date, client, param_dict, inv_num, invoice_name, total_amount, pdf_path,
                   auto=True):
    #
    start = timer()
    logger.debug("Entering Log Invoice")
    LOGGER_LIST.append("Entering Log Invoice")
    global log_id

    current_balance = param_dict['current_balance']

    try:

        # invoice_date = dt.datetime.strptime(invoice_date , "%Y-%m-%d %H:%M:%S .%f%z" )
        invoice_date = dt.datetime.now(pytz.timezone('GMT')).strftime('%Y-%m-%d %H:%M:%S %z')
        print("invoice_date", invoice_date)
    except:
        print("invoice_date", invoice_date, "%Y-%m-%d")

    if param_dict.get('is_invoice_usage_detail', False):
        is_invoice_usage_detail = "True"
    else:
        is_invoice_usage_detail = "False"

    if param_dict.get('is_short_duration_call_surcharge_detail', False):
        is_short_duration_call_surcharge_detail = "True"
    else:
        is_short_duration_call_surcharge_detail = "False"

    if auto:
        create_type = 0
    else:
        create_type = 1

    if param_dict.get('is_invoice_account_summary', False):
        is_invoice_account_summary = "True"
    else:
        is_invoice_account_summary = "False"

    if not param_dict.get('dayusage', False):
        is_show_daily_usage = False
    else:
        is_show_daily_usage = True

    if param_dict.get('invoice_jurisdictional_detail', False):
        invoice_jurisdictional_detail = "True"
    else:
        invoice_jurisdictional_detail = "False"

    if param_dict.get('is_send_as_link', False) == 0 or param_dict.get('is_send_as_link', False) == False:
        is_send_as_link = False
    else:
        is_send_as_link = True

    try:
        decimal_place = int(param_dict.get('decimal_place', 2)[0])
    except:
        decimal_place = 5

    if not param_dict.get('summary_of_payments',
                          False):  # param_dict.get('invoice_include_payment',False) == False and
        client_invoice_include_payment = "False"
    else:
        client_invoice_include_payment = "True"

    if param_dict.get('detail_by_trunk', False):
        param_dict['is_show_detail_trunk'] = True
    if not param_dict.get('is_show_detail_trunk', False):
        is_show_detail_trunk = "False"
    else:
        is_show_detail_trunk = "True"

    if param_dict.get('show_code_summery', False):
        param_dict['is_show_code_100'] = True
    if not param_dict.get('is_show_code_100', False):
        is_show_code_100 = "False"
    else:
        is_show_code_100 = "True"

    if param_dict.get('show_trafic_code_name', False):
        param_dict['is_show_code_name'] = True
    if not param_dict.get('is_show_code_name', False):
        is_show_code_name = "False"
    else:
        is_show_code_name = "True"

    if param_dict.get('show_trafic_country', False):
        param_dict['is_show_country'] = True
    if not param_dict.get('is_show_country', False):
        is_show_country = "False"
    else:
        is_show_country = "True"

    '''taron [7:24 PM] 
I suggest you keep only "/invoice/2395201708091617.pdf "
then we will found the dile with config_value.db_value


[7:25] 
I mean let's say someone changing config value to download1
then the files won't work with older path in DB


[7:25] 
so it means you need to keep in DB only my suggested part


[7:27] 
without slash 
"invoice/2395201708091617.pdf"'''

    pdf_path = pdf_path.split("/")[-1]
    pdf_path = pdf_path + "/" + invoice_name + ".pdf"
    pdf_path = invoice_name + ".pdf"
    print("pdf_path", pdf_path)

    if param_dict.get('show_calls_date', False):
        param_dict['is_show_by_date'] = True
    if not param_dict.get('is_show_by_date', False):
        is_show_by_date = "False"
    else:
        is_show_by_date = "True"

    # ['show_code_summery'] =result['is_show_code_100']
    sql = """insert into invoice(invoice_balance_time,invoice_use_balance_type,invoice_log_id,usage_detail_fields,is_short_duration_call_surcharge_detail,
	invoice_include_payment,is_show_daily_usage,is_invoice_account_summary,generate_start_time, include_detail,total_amount,buy_total,sell_total,buy_minutes,sell_minutes,buy_service_charge,
	sell_service_charge,state,client_id,invoice_time,invoice_start,invoice_end,due_date,current_balance,invoice_number,type,invoice_zone,create_type,status,invoice_jurisdictional_detail,decimal_place,
	is_send_as_link,pdf_path,is_show_detail_trunk,is_show_code_100,is_show_country,is_show_code_name,is_show_by_date) values( '%s', %s, %s, '%s', %s, %s, %s, %s, '%s', %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, '%s', '%s', '%s', '%s', %s, %s, %s, '%s', %s, %s, %s, %s,%s,'%s',%s ,%s,%s ,%s,%s)""" % (
        param_dict.get('balance_time', 0),
        client.get('invoice_use_balance_type', 0) or 0, log_id, client.get('usage_detail_fields', ""),
        is_short_duration_call_surcharge_detail,
        client_invoice_include_payment, is_show_daily_usage, is_invoice_account_summary, param_dict["start_date"],
        is_invoice_usage_detail,
        total_amount, 0, 0, 0, 0, 0, 0, 0, client.get('client_id', 0) or 0, invoice_date,
        param_dict['start_date_tmstamp'], param_dict['end_date_tmstamp'], param_dict.get('invoice_due_date', 0) or 0,
        current_balance, inv_num, client.get('invoice_type', 0) or 0,
        #client.get('invoice_zone', 0),
        param_dict.get('invoice_zone', '+00:00') or '+00:00',
        create_type, 2, invoice_jurisdictional_detail, decimal_place, is_send_as_link,
        pdf_path,
        is_show_detail_trunk, is_show_code_100, is_show_country, is_show_code_name,
        is_show_by_date)  # "/invoice/%s.pdf"%
    print("sql for inserting the invoice:", sql)
    LOGGER_LIST.append("sql for inserting the invoice: " + sql)
    print("Total amount ", total_amount)
    logger.debug("sql for inserting the invoice:" + sql)
    try:
        cur = pg_cur.execute(sql)

    except Exception as e:
        logger.error(" Exception in logging invoice:  %s" % (str(e)))
        print("Exception in logging invoice:  %s" % (str(e)))
        return None
    end = timer()
    logger.debug("execution time  in milliseconds: %s" % ((end - start) * 1000))
    return


def MakeAccountSumary(acount_sumary, float_form, client, param_dict, current_bill):
    """Makes pdf friendly acount sumary list"""
    #
    start = timer()
    logger.debug("Entering Making Acount summery table")
    # noinspection PyComparisonWithNone
    if acount_sumary == None:
        return None
    # print ("Makes pdf friendly acount sumary list")
    # print ("acount_sumary: "+str(acount_sumary),"current_bill:"+str(current_bill),"client: "+str(client))
    payment_credit = acount_sumary.get('payment_credit', 0)
    # noinspection PyComparisonWithNone
    if payment_credit == None:
        payments = 0.00
    else:
        payments = payment_credit  # -1 *
    prev_balance = acount_sumary.get('previous_balance', 0.00)
    # noinspection PyComparisonWithNone
    if prev_balance == None:
        prev_balance = 0
    else:
        if int(prev_balance) != 0:
            prev_balance = prev_balance  # -1 *

    if client.get("include_tax", False):
        tax = (zn(client.get("tax", 0)) * zn(current_bill)) / 100
    else:
        tax = 0.00
    try:
        result = [["Previous Balance", float_form % (prev_balance)], ["Payments and Credits", float_form % (payments)]
            , ["Balance Forward", float_form % (payments + prev_balance)],
                  ["Long Distance Charges", float_form % (current_bill)],
                  ["Federal, State, and Local Taxes", float_form % (tax)]
            , ["Balance as of %s " % param_dict.get("invoice_date", "N/A"),
               float_form % (-Decimal(current_bill) + Decimal(payments) + Decimal(prev_balance) - Decimal(tax))]]
    except Exception as e:
        logger.error(" Exception in calculating  client balance result:  %s" % (str(e)))
        print("Exception in calculating  client balance result:  %s" % (str(e)))

    # if client['include_tax'] :
    #	result.append (["Federal, State, and Local Taxes:", float_form % ( tax  )])

    query = """select balance,ingress_balance  from client_balance where client_id = '%s';""" % (client['client_id'])
    print(query)
    logger.debug(query)
    LOGGER_LIST.append(query)
    try:
        cur = pg_cur.execute(query)
        balance = dict_or_none(cur.fetchone())
        if balance is not None:
            print("balance", balance['balance'], type(balance['balance']), "ingress balance",
                  balance['ingress_balance'], type(balance['ingress_balance']))
            # logger.debug("Current Charges: %s. New Balances: %s, type: %s %s"%( balance.get('balance',"N/A"),balance.get('ingress_balance',"N/A"),
            # type(balance.get('balance',"N/A") ),type(balance.get('ingress_balance',"N/A")),type(balance.get('balance',"N/A")),type(balance.get('ingress_balance',"N/A")) ) )
            # print("Current Charges: %s. New Balances: %s, type: %s %s"%( balance.get('balance',"N/A"),balance.get('ingress_balance',"N/A"),
            # type(balance.get('balance',"N/A") ),type(balance.get('ingress_balance',"N/A")),type(balance.get('balance',"N/A")),type(balance.get('ingress_balance',"N/A")) ) )
            try:

                result.append(["Current Charges:", float_form % (Decimal(balance['balance']))])
                result.append(["New Balances:", Decimal(balance['ingress_balance'])])
            except Exception as e:
                logger.error(" Exception in getting client balance when balance is not None:  %s" % (str(e)))
                print("Exception in getting client balance:  %s" % (str(e)))
                invoice_log_set_error(str(e))
        else:
            print("Balance is None!")
    except Exception as e:
        logger.error(" Exception in getting client balance:  %s" % (str(e)))
        print("Exception in getting client balance:  %s" % (str(e)))
        invoice_log_set_error(str(e))

    query2 = """select client.mode, client.allowed_credit, client.unlimited_credit,  payment_term.name as payment_term_name from client left join payment_term on client.payment_term_id = 
	payment_term.payment_term_id where client_id = %s;""" % (client.get('client_id', 0))
    print("payment query and more: ", query2)
    logger.debug(query2)
    LOGGER_LIST.append(query2)
    try:
        cur = pg_cur.execute(query2)
        resultQ = dict_or_none(cur.fetchone())
        # print (resultQ)
        # noinspection PyComparisonWithNone
        if resultQ != None:
            print("RESULQ IS NOT NONE!")
            try:
                result.append(["Payment term:", resultQ['payment_term_name']])
            except Exception as e:
                logger.error(" Exception in getting client payment term:  %s" % (str(e)))
                print("Exception in getting client payment term:  %s" % (str(e)))
            try:
                if resultQ['mode'] == 2:
                    if resultQ['unlimited_credit']:
                        result.append(["Credit Remaining:", "Unlimited"])
                    else:
                        result.append(["Credit Remaining:", float_form % (abs(resultQ["allowed_credit"]))])  # math.
            except Exception as e:
                logger.error(" Exception in getting client credit remaining:  %s" % (str(e)))
                print("Exception in getting client credit remaining:  %s" % (str(e)))


    except Exception as e:
        logger.error(" Exception in getting client payment term and more:  %s" % (str(e)))
        print("Exception in getting client payment term and more:  %s" % (str(e)))
    # print ("Tabled Account Summery:" ,result)
    end = timer()
    logger.debug("execution time  in milliseconds: %s" % ((end - start) * 1000))
    return result


'''
def MakeShortSurcharge( param_dict,client,summary_of_charges,minutes,bill_time_secs,not_zero_calls,cost):
	#decides if surcharge is need and returns the surcharge
	pass 
'''


def GetSummary_of_payments(param_dict, client, sumary_of_payments, float_form):
    """Getting sumarry of payments"""
    #
    start = timer()
    logger.debug("Entering Get Summery of Payments")
    LOGGER_LIST.append("Entering Get Summery of Payments")
    print("Entering Get Summery of Payments")
    # if sumary_of_payments != None:
    #	from_date = sumary_of_payments.get(  param_dict['start_date'] )  #"invoice_end_time" ,
    # else:
    from_date = param_dict['start_date']
    start_date = from_date
    end_date = param_dict.get('end_date', 0)

    sql = """select client_payment_id,payment_time,case payment_type when 3 then amount*(0-1) when 4 then amount when 5 then amount when 6 then amount*(0-1) else 0 end as total_payment from
client_payment where  client_id= %s and payment_type in (4,5) and payment_time between '%s' and '%s'  order by payment_time desc limit 10 ;""" % (
        client['client_id'], start_date, end_date)  # ,"client_payment_id """ 3 , 6

    logger.debug(sql)
    LOGGER_LIST.append(sql)
    print(sql)
    try:
        cur = pg_cur.execute(sql)
        result = cur.fetchall()
        print("sql for summery_payments:", sql)
        LOGGER_LIST.append("sql for summery_payments:" + sql)
    except Exception as e:
        logger.error(" Exception in getting invoice summary_payments:  %s" % (str(e)))
        print(" Exception in getting invoice summary_payments:  %s" % (str(e)))
        print("sql for summery_payments:", sql)
        logger.debug(" Exception in getting invoice summary_payments:  %s" % (str(e)))
        invoice_log_set_error(str(e))
        return None
    table = [["Date", "Payment received"]]
    for row in [dict(r) for r in result]:
        new_row = [row.get("payment_time", "N/A"), float_form % (row.get("total_payment", 0))]
        table.append(new_row)
    # print ("Sumary of payments: ",table)
    end = timer()
    logger.debug("execution time  in milliseconds: %s" % ((end - start) * 1000))
    return table


def SumaryOfCharges(basic_bill, param_dict, client, cost, minutes, float_form):
    """ generates basic table for client bill with surcharges included."""
    print("generates basic table for client bill with surcharges included")
    #
    start = timer()
    logger.debug("Summery of Short Call Charges")
    LOGGER_LIST.append("Summery of Short Call Charges")
    table = [["", "Total Minutes", "Total Calls", "Total Charges(US)"],
             ["Minutes Usage", minutes, basic_bill.get('not_zero_calls', 0), float_form2 % (cost)]]

    # noinspection PyComparisonWithNone
    scc_perc = param_dict.get('scc_percent', 0) if param_dict.get('scc_percent', 0) != None else 0
    # noinspection PyComparisonWithNone
    scc_below_sec = param_dict.get('scc_bellow', 0) if param_dict.get('scc_bellow', 0) != None else 0
    # noinspection PyComparisonWithNone
    scc_charge = param_dict.get('scc_charge', 0) if param_dict.get('scc_charge', 0) != None else 0
    # noinspection PyComparisonWithNone
    scc_type = param_dict.get('scc_type', 0) if param_dict.get('scc_type',
                                                               0) != None else 0  # if this is selected, then the penalty is 200 * short charge

    if not param_dict.get("is_short_duration_call_surcharge_detail", False):
        print("Carrier do not have surcharge include")
        print("cost:", cost)
        row_total = ["TOTAL", "", "", float_form2 % (cost)]
        table.append(row_total)
        return table
    result = None

    start_date = param_dict.get('start_date')
    end_date = param_dict.get('end_date')
    client_id = param_dict.get('client_id')

    # noinspection PyComparisonWithNone,PyComparisonWithNone,PyComparisonWithNone
    if start_date == None or end_date == None or client_id == None:
        print("Error! Must suply client_id,start_date and end_date!")
        return {}
    try:
        start_date_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S").date()
        end_date_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S").date()
    except Exception as e:
        print(str(e))
        invoice_log_set_error(str(e))
        logger.error(str(e))
        logger.debug("error %s" % (str(e)))
        return None
    delta = end_date_obj - start_date_obj
    if delta.days < 0:  # single day
        today = end_date_obj.strftime("%Y%02m%02d")
        # basic query  select duration from public.cdr_report  where ingress_client_id =58 and not_zero_calls > 0 and duration < 1000
        daily_query_basic = """select duration from public.cdr_report_detail%s where ingress_client_id =%s and not_zero_calls > 0 and duration < %s;""" % (
            today, client_id, scc_below_sec)
        daily_query_basic_all_duration = """select duration from public.cdr_report_detail%s where ingress_client_id =%s and not_zero_calls > 0 ;""" % (
            today, client_id)
        print("surcharge daily_query: ", daily_query_basic)
        print("surcharge daily_query ALL durations: ", daily_query_basic_all_duration)
        cur = pg_cur.execute(daily_query_basic)
        result = cur.fetchall()
        cur = pg_cur.execute(daily_query_basic_all_duration)
        result_all = cur.fetchall()
    else:
        # basic query  ,ingress_client_id,not_zero_calls sum(duration) , count(*)
        basic_quer_part1 = """select  sum(duration) as dur ,sum(not_zero_calls) as nzc from 
	(select duration,ingress_client_id,not_zero_calls  from public.cdr_report_detail%s """ % (
            start_date_obj.strftime("%Y%02m%02d"))
        basic_quer_part1_all = """select sum(duration) as dur ,sum(not_zero_calls) as nzc  from 
	(select duration,ingress_client_id,not_zero_calls from public.cdr_report_detail%s """ % (
            start_date_obj.strftime("%Y%02m%02d"))

        basic_quer_part3 = """) t where ingress_client_id = %s and not_zero_calls > 0 and duration < %s ;""" % (
            client_id, scc_below_sec)
        basic_make_query = basic_quer_part1
        basic_quer_part3_all = """) t where ingress_client_id = %s and not_zero_calls > 0  ;""" % (client_id)
        basic_make_query_all = basic_quer_part1_all

        for i in range(1, delta.days + 1):
            day = start_date_obj + datetime.timedelta(days=i)  # .replace("-","")
            day = day.strftime("%Y%02m%02d")
            basic_make_query += """union all select duration ,ingress_client_id,not_zero_calls from public.cdr_report_detail%s """ % (
                day)
            basic_make_query_all += """union all select duration ,ingress_client_id,not_zero_calls from public.cdr_report_detail%s """ % (
                day)

        basic_make_query += basic_quer_part3
        basic_make_query_all += basic_quer_part3_all
        logger.debug("getting invoice basic surcharge query:" + basic_make_query)
        print("getting invoice basic surcharge query:" + basic_make_query)
        print("getting invoice multiunion surcharge query ALL:", basic_make_query_all)
        logger.debug("getting invoice multiunion surcharge query ALL:" + basic_make_query_all)
        LOGGER_LIST.append("getting invoice multiunion surcharge query ALL:" + basic_make_query_all)
        try:
            cur = pg_cur.execute(basic_make_query)
            result = dict_or_none(cur.fetchone())
            cur = pg_cur.execute(basic_make_query_all)
            result_all = dict_or_none(cur.fetchone())

        except Exception as e:
            logger.error(" error in getting surcharge multi:  %s" % (str(e)))
            print("error in getting surcharge multi %s" % (str(e)))
            invoice_log_set_error(str(e))
    print("len of surcharged calls", result['nzc'], result_all['nzc'])
    try:
        percent_real = (result['nzc'] / result_all['nzc']) * 100  # we need this a whole percent
    except Exception as e:
        invoice_log_set_error(str(e))
        print(str(e))
        logger.error(str(e))
        # logger.debug ("error  %s" % (str(e) ))
        percent_real = 0
    print("percent of short calls %s,  from %s , scc_type is %s" % (percent_real, scc_perc, scc_type))
    LOGGER_LIST.append("percent of short calls %s,  from %s , scc_type is %s" % (percent_real, scc_perc, scc_type))

    if scc_type == 0 and percent_real <= scc_perc:
        LOGGER_LIST.append("scc will be applied to each call ")
        num_calls = result['nzc']  # len (result_all ) -   len (result)
        # noinspection PyComparisonWithNone
        if num_calls == None:
            num_calls = 0
        charge = num_calls * scc_charge
    elif scc_type == 1 and percent_real > scc_perc:
        LOGGER_LIST.append("scc will be applied to exccess  calls only  ")
        num_calls = result['nzc'] - (scc_perc / 100) * result_all['nzc']
        charge = num_calls * scc_charge
    else:
        LOGGER_LIST.append("Rule is not met percent_real >=<  scc_per")
        row_total = ["TOTAL", minutes, basic_bill.get('not_zero_calls', 0), float_form2 % (cost)]
        table.append(row_total)
        return table

    print("Aplying surcharges to table")
    row_charge = ["Short Charges", "", num_calls, float_form2 % (charge)]
    row_total = ["TOTAL", "", "", float_form2 % (Decimal(cost) + charge)]
    basic_bill['call_cost'] = Decimal(cost) + charge
    table.append(row_charge)
    table.append(row_total)
    end = timer()
    logger.debug("execution time  in milliseconds: %s" % ((end - start) * 1000))
    return table


def MakeDailyQueryTable(param_dict, client, float_form, day_usage):
    """generates DAILY USAGE! table  """
    #
    start = timer()
    logger.debug("Entering Make Daily Table")
    table = day_usage  # [["code Name", "Rate(US)", "Effective Date"]]
    start_date = param_dict.get('start_date')
    end_date = param_dict.get('end_date')
    client_id = param_dict.get('client_id')

    # noinspection PyComparisonWithNone,PyComparisonWithNone,PyComparisonWithNone
    if start_date == None or end_date == None or client_id == None:
        print("Error! Must suply client_id,start_date and end_date!")
        return {}
    try:
        start_date_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S").date()
        end_date_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S").date()
        start_datetime_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S")
        end_datetime_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S")
    except Exception as e:
        print(str(e))
        invoice_log_set_error(str(e))
        logger.error(str(e))
        logger.debug("error in getting Daily query %s" % (str(e)))
        return table
    delta = end_date_obj - start_date_obj

    today = start_date_obj.strftime("%Y%02m%02d")
    # basic query
    basic_quer_part1 = """select date_trunc('day',report_time) as report_time ,sum(ingress_bill_time) as bill_time,sum(ingress_call_cost) as cost,sum(not_zero_calls) as calls,sum(ingress_call_cost_intra) as cost_intra,
sum(ingress_call_cost_inter) as cost_inter,sum(ingress_bill_time_intra) as bill_time_intra,sum(ingress_bill_time_inter) as bill_time_inter  from ( select  report_time,ingress_client_id,ingress_bill_time,ingress_call_cost,not_zero_calls,ingress_call_cost_intra,
ingress_call_cost_inter,ingress_bill_time_intra,ingress_bill_time_inter  from cdr_report_detail%s """ % (today)

    basic_quer_part3 = """) t where ingress_client_id = %s  and not_zero_calls>0 group by report_time ; """ % (
        client['client_id'])
    basic_make_query = basic_quer_part1
    result_dict = dict()
    result_list = list()
    result_dict[start_date_obj.strftime("%Y-%02m-%02d")] = [0, 0, 0, 0, 0, 0, 0,
                                                            0]  # result_dict is a dict keys every date from billing period
    result_list.append(start_date_obj.strftime("%Y-%02m-%02d"))
    for i in range(1, delta.days + 1):
        day = start_date_obj + datetime.timedelta(days=i)  # .replace("-","")
        result_dict[day.strftime("%Y-%02m-%02d")] = [0, 0, 0, 0, 0, 0, 0, 0]
        result_list.append(day.strftime("%Y-%02m-%02d"))
        day = day.strftime("%Y%02m%02d")
        basic_make_query += """UNION ALL    select report_time,ingress_client_id,ingress_bill_time,ingress_call_cost,not_zero_calls,ingress_call_cost_intra,
ingress_call_cost_inter,ingress_bill_time_intra,ingress_bill_time_inter  from cdr_report_detail%s  """ % (day)

    basic_make_query += basic_quer_part3

    print("DAILY  QUERY:", basic_make_query, result_dict)
    LOGGER_LIST.append("DAILY  QUERY:" + basic_make_query)
    logger.debug(basic_make_query)
    try:
        cur = pg_cur.execute(basic_make_query)
        result = cur.fetchall()

    except Exception as e:
        logger.error(" error in getting surcharge multi:  %s" % (str(e)))
        print("error in getting daily %s" % (str(e)))
        return table
    # print ("RESULT OF DAILY:" , result)
    total = def_dict(int)

    day_totals = def_dict(lambda: def_dict(Decimal))
    for row in [dict(r) for r in result]:
        # result_dict [  str (row["report_time"].date() )  ] [idx] += row [idx]
        day = str(row["report_time"].date())
        # day_totals [ day  ] = str (row["report_time"].date() )
        day_totals[str(row["report_time"].date())]["cost"] += Decimal(row["cost"])
        day_totals[str(row["report_time"].date())]["cost_intra"] += Decimal(row["cost_intra"])
        day_totals[str(row["report_time"].date())]["cost_inter"] += Decimal(row["cost_inter"])
        day_totals[str(row["report_time"].date())]["cost_ij"] += Decimal(row["cost"]) - Decimal(
            row["cost_inter"]) - Decimal(
            row["cost_intra"])
        day_totals[str(row["report_time"].date())]["bill_time"] += Decimal(row["bill_time"] / 60)
        day_totals[str(row["report_time"].date())]["bill_time_intra"] += Decimal(row["bill_time_intra"] / 60)
        day_totals[str(row["report_time"].date())]["bill_time_inter"] += Decimal(row["bill_time_inter"] / 60)
        day_totals[str(row["report_time"].date())]["bill_time_ij"] += Decimal(row["bill_time"] / 60) - Decimal(
            row["bill_time_inter"] / 60) - Decimal(row["bill_time_intra"] / 60)
        # print ("row", row["report_time"], row["cost"],row  ["cost_intra"] , row  ["cost_inter"],row["bill_time"]/60 ,row  ["bill_time_intra"]/60 - row  ["bill_time_inter"]/60 )
        # day_val = result_dict [  str (row["report_time"].date() )  ]
        # day_totals [str (row["report_time"].date()] = day_val
        call_inted = row["cost"] - row["cost_intra"] - row["cost_inter"]
        total['call_inted'] += call_inted
        total['cost'] += row["cost"]
        bill_time_inted = row["bill_time"] / 60 - row["bill_time_intra"] / 60 - row["bill_time_inter"] / 60
        total['bill_time_inted'] += +Decimal(bill_time_inted)  # Decimal( day_val[2] )
        total['bill_time_intra'] += Decimal(row["bill_time_intra"] / 60)
        total['bill_time_inter'] += Decimal(row["bill_time_inter"] / 60)
        total['bill_time'] += Decimal(row["bill_time"] / 60)  # Decimal(day_val[3])+
        total['cost_intra'] += row["cost_intra"]
        total['cost_inter'] += row["cost_inter"]
    # print ("day_totals", str(day_totals))
    for key in day_totals.keys():
        row = day_totals[key]
        result_dict[key] = [Decimal(row["bill_time_inter"]), Decimal(row["cost_inter"]),
                            Decimal(row["bill_time_intra"]), Decimal(row["cost_intra"]),
                            Decimal(row["bill_time_ij"]), Decimal(row["cost_ij"]), Decimal(row['bill_time']),
                            Decimal(row["cost"])]  # day_val[6] +
    #  ,day_val[3] + row  ["bill_time"] / 60 	+ row  ["cost"]  ]
    # print ("result_dict: ", result_dict)

    for key in result_list:
        all_cost = result_dict[key][7]
        if all_cost != 0:
            row = result_dict[key]
            row.insert(0, key)
            table_row = []
            for elem in row:
                if not isinstance(elem, str):
                    elem = float_form % (elem)
                table_row.append(elem)
            table.append(table_row)
        else:
            print("Daily row was not added", all_cost, key)
    if len(table) > 2:
        table.append(["Total", float_form2 % (total['bill_time_inter']), float_form2 % (total['cost_inter']),
                      float_form2 % (total['bill_time_intra']), float_form2 % (total['cost_intra']),
                      float_form2 % (total['bill_time_inted']), float_form2 % (total['call_inted']),
                      float_form2 % (total['bill_time']), float_form2 % (total['cost'])])
    # print ("DAILY TABLE: ",table)
    end = timer()
    logger.debug("execution time  in milliseconds: %s" % ((end - start) * 1000))
    return table


def GetJurisdict(param_dict, client, acount_sumary, float_form):
    """Getting juridct breakdown and making it table """
    table = [["Code Name", 'Interstate', '', 'Intrastate', '', 'IJ', '', 'Total', ''],
             ["", " Rate", "Cost", "Rate", "Cost", "Rate", " Cost", "Rate", "Cost"]]

    start = timer()
    logger.debug("Entering Get GEt Jursidiction")
    LOGGER_LIST.append("Entering Get GEt Jursidiction")

    start_date = param_dict.get('start_date')
    end_date = param_dict.get('end_date')
    client_id = param_dict.get('client_id')

    if start_date is None or end_date is None or client_id is None:
        print("Error! Must suply client_id,start_date and end_date!")
        return {}
    try:
        start_date_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S").date()
        end_date_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S").date()
        start_datetime_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S")
        end_datetime_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S")
    except Exception as e:
        print(str(e))
        logger.error(str(e))
        return table
    # ingress_code_name |    cost    | ingress_call_cost_intra | ingress_call_cost_inter | ingress_bill_time_intra | ingress_bill_time_inter | ingress_bill_time |  cost_ij
    # -------------------+------------+-------------------------+-------------------------+-------------------------+-------------------------+-------------------+------------
    # | 417.399930 |                0.000000 |                0.000000 |                       0 |                       0 |             12522 | 417.399930

    try:
        params = {
            'field': "not_zero_calls,inter_ingress_calls,ingress_bill_time_inter,intra_ingress_calls,ingress_call_cost_intra,ingress_bill_time_intra,ij_ingress_calls,ingress_bill_time_ij,ingress_call_cost_ij,ingress_call_cost_inter,ingress_calls,ingress_call_cost",
            'ingress_id': ",".join(str(e) for e in param_dict['ingress_ids']), 'group': "ingress_id,code_name"}
    except Exception as e:
        print("Exception in generating params for peterAPI %s" % e)
        traceback.print_tb(e.__traceback__)

    result = send_api_request(start_datetime_obj, end_datetime_obj, params)


    try:
        result = result.get('data', {})
    except:
        return table

    total = def_dict(int)
    float_form3 = "%0.3f"
    float_form2 = "%0.2f"
    for row in result:
        # if not row.get ("ingress_code_name",False):
        #	continue
        if bool(row):
            if row['not_zero_calls'] < 0.01:
                continue
            ingress_code_name = row.get("code_name", "N/A").replace("NULL", "")
            # if ingress_code_name == "":
            #	print ("ingress code name is None")
            #	continue #ingress_code_name = "Null"

            cost = Decimal(row.get("ingress_call_cost", 0))
            ingress_call_cost_inter = Decimal(row.get("ingress_call_cost_inter", 0))
            ingress_call_cost_intra = Decimal(row.get("ingress_call_cost_intra", 0))
            ingress_call_cost_ij = Decimal(row.get("ingress_call_cost_ij", 0))
            ingress_bill_time_ij = row.get("ingress_bill_time_ij", 0) / 60
            ingress_bill_time_inter = row.get("ingress_bill_time_inter", 0) / 60
            ingress_bill_time_intra = row.get("ingress_bill_time_intra", 0) / 60
            # print (ingress_code_name,    cost  ,ingress_call_cost_intra, ingress_call_cost_inter,ingress_bill_time_intra ,ingress_bill_time_inter , ingress_bill_time  )
            # print ("cp2")
            try:
                ingress_rate = ingress_call_cost_ij / ingress_bill_time_ij
            except Exception as e:
                print("ingress_rate = cost  / ingress_bill_time", str(e))
                ingress_rate = 0

            try:
                ingress_rate_inter = ingress_call_cost_inter / ingress_bill_time_inter
            except Exception as e:
                ingress_rate_inter = 0
                print("ingress_rate = cost  / ingress_bill_tim_inter", str(e))

            try:
                ingress_rate_intra = ingress_call_cost_inter / ingress_bill_time_intra
            except Exception as e:
                ingress_rate_intra = 0
                print("ingress_rate = cost  / ingress_bill_tim_intra", str(e))

            ### Totals!
            # print ("cp3")
            total['cost_inted'] += ingress_call_cost_ij
            total['cost'] += cost
            total['ingress_rate_inted'] = ""
            total['ingress_rate_intra'] = ""  # ingress_bill_time_intra
            total['ingress_rate_inter'] = ""  # ingress_bill_time_inter
            total['ingress_rate'] = ""  # ingress_rate
            total['cost_intra'] += ingress_call_cost_intra
            total['cost_inter'] += ingress_call_cost_inter
            # print ("cp4")

            table.append([ingress_code_name, float_form3 % (ingress_rate_inter),
                          float_form2 % (ingress_call_cost_inter),
                          float_form3 % (ingress_rate_intra),
                          float_form2 % (ingress_call_cost_intra),
                          float_form3 % (ingress_rate), float_form2 % (ingress_call_cost_ij),
                          float_form3 % (ingress_rate), float_form2 % (cost)])

    if len(table) > 2:
        table.append(["Total", "", float_form2 % (total['cost_inter']), "", float_form2 % (total['cost_intra']), "",
                      float_form2 % (total['cost_inted']), "", float_form2 % (total['cost'])])

    print("jurisdiction_table len :", len(table))

    # float_form = "%0.2f"
    end = timer()
    logger.debug("execution time  in milliseconds: %s" % ((end - start) * 1000))
    return table


def MakeDayUsageHeader():
    """Daily usage """
    table = [["Date", "Interstate", "", "Intrastate", "", "IJ", "", "Total", ""],
             ["", "Minute", "Cost", "Minute", "Cost", "Minute", "Cost", "Minute", "Cost"]]

    return table


def Make_Ingress_Prefix_Jur(param_dict, client, float_form):
    # Summary By Trunk
    start = timer()
    logger.debug("Entering Summary By Trunk Table Jur")
    LOGGER_LIST.append("Entering Summary By Trunk Table Jur")
    print("Summary By Trunk")
    table = [['', 'Interstate', '', '', 'Intrastate', '', '', 'IJ', '', ''],
             ["Trunk ", "Calls", "Duration", "Amount", "Calls", "Duration",
              "Amount", "Calls", "Duration", "Amount"]]
    start_date = param_dict.get('start_date')
    end_date = param_dict.get('end_date')
    client_id = param_dict.get('client_id')

    if start_date is None or end_date is None or client_id is None:
        print("Error! Must suply client_id,start_date and end_date!")
        return {}
    try:
        start_date_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S").date()
        end_date_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S").date()
        start_datetime_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S")
        end_datetime_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S")
    except Exception as e:
        print(str(e))
        logger.error(str(e))
        logger.debug("error in getting Show traffic country %s" % (str(e)))
        return table

    try:
        params = {
            'field': "not_zero_calls,inter_ingress_calls,ingress_bill_time_inter,intra_ingress_calls,ingress_call_cost_intra,ingress_bill_time_intra,ij_ingress_calls,ingress_bill_time_ij,ingress_call_cost_ij,ingress_call_cost_inter,ingress_calls,ingress_call_cost",
            'ingress_id': ",".join(str(e) for e in param_dict['ingress_ids']), 'group': "ingress_id"}
    except Exception as e:
        print("Exception in generating params for peterAPI %s" % e)
        traceback.print_tb(e.__traceback__)

    result = send_api_request(start_datetime_obj, end_datetime_obj, params)


    try:
        result = result.get('data', {})
    except:
        return table

    ##Here, we need to map ingress_id with their names
    sql = """select resource_id ,alias from resource where resource_id in (%s)""" % ",".join(
        str(e) for e in param_dict['ingress_ids'])
    # print ("Here, we need to map ingress_id with their names")
    # print (sql)
    cur=pg_cur.execute(sql)
    res_aliases = cur.fetchall()
    res_to_alias_dict = dict()
    for row in res_aliases:
        try:
            res_id = row['resource_id']
            res_to_alias_dict[res_id] = row['alias']
        except Exception as e:
            print(e)
            print(row.copy())

    total = def_dict(int)
    float_form3 = "%0.3f"
    float_form2 = "%0.2f"
    for row in result:
        # if not row.get ("ingress_code_name",False):
        #	continue
        if bool(row):
            if row['not_zero_calls'] < 0.01:
                continue
            ingress_code_name = row.get("code_name", "N/A").replace("NULL", "")
            # if ingress_code_name == "":
            #	print ("ingress code name is None")
            #	continue #ingress_code_name = "Null"

            cost = Decimal(row.get("ingress_call_cost", 0))
            ingress_call_cost_inter = Decimal(row.get("ingress_call_cost_inter", 0))
            ingress_call_cost_intra = Decimal(row.get("ingress_call_cost_intra", 0))
            ingress_call_cost_ij = Decimal(row.get("ingress_call_cost_ij", 0))
            ingress_bill_time_ij = row.get("ingress_bill_time_ij", 0) / 60
            ingress_bill_time_inter = row.get("ingress_bill_time_inter", 0) / 60
            ingress_bill_time_intra = row.get("ingress_bill_time_intra", 0) / 60
            try:
                ingress_rate = ingress_call_cost_ij / ingress_bill_time_ij
            except Exception as e:
                print("ingress_rate = cost  / ingress_bill_time", str(e))
                ingress_rate = 0

            try:
                ingress_rate_inter = ingress_call_cost_inter / ingress_bill_time_inter
            except Exception as e:
                ingress_rate_inter = 0
                print("ingress_rate = cost  / ingress_bill_tim_inter", str(e))

            try:
                ingress_rate_intra = ingress_call_cost_inter / ingress_bill_time_intra
            except Exception as e:
                ingress_rate_intra = 0
                print("ingress_rate = cost  / ingress_bill_tim_intra", str(e))

            ### Totals!
            total['cost_ij'] += ingress_call_cost_ij
            total['cost'] += cost
            total['ingress_rate_inted'] = ""
            total['bill_time_intra'] = ingress_bill_time_intra
            total['bill_time_inter'] = ingress_bill_time_inter
            total['ingress_rate'] = ""  # ingress_rate
            total['cost_intra'] += ingress_call_cost_intra
            total['cost_inter'] += ingress_call_cost_inter
            total['intra_calls'] += row['intra_ingress_calls']
            total['inter_calls'] += row['inter_ingress_calls']
            total['ij_calls'] += row['ij_ingress_calls']

            alias = res_to_alias_dict.get(row['ingress_id'], 'N/A')
            table.append([alias, row['intra_ingress_calls'], float_form2 % (ingress_bill_time_intra),
                          float_form2 % (ingress_call_cost_intra),
                          row['inter_ingress_calls'], float_form2 % (ingress_bill_time_inter),
                          float_form2 % (ingress_call_cost_inter),
                          row['not_zero_calls'] - row['inter_ingress_calls'] - row['intra_ingress_calls'],
                          float_form2 % (ingress_bill_time_ij),
                          float_form2 % (ingress_call_cost_ij)])

    if len(table) > 2:
        table.append(["Total", total['intra_calls'], float_form % (total['bill_time_intra'] / 60),
                      float_form % (total['cost_intra']),
                      total['inter_calls'], float_form % (total['bill_time_inter'] / 60),
                      float_form % (total['cost_inter']), total['ij_calls'],
                      float_form % (total['bill_time_ij'] / 60), float_form % (total['cost_ij'])])

    print("jurisdiction prefix table len :", len(table))

    end = timer()
    logger.debug("execution time  in milliseconds: %s" % ((end - start) * 1000))
    return table


def GetIngress_prefix(param_dict, client, float_form):
    # Summary By Trunk

    if param_dict.get('jurisdict', False):  # invoice_jurisdictional_detail
        prefix = Make_Ingress_Prefix_Jur(param_dict, client, float_form)
        return prefix

    start = timer()
    logger.debug("Entering Summary By Trunk Table")
    table = [["Trunk ", "Calls Total", "Duration", "Amount"]]
    start_date = param_dict.get('start_date')
    end_date = param_dict.get('end_date')

    try:
        start_datetime_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S")
        end_datetime_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S")
    except Exception as e:
        print(str(e))
        logger.error(str(e))
        return table

    # The Trunk that has 0 amount should not be shown. http://jira.denovolab.com/browse/CLAS-2510
    try:
        params = {
            'field': "not_zero_calls,inter_ingress_calls,ingress_bill_time_inter,intra_ingress_calls,ingress_call_cost_intra,ingress_bill_time_intra,ij_ingress_calls,ingress_bill_time_ij,ingress_call_cost_ij,ingress_call_cost_inter,ingress_calls,ingress_call_cost",
            'ingress_id': ",".join(str(e) for e in param_dict['ingress_ids']), 'group': "ingress_id"}
    except Exception as e:
        print("Exception in generating params for peterAPI %s" % e)
        traceback.print_tb(e.__traceback__)

    result = send_api_request(start_datetime_obj, end_datetime_obj, params)


    #  alias     | ingress_prefix | bill_time |   cost    | calls
    # --------------+----------------+-----------+-----------+-------
    # mera_ingress |                |       338 | 11.267100 |     9
    # 'data': [{'ingress_bill_time_inter': 0.0, 'ingress_bill_time_ij': 12522.0, 'ij_ingress_calls': 14414.0, 'intra_ingress_calls': 0.0, 'ingress_call_cost': 417.402771,
    # 'inter_ingress_calls': 0.0, 'ingress_calls': 14414.0, 'ingress_bill_time_intra': 0.0, 'ingress_call_cost_inter': 0.0, 'ingress_call_cost_intra': 0.0,
    #  'ingress_call_cost_ij': 417.402771, 'ingress_id': 980, 'time': 1518739200}, {}]}
    ####
    # krasytod [2:59 PM]
    # @akash. Sorry, I meant the "prefix" for that option.  I am getting Alias from resource table, but what about prefix ?
    # akash [3:07 PM]
    # we need to remove that oprion
    # we do not have that by peter api
    # For version 6 remove prefix column from the table

    ##Here, we need to map ingress_id with their names
    sql = """select resource_id ,alias from resource where resource_id in (%s)""" % ",".join(
        str(e) for e in param_dict['ingress_ids'])
    # print ("Here, we need to map ingress_id with their names")
    # print (sql)
    cur=pg_cur.execute(sql)
    res_aliases = cur.fetchall()
    res_to_alias_dict = dict()
    for row in res_aliases:
        try:
            res_id = row['resource_id']
            res_to_alias_dict[res_id] = row['alias']
        except Exception as e:
            print(e)
            print(row.copy())
    # time.sleep(10)

    total = def_dict(int)
    # print ("res_to_alias_dict",res_to_alias_dict)

    for row in result.get('data', {}):
        if row:
            if row[
                'ingress_calls'] > 0.01:  # The Trunk that has 0 amount should not be shown. http://jira.denovolab.com/browse/CLAS-2510
                alias = res_to_alias_dict.get(row.get('ingress_id', "N/A"), "N/A")
                if len(alias) > 12:
                    alias = alias[0:10] + "..."
                total['calls'] += int(row['not_zero_calls'])
                total['bill_time'] += row['ingress_bill_time_ij'] / 60
                total['cost'] += row['ingress_call_cost_ij']
                table.append([alias, int(row['not_zero_calls']), float_form % (row['ingress_bill_time_ij'] / 60),
                              float_form % (row['ingress_call_cost_ij'])])
    if len(table) > 1:
        table.append(["Total", total['calls'], float_form % (total['bill_time']), float_form % (total['cost'])])

    end = timer()
    logger.debug("execution time  in milliseconds: %s" % ((end - start) * 1000))
    return table


def MakeShowDetailByCodeName(param_dict, client, float_form):
    # last change from Jira CLAS-2764
    start = timer()
    logger.debug("Entering Detail by code name Table")
    table = [['Trunk Name', 'Duration', 'connected calls', 'Avg Rate', 'Cost']]
    start_date = param_dict.get('start_date')
    end_date = param_dict.get('end_date')
    client_id = param_dict.get('client_id')

    # noinspection PyComparisonWithNone,PyComparisonWithNone,PyComparisonWithNone
    if start_date == None or end_date == None or client_id == None:
        print("Error! Must suply client_id,start_date and end_date!")
        return {}
    try:
        start_date_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S").date()
        end_date_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S").date()
        start_datetime_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S")
        end_datetime_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S")
    except Exception as e:
        print(str(e))
        logger.error(str(e))
        return table
    delta = end_date_obj - start_date_obj
    if delta.days < 0:
        return None


    else:
        today = start_date_obj.strftime("%Y%02m%02d")  # duration, connected calls, Avg Rate, cost
        basic_quer_part1 = """ select  ingress_code_name,sum(duration) as duration,sum(not_zero_calls) as calls, sum(ingress_call_cost) as cost 
	  from  ( select ingress_code_name, alias,duration  ,not_zero_calls ,   ingress_call_cost ,ingress_id  
   from    public.cdr_report_detail%s  right join   
  resource on  cdr_report_detail%s.ingress_id =  resource.resource_id  where
 ingress_client_id =%s and  report_time between '%s' and '%s' """ % (
            today, today, client_id, start_datetime_obj, end_datetime_obj)

        basic_quer_part3 = """ )as A group by ingress_code_name,alias; """
        basic_make_query = basic_quer_part1

        for i in range(1, delta.days + 1):
            day = start_date_obj + datetime.timedelta(days=i)  # .replace("-","")
            day = day.strftime("%Y%02m%02d")
            basic_make_query += """UNION ALL  select ingress_code_name, alias,duration  ,not_zero_calls ,   ingress_call_cost ,ingress_id  
  from    public.cdr_report_detail%s   right join     resource on  cdr_report_detail%s.ingress_id =  resource.resource_id   where
 ingress_client_id =%s and report_time between '%s' and '%s' """ % (
                day, day, client_id, start_datetime_obj, end_datetime_obj)
        basic_make_query += basic_quer_part3

        print("INGRESS code_name DETAIL  QUERY:", basic_make_query)
        logger.debug("INGRESS code_name DETAIL QUERY:" + basic_make_query)
        try:
            cur = pg_cur.execute(basic_make_query)
            result = cur.fetchall()

        except Exception as e:
            logger.error(" Error in getting ingress code_name detail:  %s" % (str(e)))
            print("error in getting ingress code_name detail  %s" % (str(e)))
            logger.debug(" Error in getting ingress code_name detail :  %s" % (str(e)))
            return table
    print("INGRESS code_name DETAIL  QUERY Result:", result)

    total = def_dict(int)

    for row in [dict(r) for r in result]:
        # noinspection PyComparisonWithNone
        if row.get('ingress_code_name', None) == None:
            continue
        # duration, connected calls, Avg Rate, cost
        total["duration"] += row.get("duration", 0) / 60
        total["calls"] += row.get("calls", 0)
        try:
            total["rate"] += row.get("cost", 0) / row.get("duration", 0) / 60
        except:
            total["rate"] += 0
        total["cost"] += row.get("cost", 0)
        try:
            rate = Decimal(row.get("cost", 0)) / Decimal(Decimal(row.get("duration", 0)) / 60)
        except:
            rate = 0

        table.append(
            [row.get('ingress_code_name', "N/A"), float_form % (row.get("duration", 0) / 60), row.get("calls", 0),
             float_form % (rate)
                , float_form % (row.get("cost", 0))])

    if len(table) > 1:
        table.append(["Total", float_form % (total["duration"]), total["calls"],
                      float_form % (Decimal(total["cost"]) / Decimal(total["duration"])), float_form % (total["cost"])])

    print("detail by code name table:", table)

    end = timer()
    logger.debug("execution time  in milliseconds: %s" % ((end - start) * 1000))
    return table


def Make_show_trafic_code_name_jur(param_dict, client, float_form):
    start = timer()
    logger.debug(" Make_show_trafic_code_name_jur")
    LOGGER_LIST.append(" Make_show_trafic_code_name_jur")
    print(" Make_show_trafic_code_name_jur")
    table = [["Code Name", 'Interstate', "", "", 'Intrastate', "", "", 'IJ', "", "", 'Total'],
             ["", "Calls", "Duration", "Amount", "Calls", "Duration",
              "Amount", "Calls", "Duration", "Amount", "Calls", "Duration", "Amount"]]
    start_date = param_dict.get('start_date')
    end_date = param_dict.get('end_date')
    client_id = param_dict.get('client_id')

    if start_date is None or end_date is None or client_id is None:
        print("Error! Must suply client_id,start_date and end_date!")
        return {}
    try:
        start_date_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S").date()
        end_date_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S").date()
        start_datetime_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S")
        end_datetime_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S")
    except Exception as e:
        print(str(e))
        logger.error(str(e))
        logger.error("error in getting  Make_show_trafic_code_name_jur%s" % (str(e)))
        return table

    float_form3 = "%0.3f"
    float_form4 = "%0.4f"
    float_form2 = "%0.2f"
    total = def_dict(int)
    try:
        params = {
            'field': """not_zero_calls,inter_ingress_calls,ingress_bill_time_inter,intra_ingress_calls,ingress_call_cost_intra,ingress_bill_time_intra,ij_ingress_calls,ingress_bill_time_ij,ingress_call_cost_ij,ingress_call_cost_inter,ingress_calls,ingress_call_cost""",
            'ingress_id': ",".join(str(e) for e in param_dict['ingress_ids']), 'group': "ingress_id,code_name"}
    except Exception as e:
        print("Exception in generating params for peterAPI %s" % e)
        traceback.print_tb(e.__traceback__)

    result = send_api_request(start_datetime_obj, end_datetime_obj, params)


    result = result.get('data', {})

    for row in result:
        if not bool(row):  # row is empty dict
            continue
        try:
            ingress_code = row['code_name'].replace("NULL", "")
            if len(ingress_code) > 9:
                ingress_code = ingress_code[:7] + "..."
        except:
            continue
        calls = row['not_zero_calls']
        bill_time = row['ingress_bill_time_ij'] / 60
        cost = row['ingress_call_cost_ij']

        ingress_call_cost_intra = row['ingress_call_cost_intra']
        ingress_call_cost_inter = row['ingress_call_cost_inter']

        ingress_bill_time_intra = row['ingress_bill_time_intra'] / 60
        ingress_bill_time_inter = row['ingress_bill_time_inter'] / 60

        inter_ingress_calls = row['inter_ingress_calls']
        intra_ingress_calls = row['intra_ingress_calls']
        ij_ingress_calls = row['ij_ingress_calls']

        total["calls"] += calls
        total["bill_time"] += bill_time
        total["cost"] += cost

        total["intra_calls"] += intra_ingress_calls
        total["bill_time_intra"] += ingress_bill_time_intra
        total["cost_intra"] += ingress_call_cost_intra

        total["inter_calls"] += ingress_call_cost_inter
        total["bill_time_inter"] += ingress_bill_time_inter
        total["cost_inter"] += ingress_call_cost_inter

        total["ij_calls"] += calls
        total["bill_time_ij"] += bill_time - ingress_bill_time_intra - ingress_bill_time_inter
        total["cost_ij"] += cost - ingress_call_cost_intra - ingress_call_cost_inter

        try:
            table.append([ingress_code, inter_ingress_calls, float_form2 % (ingress_bill_time_intra),
                          float_form2 % (ingress_call_cost_intra),
                          inter_ingress_calls, float_form2 % (ingress_bill_time_inter),
                          float_form2 % (ingress_call_cost_inter),
                          calls - inter_ingress_calls - ingress_call_cost_inter,
                          float_form2 % (bill_time - ingress_bill_time_inter - ingress_bill_time_intra),
                          float_form2 % (cost - ingress_call_cost_intra - ingress_call_cost_inter),
                          calls, float_form2 % (bill_time), float_form2 % (cost)])
        except Exception as e:
            print("Error in Make_show_trafic_code_name_jur table generation", e)

    if len(table) > 2:
        try:
            table.append(["Total", total["intra_calls"], float_form2 % (total["bill_time_intra"]),
                          float_form2 % (total["cost_intra"]),
                          total["inter_calls"], float_form2 % (total["bill_time_inter"]),
                          float_form2 % (total["cost_inter"]),
                          total["ij_calls"], float_form2 % (total["bill_time_ij"]), float_form2 % (total["cost_ij"]),
                          float_form2 % (total["calls"]), float_form2 % (total["bill_time"]),
                          float_form2 % (total["cost"])])
        except:
            pass
    end = timer()
    print("Make_show_trafic_code_name_jur table len", len(table))
    # print ("execution time of ingress_ code name in milliseconds: %s" % ((end-start) * 1000  ) )
    logger.debug("execution time  in milliseconds: %s" % ((end - start) * 1000))
    return table


# Code Name/country : Total Calls : Total minutes : Total Cost/Amount
def Make_show_trafic_code_name(param_dict, client, float_form):
    if param_dict.get('jurisdict', False):  # invoice_jurisdictional_detail
        jurisdict = Make_show_trafic_code_name_jur(param_dict, client, float_form)
        return jurisdict
    start = timer()
    logger.debug("Entering Show Traffic Code Name Table")
    table = [["Code Name", "Calls Total", "Duration", "Amount"]]
    start_date = param_dict.get('start_date')
    end_date = param_dict.get('end_date')
    client_id = param_dict.get('client_id')

    if start_date is None or end_date is None or client_id is None:
        print("Error! Must suply client_id,start_date and end_date!")
        return {}
    try:
        start_date_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S").date()
        end_date_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S").date()
        start_datetime_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S")
        end_datetime_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S")
    except Exception as e:
        print(str(e))
        logger.error(str(e))
        return table
    delta = end_date_obj - start_date_obj

    # ingress_code_name | bill_time |   cost    | calls
    # -------------------+-----------+-----------+-------
    # AA                |       338 | 11.267100 |     9
    #                   |         0 |  0.000000 |     0

    float_form3 = "%0.3f"
    float_form4 = "%0.4f"
    float_form2 = "%0.2f"
    total = def_dict(int)
    try:
        params = {
            'field': """not_zero_calls,inter_ingress_calls,ingress_bill_time_inter,intra_ingress_calls,ingress_call_cost_intra,ingress_bill_time_intra,ij_ingress_calls,ingress_bill_time_ij,ingress_call_cost_ij,ingress_call_cost_inter,ingress_calls,ingress_call_cost""",
            'ingress_id': ",".join(str(e) for e in param_dict['ingress_ids']), 'group': "ingress_id,code_name"}
    except Exception as e:
        print("Exception in generating params for peterAPI %s" % e)
        traceback.print_tb(e.__traceback__)

    result = send_api_request(start_datetime_obj, end_datetime_obj, params)

    result = result.get('data', {})

    for row in result:
        if not bool(row):  # row is empty dict
            continue
        try:
            ingress_code = row['code_name'].replace("NULL", "")
        except:
            continue
        calls = row['not_zero_calls']
        bill_time = row['ingress_bill_time_ij'] / 60
        cost = row['ingress_call_cost_ij']
        total["calls"] += calls
        total["bill_time"] += bill_time
        total["cost"] += cost
        table.append([ingress_code, calls, float_form2 % (bill_time), float_form2 % (cost)])
    if len(table) > 1:
        table.append(["Total", float_form2 % (total["calls"]), float_form2 % (total["bill_time"]),
                      float_form2 % (total["cost"])])
    end = timer()
    # print ("table",table)
    logger.debug("execution time  in milliseconds: %s" % ((end - start) * 1000))
    return table


def Make_show_trafic_country_Jur(param_dict, client, float_form):
    #
    start = timer()
    logger.debug("Show Traffic Country_Jur")
    LOGGER_LIST.append("Show Traffic Country_Jur")
    print("Show Traffic Country_Jur")
    table = [["Country", 'Interstate', '', '', 'Intrastate', '', '', 'IJ', '', '', 'Total'],
             ['', "Calls", "Duration", "Amount", "Calls", "Duration",
              "Amount", "Calls", "Duration", "Amount", "Calls", "Duration", "Amount"]]
    start_date = param_dict.get('start_date')
    end_date = param_dict.get('end_date')
    client_id = param_dict.get('client_id')

    if start_date is None or end_date is None or client_id is None:
        print("Error! Must suply client_id,start_date and end_date!")
        return {}
    try:
        start_date_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S").date()
        end_date_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S").date()
        start_datetime_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S")
        end_datetime_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S")
    except Exception as e:
        print(str(e))
        logger.error(str(e))
        logger.debug("error in getting Show traffic country %s" % (str(e)))
        return table

    float_form3 = "%0.3f"
    float_form4 = "%0.4f"
    float_form2 = "%0.2f"
    total = def_dict(int)
    try:
        params = {
            'field': """not_zero_calls,inter_ingress_calls,ingress_bill_time_inter,intra_ingress_calls,ingress_call_cost_intra,ingress_bill_time_intra,ij_ingress_calls,ingress_bill_time_ij,ingress_call_cost_ij,ingress_call_cost_inter,ingress_calls,ingress_call_cost""",
            'ingress_id': ",".join(str(e) for e in param_dict['ingress_ids']), 'group': "ingress_id,country"}
    except Exception as e:
        print("Exception in generating params for peterAPI %s" % e)
        traceback.print_tb(e.__traceback__)

    result = send_api_request(start_datetime_obj, end_datetime_obj, params)


    result = result.get('data', {})

    for row in result:
        if not bool(row):  # row is empty dict
            continue
        try:
            country = row['country'].replace("NULL", "")
            if len(country) > 9:
                country = country[:7] + "..."
        except:
            continue
        calls = row['not_zero_calls']
        bill_time = row['ingress_bill_time_ij'] / 60
        cost = row['ingress_call_cost_ij']

        ingress_call_cost_intra = row['ingress_call_cost_intra']
        ingress_call_cost_inter = row['ingress_call_cost_inter']

        ingress_bill_time_intra = row['ingress_bill_time_intra'] / 60
        ingress_bill_time_inter = row['ingress_bill_time_inter'] / 60

        inter_ingress_calls = row['inter_ingress_calls']
        intra_ingress_calls = row['intra_ingress_calls']
        ij_ingress_calls = row['ij_ingress_calls']

        total["calls"] += calls
        total["bill_time"] += bill_time
        total["cost"] += cost

        total["intra_calls"] += intra_ingress_calls
        total["bill_time_intra"] += ingress_bill_time_intra
        total["cost_intra"] += ingress_call_cost_intra

        total["inter_calls"] += ingress_call_cost_inter
        total["bill_time_inter"] += ingress_bill_time_inter
        total["cost_inter"] += ingress_call_cost_inter

        total["ij_calls"] += calls
        total["bill_time_ij"] += bill_time - ingress_bill_time_intra - ingress_bill_time_inter
        total["cost_ij"] += cost - ingress_call_cost_intra - ingress_call_cost_inter

        try:
            table.append([country, inter_ingress_calls, float_form2 % (ingress_bill_time_intra),
                          float_form2 % (ingress_call_cost_intra),
                          inter_ingress_calls, float_form2 % (ingress_bill_time_inter),
                          float_form2 % (ingress_call_cost_inter),
                          calls - inter_ingress_calls - ingress_call_cost_inter,
                          float_form2 % (bill_time - ingress_bill_time_inter - ingress_bill_time_intra),
                          float_form2 % (cost - ingress_call_cost_intra - ingress_call_cost_inter),
                          calls, float_form2 % (bill_time), float_form2 % (cost)])
        except Exception as e:
            print("Error in Make_show_trafic_code_name_jur table generation", e)

    if len(table) > 2:
        try:
            table.append(["Total", total["intra_calls"], float_form2 % (total["bill_time_intra"]),
                          float_form2 % (total["cost_intra"]),
                          total["inter_calls"], float_form2 % (total["bill_time_inter"]),
                          float_form2 % (total["cost_inter"]),
                          total["ij_calls"], float_form2 % (total["bill_time_ij"]), float_form2 % (total["cost_ij"]),
                          float_form2 % (total["calls"]), float_form2 % (total["bill_time"]),
                          float_form2 % (total["cost"])])
        except:
            pass
    end = timer()
    print("Make_show_trafic_code_name_jur table len", len(table))
    # print ("execution time of ingress_ code name in milliseconds: %s" % ((end-start) * 1000  ) )
    logger.debug("execution time  in milliseconds: %s" % ((end - start) * 1000))
    return table


def Make_show_trafic_country(param_dict, client, float_form):
    #
    if param_dict.get('jurisdict', False):  # invoice_jurisdictional_detail
        jurisdict = Make_show_trafic_country_Jur(param_dict, client, float_form)
        return jurisdict

    start = timer()
    logger.debug("Show Traffic Country")
    LOGGER_LIST.append("Show Traffic Country")
    table = [["Country", "Calls Total", "Duration", "Amount"]]
    start_date = param_dict.get('start_date')
    end_date = param_dict.get('end_date')
    client_id = param_dict.get('client_id')

    if start_date is None or end_date is None or client_id is None:
        print("Error! Must suply client_id,start_date and end_date!")
        return {}
    try:
        start_date_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S").date()
        end_date_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S").date()
        start_datetime_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S")
        end_datetime_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S")
    except Exception as e:
        print(str(e))
        logger.error(str(e))
        logger.debug("error in getting Show traffic country %s" % (str(e)))
        return table

    # ingress_country | bill_time |   cost    | calls
    # -----------------+-----------+-----------+-------
    # BB              |       338 | 11.267100 |     9
    #                 |         0 |  0.000000 |     0

    float_form3 = "%0.3f"
    float_form4 = "%0.4f"
    float_form2 = "%0.2f"
    total = def_dict(int)
    try:
        params = {
            'field': """not_zero_calls,inter_ingress_calls,ingress_bill_time_inter,intra_ingress_calls,ingress_call_cost_intra,ingress_bill_time_intra,ij_ingress_calls,ingress_bill_time_ij,ingress_call_cost_ij,ingress_call_cost_inter,ingress_calls,ingress_call_cost""",
            'ingress_id': ",".join(str(e) for e in param_dict['ingress_ids']), 'group': "ingress_id,country"}
    except Exception as e:
        print("Exception in generating params for peterAPI %s" % e)
        traceback.print_tb(e.__traceback__)

    result = send_api_request(start_datetime_obj, end_datetime_obj, params)


    result = result.get('data', {})

    for row in result:
        if not bool(row):  # row is empty dict
            continue
        try:
            ingress_code = row['country'].replace("NULL", "")
        except:
            continue
        calls = row['not_zero_calls']
        bill_time = row['ingress_bill_time_ij'] / 60
        cost = row['ingress_call_cost_ij']
        total["calls"] += calls
        total["bill_time"] += bill_time
        total["cost"] += cost
        table.append([ingress_code, int(calls), float_form2 % (bill_time), float_form2 % (cost)])
    if len(table) > 1:
        table.append(["Total", int(total["calls"]), float_form2 % (total["bill_time"]), float_form2 % (total["cost"])])
    end = timer()
    # print ("table",table)
    logger.debug("execution time  in milliseconds: %s" % ((end - start) * 1000))
    return table


def __Make_show_code_summery(param_dict, client, float_form):
    '''Likewise, "Top ten codes" will show the cost of the top ten destination (codes)'''
    #
    start = timer()
    logger.debug("Entering TOP 10 code summery")
    LOGGER_LIST.append("Entering TOP 10 code summery")
    print("Entering TOP 10 code summery")
    table = [["Code", "Calls", "Duration", "Amount"]]
    start_date = param_dict.get('start_date')
    end_date = param_dict.get('end_date')
    client_id = param_dict.get('client_id')
    try:
        sql = """select resource_id from resource where ingress is true and client_id = %s""" % client_id
        pg_cur.execute(sql)
        result = pg_cur.fetchall()
    except Exception as e:
        logger.error(" error in getting ingress_id in  Make_show_code_summery():  %s" % (str(e)))
        print("error in getting ingress_id in  Make_show_code_summery(): %s" % (str(e)))
        return table
    if start_date == None or end_date == None or client_id == None:
        print("Error! Must suply client_id,start_date and end_date!")
        return {}
    try:
        start_datetime_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S")
        end_datetime_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S")
    except Exception as e:
        print("error in Make_show_code_summery() converting dates  %s" % (str(e)))
        logger.error("error in Make_show_code_summery() converting dates  %s" % (str(e)))
        return table
    try:
        url = config['cdr2']["url"]
    except:
        url = "http://192.99.10.113:8889"
    result_list = []
    try:
        for row in result:
            res = get_cdr_records.ShowCodeSummery(start_datetime_obj, end_datetime_obj, row.get('resource_id', None),
                                                  url)
            result_list.extend(res)
    except:
        logger.error("CDR api not available")
        print("CDR api not available")
        return None

    total = def_dict(int)

    for row in result_list:

        if row.get('orig_code', "NULL") != "NULL":
            total["calls"] += row['calls']
            total["bill_time"] += row.get('ingress_client_bill_time', 0) / 60
            total["cost"] += row.get('ingress_client_cost', 0)
            table.append([row.get('orig_code', "N/A"), row.get('calls', "N/A"),
                          float_form % (row.get('ingress_client_bill_time', -1) / 60),
                          float_form % (row.get('ingress_client_cost', "-1"))])
    table.append(["Total", total["calls"], float_form % (total["bill_time"]), float_form % (total["cost"])])
    end = timer()
    print("Make_show_code_summery TABLE:", table)
    logger.debug("execution time  in milliseconds: %s" % ((end - start) * 1000))
    return table

def Make_show_code_summery(param_dict, client, float_form):
    # Usage Detail
    start = timer()
    logger.debug("Entering TOP 10 code summery")
    LOGGER_LIST.append("Entering TOP 10 code summery")
    print("Entering TOP 10 code summery")
    table = [["Code", "Calls", "Duration", "Amount"]]
    start_date = param_dict.get('start_date')
    end_date = param_dict.get('end_date')
    client_id = param_dict.get('client_id')
    results_dict = {}
    if start_date is None or end_date is None or client_id is None:
        print("Error! Must suply client_id,start_date and end_date!")
        logger.debug("  Error! Must suply client_id,start_date and end_date!")
        return {}
    try:
        start_date_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S").date()
        end_date_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S").date()
        start_datetime_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S")
        end_datetime_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S")
    except Exception as e:
        print(str(e))
        logger.error(str(e))
        logger.debug("  Error in getting TOP 10 code summery :  %s" % (str(e)))
        return table
    delta = end_date_obj - start_date_obj
    if delta.days < 0:  # single day
        # it cab be
        return table

    # code_name | completed_calls | total_minutes |  rate   |     effective_date     | total_charges
    # -----------+-----------------+---------------+---------+------------------------+---------------
    # AA        |               9 |          5.63 | 2.00126 | 2017-09-19 00:00:00+00 |     11.267100

    float_form3 = "%0.3f"
    float_form4 = "%0.4f"
    float_form2 = "%0.2f"

    try:
        params = {'field': "ingress_calls,ingress_bill_time,ingress_call_cost",
                  'ingress_id': ",".join(str(e) for e in param_dict['ingress_ids']), 'group': "orig_code"}
    except Exception as e:
        print("Exception in generating params for peterAPI %s" % e)
        traceback.print_tb(e.__traceback__)

    result = send_api_request(start_datetime_obj, end_datetime_obj, params)

    result = result.get('data', {})
    total_calls,total_bill_time,total_cost = 0,0,0.0
    for row in result[0:10]:
        if not bool(row):  # row is empty dict
            continue

        # print("row",row,row == False,row == True)
        code_name = row.get("orig_code", "").replace("NULL", "")
        calls = row.get("ingress_calls", 0)
        bill_time = row.get("ingress_bill_time", 0)
        cost = row.get("ingress_call_cost", 0.0)
        total_calls += calls
        total_bill_time += bill_time
        total_cost += cost
        try:
            table.append(
                [code_name, calls, bill_time,cost])
        except Exception as e:
            msg = "Error in creating table for code summary %s" % e
            print(msg)
            logger.error(msg)
            traceback.print_tb(e.__traceback__)
    table.append(
        ['Total', total_calls, total_bill_time, total_cost])
    print("table",table)

    end = timer()
    logger.debug("execution time  in milliseconds: %s" % ((end - start) * 1000))
    return table


def MakeUsage(param_dict, client, float_form):
    # Usage Detail
    start = timer()
    logger.debug("Entering Make Usage Detail Table")
    LOGGER_LIST.append("Entering Make Usage Detail Table")
    table = [["Code Name", "Completed Calls", "Total Minutes", "Rate(US)", " Effective Date", "Total Charges(US)"]]

    start_date = param_dict.get('start_date')
    end_date = param_dict.get('end_date')
    client_id = param_dict.get('client_id')
    results_dict = {}
    if start_date is None or end_date is None or client_id is None:
        print("Error! Must suply client_id,start_date and end_date!")
        logger.debug("  Error! Must suply client_id,start_date and end_date!")
        return {}
    try:
        start_date_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S").date()
        end_date_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S").date()
        start_datetime_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S")
        end_datetime_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S")
    except Exception as e:
        print(str(e))
        logger.error(str(e))
        logger.debug("  Error in getting USAGE DETAIL :  %s" % (str(e)))
        return table
    delta = end_date_obj - start_date_obj
    if delta.days < 0:  # single day
        # it cab be
        return table

    # code_name | completed_calls | total_minutes |  rate   |     effective_date     | total_charges
    # -----------+-----------------+---------------+---------+------------------------+---------------
    # AA        |               9 |          5.63 | 2.00126 | 2017-09-19 00:00:00+00 |     11.267100

    float_form3 = "%0.3f"
    float_form4 = "%0.4f"
    float_form2 = "%0.2f"

    try:
        params = {'field': "not_zero_calls,ingress_bill_time_ij,ingress_call_cost_ij",
                  'ingress_id': ",".join(str(e) for e in param_dict['ingress_ids']), 'group': "ingress_id,code_name"}
    except Exception as e:
        print("Exception in generating params for peterAPI %s" % e)
        traceback.print_tb(e.__traceback__)

    result = send_api_request(start_datetime_obj, end_datetime_obj, params, "day")

    result = result.get('data', {})

    for row in result:
        if not bool(row):  # row is empty dict
            continue

        # print("row",row,row == False,row == True)
        code_name = row.get("code_name", "").replace("NULL", "")
        completed_calls = row.get("not_zero_calls", "N/A")
        total_minutes = row.get("ingress_bill_time_ij", 0) / 60
        total_charges = row.get("ingress_call_cost_ij", 0.001)
        try:
            if total_minutes:
                rate = total_charges / (total_minutes)
            else:
                rate = 0
        except Exception as e:
            msg = "Error in rate calc for usage detail %s" % e
            print(msg)
            logger.error(msg)
            continue
        # traceback.print_tb(e.__traceback__)
        try:
            effective_date = datetime.datetime.fromtimestamp(row['time']).strftime("%Y-%m-%d %H:%M:%S")
        except Exception as e:
            print(e)
            effective_date = "N/A"
        try:
            table.append(
                [code_name, completed_calls, float_form2 % (total_minutes), float_form4 % (rate), effective_date,
                 total_charges])
        except Exception as e:
            msg = "Error in creating table for usage detail %s" % e
            print(msg)
            logger.error(msg)
            traceback.print_tb(e.__traceback__)

    # print("table",table)

    end = timer()
    logger.debug("execution time  in milliseconds: %s" % ((end - start) * 1000))
    return table


def detail_by_trunk(param_dict, client, float_form):
    # Show Detail by Trunk
    # http://jira.denovolab.com/browse/CLAS-5789
    table = [['', 'Total Calls', 'Total Minutes', 'ACD', 'Amount']]
    # last change from Jira CLAS-2764
    start = timer()
    logger.debug("Entering  detail_by_trunk Table")

    start_date = param_dict.get('start_date')
    end_date = param_dict.get('end_date')
    client_id = param_dict.get('client_id')

    if start_date is None or end_date is None or client_id is None:
        print("Error! Must suply client_id,start_date and end_date!")
        return {}
    try:
        start_date_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S").date()
        end_date_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S").date()
        start_datetime_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S")
        end_datetime_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S")
    except Exception as e:
        print(str(e))
        logger.error(str(e))
        return table
    delta = end_date_obj - start_date_obj

    if delta.days < 0:
        return None

    float_form3 = "%0.3f"
    float_form3 = "%0.2f"
    total = def_dict(int)
    try:
        params = {
            'field': "not_zero_calls,not_zero_calls_6,inter_ingress_calls,ingress_bill_time_inter,intra_ingress_calls,ingress_call_cost_intra,ingress_bill_time_intra,ij_ingress_calls,ingress_bill_time_ij,ingress_call_cost_ij,ingress_call_cost_inter,ingress_calls,ingress_call_cost",
            'ingress_id': ",".join(str(e) for e in param_dict['ingress_ids']), 'group': "ingress_id"}
    except Exception as e:
        print("Exception in generating params for peterAPI %s" % e)
        traceback.print_tb(e.__traceback__)

    result = send_api_request(start_datetime_obj, end_datetime_obj, params)


    if result.get('data', {})[0]:
        result = result.get('data', {})[0]
        # {'ingress_bill_time_inter': 0.0, 'ingress_call_cost_intra': 0.0, 'ingress_calls': 14414.0, 'ingress_call_cost_inter': 0.0, 'ij_ingress_calls': 14414.0,
        # 'not_zero_calls': 1006.0, 'ingress_bill_time_ij': 12522.0, 'intra_ingress_calls': 0.0, 'ingress_call_cost': 417.402771, 'inter_ingress_calls': 0.0,
        # 'time': 1518739200, 'ingress_call_cost_ij': 417.402771, 'ingress_bill_time_intra': 0.0, 'ingress_id': 980}, {}], 'msg': None}

        try:
            inter_ACD = Decimal(result['ingress_bill_time_inter']) / 60 / result['inter_ingress_calls']
        except:
            inter_ACD = 0.00
        try:
            intra_ACD = Decimal(result['ingress_bill_time_intra']) / 60 / result['intra_ingress_calls']
        except:
            intra_ACD = 0.00
        try:
            indeter_ACD = Decimal(result['ingress_bill_time_ij']) / 60 / result['not_zero_calls']
        except:
            indeter_ACD = 0.00
        try:
            table.append(["Interstate", result['inter_ingress_calls'], result['ingress_bill_time_inter'] / 60,
                          float_form3 % (inter_ACD), result['ingress_call_cost_inter']])
            table.append(["Intrastate", result['intra_ingress_calls'], result['ingress_bill_time_intra'] / 60,
                          float_form3 % (intra_ACD), result['ingress_call_cost_intra']])
            table.append(["Indeterminate", result['not_zero_calls'], result['ingress_bill_time_ij'] / 60,
                          float_form3 % (indeter_ACD), result['ingress_call_cost_ij']])
            table.append(["Short calls (under 6 seconds)", result['not_zero_calls_6']])
        except Exception as e:
            msg = "Exception in table append detail bu trunk %s" % e
            print(msg)
            print(result.copy())
            logger.error(msg)
            traceback.print_tb(e.__traceback__)

        try:
            ingress_call_cost_inter = Decimal(result['ingress_call_cost_inter'])
        except Exception as e:
            ingress_call_cost_inter = 0.00
        try:
            ingress_call_cost_intra = Decimal(result['ingress_call_cost_intra'])
        except Exception as e:
            ingress_call_cost_intra = 0.00
        try:
            indeterminate_cost = Decimal(result['ingress_call_cost_ij'])
        except Exception as e:
            indeterminate_cost = 0.00

        total_cost = ingress_call_cost_inter + ingress_call_cost_intra + indeterminate_cost
        table.append(["Total Amount", float_form3 % (total_cost)])

    # table.append (  ["Total", float_form % (  total["bill_time"]) ,total["calls"],"",float_form % ( total["cost"] ) ])

    end = timer()
    logger.debug("execution time  in milliseconds: %s" % ((end - start) * 1000))
    return table


def showCallsDate(param_dict, client, float_form):
    #
    start = timer()
    logger.debug("Entering Show Calls by Date Table")
    LOGGER_LIST.append("Entering Show Calls by Date Table")
    table = [["Date", "Calls", "Duration", "Amount"]]
    start_date = param_dict.get('start_date')
    end_date = param_dict.get('end_date')
    client_id = param_dict.get('client_id')

    if start_date is None or end_date is None or client_id is None:
        print("Error! Must suply client_id,start_date and end_date!")
        return {}
    try:
        start_date_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S").date()
        end_date_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S").date()
        start_datetime_obj = datetime.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S")
        end_datetime_obj = datetime.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S")
    except Exception as e:
        print(str(e))
        logger.error(str(e))
        return table

    # report_time |   cost    | calls | duration
    # -------------+-----------+-------+----------
    # 2018-01-16  | 11.267100 |     9 |      338

    float_form3 = "%0.3f"
    float_form4 = "%0.4f"
    float_form2 = "%0.2f"
    total = def_dict(int)
    try:
        params = {
            'field': """not_zero_calls,inter_ingress_calls,ingress_bill_time_inter,intra_ingress_calls,ingress_call_cost_intra,ingress_bill_time_intra,ij_ingress_calls,ingress_bill_time_ij,ingress_call_cost_ij,ingress_call_cost_inter,ingress_calls,ingress_call_cost""",
            'ingress_id': ",".join(str(e) for e in param_dict['ingress_ids']), 'group': "ingress_id"}

    except Exception as e:
        print("Exception in generating params for peterAPI %s" % e)
        traceback.print_tb(e.__traceback__)

    result = send_api_request(start_datetime_obj, end_datetime_obj, params, "day")

    result = result.get('data', {})

    for row in result:
        if not bool(row):  # row is empty dict
            continue
        calls = row['not_zero_calls']
        if int(calls) == 0:
            continue
        day = effective_date = datetime.datetime.fromtimestamp(row['time']).strftime("%Y-%m-%d %H:%M:%S")
        cost = row['ingress_call_cost_ij']
        bill_time = row['ingress_bill_time_ij'] / 60
        total["calls"] += calls
        total["bill_time"] += bill_time
        total["cost"] += cost
        table.append([day, int(calls), float_form2 % (bill_time), float_form2 % (cost)])
    if len(table) > 1:
        table.append(["Total", int(total["calls"]), float_form2 % (total["bill_time"]), float_form2 % (total["cost"])])
    end = timer()
    # print ("table",table)
    logger.debug("execution time  in milliseconds: %s" % ((end - start) * 1000))
    return table


def id_generator(size=12, chars=string.ascii_uppercase + string.ascii_lowercase + string.digits):
    # do not use random numbers, Invoice name should be -  <client_id>_<date time of generation> , http://jira.denovolab.com/browse/CLAS-2510
    return datetime.datetime.now().strftime("%Y%m%d%H%M")


# return ''.join(random.choice(chars) for _ in range(size))


def makeNewInv(param_dict, autoinvoice=False):
    global log_id, logo_file
    print("PARAM DICT FOR NEW INVOICE:", str(param_dict))
    LOGGER_LIST.append("PARAM DICT FOR NEW INVOICE: %s" % str(param_dict))
    invoice_id = None
    # get ingress ids
    try:
        sql = """select array_agg(resource_id) as ingress_ids from resource where ingress is true and client_id = %s""" % \
              param_dict['client_id']
        print(sql)
        cur=pg_cur.execute(sql)
        param_dict['ingress_ids'] = cur.fetchone()['ingress_ids']
        if param_dict['ingress_ids'] is None:
            raise InvoiceException('no ingress_ids, cannot make invoice')
    except Exception as e:
        logger.error(" Error in getting switch settings:  %s" % (str(e)))
        print("Error in getting switch settings %s" % (str(e)))
        return [-1, -1]

    status, msg = check_table_names_new(param_dict)
    print(status)
    if status != 0:
        return -3, msg

    try:
        cur = pg_cur.execute(SWITCH_INVOICE_SETTINGS)
        switch_settings = dict_or_none(cur.fetchone())
        print("switch_settings", switch_settings)
    except Exception as e:
        logger.error(" Error in getting switch settings:  %s" % (str(e)))
        print("Error in getting switch settings %s" % (str(e)))
        return [-1, invoice_id]

    zone = param_dict.get('invoice_zone',None)
    # noinspection PyComparisonWithNone
    #if zone == None:
    #    zone = "+00:00"
    address = param_dict.get('address')
    # noinspection PyComparisonWithNone
    if address == None:
        address = ""
    due_date = param_dict.get('invoice_due_date')  # .replace("-","/")
    # noinspection PyComparisonWithNone
    if due_date == None:
        print("invoice_due_date must be provide")
        logger.error("invoice_due_date must be provide")
        return [-1, invoice_id]
    bill_dict, total_amount = get_bill(param_dict)
    if bill_dict == -1:
        print("Invoice will be not generated", total_amount)  # total_amount in this case is error msg
        logger.error("Invoice will be not generated %s" % total_amount)
        invoice_log_set_finish(3, 0)
        return [total_amount, -11]
    if param_dict.get('invoice_zero', True) == True and int(math.ceil(total_amount)) == 0 and False:
        print("Invoice will be not generated")
        logger.debug("Invoice will be not generated")
        invoice_log_set_finish(2, 0)
        return ["", -10]
    # print ("BILL: ",bill_dict,"total_amount ",total_amount)

    if bill_dict == {}:
        print("Problem with invoice for client. GetBill returned None")
        return [-1, invoice_id]

    ### Get client info
    query = "select * from client where client_id= %s" % (param_dict['client_id'])
    print("Query for getting client info: ", query)
    cur = pg_cur.execute(query)
    client = dict_or_none(cur.fetchone())
    address = client.get('address', "N/A")
    print("Client address: ", client.get('address', "N/A"))
    company = client.get('company', "N/A")
    print("Client company: ", client.get('company', "N/A"))
    if not zone:
        zone = client.get('invoice_zone', '+00:00')
    invoice_id = param_dict.get('invoice_number', "1111")
    start_date = param_dict.get('start_date', "No Start date")
    end_date = param_dict.get('end_date', "No End date")
    try:
        param_dict['start_date_tmstamp'] = dt.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S")
        param_dict['end_date_tmstamp'] = dt.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S")
    except:
        param_dict['start_date_tmstamp'] = dt.datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S")
        param_dict['end_date_tmstamp'] = dt.datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S")
    period = start_date + " - " + end_date
    invoice_date = param_dict.get("invoice_date", "N/A")

    if autoinvoice:
        round_to = client['decimal_place']
    else:  # manual invoice creation, must take decimal places from other place
        sql = """SELECT invoice_decimal_digits FROM system_parameter"""
        try:
            cur = pg_cur.execute(sql)
            result = dict_or_none(cur.fetchone())
            # noinspection PyComparisonWithNone
            if result != None:
                round_to = result.get('invoice_decimal_digits', client['decimal_place'])
            else:
                round_to = client['decimal_place']
        except Exception as e:
            print(" Exception in getting system parameter for Dec Place:  %s" % (str(e)))
            traceback.print_tb(e.__traceback__)
            logger.error("  Exception in getting system parameter for Dec Place:  %s" % (str(e)))
            round_to = client['decimal_place']
    total_amount = round(total_amount,round_to)
    float_form = "%0.2f"
    # Daily Usage
    if param_dict.get('dayusage', False) or param_dict.get('is_show_daily_usage', None):
        # this is daily usage!
        day_usage = MakeDayUsageHeader()
        usage_detail = MakeDailyQueryTable(param_dict, client, float_form,
                                           day_usage)  # MakeDailyQueryTable(bill_dict.get('details', []) ,day_usage)
    else:
        print("No dayusage. No is_show_daily_usage")
        usage_detail = None
    day_usage = usage_detail

    print("PARAM DICT FOR NEW INVOICE2:", str(param_dict), param_dict.get('is_invoice_account_summary', False))

    acount_sumary = get_acount_summary(param_dict, invoice_id)
    # param_dict['account_sumary'] = dict(acount_sumary)
    # if  True:   # param_dict.get('is_invoice_account_summary',False)  or autoinvoice == False :
    #	print("No acount summary")
    #	acount_sumary = None

    if param_dict.get('is_invoice_usage_detail', False):
        #
        usage_detail = MakeUsage(param_dict, client,
                                 float_form)  # MakeDailyQueryTable(bill_dict.get('details', []) ,day_usage)
    else:
        print("No usage_detail")
        usage_detail = None

    if param_dict.get('summary_of_payments', False):
        summary_of_payments = GetSummary_of_payments(param_dict, client, acount_sumary, float_form)
    else:
        print("No summary_of_payments")
        summary_of_payments = None

    # Jurisdictional Breakdown
    if param_dict.get('jurisdict', False):  # invoice_jurisdictional_detail
        jurisdict = GetJurisdict(param_dict, client, acount_sumary, float_form)
    else:
        print("No Jurisdictional  Breakdown")
        jurisdict = None
    param_dict['invoice_jurisdictional_detail'] = param_dict.get('jurisdict', False)

    if param_dict.get('ingress_prefix', False):
        ingress_prefix = GetIngress_prefix(param_dict, client, float_form)
    else:
        print("No ingress_prefix")
        ingress_prefix = None

    if param_dict.get('invoice_show_details', False):  # Yes invoice_show_details is for show code_name totals!
        ShowDetailByCodeName = MakeShowDetailByCodeName(param_dict, client, float_form)
    else:
        print("No MakeShowDetailByCodeName")
        ShowDetailByCodeName = None

    if param_dict.get('show_trafic_code_name', False):
        show_trafic_code_name = Make_show_trafic_code_name(param_dict, client, float_form)
    else:
        print("No show_trafic_code_name")
        show_trafic_code_name = None

    if param_dict.get('show_trafic_country', False):
        show_trafic_country = Make_show_trafic_country(param_dict, client, float_form)
    else:
        print("No show_trafic_country")
        show_trafic_country = None

    if param_dict.get('show_code_summery', False):
        show_code_summery = None  # not use in the moment
        show_code_summery = Make_show_code_summery(param_dict,client,float_form)
        print("Show_show_code_summery_table:" ,show_code_summery)
    else:
        print("Show_show_code_summery_table:")
        show_code_summery = None

    if param_dict.get('detail_by_trunk', False):
        # pass  #this is not correct and not used
        detail_by_trunk_table = detail_by_trunk(param_dict, client, float_form)
    # detail_by_trunk_table = None
    else:
        print("No detail_by_trunk")
        detail_by_trunk_table = None

    if param_dict.get('show_calls_date', False):
        show_calls_date = showCallsDate(param_dict, client, float_form)
    else:
        print("No show_calls_date")
        show_calls_date = None
    # print ("minava1")
    if param_dict.get('include_origination_billing', False):
        include_origination_billing = IncludeOriginationBilling(param_dict, client, float_form)
    else:
        print("No include_origination_billing")
        include_origination_billing = None

    basic_bill = bill_dict['basic']
    # noinspection PyComparisonWithNone
    if basic_bill == None:
        basic_bill = dict()
    minutes = float_form % (Decimal(basic_bill.get('bill_time', 0) / 60))
    cost = float_form % (basic_bill.get('call_cost', 0))
    # print ("minava3")
    summary_of_charges = SumaryOfCharges(basic_bill, param_dict, client, basic_bill.get('call_cost', 0), minutes,
                                         float_form)
    # print ("minava4")
    print("summary_of_charges :", summary_of_charges)
    acount_sumary = MakeAccountSumary(acount_sumary, float_form, client, param_dict, basic_bill.get('call_cost', 0))
    print("show_code_summery :", show_code_summery)
    client_info = [client['company'], address, invoice_id, invoice_date, due_date, period, zone]
    invoice_name = str(invoice_id) + id_generator()  # +"_"
    print("ShowDetailByCodeName  ", ShowDetailByCodeName)
    try:
        logo_file = download_logo()
    except Exception as e:
        logger.error(" Error in Downloading logo: %s" % (str(e)))
        print("error in Downloading logo %s" % (str(e)))
        # DownloadLogoNoResize()
        # set the blank logo instead
        LOGGER_LIST.append(" Error in Downloading logo: %s" % (str(e)))
        logo_file = settings.FILES['upload_to'] + "/blank_logo.png"
        return [-1,'Cannot find invoice logo! Set invoices_logo_id in configuration']
    # getting invoice path
    try:
        # pdf_path = config['other']["pdf_path"]
        pdf_path = settings.FILES['invoices']
        if os.path.isdir(pdf_path):
            # randomfile = ''.join(random.choice(string.ascii_uppercase + string.digits) for _ in range(7))
            # f = open(randomfile,'w')
            # f.close()
            pass
        else:
            os.makedirs(pdf_path)
    except Exception as e:
        print("pdf_path exception %s" % e)
        logger.debug("pdf_path exception %s" % e)
        pdf_path = "app/invoice"
    # it is not used now
    breakdown_by_rate_table = None

    if not param_dict.get('show_account_summary', False):
        print("Do not display Account summary")
        acount_sumary = None
        print(param_dict.get('show_account_summary', False))
    else:
        print("display Account summary")
        print(param_dict.get('show_account_summary', False))

    try:
        if param_dict.get('jurisdict', False):
            doc = TermInvoiceRender("%s/%s.pdf" % (pdf_path, invoice_name), "Denovolab", client_info,
                                    summary_of_charges,
                                    acount_sumary, summary_of_payments, usage_detail, jurisdict, day_usage,
                                    ingress_prefix,
                                    show_trafic_code_name, show_trafic_country, show_code_summery,
                                    detail_by_trunk_table,
                                    show_calls_date, include_origination_billing, logo_file, switch_settings,
                                    ShowDetailByCodeName, breakdown_by_rate_table, True)
        else:
            doc = TermInvoiceRender("%s/%s.pdf" % (pdf_path, invoice_name), "Denovolab", client_info,
                                    summary_of_charges,
                                    acount_sumary, summary_of_payments, usage_detail, jurisdict, day_usage,
                                    ingress_prefix,
                                    show_trafic_code_name, show_trafic_country, show_code_summery,
                                    detail_by_trunk_table,
                                    show_calls_date, include_origination_billing, logo_file, switch_settings,
                                    ShowDetailByCodeName, breakdown_by_rate_table)
        doc.createDocument()
        doc.savePDF()
    except Exception as e:
        print(" Exception in createDocument:  %s" % (str(e)))
        traceback.print_tb(e.__traceback__)
        logger.error(" Exception in createDocument:  %s" % (str(e)))
        return [-1, invoice_id]
    invoice_insert(start_date, end_date, invoice_date, client, param_dict, invoice_id, invoice_name, total_amount, pdf_path,
                   autoinvoice)
    invoice_log_set_finish(2, 1)
    return ["%s.pdf" % (invoice_name), invoice_id]


def check_invoice_days(param_dict):
    """check if the period of this invoice is overlapping with old invoices"""
    #
    start = timer()
    logger.debug("Entering new invoice for overlapping with older invoices")
    client_id = param_dict['client_id']
    invoice_start = param_dict['start_date']
    invoice_end = param_dict['end_date']

    try:
        cur = pg_cur.execute(SWITCH_INVOICE_SETTINGS)
        result = dict_or_none(cur.fetchone())['overlap_invoice_protection']
        print('overlap_invoice_protection', result)
        if not result:
            return [0, 0]

    except Exception as e:
        logger.error(" Error in Invoice overlapping   %s" % (str(e)))
        print("error in Invoice overlapping  %s" % (str(e)))
        return [0, 0]

    sql = """select * from invoice where client_id = %s and invoice_end >'%s' and invoice_start <'%s' and state > -1 limit 1 ;  """ % (
        client_id, invoice_start, invoice_end)

    print("Invoice overlapping QUERY:", sql)
    logger.debug("Invoice overlapping QUERY: %s" % sql)
    try:
        cur = pg_cur.execute(sql)
        result = dict_or_none(cur.fetchone())
        print(result)
    except Exception as e:
        logger.error(" Error in Invoice overlapping   %s" % (str(e)))
        print("error in Invoice overlapping  %s" % (str(e)))
        logger.debug("error in Invoice overlapping  %s" % (str(e)))
        return [-1, str(e)]
    if result is not None:
        print("returning -1")
        logger.debug("Overlapping invoice number: %s       Start: %s   End: %s " % (
            result.get("invoice_number", "N/A"), result.get("invoice_start", "N/A")
            , result.get("invoice_end", "N/A")))
        return [-1, "invoice number: %s       Start: %s   End: %s " % (
            result.get("invoice_number", "N/A"), result.get("invoice_start", "N/A"),
            result.get("invoice_end", "N/A"))]  # overlapping !
    else:
        print("returning 0", result)
        return [0, 0]


def MakeInvoiceAuto(data, pg_cur_a=""):
    global log_id, pg_cur, LOGGER_LIST
    if pg_cur_a != "":
        pg_cur = pg_cur_a
    # data = client
    log_id = invoice_log_insert()
    # ,logo_file
    start = timer()
    LOGGER_LIST = []
    logger.debug("Starting new auto invoice")
    param_dict = GetParamsAuto(data)
    auto = True
    if param_dict.get('create_type') == 1:
        auto = False
        print("This invoice is Regen of Manual Invoice")
    else:
        print("This invoice will be Auto Invoice")
    logger.debug("Options set: %s " % str(param_dict))
    try:
        filename, invoice_number = makeNewInv(param_dict, True)
    except Exception as e:
        print(" Exception in making new invoice:  %s" % (str(e)))
        logger.error(" Exception in making new invoice:  %s" % (str(e)))
        invoice_log_set_error(str(e))
        return [-1, -1, -1]
    if filename == -1 or invoice_number == -1:
        logger.error("Creating new Invoice Failed. Aborting process")
        return [-1, -1, invoice_number]

    # this was used for early debug

    if settings.LOG_LEVEL in ['debug', 'info', 'warning']:
        if filename == -1:
            filename = "last_error"
        try:
            with open(settings.FILES['invoice_logs'] + '/' + str(filename) + '.txt', mode='wt',
                      encoding='utf-8') as myfile:
                myfile.write('\n'.join(LOGGER_LIST))
        except Exception as e:
            print(" Exception in saving log file:  %s" % (str(e)))
            logger.error(" Exception in saving log file %s:" % (str(e)))
    # ErrorInLogInvoice( str(e) )
    # return [-1,-1,-1]

    for debug_elem in LOGGER_LIST:
        logger.debug(debug_elem)

    return [0, filename, invoice_number]


def get_smtp_info(cursor):
    sql = """SELECT smtphost as host,smtpport as port,emailusername as username,emailpassword as password,loginemail as is_auth,fromemail as from_email, smtp_secure as smtp_secure,noc_email as noc_email ,switch_alias FROM system_parameter LIMIT 1"""
    cursor.execute(sql)
    smtp_setting = cursor.fetchone()
    return smtp_setting


def GetEmailTemplate(cursor):
    sql = """select invoice_from ,invoice_to ,invoice_cc ,invoice_subject ,invoice_content from mail_tmplate limit 1 ;"""
    try:
        cursor.execute(sql)
        email_template = cursor.fetchone()
    except Exception as e:
        logger.error(" Exception in getting EmailTemplate:  %s" % (str(e)))
        print(" Exception in getting EmailTemplate:  %s" % (str(e)))
        return -1
    return email_template


def send_mail(send_from, invoice_cc, send_to, subject, text, files, server, port, username, password, smtp_info,
              isTls=False):
    msg = MIMEMultipart()
    send_to = send_to.replace(",", ";")
    invoice_cc = invoice_cc.replace(",", ";")
    # send_to = "piyali@intlcx.com;anne.denovolab@gmail.com;krasytod@gmail.com"
    msg['From'] = send_from
    msg['To'] = send_to  # COMMASPACE.join(send_to)
    # msg['cc'] = invoice_cc
    msg['Date'] = formatdate(localtime=True)
    msg['Subject'] = subject
    msg.attach(MIMEText(text, 'html'))
    print("send to", send_to, "invoice cc", invoice_cc)
    for f in files:
        print("file attachments:", f)
        # f = f
        part = MIMEBase('application', "octet-stream")
        part.set_payload(open(f, "rb").read())
        encoders.encode_base64(part)
        part.add_header('Content-Disposition', 'attachment; filename="{0}"'.format(os.path.basename(f)))
        msg.attach(part)
    try:
        send_to = send_to.split(";") + invoice_cc.split(";")
    except Exception as e:
        print("Exception send_to %s" % e)
        send_to = send_to.split(";")

    print("send_to", send_to, smtp_info['smtp_secure'], isTls, server, port, "user:", smtp_info['username'], "pass:",
          smtp_info['password'])

    ret_msg = ""
    if smtp_info['smtp_secure'] == 2:
        smtp = smtplib.SMTP_SSL(server, port)
    # smtp = smtplib.SMTP(server, port)
    else:
        smtp = smtplib.SMTP(server, port)
    try:
        smtp.set_debuglevel(True)
        if isTls: smtp.starttls()
        smtp.ehlo()
        smtp.login(smtp_info['username'], smtp_info['password'])
        smtp.sendmail(smtp_info['from_email'], send_to, msg.as_string())

    except smtplib.SMTPRecipientsRefused:
        logger.error('All recipients were refused.')
        ret_msg = 'All recipients were refused.'
    except smtplib.SMTPHeloError:
        logger.error('The server didn’t reply properly to the HELO greeting.')
        ret_msg = 'The server didn’t reply properly to the HELO greeting.'
    except smtplib.SMTPSenderRefused:
        logger.error('The server didn’t accept the %s.' % smtp_info['from_email'])
        ret_msg = 'The server didn’t accept the %s.' % smtp_info['from_email']
    except smtplib.SMTPDataError:
        logger.error('The server replied with an unexpected error code (other than a refusal of a recipient).')
        ret_msg = 'The server replied with an unexpected error code (other than a refusal of a recipient).'
    else:
        logger.debug('OK')
        ret_msg = 'OK'
    finally:
        try:
            smtp.quit()
        except:
            pass
        return ret_msg


def cdr_fields_get(pg_cur):
    sql = '''SELECT send_cdr_fields as fields  FROM system_parameter LIMIT 1;'''  # gets cdr link fields
    print("Getting send_cdr_fields from System parameter: %s" % sql)
    try:
        cur = pg_cur.execute(sql)
        fields = dict_or_none(cur.fetchone())
    except Exception as e:
        print(" Exception in getting send_cdr_fields from Sysytem parameter:  %s" % (str(e)))
        logger.error("Exception in getting send_cdr_fields from Sysytem parameter:  %s" % (str(e)))
        return []
    print("Returned result from query for getting send cdr fields:", fields)
    logger.debug("Returned result from query for getting send cdr fields: %s" % str(fields))
    # change comma delimiter to "&nbsp;"
    # fields =fields['fields'].replace( ',',',&nbsp;' )

    return fields['fields']


def cdr_link_1_get(client, pg_cur, data, fields):
    url = config['cdr']["url"]
    get_url = config['cdr']["get_cdr"]
    switch = config['cdr']["switch"]
    start = str(data['start_date'])
    end = str(data['end_date'])
    headers = {'Content-Type': 'application/json', }
    # end = "2017-01-02 23:59:59"
    jsn_request = {"switch_ip": switch, "start": start, "end": end,
                   "search_filter": "ingress_client_id=%s" % client['client_id'],
                   "result_filter": "%s" % fields}  # % 258
    print("json_request", jsn_request)
    r = requests.post(url, json=jsn_request)
    cdr_links = []

    if int(r.status_code) == 200:
        data = r.json()

        counter = len(data['query_key'])
        counter_end = counter * 20
        print("Getting CDR Info with length", counter)
        time.sleep(counter)
        for key in data['query_key']:
            payload = {"query_key": key, "switch_ip": switch}
            print("payload: ", payload)
            r = requests.post(get_url, json=payload, headers=headers)
            # print (r.url)
            print(counter_end)
            if counter_end == 0:
                print("too long time API do not respond")
                logger.debug("too long time API do not respond")
                return cdr_links
            try:
                result = r.json()['query'][0]
                # noinspection PyComparisonWithNone
                if result['status'] != None:
                    counter = counter - 1
                    print(counter)
                    # noinspection PyComparisonWithNone
                    if result['url'] != None:
                        cdr_links.append(result)
                else:
                    print("No result for: ", result['status'], result['url'])
                    data['query_key'].append(key)
                    time.sleep(1)
                counter_end -= 1
            except:
                counter_end -= 1

    return cdr_links


def client_get(params, pg_cur1=None):
    # noinspection PyComparisonWithNone
    if pg_cur1 != None:
        pg_cur = pg_cur1
    sql = """ select * from client where client_id =  %s """ % params['client_id']
    try:
        cur = pg_cur.execute(sql)
        client = dict_or_none(cur.fetchone())
    except Exception as e:
        # print ("SQL for updating cdr path in DB:  %s" % (str(e) ) )
        logger.error("Exception in  Get Client Details  %s" % (str(e)))
        traceback.print_tb(e.__traceback__)
        return -1
    return client


def syncSubProcessEmailCdr(params, data):
    """sync handlder for email invoice and cdr download link generation """
    try:
        pg_cur = new_cursor()
        data = dict(data)
        send_to = data['email'][0]
        smtp_info = get_smtp_info(pg_cur)
        EmailTemplate = GetEmailTemplate(pg_cur)
        client = client_get(params, pg_cur)

        # Get config.ini
        config = configparser.ConfigParser()
        config.read('./config.ini')

        print("smtp_info", smtp_info, "EmailTemplate", EmailTemplate, "client", client)
        subject = '''Hello %s. This is resend of your invoice'''
        data = {'start_date': str(params['invoice_start']).replace("+00:00", ""),
                'end_date': str(params['invoice_end']).replace("+00:00", "")}
        print("'pdf_path'", params['pdf_path'])
        try:
            cdr_link = cdr_link_get(client, pg_cur, params['invoice_number'], data)
        except Exception as e:
            print("Error inside get cdr link ", e)
        try:
            result = email_invoice(
                config['other']['pdf_path'] + "/" + params['pdf_path'][params['pdf_path'].rfind('/') + 1:], client,
                data, smtp_info, EmailTemplate, subject, send_to, True, params['invoice_number'], pg_cur)
        except Exception as e:
            print("Error inside email invoice ", e)

    except Exception as e:
        print("Error inside created subproccess ", e)


def reSendEmail(params, data, pg_cur=None):
    print("reSendEmail")
    try:
        # p = multiprocessing.Process(target=syncSubProcessEmailCdr, args=(params,data)
        syncSubProcessEmailCdr(params, data)
    # p.daemon = False
    # p.start()
    # jobs.append(p)

    except Exception as e:
        print("Error in creating subproccess ", e)
    return "New email will be send async"


# jobs.append(p)

def send_email_log(client, send_to, mail_subject, mail_content, files, error=False, error_msg="", pg_cur1=None):
    # noinspection PyComparisonWithNone
    if pg_cur1 != None:
        pg_cur = pg_cur1
    if not error:
        sql = """insert into email_log(send_time,client_id,email_addresses,files ,type,subject,content,status ) values (CURRENT_TIMESTAMP(0),%s, %s ,%s, %s,%s, %s,0)"""
        ## email log still do not work!
        print("send_to ", send_to, "files ", files)
        print(sql)
        cur = pg_cur.execute(sql, (client['client_id'], str(send_to), files, 7, mail_subject, mail_content))
    else:
        sql = """insert into email_log(send_time,client_id,email_addresses,files ,type,subject,content,status, error) values (CURRENT_TIMESTAMP(0),%s, %s ,%s, %s,%s, %s,1,%s)"""
        ## email log still do not work!
        print("send_to ", send_to, "files ", files)
        print(sql)
        cur = pg_cur.execute(sql, (client['client_id'], str(send_to), files, 7, mail_subject, mail_content, error_msg))


def cdr_link_get(client, pg_cur, invoice_number, data):
    # pg_cur = new_cursor()

    sql = """select invoice_id from invoice where invoice_number = '%s' """ % invoice_number
    cur = pg_cur.execute(sql)
    try:
        invoice_id = dict_or_none(cur.fetchone())['invoice_id']
    except Exception as e:  # do not exists
        print(e)
        return -1

    fields = "0,7,9,10,11,12,13,31,37,41,43,45,59,60,67,68,69"
    sql = """select resource_id from resource where client_id = %s and ingress is true """ % client['client_id']
    print(sql)
    cur = pg_cur.execute(sql)
    resource_ids = cur.fetchall()
    # noinspection PyComparisonWithNone
    if resource_ids == None:
        msg = "Client do not have resource ids"
        print(msg)
        logger.error(msg)
        return [msg]

    resources_list = []
    for resource in resource_ids:
        resources_list.append(resource['resource_id'])
    resources_list_str = ','.join(str(e) for e in resources_list)
    print(type(data['start_date']), data['start_date'])
    pattern = '%Y-%m-%d %H:%M:%S %z'
    start_time = int(time.mktime(time.strptime(data['start_date'], pattern)))
    end_time = int(time.mktime(time.strptime(data['end_date'], pattern)))
    print(start_time, end_time)

    url = 'http://127.0.0.1:' + config['cdr']["port"]
    get_url = 'http://127.0.0.1:' + config['cdr']["get_port"]
    status_url = 'http://127.0.0.1:' + config['cdr']["status_port"]
    switch = config['cdr']["switch"]
    start = str(data['start_date'])
    end = str(data['end_date'])

    # print (resources_list,type(resources_list),fields )

    # curl -X POST localhost:8887 [5:27]  it will give you token
    r = requests.post(url)
    if int(r.status_code) == 200:
        token = r.json()['token']
    else:
        print(r.reason)
        return ["Error in Getting CDR Links"]
    print(token)
    # debug with static token
    # token =  "Yuza2L2rlGkdemBeYzL0SVncFafTjYNFSMpShsJT614inGMLDf"
    # time.sleep(2)
    # curl -H "Authorization: Token EbSFxvNcmOx0TG72Q3Y07HqpMlBenntzMJDHEatyyoyP45QV8w" --data "start_time=1506470400&end_time=1506556799&ingress_id=624&human_readable" 192.99.10.113:8889
    auth_token = {'Authorization': 'Token %s' % token}
    # print (auth_token)1506470400 #1505692800 1506297599  "fields":fields
    payload = {"start_time": start_time, "end_time": end_time, "ingress_id": resources_list_str, "field": fields,
               "human_readable": 1}  # {"data": ,"human_readable":"1"
    r = requests.post(get_url, headers=auth_token, data=payload)  # ,data = payload
    # print ( r.text )  #  r.json()
    time.sleep(.2)
    if r.json()["msg"] == "Async request successfully created":
        request_id = r.json()["request_id"]
        print(r.text)
    else:
        print(r.text)
        return ["Error in Getting CDR LInks %s" % r.text]
    print('  curl -H "Authorization: Token %s" 127.0.0.1:8889/%s   ' % (token, request_id))
    # print (URL_2+"/"+request_id)
    save_counter = 0
    cdr_link = None
    while True:

        r = requests.get(status_url + "/" + request_id, headers=auth_token)
        if r.json()["code"] != 200:
            print("ERROR!")
            print(r.text)
            break
        if r.json()["status"] == "Complete":
            print("FINSIHED")
            print(r.text)
            cdr_link = switch + ":" + config['cdr']["status_port"] + r.json()['download_link']

            break
        print(r.text)
        save_counter += 1
        if save_counter == 1000:  # save exit
            break
        time.sleep(1)

    # noinspection PyComparisonWithNone
    if cdr_link != None:
        sql = """UPDATE invoice set cdr_link = '%s', cdr_token = '%s' where invoice_number = '%s' """ % (
            cdr_link, token, invoice_number)
        print(sql)
        cur = pg_cur.execute(sql)
    else:
        print("cdr link is None")

    return 0


def email_invoice(filename, client, data, smtp_info, EmailTemplate, subject="New Invoice for %s", send_to="",
                  resend=False, invoice_number=None, pg_cur1=None):
    """Sends email with invoice or link to invoice with given filename"""
    global CDR_UI
    # noinspection PyComparisonWithNone
    if pg_cur1 != None:
        pg_cur = pg_cur1
    ##CDR link
    FTP_HOST = config["other"].get('ftp', "").replace("http://", "")
    print(smtp_info)
    logger.debug(smtp_info)
    mail_subject = str(EmailTemplate.get('invoice_subject',
                                         "N/A"))  # subject % ( client.get("client_name",client.get("name","N/A") ) )
    server = smtp_info['host']
    port = smtp_info['port']
    username = smtp_info['username']
    password = smtp_info['password']
    if EmailTemplate.get('invoice_from', "default") == "default":
        send_from = smtp_info['from_email']
    else:
        send_from = EmailTemplate.get('invoice_from', 1)
        sql = """select * from mail_sender where id = %s""" % send_from
        cur = pg_cur.execute(sql)
        send_from = dict_or_none(cur.fetchone())
        try:
            send_from = send_from['name']
        except:
            send_from = "N/A"

    invoice_cc = EmailTemplate.get('invoice_cc', "")
    if not resend:
        send_to = client['billing_email']  # .split(";")
    if len(send_to) == 0:
        # print ('client %s  email is not configured' % client['name'])
        logger.error('client %s  email is not configured' % client['name'])
        return -1
    if smtp_info['smtp_secure'] == 1:
        isTls = True
    else:
        isTls = False
    # email attachment or as links
    sql = """SELECT invoice_send_mode FROM system_parameter"""
    # noinspection PyComparisonWithNone
    if invoice_number == None:
        invoice_number = filename[:-16]  # 1120201705220835.pdf
    print("invoice_number", invoice_number)
    try:
        cur = pg_cur.execute(sql)
        result = dict_or_none(cur.fetchone())
        # noinspection PyComparisonWithNone
        if result != None:
            send_attachment = result.get('invoice_send_mode', 1)
        else:
            send_attachment = 1
    except Exception as e:
        print(" Exception in getting system parameter ")
        traceback.print_tb(e.__traceback__)
        logger.error("  Exception in getting system parameter for Send attachment:  %s" % (str(e)))
        send_attachment = 1
    print("send_attachment:", send_attachment)
    if send_attachment == 1:
        # print ("select invoice_id ,total_amount from invoice where invoice_number = '%s'"%invoice_number)
        try:
            sql = "select invoice_id ,total_amount from invoice where invoice_number = '%s'" % invoice_number
            cur = pg_cur.execute(sql)
            result = dict_or_none(cur.fetchone())
            invoice_id = result['invoice_id']
            total_amount = result['total_amount']
            files = []
            base64_encode = base64.b64encode(
                bytes(str(invoice_id), 'utf-8'))  # int(invoice_number).to_bytes(2, byteorder='big')
            print("invoice_number", invoice_number, "FTP_HOST", FTP_HOST, "base64_encode", base64_encode.decode())
            links_pdf = "<a href = '%s/%s' > Download Invoice here </a> <br>" % (FTP_HOST, base64_encode.decode())
        except Exception as e:
            print(" Exception in getting  invoice_id:  %s" % (str(e)))
            logger.error("Exception in invoice_id :  %s" % (str(e)))
            links_pdf = "Link to your invoice can`t be uptain. Please contact the support"
            files = []
            invoice_id = "N/A"
            total_amount = "N/A"
    else:
        try:
            sql = "select invoice_id ,total_amount from invoice where invoice_number = '%s'" % invoice_number
            cur = pg_cur.execute(sql)
            result = dict_or_none(cur.fetchone())
            invoice_id = result['invoice_id']
            total_amount = result['total_amount']
        except Exception as e:
            print(" Exception in getting  invoice_id:  %s" % (str(e)))
            logger.error("Exception in invoice_id :  %s" % (str(e)))
            invoice_id = "N/A"
            total_amount = "N/A"
        files = [filename]
        links_pdf = ""

    ##CDR link
    print("CDR_UI", CDR_UI, str(invoice_id))
    CDR_UI = CDR_UI % str(invoice_id)
    cdr_link = config['cdr']["switch"] + CDR_UI
    links_cdr = "<a href='%s'>CDR LINK </a>  " % cdr_link

    print(filename, invoice_number)
    print("Files", str(files))
    print("links_pdf", links_pdf)
    print("links_cdr", links_cdr)
    mail_content = EmailTemplate.get('invoice_content',
                                     "N/A mail content in system cursor. Please report to administrator!")
    mail_content = mail_content.replace('{company_name}', client.get('company', 'N/A')).replace('{switch_alias}', str(
        smtp_info.get('switch_alias', 'N/A'))).replace('{start_date}',
                                                       str(data.get('start_date', 'N/A'))).replace('{end_date}', str(
        data.get('end_date', 'N/A'))).replace('{invoice_number}', str(invoice_number)).replace('{invoice_link}',
                                                                                               links_pdf).replace(
        '{client_name}', client.get('name', 'N/A')).replace('{invoice_amount}', str(total_amount)).replace('{cdr_url}',
                                                                                                           links_cdr)
    # mail_content +=  "  Created with the new script"
    logger.debug(mail_content)
    logger.debug(mail_subject)
    print("mail_subject ", mail_subject, send_to, invoice_cc)
    ret_msg = send_mail(send_from, invoice_cc, send_to, mail_subject, mail_content, files, server, port, username,
                        password, smtp_info, isTls)
    if ret_msg == 'OK':
        send_email_log(client, send_to, mail_subject, mail_content, 'http://%s/invoice/%s' % (FTP_HOST, filename),
                       False, "", pg_cur)
    else:
        send_email_log(client, send_to, mail_subject, mail_content, 'http://%s/invoice/%s' % (FTP_HOST, filename), True,
                       ret_msg, pg_cur)

    return ret_msg


def GetInvoiceDetails(data):
    pg_cur_l = new_cursor()
    data = dict(data)
    invoice_number = data['invoice_number'][0]
    try:
        int(invoice_number)
    except:
        return -2
    print("invoice_number:", invoice_number)
    sql = """select * from invoice where  invoice_number = '%s'""" % invoice_number

    print("sql for getting invoice number " + sql)
    try:
        pg_cur_l.execute(sql)
        result = pg_cur_l.fetchone()
    except Exception as e:
        # print ("SQL for updating cdr path in DB:  %s" % (str(e) ) )
        logger.error("Exception in  GetInvoiceDetails  %s" % (str(e)))
        traceback.print_tb(e.__traceback__)
        pg_cur_l.close()
        return -1

    # print ("Old Invoice Dict:", str(result))
    invoice_option = dict()  # options[0]
    invoice_option['invoice_number'] = invoice_number
    invoice_option['client_id'] = result['client_id']
    invoice_option['end_date'] = str(result['invoice_end']).replace("+00:00", "")
    invoice_option['start_date'] = str(result['invoice_start']).replace("+00:00", "")
    invoice_option['balance_time'] = str(result['invoice_balance_time']).replace("+00:00", "").replace("00:00:00", "")
    invoice_option['invoice_date'] = str(result['invoice_time']).replace("+00:00", "").replace("00:00:00", "")
    invoice_option['invoice_due_date'] = str(result['due_date']).replace("+00:00", "").replace("00:00:00", "")
    invoice_option['is_invoice_usage_detail'] = result['usage_detail_fields']
    invoice_option['jurisdict'] = result['invoice_jurisdictional_detail']
    invoice_option['is_short_duration_call_surcharge_detail'] = result['is_short_duration_call_surcharge_detail']
    invoice_option['is_invoice_account_summary'] = result['is_invoice_account_summary']
    invoice_option['detail_by_trunk'] = result['is_show_detail_trunk']
    invoice_option['include_origination_billing'] = 1  # result[''] # направи
    invoice_option['show_calls_date'] = result['is_show_by_date']
    invoice_option['summary_of_payments'] = result['invoice_include_payment']
    invoice_option['show_code_summery'] = result['is_show_code_100']
    invoice_option['show_trafic_country'] = result['is_show_country']
    invoice_option['show_trafic_code_name'] = result['is_show_code_name']
    invoice_option['is_send_as_link'] = result.get('is_send_as_link', False)
    invoice_option['create_type'] = result.get('create_type', 0)
    invoice_option['dayusage'] = result['is_show_daily_usage']

    # print (invoice_option['start_date'] , invoice_option['end_date'] ,invoice_option['balance_time'],invoice_option['invoice_date'],invoice_option['invoice_due_date'] )
    pg_cur_l.close()
    return invoice_option


def GetInvoiceDetailsAll(data):
    pg_cur = new_cursor()
    data = dict(data)
    invoice_number = data['invoice_number'][0]
    sql = """select * from invoice where  invoice_number = '%s'""" % invoice_number

    print("sql for getting invoice number " + sql)
    try:
        cur = pg_cur.execute(sql)
        result = dict_or_none(cur.fetchone())
    except Exception as e:
        print("Exception in  GetInvoiceDetails  %s" % (str(e)))
        # logger.error("Exception in  GetInvoiceDetails  %s" % (str(e) ) )
        traceback.print_tb(e.__traceback__)

    return result, pg_cur


def markForResend(data):
    pg_cur = new_cursor()
    data = dict(data)
    invoice_number = data['invoice_number'][0]
    send_to_email = data['email'][0]
    sql = """UPDATE invoice SET api_requests = 1 ,api_params = '%s' where  invoice_number = '%s'""" % (
        send_to_email, invoice_number)  # api_requests = 1 is for resend

    print("sql for marking the invoice for resending! " + sql)
    try:
        cur = pg_cur.execute(sql)
        pg_cur.close()
        return "OK"
    except Exception as e:
        print("Exception in  GetInvoiceDetails  %s" % (str(e)))
        # logger.error("Exception in  GetInvoiceDetails  %s" % (str(e) ) )
        traceback.print_tb(e.__traceback__)
        pg_cur.close()
        return ("Exception in  marking Invoice for resending  %s" % (str(e)))


def MakeInvoice(data, regenInvoice=False, SkipOverlapping=False, auto=False):
    """Handles name creation"""
    global log_id, pg_cur, logger, LOGGER_LIST
    # print ('''Handles name creation''')
    pg_cur, logger = setup()
    log_id = invoice_log_insert()
    # ,logo_file
    start = timer()
    LOGGER_LIST = []
    logger.debug("Starting new invoice")
    # print ("Data:",data)
    logger.debug("UI request: " + str(data))
    data = dict(data)  # original is in multidict Flask  - not anymore
    # print (data ) #data['username']
    param_dict = get_params(data, regenInvoice)
    print("param_dict", param_dict)
    try:
        param_dict['client_id'] = param_dict['client_id'][0]
        param_dict['start_date'] = param_dict['start_date'][0]
        param_dict['end_date'] = param_dict['end_date'][0]
        param_dict['invoice_due_date'] = param_dict['invoice_due_date'][0]
        param_dict['invoice_date'] = param_dict['invoice_date'][0]
        early_possible_date = config['other'].get('test_early_date', '2000-00-00') + " 00:00:00"  # = 2017-02-22
        pattern = " '%d-%m-%Y %H:%M:%S'"
        start_request_epoch = int(time.mktime(time.strptime(param_dict['client_id'], pattern)))
        early_possible_epoch = int(time.mktime(time.strptime(early_possible_date, pattern)))
        if start_request_epoch < early_possible_epoch:
            print("Start date is too early!")
            logger.debug("Start date is too early!")
            param_dict['start_date'] = start_request_epoch

    # print(param_dict)
    except  Exception as e:
        print("Bad request, ! %s   Trying with fallback" % str(e))
        try:
            param_dict['client_id'] = param_dict['client_id']
            param_dict['start_date'] = param_dict['start_date']
            param_dict['end_date'] = param_dict['end_date']
            param_dict['invoice_due_date'] = param_dict['invoice_due_date']
            param_dict['invoice_date'] = param_dict['invoice_date']
            early_possible_date = '2017-02-21 00:00:00'  # = 2017-02-22
            pattern = "%Y-%m-%d %H:%M:%S"
            start_request_epoch = int(time.mktime(time.strptime(param_dict['start_date'], pattern)))
            early_possible_epoch = int(time.mktime(time.strptime(early_possible_date, pattern)))
            if start_request_epoch < early_possible_epoch:
                print("Start date is too early!")
                logger.debug("Start date is too early!")
                param_dict['start_date'] = start_request_epoch
        except  Exception as e:
            print("Bad request, wrong format for dates! %s" % str(e))
            logger.error("Bad request, wrong format for dates! %s" % str(e))
            return [-1, "Bad request, wrong format for request to the API! The error is  %s" % str(e)]

    param_dict['regen'] = 1
    check = check_invoice_days(param_dict)  # [0]
    # print ("check: ", check)
    logger.debug("Options set: %s " % str(param_dict))

    print("skipOverlapping", SkipOverlapping)
    if check[0] == -1 and not SkipOverlapping:
        # overlapping
        print("invoice overlapping")
        return [-1, "Invoice overlapping !" + check[1]]
    if param_dict == -1:
        return [-1, "Wrong API call"]
    try:
        filename, invoice_number = makeNewInv(param_dict, auto)
        if filename == -3:  # missing daily table
            logger.error("Creating new Invoice Failed. Missing tables")
            return [-3, invoice_number]
    except Exception as e:
        traceback.print_tb(e.__traceback__)
        logger.error(" Exception in making new invoice:  %s" % (str(e)))
        return [-1, " Exception in making new invoice:  %s" % (str(e))]
    if settings.LOG_LEVEL in ['debug', 'info', 'warning']:
        with open(settings.FILES['invoice_logs'] + '/' + str(filename) + '.txt', mode='wt', encoding='utf-8') as myfile:
            myfile.write('\n'.join(LOGGER_LIST))
    return [filename, invoice_number]


def invoice_insert_void(data):
    try:
        pg_cur_l = new_cursor()
        param_dict = dict(data)
        print(param_dict)
        # param_dict = {}
        # for item in data :
        #	param_dict[item]=request.forms.get(item)

        sql = """update invoice set state =-1  where invoice_number ='%s' ; """ % (param_dict['invoice_number'][0])
        print("Sql for voiding invoice:", sql)
        pg_cur_l.execute(sql)
        print("executed")

    except Exception as e:
        logger.error(" Error in Invoice voiding   %s" % (str(e)))
        print("error in Invoice voiding   %s" % (str(e)))
        pg_cur_l.close()
        return str(e)
    pg_cur_l.close()
    return "Query executed: " + sql


def invoice_set_deleted(data):
    try:
        param_dict = dict(data)
        print(param_dict)
        pg_cur_l = new_cursor()
        # param_dict = {}
        # for item in data :
        #	param_dict[item]=request.forms.get(item)
        # we will not change invoice number for regenerated invoices anymore
        # random_string = '_reg_'
        # random_string = random_string + ''.join(random.choice(string.ascii_uppercase + string.digits) for _ in range(7))
        sql = """update invoice set state =-1 where invoice_number ='%s' ; """ % param_dict['invoice_number'][0]
        print("Sql for voiding invoice:", sql)
        cur = pg_cur.execute(sql)
        print("executed")

    except Exception as e:
        logger.error(" Error in Invoice voiding   %s" % (str(e)))
        print("error in Invoice voiding   %s" % (str(e)))
        pg_cur_l.close()
        return str(e)
    pg_cur_l.close()
    return "Query executed: " + sql


def dict_or_none(row):
    if row is None:
        return None
    else:
        return dict(row)


pg_cur, logger = setup()
