from api_dnl import settings
settings.LOG_FILE=settings.LOG_FILE+'.pcaploader'
from falcon_rest.logger import log
from api_dnl.tasks import app,db,SqlAlchemyTask,SchLog
import celery
from datetime import date,datetime,timedelta
from pytz import UTC
import time
from time import mktime
import io,csv,gzip,zipfile
import xlwt
import json
from celery import Celery
from celery.app.log import get_logger
from celery.schedules import crontab
from falcon_rest.db import initialize_db
from sqlalchemy import (
    Integer, SmallInteger, Float, Text, String, DateTime, Date, Time, Boolean, ForeignKey, BigInteger,
    Table
)
from sqlalchemy import (Column, desc, and_, text as text_, PrimaryKeyConstraint, inspect, Index, UniqueConstraint)
from sqlalchemy.sql import func, select,alias,case
from api_dnl.base_model import DnlApiBaseModel
from api_dnl.model import PcapQuery,CdrReportDetail,client_cdr,ClientCdr
from api_dnl.model import PrimaryKeyConstraint,func,query_to_sting,cast
from api_dnl import model
#old
import os
from os.path import exists, join, basename, dirname
import fnmatch
import glob
import re
import subprocess
import random
from Crypto.Random import atfork
from time import sleep, mktime
from shutil import copy, move
from ftplib import FTP
import hashlib
from collections import deque
import itertools
import paramiko
from api_dnl.utils.snippets import Application, compare_file_vs_hash,run_command
#import multiprocessing
#from multiprocessing import Pool
from billiard.pool import RUN,CLOSE,Pool
#from celery.concurrency.asynpool import AsynPool as Pool

PCAP_APP = None
@app.task(base=SqlAlchemyTask)
def do_pcap_loader(loop=False):
    global PCAP_APP
    if not PCAP_APP:
        log.debug('pcap loader! first start or reread settings ')
        load_db_settings()
        tcpdump_check_n_stop(settings.PCAP_TCPDUMP_USER)
        if not settings.PCAP_ACTIVE:
            log.debug('pcap loader pcap disabled')
            return False
        check_voice_ip_dirs_writable(settings.PCAP_TCPDUMP_DIR, settings.PCAP_VOICE_IPS_LIST)
        if settings.PCAP_STORAGE_TYPE == "local":
            #check_dir_writable(os.path.expanduser(settings.PCAP_STORAGE_DIR))
            check_dir_writable(settings.PCAP_STORAGE_DIR)
            check_dir_writable(settings.PCAP_PCAP_DIR)
            check_dir_writable(settings.PCAP_STAGING_DIR)
            check_dir_writable(settings.PCAP_WEB_PUBLIC_DIR)

        PCAP_APP = App("pcap_loader")

        if settings.PCAP_STORAGE_TYPE == "sftp":
            import paramiko
        if settings.PCAP_STORAGE_TYPE == "gcs":
            import gcs_worker
            PCAP_APP.GCSWorker = gcs_worker.GCSWorker(settings.PCAP_CREDENTIALS_FILE, logger)

    log.debug('Start pcap loader!')

    if loop:
        while True:
            count = PCAP_APP.mp_pcap_loader()
            log.debug('pcap loader! load {} files '.format(count))
            sleep(60)
    else:
        count = PCAP_APP.mp_pcap_loader()
        log.debug('pcap loader! load {} files '.format(count))


def port_from_ipnport(ipnport):
    return ipnport[ipnport.rfind(":"):]


def ip_from_ipnport(ipnport):
    return ipnport[0:ipnport.rfind(":")]


def get_pid(name):
    cmd = " sudo ps aux  | grep \'"+name+"\' | grep -v grep |  head -n 1 "
    try:
        result_out = run_command(cmd, settings.COMMAND_TIMEOUT)[0]
        if result_out:
            result_list = re.sub("[^\d+]", " ",  result_out).split()
            pid = result_list[0]
        else:
            pid = ""
    except Exception as e:
        log.error("Executing command {} gives error {}".format(cmd, e))
        pid = ""
    return pid


def tcpdump_check_n_fork(port,pcapdir,user):
    """sudo settings.PCAP_TCPDUMP -Z yaroslav -n -i eth0 host 192.99.10.113 and port
        5060 -G 60 -w  /home/yaroslav/pcaparchd/tcpdumpdir/%s.pcap"""
    cmd = " ".join((settings.PCAP_TCPDUMP, "-s 0 -Z", user, "-n -i any port", port, "-G 60"
            " -z lzma -w", join(pcapdir, "%s.pcap"), "&"))
    current_pid = get_pid(settings.PCAP_TCPDUMP + " -s 0 -Z "+ user+ " -n -i any port " + port)
    if not current_pid:
        subprocess.Popen("sudo " + cmd,shell=True,universal_newlines=True)
    return get_pid(settings.PCAP_TCPDUMP + " -s 0 -Z "+ user + " -n -i any port " + port)


def tcpdump_check_n_stop(user):
    current_pid = get_pid(" ".join(("sudo", settings.PCAP_TCPDUMP, "-s 0 -Z", user)))
    #current_pid = get_pid(" sudo | grep settings.PCAP_TCPDUMP | grep " + user + " ")
    if current_pid:
        run_command("sudo kill {}".format(current_pid),5)
    return current_pid


def get_free_pcap(directory):
    """Get unlocked pcap files.

        :param directory: Root folder to start search files.
        :return: List with "*.pcap.lzma" filename.

        Return list with recursive searched files with ".pcap.lzma" extension
        and filename 10-digit UTC epoch.

        """
    pcap_list = glob.glob(join(directory, "*.pcap.lzma"))
    for pcap in pcap_list:
        pcap = basename(pcap)
        fname = pcap[0:pcap.find(".pcap.lzma")]
        if fname.isdigit() and len(fname) == 10:
            pcap_datetime = datetime.utcfromtimestamp(int(fname))
            if ((datetime.now() - pcap_datetime).seconds >
                    settings.PCAP_SKIP_NEWER_SECONDS):
                return pcap
                break
            else:
                log.debug("get_free_pcap: Skip pcap file "
                        "earlier than {} seconds ago:{}".format(
                        settings.PCAP_SKIP_NEWER_SECONDS, pcap))
        else:
            log.error("Pcap file have unexpected name {}".format(pcap))
    return ""


def mp_get_free_pcaps(directory):
    """Get unlocked pcap files.

        :param directory: Root folder to start search files.
        :return: List with `pcap` filename.

        Return list with recursive searched files with .pcap extension
        and filename 10-digit UTC epoch.

        """
    return mp_get_free_pcaps_for_upload(directory, '')


def mp_get_free_pcaps_for_upload(directory, ip=''):
    """Get unlocked pcap files for upload.

        :param directory: Root folder to start search files.
        :param ip: Prefix for return filename.
        :return: List with `ip`+'/'+`pcap` filename.

        Return list with recursive searched files with .pcap extension
        and filename 10-digit UTC epoch.

        """
    log.debug("mp_get_free_pcaps_for_upload will run with params "
        "(directory:{}, ip:{})".format(directory, ip))
    # ls -l /proc/$PID/fd  | grep pcap
    pcaps = deque((), settings.PCAP_MAX_FILES_CYCLE)
    pcap_list = glob.glob(join(directory, "*.pcap.lzma"))
    log.debug("mp_get_free_pcaps_for_upload: Total count pcaps in directory:"
            "{}".format(len(pcap_list)))
    list_size = 0
    for pcap in pcap_list:
        if list_size >= settings.PCAP_MAX_FILES_CYCLE:
            break
        pcap = basename(pcap)
        fname = pcap[0:pcap.find(".pcap.lzma")]
        if fname.isdigit() and len(fname) == 10:
            """Instruct script to skip files earlier than
                `settings.PCAP_SKIP_PCAP_NEWER_SECONDS` seconds ago.
                There would be no need in LSOF command.
                can any pcap file older than 2 minute from now be locked
                for I/O? it is settings.PCAP_TCPDUMP -ed every 1 min. Should not be
                more than 2 files locked? An I right?
                locked file should be only one that is currently used by
                settings.PCAP_TCPDUMP and that should be last one.

            """
            pcap_datetime = datetime.utcfromtimestamp(int(fname))
            if ((datetime.now() - pcap_datetime).seconds >
                    settings.PCAP_SKIP_NEWER_SECONDS):
                list_size += 1
                if ip:
                    pcaps.append(join(ip, pcap))
                else:
                    pcaps.append(pcap)
            else:
                log.debug("mp_get_free_pcaps_for_upload: Skip pcap file "
                        "earlier than {} seconds ago:{}".format(
                        settings.PCAP_SKIP_NEWER_SECONDS, pcap))
        else:
            log.error("Pcap file have unexpected name {}".format(pcap))
    return pcaps


def pcap_ips_parse_put_local(directory,pcap,ips):
    """get ip from list
    lzmacat | settings.PCAP_TSHARK | lzma to directory/ip/
    cmd = settings.PCAP_LZCAT + " " + pcap + " | " + settings.PCAP_TSHARK + " -r -  -Y 'ip.addr == \"" + ip +"\"\'  -w - | xz --format=lzma > "+directory+ip+"/"+pcap
    """
    for ip in ips:
        if not ip:
            log.error("ip is wrong")
            return 1
        cmd = (settings.PCAP_LZCAT + " " + join(directory, pcap) + " | " + settings.PCAP_TSHARK + " -r - "
                "-Y 'ip.addr == " + ip + "\' -w - | xz -2 --format=lzma > "
                + join(directory, ip, pcap))
        try:
            run_command(cmd)
        except Exception as e:
            log.error("Executing command {} gives error {}".format(cmd, e))
            return 1
    #original file removal is not implemented yet
    os.remove(directory+pcap)
    return 0

def check_dir_writable(directory):
    """Check whether dir is exists and writable.

    :param directory: Directory to check.
    :return: True if dir is exists and writable, False if not.

    os.access(path, mode) Use the real uid/gid to test for access to path.
    os.makedirs(path[, mode]) Recursive directory creation function.
    Like mkdir(), but makes all intermediate-level directories needed to
    contain the leaf directory. Raises an error exception if the leaf
    directory already exists or cannot be created.
    The default mode is 0777 (octal).

    """
    if os.access(directory, os.W_OK | os.X_OK | os.R_OK):
        return True
    else:
        try:
            os.makedirs(directory)
        except IOError as e:
            log.error("The leaf directory {} already exists or cannot be "
                    "created: {}".format(directory, e))
            return False
        return True

def check_voice_ip_dirs_writable(directory,ips):
    """Check whether all switch`s settings.PCAP_TCPDUMP dirs are exist and writable.

    :param directory: Directory to check.
    :param ips: List of ips inside directory to check.

    :return: 1 if dirs are exists and writable, 0 if not.

    I have found new bug in script. it checks whether dir is exists
    and writable in an inefficient way. each time and for each switch
    ip. And some way is started from 4 checks and now it is grew to 24
    checks in a cycle that are very slow - write, delete.

    """
    ok_flag = check_dir_writable(directory)
    for ip in ips:
        if not ip:
            log.error("ip is wrong")
            continue
        ok_flag *= int(check_dir_writable(join(directory, ip)))
    return ok_flag

def mp_pcap_ips_parse_put_local(pcap):
    """get ip from list
    lzmacat | settings.PCAP_TSHARK | lzma to directory/ip/
    cmd = settings.PCAP_LZCAT + " " + pcap + " | " + settings.PCAP_TSHARK + " -r -  -Y 'ip.addr == \"" + ip +"\"\'  -w - | xz --format=lzma > "+directory+ip+"/"+pcap
    """
    directory = settings.PCAP_TCPDUMP_DIR
    ips = settings.PCAP_VOICE_IPS_LIST
    for ip in ips:
        if not ip:
            log.error("ip is wrong")
            return 0
        cmd = (settings.PCAP_LZCAT + " " + join(directory, pcap) + " | " + settings.PCAP_TSHARK + " -r - -Y"
                " 'ip.addr == " + ip + "\' -w - | xz -2 --format=lzma > "
                + join(directory, ip, pcap))
        try:
            run_command(cmd)
        except Exception as e:
            log.error("Executing command {} gives error {}".format(cmd, e))
            return 0
    os.remove(directory+pcap)
    return 1


def mp_storage_put_ftp(ip_n_pcap):
    #(directory,host,port,login,password,storage,pcap,switch_ip)
    #input will be ip/pcap
    myid = str(random.random())
    input_list = ip_n_pcap.split("/")
    switch_ip = input_list[0]
    pcap = input_list[1]
    storage = settings.PCAP_STORAGE_DIR
    directory = settings.PCAP_TCPDUMP_DIR + switch_ip + "/"
    login = settings.PCAP_FTP_USER
    password = settings.PCAP_FTP_PASS
    host = settings.PCAP_FTP_HOST
    port = settings.PCAP_FTP_PORT
    fname = pcap[0:pcap.find(".pcap.lzma")]
    date_pcap = str(date.fromtimestamp(int(fname)))
    date_pcap_list = date_pcap.split("-")
    pcap_year = date_pcap_list[0]
    pcap_month = date_pcap_list[1]
    pcap_day = date_pcap_list[2]
    log.debug("ftploaderid "+ myid +" : "+ "target ftp://"+login+":PASSWORD@"+host+":"+port+"/"+storage+"/"+switch_ip+"/"+pcap_year+"/"+pcap_month+"/"+pcap_day+"/"+pcap)
    try:
        ftp=FTP()
        ftp.connect(host,int(port),timeout=300)
        ftp.login(login,password)
    except Exception as e:
        log.error("ftploaderid "+ myid +" : "+ "can not connect to ftp server " + str(e))
        return
    ftp_tmp_dir = "/" + storage
    try:
        ftp.cwd(ftp_tmp_dir)
        log.debug("ftploaderid "+ myid +" : "+ "fine - can cwd to " + ftp_tmp_dir)
    except Exception as e:
        log.error("ftploaderid "+ myid +" : "+ "can not cwd to " + ftp_tmp_dir)
        try:
            ftp.mkd(ftp_tmp_dir)  #try create dir
            log.info("ftploaderid "+ myid +" : "+ "created new directory " + ftp_tmp_dir)
        except Exception as e:
            log.error("ftploaderid "+ myid +" : "+ "not created new directory " + ftp_tmp_dir)
    try:
        ftp_tmp_dir = "/"+storage+"/"+switch_ip
        ftp.cwd(ftp_tmp_dir)
        log.debug("ftploaderid "+ myid +" : "+ "fine - can cwd to " + ftp_tmp_dir)
    except Exception as e:
        log.error("ftploaderid "+ myid +" : "+ "can not cwd to " + ftp_tmp_dir)
        try:
            ftp.mkd(ftp_tmp_dir)  #try create dir
            log.info("ftploaderid "+ myid +" : "+ "created new directory " + ftp_tmp_dir)
        except Exception as e:
            log.error("ftploaderid "+ myid +" : "+ "not created new directory " + ftp_tmp_dir)
    try:
        ftp_tmp_dir = "/"+storage+"/"+switch_ip+"/"+pcap_year
        ftp.cwd(ftp_tmp_dir)
        log.debug("ftploaderid "+ myid +" : "+ "fine - can cwd to " + ftp_tmp_dir)
    except Exception as e:
        log.error("ftploaderid "+ myid +" : "+ "can not cwd to " + ftp_tmp_dir)
        try:
            ftp.mkd(ftp_tmp_dir)  #try create dir
            log.info("ftploaderid "+ myid +" : "+ "created new directory " + ftp_tmp_dir)
        except Exception as e:
            log.error("ftploaderid "+ myid +" : "+ "not created new directory " + ftp_tmp_dir)
    try:
        ftp_tmp_dir = "/"+storage+"/"+switch_ip+"/"+pcap_year+"/"+pcap_month
        ftp.cwd(ftp_tmp_dir)
        log.debug("ftploaderid "+ myid +" : "+ "fine - can cwd to " + ftp_tmp_dir)
    except Exception as e:
        log.error("ftploaderid "+ myid +" : "+ "can not cwd to " + ftp_tmp_dir)
        try:
            ftp.mkd(ftp_tmp_dir)  #try create dir
            log.info("ftploaderid "+ myid +" : "+ "created new directory " + ftp_tmp_dir)
        except Exception as e:
            log.error("ftploaderid "+ myid +" : "+ "not created new directory " + ftp_tmp_dir)
    try:
        ftp_tmp_dir = "/"+storage+"/"+switch_ip+"/"+pcap_year+"/"+pcap_month+"/"+pcap_day
        ftp.cwd(ftp_tmp_dir)
        log.debug("ftploaderid "+ myid +" : "+ "fine - can cwd to " + ftp_tmp_dir)
    except Exception as e:
        log.error("ftploaderid "+ myid +" : "+ "can not cwd to " + ftp_tmp_dir)
        try:
            ftp.mkd(ftp_tmp_dir)  #try create dir
            log.info("ftploaderid "+ myid +" : "+ "created new directory " + ftp_tmp_dir)
        except Exception as e:
            log.error("ftploaderid "+ myid +" : "+ "not created new directory " + ftp_tmp_dir)
    try:   #final try
        ftp.cwd(ftp_tmp_dir)
        ftpfile = open(directory+"/"+pcap, 'rb')
        ftp.storbinary('STOR ' + pcap, ftpfile)
        ftpfile.close()
        #ftpfilebak = open(directory+"/"+pcap+".bak", 'wb')
        #ftp.retrbinary('RETR ' + pcap, ftpfilebak.write)
        #ftpfilebak.close()
        log.debug("ftploaderid "+ myid +" : "+ "sucessfuly uploaded " + pcap + " to target directory " + ftp_tmp_dir)
    except Exception as e:
        log.error("ftploaderid "+ myid +" : "+ "can not place " + pcap + " to target directory " + ftp_tmp_dir)
        #ftp.quit()
        return
    pcaphash_to = ""
    pcaphash_from = hashlib.md5(open(directory+pcap,'rb').read()).hexdigest()
    sleep(10)  # waiting for on-ftp-server hash generetion and will try to download
    #pcaphash_from=hashlib.md5(open(directory+pcap,'rb').read()).hexdigest()
    #trying download hash from server
    md5loaded = 0
    log.debug("ftploaderid "+ myid +" : "+ "will check md5 for " + pcap + " in target directory " + ftp_tmp_dir)
    try:
        ftp=FTP()
        ftp.connect(host,int(port),timeout=300)
        ftp.login(login,password)
        ftp.cwd(ftp_tmp_dir)
        ftphashbak = open(directory+"/"+pcap+".md5", 'wb')
        ftp.retrbinary('RETR ' + pcap+".md5", ftphashbak.write)
        ftphashbak.close()
        md5hashfile = open(directory+"/"+pcap+".md5")
        pcaphash_to_line = md5hashfile.readline().split(" ")
        pcaphash_to = pcaphash_to_line[0]
        log.debug("ftploaderid "+ myid +" : "+ "md5 from ftp " + pcaphash_to)
        md5hashfile.close()
        md5loaded = 1
    except Exception as e:
        log.error("ftploaderid "+ myid +" : "+ "can not load md5 file from ftp due "+str(e)+" ,will check md5 by downloading full file from ftp")
    if md5loaded == 0:  # deleting zero file
        try:
            os.remove(directory+pcap+".md5")
        except Exception as e:
            log.error("ftploaderid "+ myid +" : "+ "can not delete zero md5 file, something really bad "+str(e))
    if md5loaded == 0:  # using fallback download
        try:
            ftp=FTP()
            ftp.connect(host,int(port),timeout=300)
            ftp.login(login,password)
            ftp.cwd(ftp_tmp_dir)
            ftpfilebak = open(directory+"/"+pcap+".bak", 'wb')
            ftp.retrbinary('RETR ' + pcap, ftpfilebak.write)
            ftpfilebak.close()
            pcaphash_to=hashlib.md5(open(directory+pcap+".bak",'rb').read()).hexdigest()
        except Exception as e:
            log.error("ftploaderid "+ myid +" : "+ "can not load file back, something really bad "+str(e))
            #ftp.quit()
            return
    log.debug("ftploaderid "+ myid +" : "+ "hash from  - file "+directory+pcap)
    if md5loaded == 0: log.debug("ftploaderid "+ myid +" hash to  - file "+directory+pcap+".bak")
    if md5loaded == 1: log.debug("ftploaderid "+ myid +" hash to  - file "+directory+pcap+".md5")
    log.debug("ftploaderid "+ myid +" : "+ "hash to: "+str(pcaphash_to)+" ,hash from: "+str(pcaphash_from))
    if pcaphash_from == pcaphash_to:
        if md5loaded == 0: log.debug("local hash check - ok")
        if md5loaded == 1: log.debug("remote hash check - ok")
        hash_flag_file = open(directory+pcap+".hash", 'w')
        hash_flag_file.write(pcaphash_to+"\n")
        hash_flag_file.close()
        log.debug("ftploaderid "+ myid +" : "+ "created file "+ directory+pcap+".hash")
        try:  # reconnection to ftp
            ftp.quit()
        except Exception as e:
            log.debug("ftploaderid "+ myid +" : "+ "reconnection , makin one more reconnect")
        try:
            log.debug("ftploaderid "+ myid +" : "+ "started loading hash file "+ directory+pcap+".hash to ftp")
            ftp=FTP()
            ftp.connect(host,int(port),timeout=300)
            ftp.login(login,password)
            ftp.cwd(ftp_tmp_dir)
            ftphashfile = open(directory+"/"+pcap+".hash", 'rb')
            ftp.storbinary('STOR ' + pcap+".hash", ftphashfile)
            ftphashfile.close()
            ftp.quit()
            log.debug("ftploaderid "+ myid +" : "+ "completed loading hash file "+ directory+pcap+".hash to ftp")
        except Exception as e:
            log.error("ftploaderid "+ myid +" : "+ "can not connect to ftp server " + str(e))
            log.debug("ftploaderid "+ myid +" : "+ "aborted loading file "+ directory+pcap+".hash to ftp")
            return
        os.remove(directory+pcap)
        os.remove(directory+pcap+".hash")
        if md5loaded == 0: os.remove(directory+pcap+".bak")
        if md5loaded == 1: os.remove(directory+pcap+".md5")
        log.info("ftploaderid "+ myid +" : "+ pcap+" and md5 hash placed to target directory, hash check - OK, source pcap deleted ")
    else:
        if md5loaded == 0: log.debug("ftploaderid "+ myid +" : "+ "local hash check - not ok")
        if md5loaded == 1: log.debug("ftploaderid "+ myid +" : "+ "remote hash check - not ok")
        log.error("ftploaderid "+ myid +" : "+ pcap+ " placed to target directory,but hash check - NOT OK, source pcap NOT deleted")
        #os.remove(directory+pcap+".hash")
        if md5loaded == 0: os.remove(directory+pcap+".bak")
        if md5loaded == 1: os.remove(directory+pcap+".md5")
    try:  # reconnection to ftp
        ftp.quit()
        log.debug("ftploaderid "+ myid +" : "+ "ftp closed, exiting normal")
    except Exception as e:
        log.debug("ftploaderid "+ myid +" : "+ "ftp already closed, exiting normal")
    return ip_n_pcap


def mp_pcap_put_gcs(ip_n_pcap):
    """Uploads pcap and hash to GCS.

        :param ip_n_pcap: local pcap file URL like 'switch_ip/pcap'
        :return: ``False`` if fail and `ip_n_pcap` if success.

        This function is used by worker in multiprocessing.Pool.map_async
        mode.

    """
    atfork()
    myid = str(random.random())

    input_list = ip_n_pcap.split("/")
    switch_ip = input_list[0]
    pcap = input_list[1]
    directory = settings.PCAP_TCPDUMP_DIR + switch_ip + "/"
    fname = pcap[0:pcap.find(".pcap.lzma")]
    date_pcap = str(date.fromtimestamp(int(fname)))
    date_pcap_list = date_pcap.split("-")
    pcap_year = date_pcap_list[0]
    pcap_month = date_pcap_list[1]
    pcap_day = date_pcap_list[2]

    source = directory + pcap
    target = join(settings.PCAP_STORAGE_DIR, switch_ip, pcap_year, pcap_month, pcap_day,
            pcap)
    log.debug("mp_pcap_put_gcs "+ myid +" going to put store file "
            + source + " to " + target + " at GCS " + settings.PCAP_PROJECT_NAME)
    try:
        if app.GCSWorker.upload_file_check_hash(source,target):
            return ip_n_pcap
        else:
            return False
    except Exception as e:
        log.error('File {} has not been uploaded. Reason: {}: {}'.format(
                source, e.__class__.__name__, e))
        return False

def mp_cdrstorage_put_gcs(cdrarch):
    """Uploads CDR archive file to storage.

        :param cdrarch: local CDR archive filename in `settings.PCAP_STAGING_DIR_CDR`
        path.
        :return: ``False`` if fail and `cdrarch` if success.

        This function is used by worker process in
        multiprocessing.Pool.map_async mode.

    """
    atfork()
    directory = settings.PCAP_STAGING_DIR_CDR
    storage = settings.PCAP_STORAGE_DIR_CDR
    fname=cdrarch[0:cdrarch.find(".tar.gz")]
    cdrarchdatetime = datetime.strptime(fname, '%Y%m%d')
    cdrarch_year = datetime.strftime(cdrarchdatetime, '%Y')
    cdrarch_month = datetime.strftime(cdrarchdatetime, '%m')
    source = directory + cdrarch
    target = storage + "/" + cdrarch_year + "/" + cdrarch_month + "/" + cdrarch
    myid = str(random.random())
    log.debug("mp_cdrstorage_put_gcs "+ myid +" going to put store file "
            + source + " to " + target + " at GCS " + settings.PCAP_PROJECT_NAME)
    try:
        if app.GCSWorker.upload_file_check_hash(source,target):
            return cdrarch
        else:
            return False
    except Exception as e:
        log.error('File {} has not been uploaded. Reason: {}: {}'.format(
                source, e.__class__.__name__, e))
        return False

def get_notloaded_cdr_folders_gcs():
    """Returns list of local cdr files to be uploaded to remote."""
    atfork()
    folders2 = []
    bucket = app.GCSWorker.get_bucket()
    for folder in get_files_by_mask_date(settings.PCAP_STAGING_DIR_CDR, settings.PCAP_CDR_KEEP_DAYS,
            '*.tar.gz'):
        dirdate = re.search('\d\d\d\d/\d\d/\d\d',folder)
        if dirdate:
            dirdatetime = datetime.strptime(dirdate.group(), '%Y/%m/%d')
            archhashname = join(settings.PCAP_STORAGE_DIR_CDR,"{}.tar.gz.hash".format(
                    datetime.strftime(dirdatetime,'%Y/%m/%Y%m%d')))
            if not bucket.blob(archhashname).exists():
                folders2.append(folder)
    return folders2

def mp_pcap_put_sftp(ip_n_pcap):
    """Uploads pcap and hash to sFTP.

    :param ip_n_pcap: local pcap file URL like 'switch_ip/pcap'
    :return: 0 if fail and `ip_n_pcap` if success.

    This function is used by worker in multiprocessing.Pool.map_async
    mode.

    """
    myid = str(random.random())

    input_list = ip_n_pcap.split("/")
    switch_ip = input_list[0]
    pcap = input_list[1]
    dump_path = settings.PCAP_TCPDUMP_DIR + switch_ip + "/"
    storage = settings.PCAP_STORAGE_DIR
    log.debug("mp_pcap_put_sftp id:{} is going to put pcap {} to "
            "FTP {}".format(myid, pcap, storage))
    result = storage_put_sftp2(dump_path, settings.PCAP_FTP_HOST, settings.PCAP_FTP_PORT,
            settings.PCAP_FTP_USER, settings.PCAP_FTP_PASS, storage, pcap,
            switch_ip)
    if result:
        log.debug("mp_pcap_put_sftp id:{} uploaded pcap {} to "
            "FTP.".format(myid, pcap))
        return ip_n_pcap
    else:
        log.debug("mp_pcap_put_sftp id:{} failed to upload pcap {} to "
            "FTP.".format(myid, pcap))
        return

def storage_put_sftp2(directory,host,port,login,password,storage,pcap,switch_ip):
    atfork()
    fname=pcap[0:pcap.find(".pcap.lzma")]
    date_pcap=str(date.fromtimestamp(int(fname)))
    date_pcap_list=date_pcap.split("-")
    pcap_year=date_pcap_list[0]
    pcap_month=date_pcap_list[1]
    pcap_day=date_pcap_list[2]
    log.debug("target ftp://"+login+":PASSWORD@"+host+":"+port+"/"+storage+"/"+switch_ip+"/"+pcap_year+"/"+pcap_month+"/"+pcap_day+"/"+pcap)
    try:
        ssh = paramiko.SSHClient()
        ssh.set_missing_host_key_policy(paramiko.AutoAddPolicy())
        ssh.connect(host,port=int(port),username=login,password=password)
        sftp = ssh.open_sftp()
    except Exception as e:
        log.error("can not connect to sftp server " + str(e))
        return
    try:
        ftp_tmp_dir = storage
        sftp.chdir(ftp_tmp_dir)
        sftp.chdir()
        log.debug("fine - can cwd to " + ftp_tmp_dir)
    except Exception as e:
        log.error("can not cwd to " + ftp_tmp_dir)
        try:
            sftp.mkdir(ftp_tmp_dir)  #try create dir
            log.info("created new directory " + ftp_tmp_dir)
        except Exception as e:
            log.error("not created new directory " + ftp_tmp_dir)
    try:
        ftp_tmp_dir = storage+"/"+switch_ip
        sftp.chdir(ftp_tmp_dir)
        sftp.chdir()
        log.debug("fine - can cwd to " + ftp_tmp_dir)
    except Exception as e:
        log.error("can not cwd to " + ftp_tmp_dir)
        try:
            sftp.mkdir(ftp_tmp_dir)  #try create dir
            log.info("created new directory " + ftp_tmp_dir)
        except Exception as e:
            log.error("not created new directory " + ftp_tmp_dir)
    try:
        ftp_tmp_dir = storage+"/"+switch_ip+"/"+pcap_year
        sftp.chdir(ftp_tmp_dir)
        sftp.chdir()
        log.debug("fine - can cwd to " + ftp_tmp_dir)
    except Exception as e:
        log.error("can not cwd to " + ftp_tmp_dir)
        try:
            sftp.mkdir(ftp_tmp_dir)  #try create dir
            log.info("created new directory " + ftp_tmp_dir)
        except Exception as e:
            log.error("not created new directory " + ftp_tmp_dir)
    try:
        ftp_tmp_dir = storage+"/"+switch_ip+"/"+pcap_year+"/"+pcap_month
        sftp.chdir(ftp_tmp_dir)
        sftp.chdir()
        log.debug("fine - can cwd to " + ftp_tmp_dir)
    except Exception as e:
        log.error("can not cwd to " + ftp_tmp_dir)
        try:
            sftp.mkdir(ftp_tmp_dir)  #try create dir
            log.info("created new directory " + ftp_tmp_dir)
        except Exception as e:
            log.error("not created new directory " + ftp_tmp_dir)
    try:
        ftp_tmp_dir = storage+"/"+switch_ip+"/"+pcap_year+"/"+pcap_month+"/"+pcap_day
        sftp.chdir(ftp_tmp_dir)
        sftp.chdir()
        log.debug("fine - can cwd to " + ftp_tmp_dir)
    except Exception as e:
        log.error("can not cwd to " + ftp_tmp_dir)
        try:
            sftp.mkdir(ftp_tmp_dir)  #try create dir
            log.info("created new directory " + ftp_tmp_dir)
        except Exception as e:
            log.error("not created new directory " + ftp_tmp_dir)
    try:   #final try
        sftp.chdir()
        sftp.chdir(ftp_tmp_dir)
        sftp.put(directory+"/"+pcap,pcap)
        sftp.get(pcap,directory+"/"+pcap+".bak")
    except Exception as e:
        log.error("can not place " + pcap + " to target directory " + ftp_tmp_dir)
        #sftp.close()
        #ssh.close()
        return
    pcaphash_from=hashlib.md5(open(directory+pcap,'rb').read()).hexdigest()
    pcaphash_to=hashlib.md5(open(directory+pcap+".bak",'rb').read()).hexdigest()
    if pcaphash_from == pcaphash_to:
        hash_flag_file = open(directory+pcap+".hash", 'w')
        hash_flag_file.write(pcaphash_to+"\n")
        hash_flag_file.close()
        sftp.put(directory+"/"+pcap+".hash",pcap+".hash")
        os.remove(directory+pcap)
        os.remove(directory+pcap+".bak")
        os.remove(directory+pcap+".hash")
        sftp.close()
        ssh.close()
        log.info(pcap+" and md5 hash placed to target directory, hash check - OK, source pcap deleted ")
    else:
        log.error(pcap+ " placed to target directory,but hash check - NOT OK, source pcap NOT deleted")
        os.remove(directory+pcap+".bak")
        os.remove(directory+pcap+".hash")
        sftp.close()
        ssh.close()
    return True

def mp_pcap_put_local(ip_n_pcap):
    """Uploads pcap and hash to local.

        :param ip_n_pcap: local pcap file URL like 'switch_ip/pcap'
        :return: 0 if fail and `ip_n_pcap` if success.

        This function is used by worker in multiprocessing.Pool.map_async
        mode.

    """
    myid = str(random.random())

    input_list = ip_n_pcap.split("/")
    switch_ip = input_list[0]
    pcap = input_list[1]
    directory = join(settings.PCAP_TCPDUMP_DIR, switch_ip)
    storage = settings.PCAP_STORAGE_DIR
    log.debug("mp_pcap_put_local id:{} is going to put pcap {} to "
            "local {}".format(myid, pcap, storage))
    result = storage_put_local(directory,storage,pcap,switch_ip)
    if result:
        log.debug("mp_pcap_put_local id:{} uploaded pcap {} to "
            "local.".format(myid, pcap))
    else:
        log.debug("mp_pcap_put_local id:{} failed to upload pcap {} to "
            "local.".format(myid, pcap))
    return result

def storage_put_local(directory,storage,pcap,switch_ip):
    """:return: pcap if ok, 0 if not."""
    fname=pcap[0:pcap.find(".pcap.lzma")]
    date_pcap=str(date.fromtimestamp(int(fname)))
    date_pcap_list=date_pcap.split("-")
    pcap_year=date_pcap_list[0]
    pcap_month=date_pcap_list[1]
    pcap_day=date_pcap_list[2]
    #local_tmp_dir =
    local_tmp_dir = os.path.expanduser(join("~", storage))
    local_target_dir = join(local_tmp_dir, switch_ip, pcap_year, pcap_month,
            pcap_day)
    local_target_file = join(local_target_dir, pcap)
    source = join(directory, pcap)
    log.debug("source file " + source)
    log.debug("target file " + local_target_file)
    log.debug("target dir " + local_target_dir)
    if not os.path.exists(local_target_dir):
        os.makedirs(local_target_dir)

    if not check_dir_writable(local_target_dir):
        return 0
    try:   #final try
        log.debug("copying "+ source + " to " + local_target_file)
        copy(source, local_target_file)
        copy(local_target_file, source + ".bak")
    except Exception as e:
        log.error("can not place " + pcap + " to target directory "
                + local_target_dir + " " + str(e))
        return 0
    pcaphash_from=hashlib.md5(open(source,'rb').read()).hexdigest()
    pcaphash_to=hashlib.md5(open(source + ".bak",'rb').read()).hexdigest()
    if pcaphash_from == pcaphash_to:
        hash_flag_file = open(source + ".hash", 'w')
        hash_flag_file.write(pcaphash_to + "\n")
        hash_flag_file.close()
        copy(source + ".hash", local_target_file + ".hash")
        os.remove(source)
        os.remove(source + ".bak")
        os.remove(source + ".hash")
        log.info(pcap + " and md5 hash placed to target directory, "
                "hash check - OK, source pcap deleted")
    else:
        log.error(pcap + " placed to target directory,but hash check"
                " - NOT OK, source pcap NOT deleted")
        os.remove(source + ".bak")
        os.remove(source + ".hash")
        return 0
    return pcap


def mp_dir_arch_to_staging(srcdir):
    """Pack folder containing cdr files to tar.

    :param srcdir: The folder containing files to pack.
    :return: `srcdir` absolute path if pack was successfull, None if not.

    The folder `srcdir` is packed to *.tar.gz and placed
    to `settings.PCAP_STAGING_DIR_CDR`.
    """
    directory = settings.PCAP_STAGING_DIR_CDR
    cleardir = os.path.abspath(srcdir)
    dirdate = re.search('\d\d\d\d/\d\d/\d\d',srcdir)
    if dirdate:
        dirdatetime = datetime.strptime(dirdate.group(), '%Y/%m/%d')
        # archname here is a abs path of new target archive file.
        archname = join(directory, datetime.strftime(dirdatetime, '%Y%m%d'
                '') + ".tar.gz")
        shortdirname = datetime.strftime(dirdatetime, '%d')
    else:
        log.error("wrong cdr directory name " + srcdir)
        return False
    """Remove if exist old archive name."""
    if os.path.isfile(archname):
        log.error("Should not have archive filename {} before packing cdr "
                "folder. Deleted it.".format(archname))
        os.remove(archname)
    """ "cd {};".format(join(cleardir,'..') here is cd to dir ending
    with datetime.strftime(dirdatetime, '%Y/%m'), one level up from day.
    """
    cmd = "cd {};TAR -zc --file={} {}".format(join(cleardir,'..'), archname,
            shortdirname)
    try:
        run_command(cmd)
    except Exception as e:
        log.error("Executing command {} gives error {}".format(cmd, e))
        return False
    log.info("Folder {} packed to {}".format(srcdir, archname))
    return srcdir


def get_outdated_cdr_folders(days_delta):
    """Search outdated folders with files like *.cdr.

    :param days_delta: Folders should be older than delta days from now.
    :yield: Outdated files abs path iterator.

    Generate iterator with recursive searched folders containing files
    filtered by `mask` '*.cdr' older than `delta_days`.

    """
    return get_outdated_folders_list_by_mask(settings.PCAP_CDR_DIR, days_delta, '*.cdr')


def get_files_by_mask_date(folder, days_delta=0, mask='*.cdr'):
    """Search outdated files by mask.

    :param folder: Root folder to start search files.
    :param days_delta: Files should be older than delta days from now.
    :param mask: Filenames get filtered by `mask`.
    :yield: Outdated files abs path iterator.

    Generate iterator with recursive searched files
    filtered by `mask` with date `delta_days` older than now or more.

    """
    for root, dirnames, filenames in os.walk(folder):
        for filename in fnmatch.filter(filenames, mask):
            date_match_obj = re.search('\d\d\d\d/\d\d/\d\d',filename)
            if date_match_obj:
                dir_date = datetime.date(datetime.strptime(
                        date_match_obj.group(), '%Y/%m/%d'))
                if (date.today() - dir_date).days >= days_delta:
                    (yield join(root, filename))
            else:
                log.error("File have unexpected filename {}"
                        .format(join(root, filename)))


def get_outdated_folders_list_by_mask(folder, days_delta=0, mask='*.cdr'):
    """Search outdated folders with files by mask.

    :param folder: Root folder to start search files.
    :param days_delta: Folders should be older than delta days from now.
    :param mask: Filenames get filtered by `mask`.
    :yield: Outdated folder path ending with `YYYY/mm/dd`.

    Search recursive for folder path ending with `YYYY/mm/dd`
    containing files filtered by `mask` with date `delta_days` older than
    now or more. Should omit ending 2 digit hour 'hh' from dirs ending with
    'YYYY/mm/dd/hh'.

    """
    current_dir = ''
    for root, dirnames, filenames in os.walk(folder):
        for filename in fnmatch.filter(filenames, mask):
            file_dir = dirname(join(root, filename))[0:-3]
            if current_dir == file_dir:
                continue
            current_dir = file_dir
            date_match_obj = re.search('\d\d\d\d/\d\d/\d\d',current_dir)
            if date_match_obj:
                dir_date = datetime.date(datetime.strptime(
                        date_match_obj.group(), '%Y/%m/%d'))
                if (date.today() - dir_date).days >= days_delta:
                    log.debug("Outdated folder {} is {} days old.".format(
                            current_dir, (date.today() - dir_date).days))
                    (yield current_dir)
#                else:
#                    logging.debug("Folder {} not match by date because {} <= {}".
#                            format(current_dir, (date.today() -
#                            dir_date).days, days_delta))
            else:
                log.error("Folder have unexpected name {} from filename {}"
                        .format(current_dir, filename))


def cdr_folder_index_delete(cdrfolder):
    """
    Index cdr folder and force remove.

    :param cdrfolder: outdated cdr folder.
    """
    try:
        indexf = open(settings.PCAP_INDEXFILE,'a')
        dirdate = re.search('\d\d\d\d/\d\d/\d\d',cdrfolder)
        if dirdate:
            dirdatetime = datetime.strptime(dirdate.group(), '%Y/%m/%d')
            dirdateepoch = mktime(dirdatetime.timetuple())
            dirdateepochhrs = int(int(dirdateepoch)/3600)
            for hr in [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23]:
                if settings.PCAP_INDEXMOUNT and settings.PCAP_INDEXUMOUNT: indexf.write(str(dirdateepochhrs+hr)+":"+settings.PCAP_INDEXPREFIX+":'"+settings.PCAP_INDEXMOUNT+':'+settings.PCAP_INDEXUMOUNT+"'\n")
            else: indexf.write(str(dirdateepochhrs+hr)+":"+settings.PCAP_INDEXPREFIX+"\n")
        indexf.close()
        log.debug("index file updated")
    except Exception as e:
        log.debug("can not open index file "+settings.PCAP_INDEXFILE +" , "+str(e))
    try:
        cmd = "sudo rm -rf " + cdrfolder
        run_command(cmd)
        log.debug("directory "+cdrfolder+" deleted")
    except Exception as e:
        log.debug("can not remove directory , "+str(e))
    return


def cdr_indexanddelete(outdated,notloaded):
    """
    Index cdr folders and force remove.

    :param outdated: Iterator with outdated cdr folders.
    :return: Total folders packed and moved.

    """
    for cdrfolder in outdated:
        if settings.PCAP_CDR_DIR in cdrfolder:
            try:
                notloaded.index(cdrfolder)  # folder outdated but not loaded - will not delete
            except ValueError:  # folder can be deleted
                try:
                    indexf = open(settings.PCAP_INDEXFILE,'a')
                    dirdate = re.search('\d\d\d\d/\d\d/\d\d',cdrfolder)
                    if dirdate:
                        dirdatetime = datetime.strptime(dirdate.group(), '%Y/%m/%d')
                        dirdateepoch = mktime(dirdatetime.timetuple())
                        dirdateepochhrs = int(int(dirdateepoch)/3600)
                        for hr in [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23]:
                            if settings.PCAP_INDEXMOUNT and settings.PCAP_INDEXUMOUNT: indexf.write(str(dirdateepochhrs+hr)+":"+settings.PCAP_INDEXPREFIX+":'"+settings.PCAP_INDEXMOUNT+':'+settings.PCAP_INDEXUMOUNT+"'\n")
                        else: indexf.write(str(dirdateepochhrs+hr)+":"+settings.PCAP_INDEXPREFIX+"\n")
                    indexf.close()
                    log.debug("index file updated")
                except Exception as e:
                    log.debug("can not open index file "+settings.PCAP_INDEXFILE +" , "+str(e))
                try:
                    #shutil.rmtree(cdrfolder)
                    cmd = "sudo rm -rf " + cdrfolder
                    run_command(cmd)
                    log.debug("directory "+cdrfolder+" deleted")
                except Exception as e:
                    log.debug("can not remove directory , "+str(e))
    return


def get_notloaded_cdr_folders_local():
    """Get not uploaded daily CDR folders.

        :return: List of daily folders to be uploaded.

        """
    folders = get_outdated_cdr_folders(settings.PCAP_CDR_KEEP_DAYS)
    folders2 = []
    for folder in folders:
        dirdate = re.search('\d\d\d\d/\d\d/\d\d',folder)
        if dirdate:
            dirdatetime = datetime.strptime(dirdate.group(), '%Y/%m/%d')
            archhashname = join(os.path.expanduser("~"),
                    settings.PCAP_STORAGE_DIR_CDR, datetime.strftime(dirdatetime,
                    '%Y/%m/%Y%m%d') + ".tar.gz.hash")
            if not exists(archhashname):
                folders2.append(folder)
                log.debug("folder "+folder+" not has arch "+archhashname)
    return folders2


def get_notloaded_cdr_folders_ftp():
    """Returns list of local cdr files to be uploaded to remote."""
    folders2 = []
    try:
        ftp=FTP()
        ftp.connect(settings.PCAP_FTP_HOST_CDR,int(settings.PCAP_FTP_PORT_CDR))
        ftp.login(settings.PCAP_FTP_USER_CDR,settings.PCAP_FTP_PASS_CDR)
    except Exception as e:
        log.error("can not connect to ftp server " + str(e))
        return folders2
    folders = get_outdated_cdr_folders(settings.PCAP_CDR_KEEP_DAYS)
    for folder in folders:
        dirdate = re.search('\d\d\d\d/\d\d/\d\d',folder)
        if dirdate:
            dirdatetime = datetime.strptime(dirdate.group(), '%Y/%m/%d')
            archhashname = join(settings.PCAP_STORAGE_DIR_CDR, datetime.strftime(
                    dirdatetime, '%Y/%m/%Y%m%d')+".tar.gz.hash")
            try:
                if not ftp.size(archhashname):
                    folders2.append(folder)
                    log.debug("folder's "+folder+" arch has no hash on ftp  "+archhashname)
            except Exception as e:
                log.error("can not check hash size "+archhashname+" on ftp server " + str(e))
                folders2.append(folder)
    try:  # closing if not closed to ftp
        ftp.quit()
    except Exception as e:
        log.error("ftp closure error, it looks already closed somehow")
    return folders2


def get_notloaded_cdr_folders_sftp():
    """Returns list of local cdr files to be uploaded to remote."""
    atfork()
    try:
        ssh = paramiko.SSHClient()
        ssh.set_missing_host_key_policy(paramiko.AutoAddPolicy())
        ssh.connect(settings.PCAP_FTP_HOST_CDR,port=int(settings.PCAP_FTP_PORT_CDR),username=settings.PCAP_FTP_USER_CDR,password=settings.PCAP_FTP_PASS_CDR)
        sftp = ssh.open_sftp()
    except Exception as e:
        log.error("can not connect to sftp server " + str(e))
        return
    folders = get_outdated_cdr_folders(settings.PCAP_CDR_KEEP_DAYS)
    folders2 = []
    for folder in folders:
        dirdate = re.search('\d\d\d\d/\d\d/\d\d',folder)
        if dirdate:
            dirdatetime = datetime.strptime(dirdate.group(), '%Y/%m/%d')
            archhashname = join(settings.PCAP_STORAGE_DIR_CDR, datetime.strftime(
                    dirdatetime, '%Y/%m/%Y%m%d')+".tar.gz.hash")
            try:
                if not sftp.stat(archhashname):
                    folders2.append(folder)
                    log.debug("folder's "+folder+" arch has no hash on sftp  "+archhashname)
            except Exception as e:
                log.error("can not check hash size "+archhashname+" on sftp server " + str(e))
                folders2.append(folder)
    try:  # closing if not closed to ftp
        sftp.close()
        ssh.close()
    except Exception as e:
        log.error("ssh closure error, it looks already closed somehow")
    return folders2


def get_recursive_filelist(folder):
    """Search files in folder recursive way.

        :param folder: Root folder to start search files.
        :return: Deque with recursive searched files in folder.

        """
    files_list = deque()
    for root, dirnames, filenames in os.walk(folder):
        for filename in filenames:
            files_list.append(join(root, filename))
    return files_list


def get_locked_cdrarch_list(directory):
    """List locked files like CDR archives in directory.

    :param directory: Directory to search.
    :return: List of locked files like tar.gz.

    """
    cmd = " sudo "+settings.PCAP_LSOF+" -w "+ directory + " | grep .tar.gz"
    try:
        lsofres = run_command(cmd)[0]
    except Exception as e:
        log.error("settings.PCAP_LSOF failed in get_locked_cdrarch_list(directory:{}"
                ") with message {}".format(directory, str(e)))
        lsofres = ""
    locked_cdrarch_list = lsofres.split("\n")
    log.debug("The locked CDR archives list is " + str(locked_cdrarch_list))
    return locked_cdrarch_list


def get_free_cdrarch_for_upload(directory, keep_days):
    """List CDR archives in directory not locked by any process.

    :param directory: Directory to search.
    :param keep_days: Get files with date `keep_days` older than now or more.
    :yield: iterable of locked files like tar.gz.

    The files filtered by mask `*.tar.gz` with date
    `settings.PCAP_CDR_KEEP_DAYS` older than now or more are packed and sent to storage.
    After successfull uploading to storage the local copy is deleted.

    """
    locked_cdrarch_list = get_locked_cdrarch_list(directory)
    for file_path in glob.iglob(join(directory, "*.tar.gz")):
        filename = basename(file_path)
        fname = filename[0:filename.find(".tar.gz")]
        if not fname.isdigit() or len(fname) != 8:
            log.error("The CDR archive file have unexpected name {}"
                    .format(filename))
            continue
        cdrarch_datetime = datetime.strptime(fname, '%Y%m%d')
        if (date.today() - cdrarch_datetime.date()).days < keep_days:
            log.debug("The CDR archive file {} would be kept, it is {} days"
                    " old.".format(filename, (date.today() -
                    cdrarch_datetime.date()).days))
            continue
        log.debug("The CDR archive file {} is a candidate to upload, it is "
                "{} days old.".format(filename, (date.today() -
                cdrarch_datetime.date()).days))
        try:
            for lsof_str in locked_cdrarch_list:
                if lsof_str.endswith(filename):
                    raise ValueError
        except ValueError:
            log.debug("The CDR archive file is locked as LSOF string"
                    " found a match. {} in {}".format(filename, lsof_str))
            continue
        log.debug("The CDR archive file {} is free to upload.".format(
                filename))
        (yield filename)


def mp_cdrstorage_put_ftp(cdrarch):
    """Uploads CDR archive file to storage.

        :param cdrarch: local CDR archive filename in `settings.PCAP_STAGING_DIR_CDR`
        path.
        :return: ``0`` if fail and `cdrarch` if success.

        This function is used by worker process in
        multiprocessing.Pool.map_async mode.

    """
    result = 0
    directory = settings.PCAP_STAGING_DIR_CDR
    storage = settings.PCAP_STORAGE_DIR_CDR
    fname=cdrarch[0:cdrarch.find(".tar.gz")]
    cdrarchdatetime = datetime.strptime(fname, '%Y%m%d')
    cdrarch_year = datetime.strftime(cdrarchdatetime, '%Y')
    cdrarch_month = datetime.strftime(cdrarchdatetime, '%m')
    fname_short = datetime.strftime(cdrarchdatetime, '%d') + ".tar.gz"  # DD.tar.gz instead YYYYMMDD.tar.gz
    fname_long = os.path.normpath("/"+storage+"/"+cdrarch_year+"/"+cdrarch_month+"/"+fname_short)
    log.debug("target ftp://"+settings.PCAP_FTP_USER_CDR+":PASSWORD@"+settings.PCAP_FTP_HOST_CDR+":"+settings.PCAP_FTP_PORT_CDR+fname_long)
    try:
        ftp=FTP()
        ftp.connect(settings.PCAP_FTP_HOST_CDR,int(settings.PCAP_FTP_PORT_CDR))
        ftp.login(settings.PCAP_FTP_USER_CDR,settings.PCAP_FTP_PASS_CDR)
    except Exception as e:
        log.error("can not connect to ftp server " + str(e))
        return result
    ftp_tmp_dir = ""
    for level in dirname(fname_long).split("/"):
        try:
            ftp_tmp_dir = ftp_tmp_dir +"/"+level
            ftp.cwd(ftp_tmp_dir)
            log.debug("fine - can cwd to " + ftp_tmp_dir)
        except Exception as e:
            log.error("can not cwd to " + ftp_tmp_dir)
            try:
                ftp.mkd(ftp_tmp_dir)  #try create dir
                log.info("created new directory " + ftp_tmp_dir)
            except Exception as e:
                log.error("not created new directory " + ftp_tmp_dir)
    try:   #final try
        ftp.cwd(ftp_tmp_dir)
        ftpfile = open(directory+"/"+cdrarch, 'rb')
        ftp.storbinary('STOR ' + fname_short, ftpfile)
        ftpfile.close()
        #ftpfilebak = open(directory+"/"+cdrarch+".bak", 'wb')
        #ftp.retrbinary('RETR ' + cdrarch, ftpfilebak.write)
        #ftpfilebak.close()
    except Exception as e:
        log.error("can not place " + cdrarch + " to target " + ftp_tmp_dir+"/"+fname_short)
        #ftp.quit()
        return result
    cdrarchhash_from=hashlib.md5(open(directory+cdrarch,'rb').read()).hexdigest()
    sleep(10)  # waiting for on-ftp-server hash generetion and will try to download
    #cdrarchhash_from=hashlib.md5(open(directory+cdrarch,'rb').read()).hexdigest()
    #trying download hash from server
    md5loaded = 0
    try:
        ftp=FTP()
        ftp.connect(settings.PCAP_FTP_HOST_CDR,int(settings.PCAP_FTP_PORT_CDR))
        ftp.login(settings.PCAP_FTP_USER_CDR,settings.PCAP_FTP_PASS_CDR)
        ftp.cwd(ftp_tmp_dir)
        ftphashbak = open(directory+"/"+cdrarch+".md5", 'wb')
        ftp.retrbinary('RETR ' + fname_short+".md5", ftphashbak.write)
        ftphashbak.close()
        md5hashfile = open(directory+"/"+cdrarch+".md5")
        cdrarchhash_to = md5hashfile.readline()
        log.debug("md5 from ftp " + cdrarchhash_to)
        md5hashfile.close()
        md5loaded = 1
    except Exception as e:
        log.error("can not load md5 file from ftp due "+str(e)+" ,will check md5 by downloading full file from ftp")
    if md5loaded == 0:  # deleting zero file
        try:
            os.remove(directory+cdrarch+".md5")
        except Exception as e:
            log.error("can not delete zero md5 file, something really bad "+str(e))
    if md5loaded == 0:  # using fallback download
        try:
            ftp=FTP()
            ftp.connect(settings.PCAP_FTP_HOST_CDR,int(settings.PCAP_FTP_PORT_CDR))
            ftp.login(settings.PCAP_FTP_USER_CDR,settings.PCAP_FTP_PASS_CDR)
            ftp.cwd(ftp_tmp_dir)
            ftpfilebak = open(directory+"/"+cdrarch+".bak", 'wb')
            ftp.retrbinary('RETR ' + fname_short, ftpfilebak.write)
            ftpfilebak.close()
            cdrarchhash_to=hashlib.md5(open(directory+cdrarch+".bak",'rb').read()).hexdigest()
        except Exception as e:
            log.error("can not load file back, something really bad "+str(e))
            #ftp.quit()
            return result
    log.debug("hash from  - file "+directory+cdrarch)
    log.debug("hash to  - file "+directory+cdrarch+".bak")
    log.debug("hash to: "+str(cdrarchhash_to)+" ,hash from: "+str(cdrarchhash_from))
    if cdrarchhash_from == cdrarchhash_to:
        hash_flag_file = open(directory+cdrarch+".hash", 'w')
        hash_flag_file.write(cdrarchhash_to+"\n")
        hash_flag_file.close()
        log.debug("created file "+ directory+cdrarch+".hash")
        try:  # reconnection to ftp
            ftp.quit()
        except Exception as e:
            log.error("reconnection error, makin one more reconnect")
        try:
            log.debug("started loading file "+ directory+cdrarch+".hash to ftp")
            ftp=FTP()
            ftp.connect(settings.PCAP_FTP_HOST_CDR,int(settings.PCAP_FTP_PORT_CDR))
            ftp.login(settings.PCAP_FTP_USER_CDR,settings.PCAP_FTP_PASS_CDR)
            ftp.cwd(ftp_tmp_dir)
            ftphashfile = open(directory+"/"+cdrarch+".hash", 'rb')
            ftp.storbinary('STOR ' + fname_short+".hash", ftphashfile)
            ftphashfile.close()
            ftp.quit()
            log.debug("completed loading file "+ directory+cdrarch+".hash to ftp")
        except Exception as e:
            log.error("can not connect to ftp server " + str(e))
            log.debug("aborted loading file "+ directory+cdrarch+".hash to ftp")
            return result
        os.remove(directory+cdrarch)
        os.remove(directory+cdrarch+".hash")
        if md5loaded == 0: os.remove(directory+cdrarch+".bak")
        if md5loaded == 1: os.remove(directory+cdrarch+".md5")
        log.info(cdrarch+" and md5 hash placed to target directory, hash check - OK, source cdrarch deleted ")
        result = cdrarch
    else:
        log.error(cdrarch+ " placed to target directory,but hash check - NOT OK, source cdrarch NOT deleted")
        os.remove(directory+cdrarch+".hash")
        if md5loaded == 0: os.remove(directory+cdrarch+".bak")
        if md5loaded == 1: os.remove(directory+cdrarch+".md5")
    try:  #close connection to ftp
        ftp.quit()
    except Exception as e:
        log.error("close connection to ftp error")
    return result



def mp_cdrstorage_put_sftp(cdrarch):
    """Uploads CDR archive file to storage.

        :param cdrarch: local CDR archive filename in `settings.PCAP_STAGING_DIR_CDR`
        path.
        :return: ``0`` if fail and `cdrarch` if success.

        This function is used by worker process in
        multiprocessing.Pool.map_async mode.

    """
    atfork()
    directory = settings.PCAP_STAGING_DIR_CDR
    storage = settings.PCAP_STORAGE_DIR_CDR
    fname=cdrarch[0:cdrarch.find(".tar.gz")]
    cdrarchdatetime = datetime.strptime(fname, '%Y%m%d')
    cdrarch_year = datetime.strftime(cdrarchdatetime, '%Y')
    cdrarch_month = datetime.strftime(cdrarchdatetime, '%m')
    #host,port,login,password
    log.debug("target sftp://"+settings.PCAP_FTP_USER_CDR+":PASSWORD@"+settings.PCAP_FTP_HOST_CDR+":"+settings.PCAP_FTP_PORT_CDR+"/"+storage+"/"+cdrarch_year+"/"+cdrarch_month+"/"+cdrarch)
    try:
        ssh = paramiko.SSHClient()
        ssh.set_missing_host_key_policy(paramiko.AutoAddPolicy())
        ssh.connect(settings.PCAP_FTP_HOST_CDR,port=int(settings.PCAP_FTP_PORT_CDR),username=settings.PCAP_FTP_USER_CDR,password=settings.PCAP_FTP_PASS_CDR)
        sftp = ssh.open_sftp()
    except Exception as e:
        log.error("can not connect to sftp server " + str(e))
        return 0
    ftp_tmp_dir = ""
    """TODO: quick fix: fname instead of undefined name 'fname_long'."""
    for level in dirname(fname).split("/"):
        try:
            ftp_tmp_dir = ftp_tmp_dir +"/"+level
            #ftp.cwd(ftp_tmp_dir)
            sftp.chdir(ftp_tmp_dir)
            log.debug("fine - can cwd to " + ftp_tmp_dir)
        except Exception as e:
            log.error("can not cwd to " + ftp_tmp_dir)
            try:
                sftp.mkdir(ftp_tmp_dir)  #try create dir
                log.info("created new directory " + ftp_tmp_dir)
            except Exception as e:
                log.error("not created new directory " + ftp_tmp_dir)

    """TODO: Add hash check.
    Start check if exist remote. From get_notloaded_cdr_folders_sftp()."""
#    try:
#        sftp.chdir()
#        sftp.chdir(ftp_tmp_dir)
#        if sftp.stat(cdrarch+".hash"):
#            sftp.close()
#            ssh.close()
#            log.info("Cdr archive has hash on SFTP. Skip upload. {}".format(
#                    cdrarch))
#            os.remove(directory + cdrarch)
#            return cdrarch
#    except IOError:
#        pass
    """End of check if exist remote."""

    try:   #final try
        sftp.chdir()
        sftp.chdir(ftp_tmp_dir)
        sftp.put(directory+"/"+cdrarch,cdrarch)
        sftp.get(cdrarch,directory+"/"+cdrarch+".bak")
    except Exception as e:
        log.error("can not place " + cdrarch + " to target directory " + ftp_tmp_dir)
        sftp.close()
        ssh.close()
        return 0
    cdrarchhash_from=hashlib.md5(open(directory+cdrarch,'rb').read()).hexdigest()
    cdrarchhash_to=hashlib.md5(open(directory+cdrarch+".bak",'rb').read()).hexdigest()
    if cdrarchhash_from == cdrarchhash_to:
        hash_flag_file = open(directory+cdrarch+".hash", 'w')
        hash_flag_file.write(cdrarchhash_to+"\n")
        hash_flag_file.close()
        sftp.put(directory+"/"+cdrarch+".hash",cdrarch+".hash")
        os.remove(directory+cdrarch)
        os.remove(directory+cdrarch+".bak")
        os.remove(directory+cdrarch+".hash")
        sftp.close()
        ssh.close()
        log.info(cdrarch+" and md5 hash placed to target directory, hash check - OK, source cdrarch deleted ")
    else:
        log.error(cdrarch+ " placed to target directory,but hash check - NOT OK, source cdrarch NOT deleted")
        os.remove(directory+cdrarch+".bak")
        os.remove(directory+cdrarch+".hash")
        sftp.close()
        ssh.close()
        return 0
    return cdrarch


def mp_cdrstorage_put_local(cdrarch):
    """Uploads CDR archive file to storage.

        :param cdrarch: local CDR archive filename in `settings.PCAP_STAGING_DIR_CDR`
        path.
        :return: ``0`` if fail and `cdrarch` if success.

        This function is used by worker process in
        multiprocessing.Pool.map_async mode.

    """
    directory = settings.PCAP_STAGING_DIR_CDR
    storage = settings.PCAP_STORAGE_DIR_CDR
    fname=cdrarch[0:cdrarch.find(".tar.gz")]
    cdrarchdatetime = datetime.strptime(fname, '%Y%m%d')
    cdrarch_year = datetime.strftime(cdrarchdatetime, '%Y')
    cdrarch_month = datetime.strftime(cdrarchdatetime, '%m')
    fname_short = datetime.strftime(cdrarchdatetime, '%d') + ".tar.gz"  # DD.tar.gz instead YYYYMMDD.tar.gz
    local_tmp_dir = os.path.expanduser("~/" + storage)
    local_target_dir = local_tmp_dir + "/" + cdrarch_year + "/" + cdrarch_month + "/"
    local_target_file = local_target_dir + fname_short
    if not os.path.exists(local_target_dir):
        os.makedirs(local_target_dir)
    log.debug("source file " + directory + "/" + cdrarch)
    log.debug("target file " + local_target_file)
    log.debug("target dir " + local_target_dir)
    if not check_dir_writable(local_target_dir):
        return 0
    try:   #final try
        log.debug("copying "+ directory + "/" + cdrarch + " to " + local_target_file)
        copy(directory + "/" + cdrarch, local_target_file)
        copy(local_target_file, directory + "/" + cdrarch + ".bak")
    except Exception as e:
        log.error("can not place " + cdrarch + " to target directory " + local_target_dir + " " + str(e))
        return 0
    cdrarchhash_from=hashlib.md5(open(directory + cdrarch,'rb').read()).hexdigest()
    cdrarchhash_to=hashlib.md5(open(directory + cdrarch + ".bak",'rb').read()).hexdigest()
    if cdrarchhash_from == cdrarchhash_to:
        hash_flag_file = open(directory + cdrarch + ".hash", 'w')
        hash_flag_file.write(cdrarchhash_to + "\n")
        hash_flag_file.close()
        copy(directory + "/" + cdrarch + ".hash", local_target_file + ".hash")
        os.remove(directory + cdrarch)
        os.remove(directory + cdrarch + ".bak")
        os.remove(directory + cdrarch + ".hash")
        log.info(cdrarch + " and md5 hash placed to target directory, hash check - OK, source cdrarch deleted")
    else:
        log.error(cdrarch + " placed to target directory,but hash check - NOT OK, source cdrarch NOT deleted")
        os.remove(directory + cdrarch + ".bak")
        os.remove(directory + cdrarch + ".hash")
        return 0
    return cdrarch


def cdr_folders_pack():
    """Pack folders containing cdr files older than `settings.PCAP_CDR_ARCHIVE_DAYS`.

    :return: Total folders packed and moved.

    The folders containing files filtered by mask `*.cdr` with date
    `settings.PCAP_CDR_ARCHIVE_DAYS` older than now or more are packed and placed
    to `settings.PCAP_STAGING_DIR_CDR`. Local raw cdr copy is deleted.
    """
    counter = itertools.count()
    for cdrfolder in get_outdated_cdr_folders(settings.PCAP_CDR_ARCHIVE_DAYS):
        if mp_dir_arch_to_staging(cdrfolder):
            cdr_folder_index_delete(cdrfolder)
            next(counter)
    return next(counter)


def mp_pack_cdr_folders():
    """Pack folders containing cdr files older than `settings.PCAP_CDR_ARCHIVE_DAYS`.

    :return: Total folders packed and moved.
    The folders containing files filtered by mask `*.cdr` with date
    `settings.PCAP_CDR_ARCHIVE_DAYS` older than now or more are packed and placed
    to `settings.PCAP_STAGING_DIR_CDR`. Local raw cdr copy is deleted.
    """
    pack_folders = list(get_outdated_cdr_folders(settings.PCAP_CDR_ARCHIVE_DAYS))
    packed = []
    failures_count = 0
    if pack_folders:
        log.debug("MP feature - list of cdr folders to pack "
                + str(pack_folders))
        processes = min(settings.PCAP_UPLOADERS_POOL, len(pack_folders))
        log.debug("Creating pool with {} processes".format(processes))
        try:
            process_pool = Pool(processes)
            async_result = process_pool.map_async(mp_dir_arch_to_staging,
                    pack_folders, callback=packed.append)
            async_result.wait()
            process_pool.close()
            process_pool.join()
        except Exception as e:
            log.error('pool error {}'.format(str(e)))

        while True:
            try:
                packed.remove(None)
                failures_count += 1
            except ValueError:
                break

        if not failures_count and (len(packed) ==
                len(pack_folders)):
            log.info("All outdated CDR folders have been packed and placed"
                    "to `settings.PCAP_STAGING_DIR_CDR`. Total {} folders.".format(len(packed)))
        else:
            upload_fails = set(pack_folders) - set(packed)
            log.info("Not all outdated CDR folders have been packed and pla"
                    "ced to `settings.PCAP_STAGING_DIR_CDR`. Failed:{}, uploaded:{}".format(
                    failures_count, len(packed)))
            log.error("CDR folders failed to pack list:"
                    "{}".format(upload_fails))
        """We need help to check code if something is deleting all data
        from /opt/switch/dnl_softswitch/cdr/ every night at 00:00:00
        can you check if the config to "turn off" the cdr auto removal is working?
        cdr_indexanddelete(packed, ())
        """
    return len(packed)


class App(Application):

    def mp_pcap_loader(self):
        """Do pcap files uploading and archiving.

        :return: Total pcap files uploaded.

            cdr files are archived each day, for the day before.
            And in the config there is a line `settings.PCAP_CDR_KEEP_DAYS` of how
            long cdr files would be kept locally.
            Files older than `settings.PCAP_CDR_KEEP_DAYS` are sending to storage and
            local copy is deleted.

        """
        total_pcap_uploaded = 0
        failures_count = 0
        log.debug('going to pcap part')
#        log.debug("mp_pcap_loader global variables"
#                " 'settings.PCAP_PROJECT_NAME':{}, 'settings.PCAP_PROJECT_NAME_CDR':{}.".format(
#                globals()['settings.PCAP_PROJECT_NAME'], globals()['settings.PCAP_PROJECT_NAME_CDR']))
        pid = tcpdump_check_n_fork(settings.PCAP_VOICE_PORT, settings.PCAP_TCPDUMP_DIR,  settings.PCAP_TCPDUMP_USER)
#        atfork()
        log.debug("settings.PCAP_TCPDUMP status - OK - online with PID " + pid)
        pcaps_for_ip_parsing = mp_get_free_pcaps(settings.PCAP_TCPDUMP_DIR)
        log.debug("MP feature - number of pcaps for ip parsing {}"
                .format(len(pcaps_for_ip_parsing)))

        if len(pcaps_for_ip_parsing) > 0:
            """log.debug("MP feature - list of pcaps "+str(pcaps_for
            _ip_parsing)+" to be parsed for swich IPs")"""
            try:
                processes = min(settings.PCAP_UPLOADERS_POOL, len(pcaps_for_ip_parsing))
                log.debug("Creating pool with {} processes".format(processes))
                process_pool = Pool(processes)
                process_pool.map(mp_pcap_ips_parse_put_local, pcaps_for_ip_parsing)
                process_pool.close()
                process_pool.join()
            except Exception as e:
                log.error('pool error {}'.format(str(e)))


        for voice_ip in settings.PCAP_VOICE_IPS_LIST:
            dump_path = settings.PCAP_TCPDUMP_DIR + voice_ip + "/"
            ip_pcap_list = mp_get_free_pcaps_for_upload(dump_path, voice_ip)
            log.debug("MP feature - list of pcaps to be placed for "
                    "storage is {}".format(list(ip_pcap_list)))
            """TODO: write MP functions"""

            if ip_pcap_list:
                """Deque to store upload result."""
                done_pcap_deque = deque()

                processes = min(settings.PCAP_UPLOADERS_POOL, len(ip_pcap_list))
                log.debug("Creating pool with {} processes".format(
                        processes))
                try:
                    process_pool = Pool(processes)


                    if settings.PCAP_STORAGE_TYPE == "ftp":
                        async_result = process_pool.map_async(mp_storage_put_ftp,
                                ip_pcap_list, callback=done_pcap_deque.extend)
                        async_result.wait()

                    if settings.PCAP_STORAGE_TYPE == "local":
                        async_result = process_pool.map_async(mp_pcap_put_local,
                                ip_pcap_list, callback=done_pcap_deque.extend)
                        async_result.wait()

                    if settings.PCAP_STORAGE_TYPE == "sftp":
                        async_result = process_pool.map_async(mp_pcap_put_sftp,
                                ip_pcap_list, callback=done_pcap_deque.extend)
                        async_result.wait()

                    if settings.PCAP_STORAGE_TYPE == "gcs":
                        if settings.PCAP_GCS_SUPPORT != 'enabled':
                            log.error("could not use GCS due no \'config"
                                    ".GCS_SUPPORT = enabled\' in config")
                            continue
                        async_result = process_pool.map_async(
                                mp_pcap_put_gcs,ip_pcap_list,
                                callback=done_pcap_deque.extend)
                        async_result.wait()

                    process_pool.close()
                    process_pool.join()
                except Exception as e:
                    log.error('pool error {}'.format(str(e)))
                """Display upload status for a switch."""
                failures_count += (done_pcap_deque.count(0)
                        + done_pcap_deque.count(""))
                total_pcap_uploaded += len(ip_pcap_list) - failures_count
                log.debug("Checking failures_count = {}".format(failures_count))
                log.debug("Checking total_pcap_uploaded = {}".format(total_pcap_uploaded))
                log.debug("Checking done_pcap_deque = {}".format(done_pcap_deque))

                if not failures_count and (len(done_pcap_deque) ==
                        len(ip_pcap_list)):
                    log.info("All pcap files uploaded successfully from {}."
                            " Total {} pcaps.".format(dump_path,
                            len(done_pcap_deque)))
                else:
                    log.info("Not all files uploaded successfully from {}. "
                            "Failed:{}, uploaded:{}".format(dump_path,
                            failures_count,len(ip_pcap_list) - failures_count))

        log.debug("Pcap part of cycle is finished.")
        return total_pcap_uploaded

    def run(self):
        """The part gets executed by daemon."""
        check_voice_ip_dirs_writable(settings.PCAP_TCPDUMP_DIR, settings.PCAP_VOICE_IPS_LIST)
        if settings.PCAP_STORAGE_TYPE == "local":
            check_dir_writable(os.path.expanduser(settings.PCAP_STORAGE_DIR))
        if settings.PCAP_CDR_SUPPORT == 'enabled':
            check_dir_writable(settings.PCAP_STAGING_DIR_CDR)
            last_cdr_start_date = False
        while True:
            log.debug('New work cycle started')
            #pcap part
            total_pcap_uploaded = self.mp_pcap_loader()
            last_pcap_finish_time = time.time()
            # cooldown
            if (total_pcap_uploaded <= 1) and (
                    time.time() - last_pcap_finish_time < settings.PCAP_DURATION_MARGIN):
                log.debug("Pcap part will pause for {}sec.".format(
                        settings.PCAP_SLEEP_TIME))
                sleep(settings.PCAP_SLEEP_TIME)
            else:
                sleep(.1)

@app.task(base=SqlAlchemyTask)
def load_db_settings():
    global PCAP_APP
    PCAP_APP = None
    from api_dnl.model import StorageConfig
    q=StorageConfig.filter(StorageConfig.conf_type=='pcap').first()
    if q:
        q.update_settings()


def main_func():
    from api_dnl.model import StorageConfig
    old_active=False
    while True:
        StorageConfig.session().expire_all()
        q = StorageConfig.filter(StorageConfig.conf_type == 'pcap').first()
        if q.active!=old_active:
            log.debug("active changed.")
            old_active=q.active
            load_db_settings()
        do_pcap_loader(loop=False)
        sleep(10)

if __name__ == '__main__':
    main_func()
