import json

TIMEOUT = (30, 30)


class DidApiException(Exception):
    pass


def unprefix(s):
    if type(s) == type([]):
        if 'number' in s[0]:
            return [dict(**{k: v for k, v in i.items() if k != 'number'}, number=unprefix(i['number'])) for i in s]
        return [unprefix(i) for i in s]
    else:
        if s[0] == '+':
            return s[1:]
        else:
            return s


def unprefix_2(s):
    if type(s) == type([]):
        if 'number' in s[0]:
            return [dict(**{k: v for k, v in i.items() if k != 'number'}, number=unprefix_2(i['number'])) for i in s]
        return [unprefix_2(i) for i in s]
    else:
        if s[0:2] == '+1':
            return s[2:]
        else:
            return s


def set_prefix(s):
    if type(s) == type([]):
        if len(s):
            if 'number' in s[0]:
                return [dict(**{k: v for k, v in i.items() if k != 'number'}, number=set_prefix(i['number'])) for i in
                        s]
            elif 'did' in s[0]:
                return [dict(**{k: v for k, v in i.items() if k != 'did'}, did=set_prefix(i['did'])) for i in s]
            return [set_prefix(i) for i in s]
        else:
            return s
    elif s[0] != '+':
        if len(s) == 10:
            return '+1' + s
        else:
            return '+' + s
    else:
        return s


def fmt_content(cont, data=None):
    if type(cont) == type(b''):
        cont = cont.decode('utf-8')
    if cont and cont[0] == '{':
        ret = json.loads(cont)
        if not ret.get('data', None) and data:
            ret['data'] = data
        return ret
    return dict(code=411, msg='Unknown DidApiException', data='{} {}'.format(cont, data))


class DidAPI(object):
    # abstract did api base
    def __init__(self, user, password=None, vendor=None):
        self.user = user
        self.password = password
        self.vendor = vendor

    def search_local(self, country=None, state=None, npa=None, lata=None, pattern=None, count=100, client_id=None, nxx=None):
        raise DidApiException('Not implemented search_local')

    def pending(self):
        raise DidApiException('Not implemented search_local')

    def coverage_local(self, country=None, state=None, npa=None, lata=None,group=None):
        raise DidApiException('Not implemented coverage_local')

    def search_order_local(self, country=None, state=None, npa=None, lata=None, count=100, client_id=None):
        raise DidApiException('Not implemented search_order_local')

    def order_local(self, items, client_id=None):
        raise DidApiException('Not implemented order_local')

    def assigned_local(self):
        raise DidApiException('Not implemented assigned_local')

    def disconnect_local(self, items):
        raise DidApiException('Not implemented disconnect_local')

    def send_sms(self, sender, receiver, msg):
        raise DidApiException('Not implemented send_sms')

    def set_sms_receive_hook(self, number, url, client_id):
        raise DidApiException('Not implemented set sms receive hook')

    def set_sms_deliver_hook(self, number, url):
        raise DidApiException('Not implemented set sms receive hook')

    def search_toll_free(self, pattern=None, count=100, client_id=None):
        raise DidApiException('Not implemented search_toll_free')

    def search_order_toll_free(self, pattern=None, routing_label=None, count=100):
        raise DidApiException('Not implemented search_order_toll_free')

    def order_toll_free(self, items, routing_label=None, client_id=None):
        raise DidApiException('Not implemented order_toll_free')

    def assigned_toll_free(self):
        raise DidApiException('Not implemented assigned_toll_free')

    def disconnect_toll_free(self, items):
        raise DidApiException('Not implemented disconnect_toll_free')


if __name__ == '__main__':
    # unittest.main()
    pass
