from urllib.parse import urlencode

import requests
from falcon_rest.logger import log

from api_dnl.settings import TELE
from .did_api import DidAPI, TIMEOUT, DidApiException, fmt_content

TELE_BASE = TELE['base']


class DidAPITeli(DidAPI):
    is_cache_token = True
    _token = None
    _token_expiration_time = None

    def __init__(self, user, password=None, vendor=None):
        self.user = user
        self.password = password
        self.vendor = vendor

    def authenticate(self, **kwargs):
        q_user = dict(username=self.user, ssg_key=self.password)
        self._token = self.user

    def post(self, name, **kwargs):
        url = '{}/{}?token={}'.format(TELE_BASE, name, self._token)
        # kwargs['token'] = self._token
        # data = json.dumps(kwargs)
        data = urlencode(kwargs)
        # url='{}?{}'.format(url,data)
        try:
            headers = {'Content-type': 'application/json'}
            log.debug('DidAPITeli POST {} -d {}'.format(url, kwargs))
            response = requests.post(url, data=data, timeout=TIMEOUT, headers=headers, verify=False)
            if not response.status_code in (200, 201, 202, 204):
                log.debug('DidAPITeli response {} {}'.format(response.status_code, response.content))
                raise DidApiException(
                    fmt_content(response.content, url))

        except requests.ConnectionError as e:
            raise DidApiException(dict(code=410, msg='ConnectionError',
                                       data='configured auth host {}'.format(url)))
        else:
            if response.status_code not in (200, 201, 202, 204):
                raise DidApiException(fmt_content(response.content, url))
            result = response.json()
            return result

    def get(self, name, **kwargs):
        url = '{}/{}'.format(TELE_BASE, name)
        kwargs['token'] = self._token
        # data = json.dumps(kwargs)
        data = urlencode(kwargs)
        url = '{}?{}'.format(url, data)
        try:
            headers = {'Authorization': 'Bearer {}'.format(self._token),
                       'Content-type': 'application/json'}
            log.debug('DidAPITeli POST {} -d {}'.format(url, kwargs))
            response = requests.get(url, timeout=TIMEOUT, headers=headers, verify=False)
            if not response.status_code in (200, 201, 202, 204):
                log.debug('DidAPITeli response {} {}'.format(response.status_code, response.content))
                raise DidApiException(
                    fmt_content(response.content, url))

        except requests.ConnectionError as e:
            raise DidApiException(dict(code=410, msg='ConnectionError',
                                       data='configured auth host {}'.format(url)))
        else:
            if response.status_code not in (200, 201, 202, 204):
                raise DidApiException(fmt_content(response.content, url))
            result = response.json()
            if result['status'] == 'error':
                raise DidApiException(fmt_content(response.content, url))
            return result

    def lata(self, number):
        # item=cls.filter(cls.prefix=='1'+number[0:6]).first()
        # if item:
        #     return str(item.lata)
        return None

    def search_local(self, country=None, state=None, npa=None, lata=None, pattern=None, count=100, client_id=None, nxx=None):
        import re
        params = {}
        if state:
            params['state'] = state
        if npa:
            params['npa'] = npa
        if pattern:
            pattern = pattern.replace('x', '[0-9]').replace('*', '[0-9]')
        result = self.get('dids/list', **params)
        log.debug('search local:{}'.format(str(result)[0:4096]))
        if 'data' in result and 'dids' in result['data']:
            dids = result['data']['dids']
            i = 0
            ret = []
            for item in dids:
                xi = {'number': item['number'], 'npa': item['npa'], 'lata': self.lata(item['number']),
                      'state': item['state']}
                number = item['number']
                if pattern and not re.match(pattern, number):
                    continue
                if lata and not str(lata) == xi['lata']:
                    continue
                ret.append(xi)
                i += 1
                if i >= int(count):
                    break
            return ret
        return []

    def coverage_local(self, state=None, npa=None, lata=None,group=None):
        params = {}
        if state:
            params['state'] = state
        if npa:
            params['npa'] = npa
        result = self.get('dids/list', **params)
        log.debug('search local:{}'.format(str(result)[0:4096]))
        ds = {}
        if 'data' in result and 'dids' in result['data']:
            dids = result['data']['dids']
            i = 0
            ret = []
            for item in dids:
                xi = {'number': item['number'], 'npa': item['npa'], 'lata': self.lata(item['number']),
                      'state': item['state']}
                number = item['number']
                if lata and not str(lata) == xi['lata']:
                    continue
                key = (xi['state'], xi['npa'], xi['lata'])
                if not key in ds:
                    ds[key] = 0
                ds[key] += 1
            return [{'state': k[0], 'npa': k[1], 'lata': k[2], 'count': v} for k, v in ds.items()]
        return []

    def search_order_local(self, country=None, state=None, npa=None, lata=None, count=100, client_id=None):
        ret = self.search_local(country,state, npa, lata, None, count, None)
        err = []
        succ = []
        for item in ret:
            try:
                res = self.get('dids/order', number=item['number'], cnam=str(client_id) if client_id else None)
                item.update(res['data'])
                item['status'] = 'success'
            except DidApiException as e:
                item['status'] = 'error'
                item['error'] = str(e)
            succ.append(item)
        return succ

    def order_local(self, items, client_id=None):
        succ = []
        for item in items:
            try:
                res = self.get('dids/order', number=item['number'], cnam=str(client_id) if client_id else None)
                item.update(res['data'])
                item['status'] = 'success'
            except DidApiException as e:
                item['status'] = 'error'
                item['error'] = str(e)
            succ.append(item)
        return succ

    def assigned_local(self):
        params = {'number_type': 'local'}
        ret = self.get('user/dids/list', **params)
        return ret['data']

    def disconnect_local(self, items):
        ret = []
        for item in items:
            params = dict(did_number=item['number'])
            try:
                res = self.get('user/dids/remove', **params)
                item['status'] = 'success'
            except Exception as e:
                item['status'] = 'error'
                item['error'] = e.args[0]['data']
                log.warning('cannot disconnect {} {}'.format(item['number'], e))
            ret.append(item)
        return ret

    def pending(self):
        return []