"""did_client_log

Revision ID: ee2e1ab9e6d6
Revises: 45bce7b153f6
Create Date: 2021-04-16 18:07:01.804682

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):



# revision identifiers, used by Alembic.
revision = 'ee2e1ab9e6d6'
down_revision = '45bce7b153f6'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('did_client_log',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('did', sa.String(length=50), nullable=False),
    sa.Column('client_id', sa.Integer(), nullable=True),
    sa.Column('assigned_on', sa.DateTime(timezone=True), nullable=True),
    sa.Column('assigned_by', sa.Integer(), nullable=True),
    sa.Column('released_on', sa.DateTime(timezone=True), nullable=True),
    sa.Column('released_by', sa.Integer(), nullable=True),
    sa.Column('assign_method', api_dnl.migration_types.ChoiceType(), nullable=True),
    sa.Column('release_method', api_dnl.migration_types.ChoiceType(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_did_client_log_did'), 'did_client_log', ['did'], unique=False)
    op.create_table('did_vendor_log',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('did', sa.String(length=50), nullable=False),
    sa.Column('vendor_id', sa.Integer(), nullable=True),
    sa.Column('created_on', sa.DateTime(timezone=True), nullable=True),
    sa.Column('created_by', sa.Integer(), nullable=True),
    sa.Column('deleted_on', sa.DateTime(timezone=True), nullable=True),
    sa.Column('deleted_by', sa.Integer(), nullable=True),
    sa.Column('created_method', api_dnl.migration_types.ChoiceType(), nullable=True),
    sa.Column('delete_method', api_dnl.migration_types.ChoiceType(), nullable=True),
    sa.Column('api_vendor_type', api_dnl.migration_types.ChoiceType(), server_default='0', nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_did_vendor_log_did'), 'did_vendor_log', ['did'], unique=False)
    # ### end Alembic commands ###
    up_rec('did_billing_rel')


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_did_vendor_log_did'), table_name='did_vendor_log')
    op.drop_table('did_vendor_log')
    op.drop_index(op.f('ix_did_client_log_did'), table_name='did_client_log')
    op.drop_table('did_client_log')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))