"""did_billin_rel is_available

Revision ID: 3c293ced8ac2
Revises: aeb7bac01749
Create Date: 2017-11-08 19:00:29.381600

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = '3c293ced8ac2'
down_revision = 'aeb7bac01749'
branch_labels = None
depends_on = None


def upgrade():
    connection = op.get_bind()
    connection.execute("delete from balance_history_actual where ctid not in (select max(ctid) from balance_history_actual s  group by s.date,s.client_id)")
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('ix_balance_history_actual_date', table_name='balance_history_actual')
    op.create_index('ix_balance_history_actual_date', 'balance_history_actual', ['date', 'client_id'], unique=True)
    op.add_column('did_billing_rel', sa.Column('is_available', sa.Boolean(), nullable=True))
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('did_billing_rel', 'is_available')
    op.drop_index('ix_balance_history_actual_date', table_name='balance_history_actual')
    op.create_index('ix_balance_history_actual_date', 'balance_history_actual', ['date'], unique=False)
    # ### end Alembic commands ###
